; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
pro dcstoolsheights_cleanup,tlb
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,tlb,get_uvalue=pState
ptr_free,pState
end


;************************************************************************************************
pro dcstoolsheights_handler,event
;************************************************************************************************
;
compile_opt strictarr
;
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'DCSToolsHeights_handler: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
;    eMsg = [eMsg,'Function/module name: calledfunc()',!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif


widget_control,event.top,get_uvalue=pState
if (event.id eq (*pState).done) then begin
	widget_control,event.top,/destroy
	return
endif
if (event.id eq (*pState).help) then begin
	res=dialog_message('Sorry. Help is not yet available.')
endif
end


;************************************************************************************************
pro dcstoolsheights_calcs,pState,chosen,distances,disnames,results,resnames,messages,explains
;************************************************************************************************
;
compile_opt strictarr
;
conv=25.4
;
; Inner shield
A=((*pState).input_distances)[chosen[0],0]
B=((*pState).input_distances)[chosen[0],1]
C=((*pState).input_distances)[chosen[0],2]
D=((*pState).input_distances)[chosen[0],3]
;
; Outer shield
E=((*pState).input_distances)[chosen[1],4]
F=((*pState).input_distances)[chosen[1],5]
G=((*pState).input_distances)[chosen[1],6]
H=((*pState).input_distances)[chosen[1],7]
;
; Vacuum can
I=((*pState).input_distances)[chosen[2],8]
J=((*pState).input_distances)[chosen[2],9]
; Displex
aa=((*pState).input_distances)[chosen[3],10]
cc=((*pState).input_distances)[chosen[3],11]

D1=aa+(B-D)+C
D2=cc+(E-H)
D3=cc+(F-H)+G
D4=J
;
zvalue=float((*pState).zvalue)
samhgt=float((*pState).samhgt)
top2center=float((*pState).top2center)
;
Dp=I-(*pState).dis154-aa+zvalue
Dpp=-I+(*pState).dis154+aa+A-D-zvalue
Dppp=-I+(*pState).dis154+cc+E-H-zvalue
;
Delta=Dp-top2center
;
distances=[A,B,C,D,E,F,G,H,I,J,aa,cc]
disnames='  '+['A','B','C','D','E','F','G','H','I','J','a','c']
;
results=[D1,D2,D3,D4,Dp,Dpp,Dppp,Delta]
resnames='  '+['D1   ','D2   ','D3   ','D4   ',"D'   ","D''  ","D''' ",'Delta']
explains='  '+$
	['Vacuum can top to bottom of inner shield',$
	 'Vacuum can top to inside of outer shield',$
	 'Vacuum can top to bottom of outer shield',$
	 'Vacuum can top to inside of vacuum can',$
	 'Beam center to bottom of sample block',$
	 'Beam center to inside of inner can',$
	 'Beam center to inside of outer can',$
	 'Spacer thickness']
;
messages=['MESSAGES',strarr(6)]
k=0
warning='This will not work:'
nogood=0
;
inner_shield=(chosen[0] ne 0)
outer_shield=(chosen[1] ne 0)
;
can_plus_spacer=Delta+samhgt
;
if (inner_shield) then begin
	clearance=Dp+Dpp-can_plus_spacer
	if (clearance le 0.0) then begin
		k=k+1
		messages[k]=warning+' SAMPLE OVERLAPS INNER SHIELD by '+$
			strcompress(string(-clearance,format='(f5.1)'))+' mm.'
		nogood=1
	endif else begin
		k=k+1
		messages[k]='Sample clears inner shield by '+$
			strcompress(string(clearance,format='(f5.1)'))+' mm.'
	endelse
endif
;
if ((not inner_shield) and outer_shield) then begin
	clearance=Dp+Dppp-can_plus_spacer
	if (clearance le 0.0) then begin
		k=k+1
		messages[k]=warning+' SAMPLE OVERLAPS OUTER SHIELD by '+$
			strcompress(string(-clearance,format='(f5.1)'))+' mm.'
		nogood=1
	endif else begin
		k=k+1
		messages[k]='Sample clears outer shield by '+$
			strcompress(string(clearance,format='(f5.1)'))+' mm.'
	endelse
endif
;
if ((not inner_shield) and (not outer_shield)) then begin
	clearance=Dp+D4-aa-can_plus_spacer
	if (clearance le 0.0) then begin
		k=k+1
		messages[k]=warning+' SAMPLE OVERLAPS VACUUM CAN by '+$
			strcompress(string(-clearance,format='(f5.1)'))+' mm.'
		nogood=1
	endif else begin
		k=k+1
		messages[k]='Sample clears vacuum can by '+$
			strcompress(string(clearance,format='(f5.1)'))+' mm.'
	endelse
endif
;
if (inner_shield and (not outer_shield)) then begin
	clearance=D4-D1
	if (clearance le 0.0) then begin
		k=k+1
		messages[k]=warning+'INNER SHIELD TOO LONG by '+$
			strcompress(string(-clearance,format='(f5.1)'))+' mm.'
		nogood=1
	endif else begin
		k=k+1
		messages[k]='Inner shield clears vacuum can by '+$
			strcompress(string(clearance,format='(f5.1)'))+' mm.'
	endelse
endif
;
if (inner_shield and outer_shield) then begin
	clearance=D2-D1
	if (clearance le 0.0) then begin
		k=k+1
		messages[k]=warning+'INNER SHIELD TOO LONG AND/OR OUTER SHIELD TOO SHORT by'+$
			strcompress(string(-clearance,format='(f5.1)'))+' mm.'
		nogood=1
	endif else begin
		k=k+1
		messages[k]='Inner shield clears outer shield by '+$
			strcompress(string(clearance,format='(f5.1)'))+' mm.'
	endelse
endif
;
if (outer_shield) then begin
	clearance=D4-D3
	if (clearance le 0.0) then begin
		k=k+1
		messages[k]=warning+'OUTER SHIELD TOO LONG by '+$
			strcompress(string(-clearance,format='(f5.1)'))+' mm.'
		nogood=1
	endif else begin
		k=k+1
		messages[k]='Outer shield clears vacuum can by '+$
			strcompress(string(clearance,format='(f5.1)'))+' mm.'
	endelse
endif
;
if (Delta lt 0.0) then begin
	k=k+1
	messages[k]=warning+' THICKNESS OF SPACER IS NEGATIVE'
	nogood=1
endif
;
if (nogood) then messages[0]=$
	"             **********************THIS WILL NOT WORK**********************"$
else messages[0]=$
	"                                   ****THIS WORKS****"
;
if (chosen[0] eq 3 or chosen[0] eq 4) then begin
	k=k+1
	messages[k]="This heat shield is **MISSING**"
endif
;
end


;************************************************************************************************
pro dcstoolsheights_get,event
;************************************************************************************************
;
compile_opt strictarr
;
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'DCSToolsHeights_get: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
;    eMsg = [eMsg,'Function/module name: calledfunc()',!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif


widget_control,event.top,get_uvalue=pState
chosen=(*pState).chosen
zvalmin=(*pState).zvalmin
zvalmax=(*pState).zvalmax
zvalue=(*pState).zvalue
;
if (event.id eq (*pState).widz) then begin
	zvalue=((*pState).zchoices)[event.index]
;	widget_control,event.id,get_value=zvalue
	if (float(zvalue) lt zvalmin or float(zvalue) gt zvalmax) then begin
		res=dialog_message("z value is outside limits")
	endif else begin
		(*pState).zvalue=zvalue
	endelse
;	widget_control,event.id,set_value=string((*pState).zvalue,format='(f10.2)')
endif
;
if (event.id eq (*pState).widh) then begin
	(*pState).samhgt=((*pState).shchoices)[event.index]
;	widget_control,event.id,get_value=samhgt
;	(*pState).samhgt=samhgt
;	widget_control,event.id,set_value=string((*pState).samhgt,format='(f10.2)')
endif
;
if (event.id eq (*pState).widc) then begin
	(*pState).top2center=((*pState).tcchoices)[event.index]
;	widget_control,event.id,get_value=top2center
;	(*pState).top2center=top2center
;	widget_control,event.id,set_value=string((*pState).top2center,format='(f10.2)')
endif
;
k=where(event.id eq (*pState).widg,count)
if (count gt 0) then begin
	k=k[0]
	chosen[k]=event.index
	(*pState).chosen=chosen
endif
;
widget_control,event.top,set_uvalue=pState
dcstoolsheights_calcs,pState,chosen,distances,disnames,results,resnames,messages,explains
dcstoolsheights_writeout,pState,chosen,distances,disnames,results,resnames,messages,explains
end


;************************************************************************************************
pro dcstoolsheights_writeout,pState,chosen,distances,disnames,results,resnames,messages,explains
;************************************************************************************************
;
compile_opt strictarr
;
conv=25.4
zvalue=(*pState).zvalue
zoffset=(*pState).zoffset
;
sdistances=[[string(distances,format='(f7.1)')],[string(distances/conv,format='(f8.2)')]]
sresults=[[string(results,format='(f7.1)')],[string(results/conv,format='(f8.2)')]]
if (chosen[0] eq 0) then begin
	sdistances[0:3,*]=' '
	sresults[0,*]=' '
	sresults[5,*]=' '
endif
if (chosen[1] eq 0) then begin
	sdistances[4:7,*]=' '
	sresults[1:2,*]=' '
	sresults[6,*]=' '
endif
text1=['INPUT DISTANCES','           mm      in',$
	disnames+" = "+sdistances[*,0]+sdistances[*,1]]
text2=['OUTPUT DISTANCES','               mm      in',$
	resnames+" = "+sresults[*,0]+sresults[*,1]+explains,$
	'','  (z stage reading = '+strcompress(string(zvalue+zoffset,format='(f5.1)'))+')']
widget_control,(*pState).input,set_value=text1
widget_control,(*pState).output,set_value=text2
if (messages[1] eq "") then messages[1]="This should work."
widget_control,(*pState).mess,set_value=messages
end


;************************************************************************************************
pro dcstoolsheights,$
	group_leader = group_leader, workDir=workDir, dataDir=dataDir, $
;	notify_ids = notify_ids,$
	register_name = register_name, $
	_EXTRA=etc
;************************************************************************************************
;
compile_opt strictarr
;
;;;;;;;added following 4 lines for non-modal widget action
if n_elements(group_leader) eq 0 then group_leader = 0L
;if n_elements(notify_ids) eq 0 then notify_ids = [0L,0L]
if n_elements(register_name) eq 0 then register_name = 'DCSToolsHeights'
if xregistered(register_name) then return
;
;
;inputfile=file_which('dcstoolsheights.dat',/include_current_dir)
inputfile=!DAVE_AUXILIARY_DIR+'DCSToolsHeights.dat'
openr,u,inputfile,/get_lun
;
; ncomponents is 4: inner shield, outer shield, vac can, displex.
ncomponents=4
choices=strarr(10,ncomponents)
values=strarr(ncomponents)
nchoices=intarr(ncomponents)
chosen=intarr(ncomponents)
ndistances=intarr(ncomponents)
input_distances=fltarr(10,12)
jk=-1
kk=0
dummy=''
;
for k=0,ncomponents-1 do begin
	readf,u,dummy
	values[k]=dummy; description of component
	readf,u,kk
	nchoices[k]=kk; number of choices
	readf,u,kk
	chosen[k]=kk; default chosen
	readf,u,kk
	ndistances[k]=kk; number of distances that describe component
	readf,u,dummy
	temp=strsplit(dummy,' ',/extract)
	; descriptions of the choices
	for m=0,nchoices[k]-1 do begin
		choices[m,k]=strmid(temp[m],1,strlen(temp[m])-2)
	endfor
	dumdis=fltarr(nchoices[k])
	for j=0,ndistances[k]-1 do begin
		jk=jk+1
		readf,u,dumdis
		input_distances[0:nchoices[k]-1,jk]=dumdis; input distances for each choice
	endfor
	readf,u,dummy
endfor
;
readf,u,dis154,zvalmin,zvalmax,zoffset
free_lun,u
;
nums=[-20.0,20.0,1.0]; zvalue min, max and step
nvals=1+fix((nums[1]-nums[0]+0.01)/nums[2])
zchoices=string(findgen(nvals)+nums[0],format='(f10.2)')
zchosen=fix(nvals/2)
zvalue=zchoices[zchosen]
;
nums=[50.0,150.0,1.0]; samhgt min, max and step
nvals=1+fix((nums[1]-nums[0]+0.01)/nums[2])
shchoices=string(findgen(nvals)+nums[0],format='(f10.2)')
shchosen=fix(nvals/2)
samhgt=shchoices[shchosen]
;
nums=[40.0,60.0,1.0]; top2center min, max and step
nvals=1+fix((nums[1]-nums[0]+0.01)/nums[2])
tcchoices=string(findgen(nvals)+nums[0],format='(f10.2)')
tcchosen=fix(nvals/2)
top2center=tcchoices[tcchosen]
;
tlb=widget_base(title='Sample height calculations',/col,group_leader=group_leader)
	b1=widget_base(tlb,/row)
	sb1=lonarr(ncomponents+3)
	widg=lonarr(ncomponents+3)
	for k=0,ncomponents-1 do begin
		sb1[k]=widget_base(b1,/col)
			void=widget_label(sb1[k],value=values[k],/align_left)
			widg[k]=widget_combobox(sb1[k],xsize=120,value=choices[0:nchoices[k]-1,k],$
				event_pro="dcstoolsheights_get")
			widget_control,widg[k],set_combobox_select=chosen[k]
	endfor
		sb1[ncomponents]=widget_base(b1,/col)
			void=widget_label(sb1[ncomponents],value='z motor reading',/align_left)
;			widz=widget_text(sb1[ncomponents],/editable,xsize=10,ysize=1,value=string(zvalue,format='(f10.2)'),font='Courier',$
;				event_pro="dcstoolsheights_get")
			widz=widget_combobox(sb1[ncomponents],xsize=120,value=zchoices,$
				event_pro="dcstoolsheights_get")
			widget_control,widz,set_combobox_select=zchosen
		sb1[ncomponents+1]=widget_base(b1,/col)
			void=widget_label(sb1[ncomponents+1],value='Sample height',/align_left)
;			widh=widget_text(sb1[ncomponents+1],/editable,xsize=10,ysize=1,value=string(samhgt,format='(f10.2)'),font='Courier',$
;				event_pro="dcstoolsheights_get")
			widh=widget_combobox(sb1[ncomponents+1],xsize=120,value=shchoices,$
				event_pro="dcstoolsheights_get")
			widget_control,widh,set_combobox_select=shchosen
		sb1[ncomponents+2]=widget_base(b1,/col)
			void=widget_label(sb1[ncomponents+2],value='Sample top to center',/align_left)
;			widc=widget_text(sb1[ncomponents+2],/editable,xsize=10,ysize=1,value=string(top2center,format='(f10.2)'),font='Courier',$
;				event_pro="dcstoolsheights_get")
			widc=widget_combobox(sb1[ncomponents+2],xsize=120,value=tcchoices,$
				event_pro="dcstoolsheights_get")
			widget_control,widc,set_combobox_select=tcchosen
	b2=widget_base(tlb,/row)
		inpb=widget_base(b2)
			input=widget_text(inpb,/editable,xsize=20,ysize=15,value=text1,font='Courier')
		outpb=widget_base(b2)
			output=widget_text(outpb,/editable,xsize=20,ysize=15,value=text2,font='Courier')
	mess=widget_text(tlb,/editable,ysize=7,value=messages,font='Courier')
	b3=widget_base(tlb,/row)
		done=widget_button(b3,value='Done')
		help=widget_button(b3,value='Help')
geom=widget_info(tlb,/geometry)
geom2=widget_info(input,/geometry)
frac=0.25
widget_control,input,scr_xsize=geom.xsize*frac-4*geom2.margin
widget_control,output,scr_xsize=geom.xsize*(1-frac)-4*geom2.margin
centertlb,tlb
widget_control,tlb,/realize
;
State={done:done,$
	help:help,$
	input:input,$
	output:output,$
	mess:mess,$
	widg:widg,$
	widz:widz,$
	widh:widh,$
	widc:widc,$
	chosen:chosen,$
	input_distances:input_distances,$
	dis154:dis154,$
	zvalmin:zvalmin,$
	zvalmax:zvalmax,$
	zoffset:zoffset,$
	zchoices:zchoices,$
	shchoices:shchoices,$
	tcchoices:tcchoices,$
	zvalue:zvalue,$
	samhgt:samhgt,$
	top2center:top2center}
pState=ptr_new(State)
widget_control,tlb,set_uvalue=pState
;
dcstoolsheights_calcs,pState,chosen,distances,disnames,results,resnames,messages,explains
dcstoolsheights_writeout,pState,chosen,distances,disnames,results,resnames,messages,explains
;
; added register_name variable to the call to xmanager.
xmanager,register_name,tlb,/no_block,cleanup='dcstoolsheights_cleanup',$
	event_handler="dcstoolsheights_handler"
;
end