; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro DCS_sort_by,inarr,outarr,col=col,row=row,error
;************************************************************************************************
;
compile_opt strictarr
;
; Given a 2-d input array "inarr" this routine returns an output array "outarr" sorted by column
; "col">0 if "row"=0 or by row "row">0 if "col"=0.
error=0
sizing=size(inarr)
if (sizing[0] ne 2) then begin
	error=1
	return
endif
ncol=sizing[1]; (first index)
nrow=sizing[2]; (second index)
nrc=nrow*ncol
if (col gt ncol or row gt nrow) then  begin
	error=2
	return
endif
if (col gt 0 and row eq 0) then begin
	outarr=inarr[transpose(sort(inarr[col-1,*])*ncol#transpose(intarr(ncol)+1))+indgen(nrc) mod ncol]
	return
endif
if (row gt 0 and col eq 0) then begin
	outarr=inarr[sort(inarr[*,row-1])#transpose(intarr(nrow)+1)+indgen(nrc)/ncol*ncol]
	return
endif
error=3
return
end