; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_readdatafile,filepath,omithisto,printinfo,filetype,davePtr=davePtr
;************************************************************************************************
;
compile_opt strictarr
;
nofirstline=0
;
case filetype of
	"ascii": stop," Disallowed file type (ascii)"
	;
	"binary": $
	dcs_read_binaryOctavefile,filepath,nofirstline,omithisto,variables_read,unknowns,error,$
		davePtr=davePtr
;
	else: stop," Unknown file type (neither ascii nor binary)"
endcase
;
if (strlen(error) gt 0) then begin
	if (!debug) then print,"In dcs_readdatafile, error ",error
	return
endif
;
if (not printinfo) then return
;
if (variables_read[0] ne "None") then begin
	ivar=n_elements(variables_read)
	if (!debug) then print,ivar," variables have been read:"
	if (!debug) then print,variables_read
endif else if (!debug) then print,"NO variables have been read."
if (unknowns[0] ne "None") then begin
	ivaru=n_elements(unknowns)
	if (ivaru eq 1) then $
		if (!debug) then print,ivaru," of these variables is UNKNOWN:" $
		else if (!debug) then print,ivaru," of these variables are UNKNOWN:"
	if (!debug) then print,unknowns
endif
end