; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_multichoice_modal_handler,event
;************************************************************************************************
;
compile_opt strictarr
;
; Determine the label of the button that was pressed.
widget_control,event.id,get_value=buttonvalue
;
; Obtain list of button labels.
widget_control,event.top,get_uvalue=pstate,/no_copy
button_value=(*pstate).button_value
;
; figure out which one was pressed.
nbutton=n_elements(button_value)
for i=0,nbutton-1 do begin
	if (buttonvalue eq button_value[i]) then (*(*pstate).ptr).yes=i
endfor
; Destroy the widget.
widget_control,event.top,/destroy
ptr_free,pstate
end


;************************************************************************************************
pro dcs_multichoice_modal,lines,decision,button_value,def_button,can_button,$
	group_leader=group_leader,alignment=alignment,nbuttonrow=nbuttonrow,$
	visibility=visibility
;************************************************************************************************
; This routine creates a modal widget containing some text and some buttons. There may or may not
; be default and/or cancel buttons, invoked in Windows with the Enter and Esc keys respectively.
; The routine returns an integer called "decision" which is the index of the button pressed.
;
compile_opt strictarr
;
; Default alignment of text is centered.
if (not keyword_set(alignment)) then alignment=0
;
; Find out how many buttons will be placed on the widget.
nbutton=n_elements(button_value)
;
;	The keyword "visibility" determines which buttons are visible.
; If it's undefined they are all visible.
if (not keyword_set(visibility)) then visibility=bytarr(nbutton)+1
;
; The keyword "nbuttonrow" is an array of integers saying how many buttons are in each row.
; If it's undefined all buttons are placed in a single row.
if (not keyword_set(nbuttonrow)) then nbuttonrow=[nbutton]
;
; Determine the number of lines of text.
nlines=n_elements(lines)
;
; Start to create the widget.
base=widget_base(title=' ',/col,group_leader=group_leader,/modal)
;
labelbase=widget_base(base,/col)
; Create the label widget for the first line.
case alignment of
	-1: top=widget_label(labelbase,value=lines[0],/align_left)
	 0: top=widget_label(labelbase,value=lines[0],/align_center)
	 1: top=widget_label(labelbase,value=lines[0],/align_right)
	else:
endcase
;
; If there is more than one line create more label widgets.
if (nlines gt 1) then begin
	mid=intarr(nlines)
	for i=1,nlines-1 do begin
		case alignment of
			-1: mid[i]=widget_label(labelbase,value=lines[i],/align_left)
			 0: mid[i]=widget_label(labelbase,value=lines[i],/align_center)
			 1: mid[i]=widget_label(labelbase,value=lines[i],/align_right)
			else:
		endcase
	endfor
endif
;
; determine number of rows of buttons.
nrowb=n_elements(nbuttonrow)
;
; bot is an array of widget IDs for the rows of buttons.
bot=intarr(nrowb)
;
; button is an array of widget IDs for the buttons themselves.
button=intarr(nbutton)
;
; Create the base and button widgets.
is=0
for j=0,nrowb-1 do begin
	ie=is+nbuttonrow[j]-1
	bot[j]=widget_base(title=' ',base,/row,/align_center)
	for i=is,ie do $
		if (visibility[i]) then button[i]=widget_button(bot[j],value=button_value[i])
	is=ie+1
endfor
;
; Define default button (is there is one).
if (arg_present(def_button)) then begin
	if (def_button ge 0) then begin
		widget_control,base,default_button=button[def_button]
	endif
endif
;
; Define cancel button (if there is one).
if (arg_present(can_button)) then begin
	if (can_button ge 0) then begin
		widget_control,base,cancel_button=button[can_button]
	endif
	xbutton=can_button
endif else xbutton=-1
;
; Realize the widget.
dave_position_tlb,base
widget_control,base,/realize
;
ptr=ptr_new({yes:xbutton})
state={ptr:ptr,button_value:button_value}
widget_control,base,set_uvalue=ptr_new(state),/no_copy
xmanager,'dcs_multichoice_modal',base,$
	event_handler='dcs_multichoice_modal_handler',$
	group_leader=group_leader
decision=(*ptr).yes
ptr_free,ptr
end
