; $Id$
;#######################################################################
;
; NAME:
;  dm_strlen
;
; PURPOSE:
;  This function returns the string length as shown in graphics output
;  All formatting codes are properly treated
;
; CATEGORY:
;  general
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-8562
;  United States
;  yiming.qiu@nist.gov
;  Feb, 2005
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

function dm_strlen,in
    n_str  =    n_elements(in)
    str_len    =  fltarr(n_str)
    if n_str eq 1 then str_len=str_len[0]
    for j=0L,n_str-1 do begin
      len   =   0.0
      old_len  =    0.0
      sav_len  =    0.0    ;in this version, only correct unembeded !s !r format
      fsize    =  1.0
      flag =   0 ;flag for format code
      c_num    =  strlen(in[j])    ;number characters in the string
      for i=0L,c_num-1 do begin
       switch strmid(in[j],i,1) of
         '!':begin
          if flag eq 0 then $
              flag=1 $
          else begin
              if flag eq 1 then len=len+fsize
              flag=0
          endelse
          break
          end
         '0':begin
          if flag eq 0 then $
              len=len+fsize $
          else begin
              if flag eq 1 then len=len+fsize*2
              flag=0
          endelse
          break
          end
         '1':
         '2':begin
          if flag eq 0 then $
              len=len+fsize $
          else begin
              if flag eq 1 then flag=2 $
              else flag=0
          endelse
          break
          end
         'c':
         'C':begin    ;carriage return
          if flag eq 0 then $
              len=len+fsize $
          else begin
              if flag eq 1 then begin
                 if len gt old_len then old_len=len
                 len=0.0
              endif
              flag=0
          endelse
          break
          end
         'd':
         'D':
         'u':
         'U':begin
          if flag eq 0 then $
              len=len+fsize $
          else begin
              if flag eq 1 then fsize=0.7
              flag=0
          endelse
          break
          end
         'e':
         'E':
         'i':
         'I':begin
          if flag eq 0 then $
              len=len+fsize $
          else begin
              if flag eq 1 then fsize=0.44
              flag=0
          endelse
          break
          end
         'l':
         'L':begin
          if flag eq 0 then $
              len=len+fsize $
          else begin
              if flag eq 1 then fsize=0.62
              flag=0
          endelse
          break
          end
         'n':
         'N':begin
          if flag eq 0 then $
              len=len+fsize $
          else begin
              if flag eq 1 then fsize=1
              flag=0
          endelse
          break
          end
         'r':
         'R':begin
          if flag eq 0 then $
              len=len+fsize $
          else begin
              if len gt old_len then old_len=len
              len=save_len
              flag=0
          endelse
          break
          end
         's':
         'S':begin
          if flag eq 0 then $
              len=len+fsize $
          else begin
              save_len=len
              flag=0
          endelse
          break
          end
         'z':
         'Z':begin
          if flag eq 0 then $
              len=len+fsize $
          else begin
              if flag eq 1 then begin
                 i=i+1
                 if i ge c_num then break
                 if strmid(in[j],i,1) ne '(' then begin
                   i=c_num
                   break
                 endif
                 i=i+1
                 tmp   = strmid(in[j],i,c_num-i)
                 pos   = strpos(tmp,')')
                 if pos[0] eq -1 then begin
                   i=c_num
                   break
                 endif
                 i=i+pos[0]
                 tmp   = strmid(tmp,0,pos[0])
                 tmp   = strsplit(tmp,',')
                 len   = len+n_elements(tmp)
              endif
              flag=0
          endelse
          break
          end
         else:begin
          if flag eq 0 then $
              len=len+fsize $
          else $
              flag=0
          end
       endswitch
      endfor
      str_len[j]=(len>old_len)
    endfor
    return,str_len
end