; $Id$
;#######################################################################
;
; NAME:
;  dm_set_button
;
; PURPOSE:
;  this program sets a checked button for IDL5.6 or later,
;  or change the button value for IDL5.5 or before
;
; CATEGORY:
;  widget
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  March, 2011
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

; parameter:
;   id:         button id
;   value:      1:tick on 0:tick off
; keywords:
;   onstring:   string name to be shown when value=1, for IDL5.5 or before
;   offstring:  string name to be shown when value=0, for IDL5.5 or before
pro dm_set_button,id,value,onstring=onstring,offstring=offstring,_ref_extra=_extra
    if (n_elements(id) eq 0) or (n_elements(value) eq 0) then return
    if ~(widget_info(id,/valid_id)) then return
    if float(!version.release) ge 5.6 then $
       widget_control,id,set_button=value,_extra=_extra $
    else begin
       if (n_elements(onstring) eq 0) or (n_elements(offstring) eq 0) then return
       widget_control,id,set_value=(value eq 1)?onstring:offstring,_extra=_extra
    endelse
end