; $Id$
;#######################################################################
;
; NAME:
;  dm_progress
;
; PURPOSE:
;  This program shows the file loading progress.
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  March, 2014
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

pro dm_progress::update,title=title,message=message
    widget_control,self.label,set_value=message,tlb_set_title=title,/show,/input_focus
    if ~widget_info(self.stop,/valid_id) then return
    event = Widget_Event(self.stop, /NoWait)
    name = Tag_Names(event, /Structure_Name)
    if name eq 'WIDGET_BUTTON' then begin
       obj_destroy,self
    endif 
end

pro dm_progress::Cleanup
    if widget_info(self.tlb,/valid_id) then widget_control,self.tlb,/destroy
end

function dm_progress::Init,group_leader=group_leader,title=title,message=message,nostop=nostop
    if n_elements(title) eq 0   then title = ' '
    if n_elements(message) eq 0 then message = ' '
    self.tlb   = widget_base(title=title,/col,/base_align_center,group_leader=group_leader,tlb_frame_attr=9,map=0,floating=(n_elements(group_leader) ne 0))    
    self.label = widget_label(self.tlb,value=message,/dynamic_resize,/align_center)
    if ~keyword_set(nostop) then $
    self.stop  = widget_button(self.tlb,value='Stop',/pushbutton_events)
    dm_center_kid,self.tlb,group_leader       
    widget_control,self.tlb,/realize,map=1,set_uvalue=self
    return,1 
end

pro dm_progress__define
    void={dm_progress,              $
         tlb:              0L,      $ 
         label:            0L,      $
         stop:             0L       $
         }
end