; $Id: dm_mask_detbanks.pro,v 1.13 2017/03/16 19:34:55 ymqiu Exp $
;#######################################################################
;
; NAME:
;  dm_mask_detbanks
;
; PURPOSE:
;  mask detector banks
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  March, 2017
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

; parameter:
;   banks:    dcs detector bank number to be masked -1:lower 0:central 1:upper, returns the detector number
; keyword:
;   detnum:   detector number, returns the corresponding detector bank number
function dm_mask_detbanks,banks,detnum=detnum
    banknum=[$
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1,$
        1, 1, 0, 0, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0, 0, 0,-1,-1, 1, 1,$
        0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1,$
        1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1,$
        1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,$
       -1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,$
       -1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,$
       -1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,-1,-1, 1, 1, 0, 0,$
       -1,-1, 0, 0, 1, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,$
       -1, 0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1, 0]
    if n_elements(detnum) ne 0 then return, banknum[0>(detnum)<912]
    for i=0,n_elements(banks)-1 do begin
        if abs(banks[i]) le 1 then begin
           if n_elements(mask) eq 0 then $
              mask = where(banknum eq banks[i]) $
           else $
              mask = [mask,where(banknum eq banks[i])]
        endif
    endfor
    if n_elements(mask) eq 0 then mask=-1
    mask = mask[sort(mask)]
    return,mask
end

;mask DCS detector banks or negative angle detectors
;parameter:
;   detbanks:   a string description
pro dcs_mslice::dm_mask_detbanks, detbanks
    if self.instrname ne 'dcs' then begin   ;only for DCS instrument
       ok = dialog_message('Invalid operation for non-DCS data.',/error,dialog_parent=self.tlb)
       return
    endif
    mkngBut = widget_info(self.tlb,find_by_uname='mkngBut')
    mkloBut = widget_info(self.tlb,find_by_uname='mkloBut')
    mkcnBut = widget_info(self.tlb,find_by_uname='mkcnBut')
    mkupBut = widget_info(self.tlb,find_by_uname='mkupBut')
    mkulBut = widget_info(self.tlb,find_by_uname='mkulBut')
    if n_elements(detbanks) ne 0 then begin
       ind = where(['negative','lower','center','upper','upperlower'] eq detbanks,count)
       if count ne 0 then begin
          self.dcsdetmask[ind] = ~self.dcsdetmask[ind]
       endif
       if detbanks eq 'upperlower' then begin
          self.dcsdetmask[1] = self.dcsdetmask[4]
          self.dcsdetmask[3] = self.dcsdetmask[4]
       endif
    endif
    self.dcsdetmask[4] = (self.dcsdetmask[1] and self.dcsdetmask[3])
    ptr_free,self.mask
    self.maskstr = ''
    names = ['mkstdnum','mkpldnum','mkplangl','mkbpBut']
    for i=0,n_elements(names)-1 do dm_set_button,widget_info(self.tlb,find_by_uname=names[i]),0       
    check = where(self.dcsdetmask,ncheck,complement=uncheck,ncomplement=nuncheck)
    if ncheck ne 0 then dm_toggle_menubut,check=([mkngBut,mkloBut,mkcnBut,mkupBut,mkulBut])[check]
    if nuncheck ne 0 then dm_toggle_menubut,uncheck=([mkngBut,mkloBut,mkcnBut,mkupBut,mkulBut])[uncheck]
    dm_set_button,widget_info(self.tlb,find_by_uname='mkdbMenu'),(ncheck ne 0)
      
    if self.dcsdetmask[0] then mask = where((*self.detPosPtr).two_theta lt 0)
    for i=1,n_elements(self.dcsdetmask)-2 do begin
        if self.dcsdetmask[i] then begin
           if n_elements(detmask) eq 0 then $
              detmask = i-2 $
           else $
              detmask = [detmask,i-2]
        endif
    endfor
    if n_elements(detmask) ne 0 then begin
       if n_elements(mask) eq 0 then $
          mask = dm_mask_detbanks(detmask) $
       else $
          mask = [mask,dm_mask_detbanks(detmask)]
    endif
    if n_elements(mask) ne 0 then begin
       mask = mask[sort(mask)]
       mask = mask[uniq(mask)]
       if n_elements(mask) eq n_elements((*self.detPosPtr).two_theta) then $
          ok = dialog_message('All detectors are masked.',dialog_parent=self.tlb)
       self.mask = ptr_new(mask,/no_copy)
       self->my_widget_control,['mksvBut','mkclBut'],/sensitive
       self.masktype = 0
    endif else $
       self->my_widget_control,['mksvBut','mkclBut'],sensitive=ptr_valid(self.mask_ar)
    if ptr_valid(self.projStrPtr) then self->set_display_button,/clearprojection ;need to recalculate projections   
end
