; $Id: dm_define_pointer.pro,v 1.5 2012/08/24 18:40:51 ymqiu Exp $
;#######################################################################
;
; NAME:
;  dm_define_pointer
;
; PURPOSE:
;  define a dave_pointer, can also be used to get the path separator with getpathsep keyword,
;  or the writable temp directory with gettempdir keyword
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  July, 2025
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

function dm_define_pointer,getpathsep=getpathsep,gettempdir=gettempdir
    idl_version = dm_to_number(!version.release)
    if keyword_set(gettempdir) then begin
       if idl_version ge 6.1 then begin
          dir = APP_USER_DIR('NIST','NIST Center for Neutron Research','mslice','DAVE mslice',['This is the configuration directory for DAVE mslice, an IDL visualization',$
             'and analysis software for neutron time-of-flight and other multi-detector','instruments. It is safe to remove this directory, but not recommended, as',$
             'it will delete the information of previous session.','','Yiming Qiu','NIST Center for Neutron Research','100 Bureau Drive, Gaithersburg, MD 20899-6102',$
             'United States','yiming.qiu@nist.gov'],1)
       endif else begin
          found = IDLitGetResource('',strName,/User) ;find location of .idl resource directory
          if (found) then dir = strmid(strName,0,strpos(strName,'.idl')+4) $ ;get the .idl... part
          else begin
             dir = getenv('IDL_TMPDIR')
             if ~(file_test(dir,/directory,/write)) then begin
                if idl_version ge 6.2 then dir = sourcepath() $
                else cd,current=dir
             endif
          endelse
       endelse
       return,dir
    endif
    if idl_version ge 5.5 then pathsep = call_function("path_sep") $
    else begin
       defsysv,'!delimiter',exists=exists
       if exists then pathsep = !delimiter else begin
          case !version.os_family of
               'Windows':  pathsep = '\'
               'unix':     pathsep = '/'
               'MacOS':    pathsep = ':'
               else:       pathsep = '/'
          endcase
       endelse
    endelse
    if keyword_set(getpathsep) then return,pathsep
    defsysv,'!dave_defaults',exists=exists
    re_def = 0
    if exists eq 0 then re_def=1 $
    else if ptr_valid(!dave_defaults) eq 0 then re_def=1
    if re_def eq 1 then begin
       cd,current = thisDir
       pdd = ptr_new({datDir:thisDir,workDir:thisDir,PDFReader:'',web_browser:''})
       defsysv,'!dave_defaults',pdd
    endif
    davesysvars
    dave_makedaveptr,davePtr=davePtr
    dcs_defineDaveStructure,davePtr=davePtr
    dcs_sysvars,davePtr=davePtr
    (*(*(*davePtr).dataStrPtr).specificPtr).comments = ''
    return,davePtr
end