; $Id: dm_center_kid.pro,v 1.7 2017/05/10 14:53:38 ymqiu Exp $
;#######################################################################
;
; NAME:
;  dm_center_kid
;
; PURPOSE:
;  Center kid widget over parent widget.
;  If the parent is not specified, then the kid is centered over the screen
;
; CATEGORY:
;  general
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-8562
;  United States
;  yiming.qiu@nist.gov
;  June, 2018
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

; usage:
;   dm_center_kid,kid,parent
; keyword:
;   side:  if set, center the kid to the left or right side of the parent if screen is large enough
;   space: space btw kid and parent when side keyword is set, default = 30
pro dm_center_kid,kid,parent,side=side,space=space,_extra=_extra
    if n_elements(kid) eq 0 then return
    if n_elements(parent) eq 0 then thisparent=0L else thisparent=parent
    if widget_info(kid,/valid_id) eq 0 then return
    if n_elements(space) ne 0 then space = space[0] else space = 30
    k_geom = widget_info(kid,/geometry)
    vr_idl = dm_to_number(!version.release)
    if vr_idl ge 5.6 then scr_rect = get_screen_size() else device,get_screen_size=scr_rect
    p_center = scr_rect/2.
    scr_rect = [0,0,scr_rect]
    if widget_info(thisparent,/valid_id) then begin
       geom = widget_info(thisparent,/geometry)
       p_center = [geom.xoffset+geom.scr_xsize/2.,geom.yoffset+geom.scr_ysize/2.]
       if vr_idl ge 6.3 then begin  ;for mulitple screens
          oinfo = OBJ_NEW('IDLsysMonitorInfo')
          rects = oInfo->GetRectangles()
          if n_elements(rects) gt 4 then rects = rects[*,sort(rects[0,*])]
          if oinfo->IsExtendedDesktop() then begin
             curMon = 0>(where(rects[0,*]+rects[2,*] ge geom.xoffset+geom.scr_xsize/2))[0]
             scr_rect = rects[*,curMon]
          endif
          obj_destroy,oinfo
       endif
       if keyword_set(side) then begin
          if geom.xoffset+geom.scr_xsize+k_geom.scr_xsize+space le scr_rect[0]+scr_rect[2] then p_center[0] = geom.xoffset+geom.scr_xsize+space+k_geom.scr_xsize/2.0 $
          else if geom.xoffset-k_geom.scr_xsize-space ge scr_rect[0] then p_center[0] = geom.xoffset-space-k_geom.scr_xsize/2.0 $
          else p_center[0] = (geom.xoffset+geom.scr_xsize/2 gt scr_rect[0]+scr_rect[2]/2)?(scr_rect[0]+k_geom.scr_xsize/2.0):(scr_rect[0]+scr_rect[2]-k_geom.scr_xsize/2.0)
       endif
    endif
    widget_control,kid,xoffset=(scr_rect[0]>(p_center[0]-k_geom.scr_xsize/2.)<(scr_rect[0]+scr_rect[2]-k_geom.scr_xsize)),yoffset=(scr_rect[1]>(p_center[1]-k_geom.scr_ysize/2.)<(scr_rect[1]+scr_rect[3]-k_geom.scr_ysize)),_extra=_extra
end