; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
function dcs_juldate,dates
;************************************************************************************************
; Given a date/time string, e.g. '18-Nov-2004 17:53:49' this function returns the Julian date,
; in this case 2453328.2 (2453328.24570602 if format='(f16.8)'.
; Also works for an array of date/time strings.
;
compile_opt strictarr
;
months=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]
;
nd=n_elements(dates)
answer=dblarr(nd)
for k=0,nd-1 do begin
	dt=dates[k]
	d=fix(strmid(dt,0,2))
	m=strmid(dt,3,3)
	m=where(m eq months)+1
	m=fix(m[0])
	y=fix(strmid(dt,7,4))
	h=fix(strmid(dt,12,2))
	n=fix(strmid(dt,15,2))
	s=fix(strmid(dt,18,2))
	answer[k]=julday(m,d,y,h,n,s)
endfor
;
if (nd eq 1) then answer=answer[0]
;
return,answer
;
end
