; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_daveptr_vbles_handler,event
;************************************************************************************************
;
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue=pstate
;
v2max=(*pstate).v2max
;
warning_string="!!!! TOO MANY ITEMS !!!!"
;
case event.id of
;
	(*pstate).none: begin
		for i=0,(*pstate).ntags-1 do widget_control,(*pstate).butid[i],set_button=0
		(*(*pstate).pbut)=intarr((*pstate).ntags)
		(*(*pstate).ptotitems)=0
;		widget_control,(*pstate).totals,set_value="**** NO ITEMS DEFINED ****"
		widget_control,(*pstate).done,sensitive=(*pstate).summdcs and *(*pstate).pdq
		widget_control,(*pstate).save,sensitive=0
	end
;
	(*pstate).all: begin
		for i=0,(*pstate).ntags-1 do widget_control,(*pstate).butid[i],set_button=1
		(*(*pstate).pbut)=intarr((*pstate).ntags)+1
		(*(*pstate).ptotitems)=(*pstate).totel
		if ((*(*pstate).pact).summ) then begin
			widget_control,(*pstate).done,sensitive=0
			widget_control,(*pstate).save,sensitive=0
;			widget_control,(*pstate).totals,set_value=warning_string
			res=dialog_message(warning_string)
		endif else begin
			widget_control,(*pstate).done,/sensitive
			widget_control,(*pstate).save,/sensitive
			if (*(*pstate).ptotitems ne 1) then phrase=" ITEMS DEFINED." else phrase=" ITEM DEFINED."
;			widget_control,(*pstate).totals,set_value=strcompress(*(*pstate).ptotitems)+phrase
		endelse
	end
;
	(*pstate).save: begin
		v1=(*(*pstate).pbut)
		v2=(*(*pstate).ptotitems)
		filename=dialog_pickfile(path=(*!dave_defaults).workdir,$
			filter="*.txt",title="Select name of save file",$
			file="ascii_variables.txt")
		if (filename ne "") then begin
			save,filename=filename,v1,v2
		endif
	end
;
	(*pstate).recall: begin
		filename=dialog_pickfile(path=(*!dave_defaults).workdir,$
			filter="*.txt",title="Select name of restore file",$
			file="ascii_variables.txt")
		if (file_test(filename) and filename ne "") then begin
			restore,filename=filename
			for i=0,(*pstate).ntags-1 do widget_control,(*pstate).butid[i],set_button=v1[i]
			(*(*pstate).pbut)=v1
			(*(*pstate).ptotitems)=v2
			if (*(*pstate).ptotitems ne 1) then phrase=" ITEMS DEFINED." else phrase=" ITEM DEFINED."
;			widget_control,(*pstate).totals,$
				set_value=strcompress(*(*pstate).ptotitems)+phrase
			if ((*(*pstate).pact).summ and v2 gt v2max) then begin
				widget_control,(*pstate).done,sensitive=0
				widget_control,(*pstate).save,sensitive=0
;				widget_control,(*pstate).totals,set_value=warning_string
				res=dialog_message(warning_string)
			endif else begin
				widget_control,(*pstate).done,/sensitive
				if (*(*pstate).ptotitems ne 1) then phrase=" ITEMS DEFINED." else phrase=" ITEM DEFINED."
;				widget_control,(*pstate).totals,set_value=strcompress(*(*pstate).ptotitems)+phrase
			endelse
		endif else result=dialog_message("Invalid restore file name.",/error)
	end
;
	(*pstate).omitfn: begin
		*(*pstate).pomit=event.select
	end
;
	(*pstate).incldqs: begin
		*(*pstate).pdq=event.select
		widget_control,(*pstate).done,sensitive=event.select
	end
;
	(*pstate).done: begin
		widget_control,event.top,/destroy
		ptr_free,pstate
	end
;
	(*pstate).cancel: begin
		(*(*pstate).pbut)=intarr((*pstate).ntags)
		*(*pstate).pdq=0
		widget_control,event.top,/destroy
		ptr_free,pstate
	end
;
	(*pstate).tab: *(*pstate).pdelim=string(format='(%"\t",a0)',"")
	(*pstate).com: *(*pstate).pdelim=", "
	(*pstate).sem: *(*pstate).pdelim="; "
	(*pstate).spa: *(*pstate).pdelim=" "
;
	(*pstate).oth: begin
		(*pstate).obut=event.select
		widget_control,(*pstate).other,sensitive=(*pstate).obut
		widget_control,(*pstate).other,get_value=charact
		*(*pstate).pdelim=charact
	end
;
	(*pstate).other: begin
		widget_control,(*pstate).other,get_value=charact
		*(*pstate).pdelim=charact
	end
;
	else: begin
		k=where(event.id eq (*pstate).butid)
		(*(*pstate).pbut)[k]=event.select
		(*(*pstate).ptotitems)=(*(*pstate).ptotitems)+(*pstate).datanels[k]*(2*event.select-1)
		if (*(*pstate).ptotitems ne 1) then phrase=" ITEMS DEFINED." else phrase=" ITEM DEFINED."
;		widget_control,(*pstate).totals,set_value=strcompress((*(*pstate).ptotitems))+phrase
		v2=(*(*pstate).ptotitems)
		if (v2 eq 0) then begin
			ok=(*pstate).summdcs and *(*pstate).pdq
			mess="**** NO ITEMS DEFINED ****"
			if (not ok) then res=dialog_message(mess)
		endif
		if (v2 gt 0) then begin
			ok=((*(*pstate).pact).make or ((*(*pstate).pact).summ and v2 le v2max))
			if (ok) then begin
				if (*(*pstate).ptotitems ne 1) then phrase=" ITEMS DEFINED." else phrase=" ITEM DEFINED."
				mess=strcompress(*(*pstate).ptotitems)+phrase
			endif else begin
				mess=warning_string
				res=dialog_message(mess)
			endelse
		endif
		widget_control,(*pstate).done,sensitive=ok
		widget_control,(*pstate).save,sensitive=ok
;		widget_control,(*pstate).totals,set_value=mess
	end
;
endcase
;
if (widget_info(event.top,/valid_id)) then widget_control,event.top,get_uvalue=pstate
end


;************************************************************************************************
pro dcs_daveptr_vbles,tagnames,datasize,descriptor,datanels,ntags,action,$
	choice,delim,totel,group_leader=group_leader,omitfilename=omitfilename,$
	summdcs=summdcs,do_dqs=do_dqs
;************************************************************************************************
;
compile_opt strictarr
;
ncols=5
maxnrows=(ntags-1)/ncols+1
;
v2max=2500; maximum number of items in summary file
;
title="Click on variables to be written to "
if (action eq "make") then begin
	title=title+"output file."
	delim_sensitivity=0
endif
if (action eq "summ") then begin
	title=title+"summary file (maximum"+strcompress(v2max)+")."
	delim_sensitivity=1
endif
;
tlb=widget_base(/col,title=title,/modal,group_leader=group_leader)
	upper=widget_base(tlb,/row,/align_center)
		bb=widget_base(upper,/row,/nonexclusive)
			omitfn=widget_button(bb,value="Omit filename from summary?",sensitive=(action eq "summ"))
			incldqs=widget_button(bb,value="Include derived quantities?",sensitive=summdcs)
		done=widget_button(upper,value="PROCEED",sensitive=0)
		cancel=widget_button(upper,value="Main menu")
		if (!windows) then font="courier*18"
		if (!unix) then font="courier-18"
		if (!macos) then font="courier*18"
;		totals=widget_label(upper,value="**** NO ITEMS DEFINED ****",frame=3,font=font)
	middle=widget_base(tlb,/row,/frame)
		bbase=intarr(ncols)
		butid=intarr(ntags)
		for i=0,ncols-1 do bbase[i]=widget_base(middle,/col,/nonexclusive)
		ndisp=-1
		col=0
		for j=0,ntags-1 do begin
		  ndisp=ndisp+1
			if (ndisp ge maxnrows) then begin
				ndisp=0
				col=col+1
			endif
		  butid[j]=widget_button(bbase[col],$
		  	value=strlowcase(tagnames[j]+" ["+datasize[j]+" "+descriptor[j]+"]"))
		endfor
	bottom=widget_base(tlb,/row)
		void=widget_label(bottom,$
			value="Select a field delimiter for the summary file.")
		bottomleft=widget_base(bottom,/row,/frame)
			delims=widget_base(bottomleft,/row,/exclusive)
				tab=widget_button(delims,value="Tab")
				com=widget_button(delims,value="Comma")
				sem=widget_button(delims,value="Semicolon")
				spa=widget_button(delims,value="Space")
				oth=widget_button(delims,value="Other-->")
			other=widget_text(bottomleft,/editable,/all_events,xsize=2,ysize=1,sensitive=0)
	verybottom=widget_base(tlb,/row)
		none=widget_button(verybottom,value="Clear variable list")
		all=widget_button(verybottom,value="Select all variables")
		save=widget_button(verybottom,value="Save variable list",sensitive=0)
		recall=widget_button(verybottom,value="Restore variable list")
;
dave_position_tlb,tlb
;
widget_control,com,/set_button
widget_control,upper,sensitive=1
widget_control,middle,sensitive=1
widget_control,bottom,sensitive=delim_sensitivity
widget_control,cancel,sensitive=1
if (action eq "summ") then widget_control,all,sensitive=0
widget_control,tlb,/realize
;
pbut=ptr_new(intarr(ntags))
nitems=0l
if (action eq "summ") then begin
	for j=0,ntags-1 do begin
		tagname=strlowcase(tagnames[j])
		if ( tagname eq "ch_wl"$
			or tagname eq "comments"$
			or tagname eq "duration"$
			or tagname eq "start_date") then begin
			(*pbut)[j]=1
			nitems=nitems+datanels[j]
			widget_control,butid[j],set_button=1
		endif
	endfor
endif
;
if (nitems gt 0) then begin
	if (nitems eq 1) then mess=" 1 ITEM DEFINED."
	if (nitems gt 1) then mess=strcompress(nitems)+" ITEMS DEFINED."
	widget_control,done,sensitive=1
	widget_control,save,sensitive=1
;	widget_control,totals,set_value=mess
endif
;
if (action eq "make") then pact=ptr_new({make:1,summ:0})
if (action eq "summ") then pact=ptr_new({make:0,summ:1})
pdelim=ptr_new(", ")
ptotitems=ptr_new(nitems)
pdq=ptr_new(0)
pomit=ptr_new(0)
;
state={$
	none:none,$
	all:all,$
	done:done,$
	save:save,$
	recall:recall,$
	cancel:cancel,$
;	totals:totals,$
	ptotitems:ptotitems,$
	datasize:datasize,$
	datanels:datanels,$
	totel:totel,$
	v2max:v2max,$
	pact:pact,$
	upper:upper,$
	middle:middle,$
	incldqs:incldqs,$
	pdq:pdq,$
	pomit:pomit,$
	bottom:bottom,$
	tab:tab,$
	com:com,$
	sem:sem,$
	spa:spa,$
	oth:oth,$
	other:other,$
	pdelim:pdelim,$
	ntags:ntags,$
	butid:butid,$
	pbut:pbut,$
	obut:0,$
	omitfn:omitfn,$
	summdcs:summdcs}
pstate=ptr_new(state)
;
widget_control,tlb,set_uvalue=pstate,/no_copy
;
xmanager,'dcs_daveptr_vbles',tlb,event_handler='dcs_daveptr_vbles_handler'
;
choice=*pbut
ptr_free,pbut
ptr_free,pact
delim=*pdelim
ptr_free,pdelim
ptr_free,ptotitems
do_dqs=*pdq
ptr_free,pdq
omitfilename=*pomit
ptr_free,pomit
;
end


