; $Id$
;###############################################################################
;+
; CLASS_NAME:
;   DAVEwriteASCIISPE
;
; PURPOSE:
;   File writer for saving datasets as ASCII SPE files
;
; CATEGORY:
;   Input Output
;
; SUPERCLASSES:
;   DAVEwriteASCII
;
; SUBCLASSES:
;
; CREATION:
;   See DAVEwriteASCIISPE::Init
;
; METHODS:
;   WriteData
;
; INTERFACES:
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; October 2006
;-
;###############################################################################


;===============================================================================
; DAVEwriteASCIISPE::writeData
; 
; PURPOSE:
;   Implements DAVEwriteASCII::writeData. Responsible for writing the
;   appropriate contents of the dataset to the ASCII file in SPE format.
;
; PARAMETERS:
;   oData [in] - The data object to be written
;
; KEYWORDS:
;   none
;
; RETURN VALUE:
;    1 - Valid
;    0 - Invalid.
function DAVEwriteASCIISPE::writeData, oData
compile_opt idl2

retVal = 1
myTitle = 'Save as ASCII SPE text file'
msg = 'Could not write data'


;if (retVal ne 0) then begin
;   nx = n_elements(xData)
;   ny = n_elements(yData)
;   nqty1 = (size(qty))[1]
;   nqty2 = (size(qty))[2]
;
;   ;; If necessary, add a null value to xData to make it a 'false histogram'
;   ;; with one extra point relative to the dependent data.
;   xIsPoint = strcmp(xType,'POINTS',4,/FOLD_CASE)
;   if (xIsPoint) then xData = [xData,0.0]
;
;   ;; If necessary, add a null value to yData to make it a 'false histogram'
;   ;; with one extra point relative to the dependent data.
;   yIsPoint = strcmp(yType,'POINTS',4,/FOLD_CASE)
;   if (yIsPoint) then yData = [yData,0.0]
;
;   ;; write to disk and inform user of ouput destination
;   ;;Note: swap x and y + transpose data to be consistent with SPE files
;   ;;      generated by isis.
;   dm_write_spe,self->GetFilename(),yData,xData,transpose(qty),transpose(err) $
;      ,xtit=ylabel,ytit=xlabel,ztit=qtyLabel,error=errFlag
;
;   if (errFlag ne 0) then begin ; if error, get the error msg and exit
;;      self->ErrorMessage, !error_state.msg, title=myTitle
;      self->SignalError, !error_state.msg, severity=2,title=mytitle
;      return, 0
;   endif
;endif else $
;   self->SignalError, msg, severity=2
;
;return, retVal
;


errormsg = ''
if (obj_hasmethod(oData,'toASCIISPE')) then begin
   if (oData->toASCIISPE(dataStr, errormsg)) then begin
      xData = datastr.xData
      yData = dataStr.yData

      oData->GetProperty, axis1Distribution=xType, axis2Distribution=yType

      ;; If necessary, add a null value to xData to make it a 'false histogram'
      ;; with one extra point relative to the dependent data.
      xIsPoint = strcmp(xType,'POINTS',4,/FOLD_CASE)
      if (xIsPoint) then xData = [xData,0.0]

      ;; If necessary, add a null value to yData to make it a 'false histogram'
      ;; with one extra point relative to the dependent data.
      yIsPoint = strcmp(yType,'POINTS',4,/FOLD_CASE)
      if (yIsPoint) then yData = [yData,0.0]

      ;; Deal with masked data.
      ; Replace NaNs with a filler value of -1e20
      index = where(finite(dataStr.data,/NAN),nMask)
      if (nMask gt 0) then begin
         dataStr.data[index] = -1e20
         dataStr.error[index] = 1.0
      endif
      
      ;; Write to disk and inform user of ouput destination
      ;; Note: swap x and y + transpose data to be consistent with SPE files
      ;;      generated by isis.
      dm_write_spe,self->GetFilename() $
         ,yData,xData,transpose(dataStr.data),transpose(dataStr.error) $
         ,xtit=dataStr.yTitle,ytit=dataStr.xTitle,ztit=dataStr.dataTitle $
         ,error=errFlag

      if (errFlag ne 0) then begin ; if error, get the error msg and exit
         ;self->ErrorMessage, !error_state.msg, title=myTitle, severity=2
         self->SignalError, !error_state.msg, severity=2
         return, 0
      endif
      
      return, 1
   endif else begin
      msg = (errormsg eq '')? ["Failure to convert to SPE format"] : errormsg
      ;Self->ErrorMessage, msg, title=myTitle, severity=2
      Self->SignalError, msg, severity=2
      return, 0
   endelse
endif else begin
   msg = ['Unknown dataset type!',"Cannot convert to SPE format"]
   Self->SignalError, msg, severity=2
   return, 0
endelse

end


;===============================================================================
; DAVEwriteASCIISPE::Init
; 
; PURPOSE:
;   Initialization method for objects of DAVEwriteASCIISPE class
;
; PARAMETERS
;
; KEYWORDS:
;
; RETURN VALUE:
;    1 - Successful
;    0 - Failure
;
function DAVEwriteASCIISPE::init, _REF_EXTRA=etc
compile_opt idl2

; Init superclass
validTypes = ['ASCIISPE','DAVE1DATASET','ASCIIGRP']
if (self->IDLitWriter::Init('spe' $
                            ,TYPES='ASCIISPE' $
                            ,NAME="ASCII SPE" $
                            ,DESCRIPTION="ASCII SPE text file (spe)" $
                            ,_EXTRA=etc) eq 0) then return, 0


; call setproperty method, if necessary.
if (n_elements(etc) gt 0) then $
  self->SetProperty, _EXTRA=etc

self.asciiTypes = ['ASCIICOL','ASCIIGRP','ASCIISPE']

self->setProperty, asciiType='ASCIISPE'

return, 1

end



;===============================================================================
pro DAVEwriteASCIISPE__Define
compile_opt idl2

void = {DAVEwriteASCIISPE, $
        inherits DAVEwriteASCII $
       }
end
