; $Id$
;###############################################################################
;+
; CLASS_NAME:
;   DAVEwriteASCIICOL
;
; PURPOSE:
;   File writer for saving datasets as ASCII (Column) files
;
; CATEGORY:
;   Input Output
;
; SUPERCLASSES:
;   DAVEwriteASCII
;
; SUBCLASSES:
;
; CREATION:
;   See DAVEwriteASCIICOL::Init
;
; METHODS:
;   WriteData
;
; INTERFACES:
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; October 2006
;-
;###############################################################################


;===============================================================================
; DAVEwriteASCIICol::writeData
; 
; PURPOSE:
;   Implements DAVEwriteASCII::writeData. Responsible for writing the
;   appropriate contents of the dataset to the ASCII file in col format.
;
; PARAMETERS:
;   oData [in] - The data object to be written
;
; KEYWORDS:
;   none
;
; RETURN VALUE:
;    1 - Valid
;    0 - Invalid.
function DAVEwriteASCIICOL::writeData, oData
compile_opt idl2

retVal = 1
myTitle = 'Save as ASCII column text file'
msg = 'Could not write data'
headerFlag=0
header=''


;; Validate data object
;if (~self->isValid(oData,'DAVE1DATASET')) then  begin
;    self->SignalError,['Invalid dataset!','Cannot write selected dataset'] $
;                        ,severity=2
;    return, 0
;endif

;ncols = 0
;switch self->datasetType(oData) of
;   'DAVE1DATASET': begin
;
;      ;; Get the top level contents of dataset
;      cont = oData->Get(/all,count=cnt)
;      if (cnt lt 1) then  begin
;         self->SignalError,['Empty dataset!','Cannot write selected dataset'] $
;                            ,severity=2
;         return, 0
;      endif
;      
;      for i=0,cnt-1 do begin
;         if (retVal eq 0) then continue
;         
;         cont[i]->getProperty, type=type
;         case type of
;            'DAVE1COMMONSTR': begin
;               ;; 
;               obj = cont[i]->getByName('2') ; the dependent axis
;               if ((retVal = obj_valid(obj)) eq 0) then break
;               if ((retVal = obj->GetMetaData('Axes',axes)) eq 0 ) then axes=''
;               if (n_elements(axes) ne 1 && n_elements(axes) ne 2) then begin
;                  ;; Can't write 3D dataset using ASCII column format
;                  msg = 'Can only write 1D or 2D dataset in ASCII Column format'
;                  self->SignalError, msg,severity=2
;                  return, 0
;               endif
;               void = obj->getData(qty)
;               if (n_elements(qty) le 0) then begin
;                  msg = ['Incomplete dataset!','Cannot write selected dataset']
;                  self->SignalError, msg,severity=2
;                  return, 0
;               endif
;               if ((void = obj->GetMetaData('Long_name',qtyLabel)) eq 0 ) then qtyLabel=''
;               if ((void = obj->GetMetaData('Units',qtyUnits)) eq 0 ) then qtyUnits=''
;
;               ndims = size(qty,/n_dimensions)
;               dims = size(qty,/dimensions)
;               d1 = dims[0]
;               d2 = dims[1]
;               
;               
;               obj = cont[i]->getByName('0') ; first independent axis
;               if (obj_valid(obj)) then begin
;                  void = obj->getData(xdata)
;                  if (n_elements(xData) le 0) then begin
;                     msg = ['Incomplete dataset!','Cannot write selected dataset']
;                     self->SignalError, msg,severity=2
;                     return, 0
;                  endif
;                  if ((void = obj->GetMetaData('Long_name',xLabel)) eq 0 ) then xLabel=''
;                  if ((void = obj->GetMetaData('Units',xUnits)) eq 0 ) then xUnits=''
;                  if ((void = obj->GetMetaData('Distribution',xType)) eq 0 ) then xType='POINTS'
;
;                  nx = n_elements(xData)
;                  if (nx ne d1) then begin
;                     isHistogram = strcmp(xType,'HISTOGRAM',4,/FOLD_CASE)
;                     if (isHistogram && (nx eq d1+1)) then begin
;                        ;; convert to point mode
;                        index = lindgen(d1)
;                        xData = 0.5*(xData[index]+xData[index+1]) ; ==> mid values of the bin boundaries
;                        nx = n_elements(xData)
;                     endif else begin
;                        msg = 'Size of dependent and independent data do not match!'
;                        self->SignalError, msg, severity=2
;                        return, 0
;                     endelse
;                  endif
;               endif   
;
;               if (ndims eq 2) then begin
;
;                  obj = cont[i]->getByName('1') ; second independent axis
;                  if (obj_valid(obj)) then begin
;                     void = obj->getData(ydata)
;                     if (n_elements(yData) le 0) then begin
;                        msg = ['Incomplete dataset!','Cannot write selected dataset']
;                        self->SignalError, msg,severity=2
;                        return, 0
;                     endif
;                     if ((void = obj->GetMetaData('Long_name',yLabel)) eq 0 ) then yLabel=''
;                     if ((void = obj->GetMetaData('Units',yUnits)) eq 0 ) then yUnits=''
;                     if ((void = obj->GetMetaData('Distribution',yType)) eq 0 ) then yType='POINTS'
;   
;                     ny = n_elements(yData)
;                     if (ny ne d2) then begin
;                        isHistogram = strcmp(yType,'HISTOGRAM',4,/FOLD_CASE)
;                        if (isHistogram && (ny eq d2+1)) then begin
;                           ;; convert to point mode
;                           index = lindgen(d2)
;                           yData = 0.5*(yData[index]+yData[index+1]) ; ==> mid values of the bin boundaries
;                           ny = n_elements(yData)
;                        endif else begin
;                           msg = 'Size of dependent and independent data do not match!'
;                           self->SignalError, msg, severity=2
;                           return, 0
;                        endelse
;                     endif
;                  endif   
;               
;               
;               endif
;
;               errPresent = 0
;               obj = cont[i]->getByName('3') ; the error in the dependent axis
;               if (obj_valid(obj)) then begin
;                  void = obj->getData(err)
;                  if (n_elements(qty) ne n_elements(err)) then begin
;                     msg = 'Size of dependent data and error data do not match!'
;                     self->SignalError, msg, severity=2
;                     return, 0
;                  endif
;                  errPresent = 1
;               endif
;
;
;               if (ndims eq 1) then begin
;                  dataColumns = [transpose(xData),transpose(qty)]
;                  ncols = 2
;                  if (errPresent) then begin
;                     dataColumns = [dataColumns,transpose(err)]
;                     ncols = 3
;                  endif
;                  header = ['X       ','Intensity','Error    ']
;               endif else begin
;                  dataColumns = transpose(xData)
;                  ncols = 1
;                  header = 'X       '
;                  if (errPresent eq 0) then begin
;                     for j=0,d2-1 do begin
;                        buf = 'I'+strtrim(string(j+1),2)+' (Y='+strtrim(string(yData[j],format='(G10.4)'),2)+')'
;                        header = [header,buf]
;                        dataColumns = [dataColumns,transpose(qty[*,j])]
;                        ncols++
;                     endfor
;                  endif else begin
;                     for j=0,d2-1 do begin
;                        buf1 = 'I'+strtrim(string(j+1),2)+' (Y='+strtrim(string(yData[j],format='(G10.4)'),2)+')'
;                        buf2 = 'Error'+strtrim(string(j+1),2)+'    '
;                        header = [header,buf1,buf2]
;                        dataColumns = [dataColumns,transpose(qty[*,j]),transpose(err[*,j])]
;                        ncols += 2 
;                     endfor                 
;                  endelse
;                  msgTxt = 'Include header line in data file?'
;                  status = self->PromptUserYesNo(msgTxt,headerFlag,title=myTitle)
;               endelse
;
;            end
;                        
;            else:
;         endcase
;      endfor
;
;      break
;   end
;   
;   'ASCIIGRP':
;   'ASCIISPE': begin
;
;      ;; Get the top level contents of dataset
;      void = oData->Get(/all,count=cnt)
;      if (cnt lt 1) then  begin
;         self->SignalError,['Empty dataset!','Cannot write selected dataset'] $
;                            ,severity=2
;         return, 0
;      endif
;
;      obj = oData->getByName('2') ; the dependent axis
;      if ((retVal = obj_valid(obj)) eq 0) then break
;      void = obj->getData(qty)
;      if (n_elements(qty) le 0) then retVal = 0
;      if ((void = obj->GetMetaData('Long_name',qtyLabel)) eq 0 ) then qtyLabel=''
;      if ((void = obj->GetMetaData('Units',qtyUnits)) eq 0 ) then qtyUnits=''
;      if ((void = obj->GetMetaData('Axes',axes)) eq 0 ) then axes=''
;
;      ndims = size(qty,/n_dimensions)
;      dims = size(qty,/dimensions)
;      d1 = dims[0]
;      d2 = dims[1]
;      
;      obj = oData->getByName('3') ; the error in the dependent axis
;      if (obj_valid(obj)) then begin
;         void = obj->getData(err)
;      endif
;      if (n_elements(err) ne n_elements(qty)) then err = qty*0.0 + 1.0
;      
;      obj = oData->getByName('0') ; first independent axis
;      if (obj_valid(obj)) then begin
;         void = obj->getData(xdata)
;         if (n_elements(xData) le 0) then retVal = 0
;         if ((void = obj->GetMetaData('Long_name',xLabel)) eq 0 ) then $
;            xLabel='X Values'
;         if ((void = obj->GetMetaData('Units',xUnits)) eq 0 ) then xUnits=''
;         if ((void = obj->GetMetaData('Distribution',xType)) eq 0 ) then xType='POINTS'
;
;         nx = n_elements(xData)
;         if (nx ne d1) then begin
;            isHistogram = strcmp(xType,'HISTOGRAM',4,/FOLD_CASE)
;            if (isHistogram && (nx eq d1+1)) then begin
;               ;; convert to point mode
;               index = lindgen(d1)
;               xData = 0.5*(xData[index]+xData[index+1]) ; ==> mid values of the bin boundaries
;               nx = n_elements(xData)
;            endif else begin
;               msg = 'Size of dependent and independent data do not match!'
;               self->SignalError, msg, severity=2
;               return, 0
;            endelse
;         endif
;      endif
;      
;      obj = oData->getByName('1') ; second independent axis
;      if (obj_valid(obj)) then begin
;         void = obj->getData(yData)
;         if (n_elements(yData) le 0) then retVal = 0
;         if ((void = obj->GetMetaData('Long_name',yLabel)) eq 0 ) then $
;            yLabel='Y values'
;         if ((void = obj->GetMetaData('Units',yUnits)) eq 0 ) then yUnits=''
;         if ((void = obj->GetMetaData('Distribution',yType)) eq 0 ) then yType='POINTS'
;
;         ny = n_elements(yData)
;         if (ny ne d2) then begin
;            isHistogram = strcmp(yType,'HISTOGRAM',4,/FOLD_CASE)
;            if (isHistogram && (ny eq d2+1)) then begin
;               ;; convert to point mode
;               index = lindgen(d2)
;               yData = 0.5*(yData[index]+yData[index+1]) ; ==> mid values of the bin boundaries
;               ny = n_elements(yData)
;            endif else begin
;               msg = 'Size of dependent and independent data do not match!'
;               self->SignalError, msg, severity=2
;               return, 0
;            endelse
;         endif
;      endif
;      
;      dataColumns = transpose(xData)
;      ncols = 1
;      header = 'X       '
;      for j=0,d2-1 do begin ; loop over groups (y axis)
;         buf1 = 'I'+strtrim(string(j+1),2)+' (Y='+strtrim(string(yData[j],format='(G10.4)'),2)+')'
;         buf2 = 'Error'+strtrim(string(j+1),2)+'    '
;         header = [header,buf1,buf2]
;         dataColumns = [dataColumns,transpose(qty[*,j]),transpose(err[*,j])]
;         ncols += 2 
;      endfor                 
;      msgTxt = 'Include header line in data file?'
;      status = self->PromptUserYesNo(msgTxt,headerFlag,title=myTitle)      
;
;      break
;   end
;
;   
;   'ASCIICOL': begin
;
;      ;; Get the top level contents of dataset
;      objs = oData->Get(/all,count=cnt)
;      if (cnt lt 1) then  begin
;         self->SignalError,['Empty dataset!','Cannot write selected dataset'] $
;                            ,severity=2
;         return, 0
;      endif
;
;      obj = oData->getByName('0') ; first (and only) independent axis
;      if (obj_valid(obj)) then begin
;         void = obj->getData(xData)
;         if (n_elements(xData) le 0) then begin
;            msg = ['Incomplete dataset!','Cannot write selected dataset']
;            self->SignalError, msg,severity=2
;            return, 0
;         endif
;         header = 'X Value'
;         dataColumns = transpose(xData)
;         nx = n_elements(xData)
;         ncols++
;         ;if ((void = obj->GetMetaData('Long_name',xLabel)) eq 0 ) then xLabel=''
;         ;if ((void = obj->GetMetaData('Units',xUnits)) eq 0 ) then xUnits=''
;         ;if ((void = obj->GetMetaData('Distribution',xType)) eq 0 ) then xType='POINTS'
;      endif
;      
;
;
;      obj = oData->getByName('2') ; the dependent axis
;      if ((retVal = obj_valid(obj)) eq 0) then begin
;         msg = ['Incomplete dataset!','Cannot write selected dataset']
;         self->SignalError, msg,severity=2
;         return, 0
;      endif
;      void = obj->getData(qty)
;      nqty = n_elements(qty) 
;      if (nqty le 0) then begin
;         msg = ['Incomplete dataset!','Cannot write selected dataset']
;         self->SignalError, msg,severity=2
;         return, 0
;      endif
;      ;if ((void = obj->GetMetaData('Long_name',qtyLabel)) eq 0 ) then qtyLabel=''
;      ;if ((void = obj->GetMetaData('Units',qtyUnits)) eq 0 ) then qtyUnits=''
;      ;if ((void = obj->GetMetaData('Axes',axes)) eq 0 ) then axes=''
;      dataColumns = (n_elements(dataColumns) eq 0)? transpose(qty) : $
;                    [dataColumns,transpose(qty)]
;      ncols++
;      
;      obj = oData->getByName('3') ; the error in the dependent axis
;      if (obj_valid(obj)) then begin
;         void = obj->getData(err)
;         if (n_elements(err) gt 0) then begin
;            dataColumns = [dataColumns,transpose(err)]
;            ncols++
;         endif
;      endif
;      
;      ;; get additional columns, if present
;      if (cnt gt 3) then begin
;         processedTypes = ['0','2','3']
;         for i=0,cnt-1 do begin
;            if (~obj_valid(objs[i])) then continue
;            objs[i]->getProperty, axisType=axisType
;            res = where(processedTypes eq axisType, processed)
;            if (processed) then continue
;            ok = objs[i]->getData(data)
;            if (~ok || (n_elements(data) ne nqty)) then continue
;            
;            dataColumns = [dataColumns,transpose(data)]
;            ncols++
;         endfor
;      endif 
;      
;      break
;   end
;
;   else: begin
;      self->SignalError,['Invalid dataset!','Cannot write selected dataset in ASCII Column format'] $
;                         ,severity=2
;      return, 0
;   end
;
;endswitch

status = 0

catch, theError
if (theError ne 0) then begin
   catch, /cancel
   if (n_elements(lun) gt 0) then begin ; if IO error then close the file before exiting
      sStat = fStat(lun)
      if (sStat.open ne 0) then free_lun, lun, /force
   endif
   self->SignalError, !error_state.msg, severity=2
   return, 0
endif


; retrieve the data in column format from the object
if (obj_hasmethod(oData,'toASCIIColumn')) then begin
   status = oData->toASCIIColumn(dataColumns,header,errorMsg)

   if (status) then begin
   
      ;; open output file
      openw, lun, self->GetFilename(), /get_lun
      
      ;; write to disk and inform user of ouput destination
      msgTxt = 'Include header (column titles) in data file?'
      status = self->PromptUserYesNo(msgTxt,headerFlag,title=myTitle)      
      
      ;; Deal with masked data.
      ; Replace NaNs with a filler value of -1e20
      index = where(finite(dataColumns,/NAN),nMask)
      if (nMask gt 0) then dataColumns[index] = -1e20

      dims = size(dataColumns,/dimensions)
      ncols = dims[0]
      nx = dims[1]
      fmt = '('+strtrim(string(ncols),2)+'(A13,2X))'
      if (headerFlag) then printf, lun, format=fmt,header
      fmt = '('+strtrim(string(ncols),2)+'(E13.5,2X))'
      for i = 0,nx-1 do printf, lun, format=fmt,dataColumns[*,i]
   
      free_lun, lun, /force
   endif else $
      self->SignalError, errorMsg, severity=2
endif else begin
   msg = ['Unknown dataset type!',"Cannot convert to ASCII Column format"]
   Self->SignalError, msg, severity=2
endelse

return, status

end


;===============================================================================
; DAVEwriteASCIICOL::Init
; 
; PURPOSE:
;   Initialization method for objects of DAVEwriteASCIICOL class
;
; PARAMETERS
;
; KEYWORDS:
;
; RETURN VALUE:
;    1 - Successful
;    0 - Failure
;
function DAVEwriteASCIICOL::init, _REF_EXTRA=etc
compile_opt idl2

; Init superclass
if (self->IDLitWriter::Init('txt' $
                            ,TYPES='ASCIICOL' $
                            ,NAME="ASCII Column" $
                            ,DESCRIPTION="ASCII Column text file (txt)" $
                            ,_EXTRA=etc) eq 0) then return, 0


; call setproperty method, if necessary.
if (n_elements(etc) gt 0) then $
  self->SetProperty, _EXTRA=etc

self.asciiTypes = ['ASCIICOL','ASCIIGRP','ASCIISPE']

self->setProperty, asciiType='ASCIICOL'

return, 1

end



;===============================================================================
pro DAVEwriteASCIICOL__Define
compile_opt idl2

void = {DAVEwriteASCIICOL, $
        inherits DAVEwriteASCII $
       }
end
