; $Id$
;
; Copyright (c) 2000-2004, Research Systems, Inc.  All rights reserved.
;   Unauthorized reproduction prohibited.
;----------------------------------------------------------------------------
; Purpose:
;   This file implements the DAVEreadISV class.
;
;---------------------------------------------------------------------------
; Lifecycle Routines
;---------------------------------------------------------------------------
; Purpose:
;   The constructor of the DAVEreadISV object.
;
; Arguments:
;   None.
;
; Keywords:
;   None.
;
function DAVEreadISV::Init, _EXTRA=_extra
compile_opt idl2

; Init superclass
if (self->IDLitReader::Init("disv",$
                            NAME="DAVE Project", $
                            DESCRIPTION="DAVE Project (disv)", $
                            _EXTRA=_extra) ne 1) then $
                              return, 0
return, 1
end


;===============================================================================
; DAVEReadISV::GetData
; 
; PURPOSE:
;   Restore a DAVE project session from a saved file
;
; PARAMETERS:
;   oVoidData - not used here but required by the API!
;
; KEYWORDS:
;   None.
;
; RETURN:
;   1 ==> Success; 0 ==> Failure
;
function DAVEreadISV::GetData, oVoidData
compile_opt idl2

filename = self->GetFilename()

;if (~KEYWORD_SET(createTool)) then begin
oDAVETool = self->GetTool()
if (~OBJ_VALID(oDAVETool)) then $
  return, 0                     ; Error

;; If our current state has been modified, prompt to save first.
;; If user hits cancel (or an error occurs), then do not open.
success = oDAVETool->_CheckForUnsaved()
if (success ne 1) then $
  return, success
;endif

; Delete current project's vis tools
oDAVETool->DelVisTools

; Delete current project's datasets
oDAVETool->DelDAVEDataManagerContents 

; Delete current data in system Data Manager folder
oDAVETool->DelSystemDataManagerContents

; First retrieve all structure/object classnames so we
; can instantiate the structures. This prevents the save file
; from restoring old object definitions, and also compiles all
; of the methods within the __define files.
oSaveFile = obj_new('IDL_Savefile', filename)
structs = oSaveFile->Names(count=nstruct, /structure_definition)
obj_destroy, oSaveFile
for i=0,nstruct-1 do $
  void = create_struct(name=structs[i])

restore, filename, restored_objects=oObj, /relaxed_structure_assignment
nObj = n_elements(oObj)
if (nObj le 0) then return, -1

; Ensure all component objects are updated for the current release.
index = where(obj_isa(oObj,'IDLitComponent'),nComp)
for i=0,nComp-1 do begin
    oObj[index[i]]->Restore
    oObj[index[i]]->UpdateComponentVersion
endfor

; Reinstate project datasets
nDataSets = n_elements(__datasets)
if (nDataSets gt 0) then begin
   oDAVETool->AddDatasetToDataManager, __datasets
endif else begin
   oDAVETool->ErrorMessage,'Saved project contains no data!',title='DAVE Open Project'
   obj_destroy, oObj
   return, -1
endelse

; Reinstate sys Data Manager contents
oSystem = oDAVETool->GetSystem()
if ((n_elements(__sysData) gt 0) && obj_valid(__sysData[0]))then $
   oSystem->AddByIdentifier,'Data Manager', __sysData

; Set the filename. This will also update the title bar.
oDAVETool->SetProperty, tool_filename=filename

; Ensure the tool's filename and the File/Save and File/SaveAs are in sync.
oDesc = oDAVETool->GetByIdentifier('Operations/File/Save')
if (OBJ_VALID(oDesc)) then oDesc->SetProperty, filename=filename
oDesc = oDAVETool->GetByIdentifier('Operations/File/SaveAs')
if (OBJ_VALID(oDesc)) then oDesc->SetProperty, filename=filename

; Reset the Undo/Redo buffer since it is now invalid.
oBuffer = oDAVETool->_GetCommandBuffer()
oBuffer->ResetBuffer

nVisTools = n_elements(__visToolDesc)
if (nVisTools le 0) then return, -1
for i=0,nVisTools-1 do begin
    visToolDesc = __visToolDesc[i]

    ;; create viz tool
    oVisTool = oSystem->createTool(visToolDesc.toolName $
                                   ,title=visToolDesc.title $
                                   ,user_interface='DAVE VisTool Interface' $
                                   ,DIMENSIONS=visToolDesc.dimensions $
;                                   ,VIRTUAL_DIMENSIONS=visToolDesc.virtualDimensions $
                                  )
    if (~obj_valid(oVisTool)) then continue
    visToolObjRefs = (n_elements(visToolObjRefs) gt 0)? [visToolObjRefs,oVisTool] : oVisTool 
    oVisTool->SetProperty, tool_filename=filename, nameTag=title

    oScene = visToolDesc.scene

    ;; All IDLitIMessaging objects have to be hooked up with a tool
    nMsg = 0
    oAll = oScene->GetAll(count=nAll) ; retrieve ALL objects within scene
    index = where(obj_isa(oAll,'IDLitIMessaging'),nMsg)
    if (nMsg gt 0) then begin
        oMsg = oAll[index]
        for j=0,nMsg-1 do begin
            oMsg[j]->_SetTool, oVisTool
        endfor
    endif

    oWin = oVisTool->GetCurrentWindow()
    oVisTool->DisableUpdates;, PREVIOUSLY_DISABLED=previouslyDisabled
    oWin->ClearSelections
    ;oWin->SetProperty, current_zoom=1

    oVisTool->Add, oScene ;; Hook up previous scene

    oPrintOperation = oVisTool->GetByIdentifier('Operations/File/Print')
    if (OBJ_VALID(oPrintOperation)) then begin
        oPrintOperation->SetProperty $
          ,PRINT_ORIENTATION=visToolDesc.print_orientation $
          ,PRINT_XMARGIN=visToolDesc.print_xmargin $
          ,PRINT_YMARGIN=visToolDesc.print_ymargin $
          ,PRINT_WIDTH=visToolDesc.print_width $
          ,PRINT_HEIGHT=visToolDesc.print_height $
          ,PRINT_UNITS=visToolDesc.print_units $
          ,PRINT_CENTER=visToolDesc.print_center
    endif

    ;; Restore window properties
    etc = {auto_resize:(n_elements(visToolDesc.autoResize) gt 0) ? visToolDesc.autoResize : 1b $
           ,zoom_on_resize:visToolDesc.zoomOnResize $
          }
    virtGTdim = visToolDesc.virtualDimensions gt visToolDesc.dimensions 
    if (virtGTdim[0] || virtGtdim[1]) then begin
        ;; add this if virtual dimesion > dimension
        etc = create_struct(etc,'virtual_dimensions',visToolDesc.virtualDimensions $
                            ,'minimum_virtual_dimensions',visToolDesc.minVirtualDims $
                           )
    endif
    oWin->SetProperty, _EXTRA=etc
;      ,auto_resize=(n_elements(visToolDesc.autoResize) gt 0) ? visToolDesc.autoResize : 1b $
;      ,virtual_dimensions=visToolDesc.virtualDimensions $
;      ,minimum_virtual_dimensions=visToolDesc.minVirtualDims $
;      ,zoom_on_resize=visToolDesc.zoomOnResize

    ;; Restore the grid # of columns & rows. We may not actually
    ;; be using gridded layout, but we need to restore the grid size.
    oGrid = oWin->GetLayout('Gridded',position=gridPosition)
    if (obj_valid(oGrid)) then oGrid->SetProperty $
      ,columns=visToolDesc.viewGrid[0] > 1, rows=visToolDesc.viewGrid[1] > 1

    ;; Now set the layout index.
    oWin->SetProperty, _layout_index=visToolDesc.layoutIndex

    ;; Reset our scrollbar location.
    oWin->SetProperty, visible_location=visToolDesc.visibleLocation

    ;; Call our OnScroll method to force a Set/CropViewPort
    ;; on all of our new views. Otherwise, if the Window had scrollbars
    ;; when the state was saved, the views will still be cropped
    ;; to those scroll positions.
    oWin->OnScroll, 0, 0

    ;; Update the zoom
    ;oWin->SetProperty, current_zoom=visToolDesc.currentZoom


    ;; Update the view zoom control in the toolbar.
    oView = oScene->GetCurrentView()
    oView->GetProperty, current_zoom=zoomFactor
    id = oVisTool->GetFullIdentifier() + "/TOOLBAR/VIEW/VIEWZOOM"
    oVisTool->DoOnNotify, id, 'SETVALUE',strtrim(uint((zoomFactor*100)+0.5),2)+'%'


    ;; Create an entry in the Visualization Browser
    void = oVisTool->doUIService('AddVisItem',oDAVETool->GetUI())

    ; Use the same filename as the maintool's
    oVisTool->SetProperty, tool_filename=filename

    oVisTool->EnableUpdates
endfor

; Final touches
if (n_elements(__visIDCount) gt 0) then oDaVETool->SetVisIDCount, __visIDCount
if (n_elements(visToolObjRefs) gt 0) then oDAVETool->SetVisToolObjRefs, visToolObjRefs

; Even though we are successful, return -1 (Cancel) since
; we don't have any data objects to return.
return, -1

end


;---------------------------------------------------------------------------
; Definition
;---------------------------------------------------------------------------
; Purpose:
; Class definition for the DAVEreadISV class
;
pro DAVEreadISV__Define
compile_opt idl2

void = {DAVEreadISV $
        ,inherits IDLitReader $
       }
end
