; $Id$
;###############################################################################
;+
; NAME:
;   DAVE
;
; PURPOSE:
;   Retrieve the DAVE application configuration directory
;
; CATEGORY:
;   DAVE Utilities

; PARAMETERS
;
; KEYWORDS:
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; July 2008
;-
;###############################################################################


;===============================================================================
; returns the configuration directory.
; Note: if the directory is not present it will be created!
function getDAVEConfigDir

app_version='2'

; Increment if author_readme_text is changed 
author_readme_version = 1  
author_readme_text = $ 
   ['This is the user configuration directory for', $ 
   'IDL based products from NCNR:', $ 
   '', $ 
   '    NIST Center for Neutron Research.', $ 
   '    100 Bureau Dr', $ 
   '    Gaithersburg, MD, 20899', $ 
   '    United States', $ 
   '' ] 
 
; Increment if app_readme_text is changed 
app_readme_version = 1       
 
app_readme_text = $ 
   ['This is the configuration directory for the', $ 
   'Data Analysis and Visualization Environment', $ 
   'software suite', $ 
   '', $ 
   'It is safe to remove this directory, as it', $ 
   'will be recreated on demand. Note that all', $ 
   'settings will revert to their default settings.', $ 
   '', $ 
   'Thank you for using DAVE.'] 

authorDirName = 'NIST'
authorDesc='NIST Center for Neutron Research'
appDirName='DAVE'
appDesc='Data Analysis and Visualization environment'

config_dir = APP_USER_DIR(authorDirName, authorDesc, appDirName, appDesc, $
    app_readme_text, app_readme_version, AUTHOR_README_TEXT=author_readme_text, $
    AUTHOR_README_VERSION=author_readme_version, RESTRICT_APPVERSION=app_version)

return, config_dir

end
