; $Id$
;+
; NAME:
;
;   FIND_ID
;
; PURPOSE:
;
;  Given a UNAME of a widget of a currently managed widget application, this
;  function returns a list of widget ids with user-name specified as UNAME.
;
;  This function is useful for inter-application communication, for example,
;  when you would like to send an event from one widget application to a
;  particular widget from another application (e.g. to a button widget whose
;  UNAME is known).
;
; AUTHOR:
;
;     Robert M. Dimeo, Ph.D.
;     NIST Center for Neutron Research
;     100 Bureau Drive
;     Gaithersburg, MD 20899
;     Phone: (301) 975-8135
;     E-mail: robert.dimeo@nist.gov
;     http://www.ncnr.nist.gov/staff/dimeo
;
; CATEGORY:
;
;     Widget programming
;
; CALLING SEQUENCE:
;
;     ID = FIND_ID(UNAME = uname, TLB = tlb)
;
; RETURN VALUE:
;
;  Widget id(s) whose UNAME(S) correspond to UNAME as passed in to the function.  If
;  no UNAME is specified then a value of 0L is returned which is not a valid widget
;  id.
;
; INPUT KEYWORD PARAMETERS (optional)
;
;  UNAME:   Scalar string containing the UNAME of the widget id being sought.
;
; OUTPUT KEYWORD PARAMETERS (optional)
;
;  TLB:   Widget id of the top-level base corresponding to the returned widget id.
;
; COMMON BLOCKS:
;
;  MANAGED as defined in XMANAGER
;
; REQUIREMENTS:
;
;  NONE
;
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;
; MODIFICATION HISTORY:
;
;  Written 01/14/04 (RMD)
;-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
FUNCTION FIND_ID, UNAME = uname, TLB = tlb
; Use the common block found in XMANAGER to obtain the information on the
; currently managed widgets.
COMMON MANAGED,   ids, $      ; IDs of widgets being managed
                  names, $    ; and their names
                  modalList   ; list of active modal widgets
; Use a procedure from XMANAGER.PRO to update the list of managed widgets.
validatemanagedwidgets
; If no uname has been specified then return an invalid widget id (0L)
if n_elements(uname) eq 0 then return,0L

; Now search through the widget hierarchy of each of the widget ids currently
; being managed and find all that have UNAME defined as their user-name.
n = n_elements(ids)
ret_id = 0L
tlb = 0L
counter = 0
for i = 0,n-1 do begin
   if widget_info(ids[i],/valid_id) then begin
      id = widget_info(ids[i],find_by_uname = uname)
      if widget_info(id,/valid_id) then begin
         tlb = ids[i]
         if counter eq 0 then ret_id = id else $
            ret_id = [ret_id,id]
         counter = counter + 1
      endif
   endif
endfor

return,ret_id
end
