;$Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function dave_valid, davePtr, full=full

message, 'pass 0', /continue

	if n_elements( davePtr ) ne 1 then return, 0
	if not ptr_valid( davePtr ) then return, 0
	if size( *davePtr, /tname ) ne 'STRUCT' then return, 0

message, 'pass 1', /continue

	print, tag_names( *davePtr )
	help, tag_names( *davePtr )
	if ( where( tag_names( *davePtr ) eq 'DATASTRPTR' ))[0] eq -1 then return, 0

message, 'pass 1.1', /continue

	if not ptr_valid( (*davePtr).dataStrPtr ) then return, 0

message, 'pass 1.2', /continue

	dataStrPtr = (*davePtr).dataStrPtr

message, 'pass 1.3', /continue

	if size( *dataStrPtr, /tname ) ne 'STRUCT' then return, 0

	message, 'pass 2', /continue

	if ( where( tag_names( *dataStrPtr ) eq 'COMMONSTR' ))[0]  eq -1 then return, 0
	if size( (*dataStrPtr).commonStr, /tname ) ne 'STRUCT' then return, 0

	message, 'pass 3', /continue

	if ( where( tag_names( (*dataStrPtr).commonStr ) eq 'HISTPTR' ))[0] eq -1 then return, 0

	message, 'pass 3.1', /continue

	if not ptr_valid( (*dataStrPtr).commonStr.histPtr ) then return, 0

	message, 'pass 3.2', /continue

	histPtr = (*dataStrPtr).commonStr.histPtr

	message, 'pass 3.3', /continue

	; More tests follow if the 'full' keyword is set.
	if not keyword_set( full ) then return, 1

	if size( *histPtr, /tname ) ne 'STRUCT' then return, 0

	message, 'pass 4', /continue

	if ( where( tag_names( *histPtr ) eq 'QTY' ))[0] eq -1 then return, 0
	if ( where( tag_names( *histPtr ) eq 'ERR' ))[0] eq -1 then return, 0
	if ( where( tag_names( *histPtr ) eq 'X' ))[0] eq -1 then return, 0
	if ( where( tag_names( *histPtr ) eq 'Y' ))[0] eq -1 then return, 0

	message, 'pass 5', /continue

	if n_elements( (*histPtr).qty ) eq 0 then return, 0
	if n_elements( (*histPtr).err ) eq 0 then return, 0
	if n_elements( (*histPtr).x ) eq 0 then return, 0
	if n_elements( (*histPtr).y ) eq 0 then return, 0

	message, 'pass 6', /continue

	return, 1

end
