; $Id$
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;
; Written by J.R.D. Copley.
;************************************************************************************************
pro dave_position_tlb,tlb,ssize,center
;************************************************************************************************
; Centers a widget base at ssize*center. The screensize is ssize.
; The default value of center is [0.5,0.5]. If ssize is not specified the system variable
; !screensize is used.
;
compile_opt strictarr
;
case n_params(0) of
	1: begin
		cen = [0.5,0.5]
		scrsize = !screensize
	end
	2: begin
		cen = [0.5,0.5]
		scrsize = ssize
	end
	3: begin
		cen = center
		scrsize = ssize
	end
	else: return
endcase
;
; Size of widget.
geom=widget_info(tlb,/geometry)
wdgsize = [geom.xsize,geom.ysize]
;
; Top left and bottom right positions.
xytl = scrsize*cen-wdgsize*0.5
xybr = scrsize*cen+wdgsize*0.5
;
; Try to ensure that all of the widget is visible.
offset = (xybr < scrsize) - wdgsize
offset = (xytl > 0)
;
; Position the widget.
widget_control,tlb,tlb_set_xoffset=offset[0],tlb_set_yoffset=offset[1]
;
end
