; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    cwo_minmax
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;
;
;METHODS:
;    cwo_minmax_event
;    cwo_minmax_class::event
;    cwo_minmax_class::setProperty
;    cwo_minmax_class::setvalues
;    cwo_minmax_class::getvalues
;    cwo_minmax_class::getproperty
;    cwo_minmax_set_value
;    cwo_minmax_get_value
;    cwo_minmax_cleanup
;    cwo_minmax_class::cleanup
;    cwo_minmax_class::init
;    cwo_minmax_class__define
;    cwo_minmax_test_event
;    cwo_minmax_test
;    cwo_minmax
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Fri Feb 09 22:48:42 2007
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################

;###############################################################################
;
;NAME:
;        cwo_minmax_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_minmax_event,event

    ;print,'cwo_minmax_event'
    widget_control,widget_info(event.handler,/child),get_uvalue=self
    event = self->event(event)
    return,event
end;cwo_minmax_event
;###############################################################################
;
;NAME:
;        cwo_minmax_class::event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_minmax_class::event,event
    ;print,'cwo_minmax_class::event'
    widget_control,widget_info(event.handler,/child),get_uvalue=self

    vals = self->getvalues()
    event = {id:event.handler,$;event.id,$
             top:event.top,$
             handler:event.handler,$
             values:vals,$
             xmin:vals[0],$
             xmax:vals[1],$
             range:self.range}

    return,event
end;event

;###############################################################################
;
;NAME:
;        cwo_minmax_class::setProperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_minmax_class::setProperty,range=range,$
                            labels=labels,$
                            title=title

            if n_elements(range) eq 2 then self.range = range
            if n_elements(labels) eq 2 then self.labels = labels
            if n_elements(title) eq 1 then self.title = title

end;setproperty
;###############################################################################
;
;NAME:
;        cwo_minmax_class::setvalues
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_minmax_class::setvalues,vals
    temp = vals
    if min(temp) le min(range) then vals[0] = min(range)
    if max(temp) ge max(range) then vals[1] = max(range)

    widget_control,self.minfield,set_value=vals[0]
    widget_control,self.maxfield,set_value=vals[1]
end;setvalues
;###############################################################################
;
;NAME:
;        cwo_minmax_class::getvalues
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_minmax_class::getvalues

    widget_control,self.minfield,get_value=xmin
    widget_control,self.maxfield,get_value=xmax

    temp = [xmin,xmax]
    vals = [min(temp),max(temp)]

    range = self.range
    if min(temp) le min(range) then vals[0] = min(range)
    if max(temp) ge max(range) then vals[1] = max(range)

    widget_control,self.minfield,set_value=vals[0]
    widget_control,self.maxfield,set_value=vals[1]

    return,vals
end;getvalues
;###############################################################################
;
;NAME:
;        cwo_minmax_class::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_minmax_class::getproperty,tlb=tlb,$
                            parent=parent,$
                            minfield=minfield,$
                            maxfield=maxfield,$
                            range=range,$
                            values=values,$
                            labels=labels,$
                            obj=obj,$
                            title=title


    tlb = self.tlb
    parent = self.parent
    minfield = self.minfield
    maxfield = self.maxfield
    range = self.range
    values = self.values
    titlelabel = self.titlelabel
    title = self.title
    obj = self




end;getProperty

;###############################################################################
;
;NAME:
;        cwo_minmax_set_value
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_minmax_set_value,id,val
    print,'cwo_minmax_set_value'
    print,id
end;cwo_minmax_set_value
;###############################################################################
;
;NAME:
;        cwo_minmax_get_value
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_minmax_get_value,id,val
    print,'cwo_minmax_get_value'
    print,id
end;cwo_minmax_get_value

;###############################################################################
;
;NAME:
;        cwo_minmax_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_minmax_cleanup,id
    widget_control,id,get_uvalue=obj
    obj_destroy,obj
end;cwo_minmax_cleanup

;###############################################################################
;
;NAME:
;        cwo_minmax_class::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_minmax_class::cleanup
    print,'cwo_minmax_class::cleanup'
end;cleanup

;###############################################################################
;
;NAME:
;        cwo_minmax_class::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_minmax_class::init,parent,$
                     tlb=tlb,$
                     minfield=minfield,$
                     maxfield=maxfield,$
                     range=range,$
                     xsize=xsize,$
                     ysize=ysize,$
                     row=row,$
                     column=column,$
                     labels=labels,$
                     values=values,$
                     floating=floating,$
                     integer=integer,$
                     title=title,$
                     xoffset=xoffset,$
                     yoffset=yoffset,$
                     _extra=extra


                ;DEFAULT TO INTEGERS.
                if n_elements(floating) eq 0 then floating = 0
                if n_elements(integer) eq 0 then integer = 0
                if floating eq 0 then integer = 1 else integer = 0


                if n_elements(column) eq 0 then column = 0
                if column eq 0 then row = 1
                self.row = row
                self.column = column


                if n_elements(title) eq 0 then self.title = '' else self.title = title

                if n_elements(range) ne 2 then range = [0,1]  else self.range = range



                if n_elements(values) ne 2 then self.values = range else self.values = values

                if n_elements(labels) ne 2 then labels = ['min','max']
                self.labels = labels


                if n_elements(xsize) eq 0 then xsize = 8
                if n_elements(ysize) eq 0 then ysize = 1

                self.xsize = xsize
                self.ysize = ysize

                ;DEFINE WIDGETS
                self.parent = parent
                self.tlb = widget_base(parent,column = self.column,row = self.row,$
                                        xoffset=xoffset,$
                                        yoffset=yoffset,$
                                        event_func='cwo_minmax_event',$
                                        pro_set_value='cwo_minmax_set_value',$
                                        func_get_value='cwo_minmax_get_value',$
                                        uvalue=uvalue,uname=uname,kill_notify=kill_notify)

                self.titlelabel = widget_label(self.tlb,value = self.title,$
                                                kill_notify='cwo_minmax_cleanup',$
                                                uvalue=self)


                ;print,'floating=',floating
                ;print,'integer=', integer


                if floating eq 0 then values = fix(self.values) else value = self.values

                self.minfield = cw_field(self.tlb,$
                                            value=values[0],$
                                            title=self.labels[0],$
                                            xsize=self.xsize,ysize=self.ysize,$
                                            floating=floating,integer=integer,$
                                            /return_events)

                self.maxfield = cw_field(self.tlb,$
                                            value=values[1],$
                                            title=self.labels[1],$
                                            xsize=self.xsize,ysize=self.ysize,$
                                            floating=floating,integer=integer,$
                                            /return_events)

    return,1
end;cwo_minmax

;###############################################################################
;
;NAME:
;        cwo_minmax__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_minmax_class__define,class

    class = {cwo_minmax_class,$
                        tlb:0L,$
                        parent:0L,$
                        minfield:0L,$
                        maxfield:0L,$
                        range:dblarr(2),$
                        title:'',$
                        titlelabel:0L,$
                        values:dblarr(2),$
                        xsize:0,$
                        ysize:0,$
                        row:0,$
                        column:0,$
                        labels:strarr(2),$
                        floating:0}

end;cwo_minmax_class__define


;###############################################################################
;
;NAME:
;        cwo_minmax_test_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_minmax_test_event,event

    print,tag_names(event)
    print,event

end;cwo_minmax_test_event

;###############################################################################
;
;NAME:
;        cwo_minmax_test
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_minmax_test

    b = widget_base(/col)
    f = cwo_minmax(b,$
                   range=[0,32],$
                   xsize = 9,$
                   ysize = 1,$
                   /row,$
                   labels=['detxmin','detxmax'],$
                   value=[5,24],$
                   title='XRANGE:',floating=0,integer=1)
    g = cwo_minmax(b,$
                   range=[0,32],$
                   xsize = 9,$
                   ysize = 1,$
                   /row,$
                   labels=['detymin','detymax'],$
                   value=[5,24],$
                   title='YRANGE:',floating=1)

    widget_control,b,/realize
    xmanager,'cwo_minmax_test',b,/no_block

end;cwo_minmax_test

;###############################################################################
;
;NAME:
;        cwo_minmax
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_minmax, parent,$
                     tlb=tlb,$
                     minfield=minfield,$
                     maxfield=maxfield,$
                     range=range,$
                     xsize=xsize,$
                     ysize=ysize,$
                     row=row,$
                     column=column,$
                     labels=labels,$
                     values=values,$
                     floating=floating,$
                     integer=integer,$
                     obj=obj,$
                     xoffset=xoffset,$
                     yoffset=yoffset,$
                     title=title


    obj = obj_new('cwo_minmax_class',parent,$
                                 tlb=tlb,$
                                 minfield=minfield,$
                                 maxfield=maxfield,$
                                 range=range,$
                                 xsize=xsize,$
                                 ysize=ysize,$
                                 row=row,$
                                 column=column,$
                                 labels=labels,$
                                 values=values,$
                                 floating=floating,$
                                 integer=integer,$
                                 xoffset=xoffset,$
                                 yoffset=yoffset,$
                                 title=title)


    obj->getproperty,tlb=tlb
    return,tlb


end;cwo_minmax
