; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    cwo_drawplot_class__define,class
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;    idl_container
;
;METHODS:
;    setCircleSymbol
;    cwo_drawplot_event
;    cwo_drawplot_class::handleContextMenu
;    cwo_drawplot_class::event
;    cwo_drawplot_class::handleMouseEvents
;    cwo_drawplot_class::reportRanges
;    cwo_drawplot_class::updateContextSetList
;    cwo_drawplot_class::copyWindow
;    cwo_drawplot_class::setWindow
;    cwo_drawplot_class::draw
;    cwo_drawplot_class::defaultDraw
;    cwo_drawplot_class::getColorImage
;    cwo_drawplot_class::writejpg
;    cwo_drawplot_class::writePS
;    cwo_drawplot_class::printWindow
;    cwo_drawplot_class::showMode
;    cwo_drawplot_class::getDataRange
;    cwo_drawplot_class::legend
;    cwo_drawplot_class::oplot
;    cwo_drawplot_class::print
;    cwo_drawplot_class::setDataRange
;    cwo_drawplot_class::setZoomRange
;    cwo_drawplot_class::setxlog
;    cwo_drawplot_class::setylog
;    cwo_drawplot_class::range
;    cwo_drawplot_class::zoombox
;    cwo_drawplot_class::createContextMenu
;    cwo_drawplot_class::add
;    cwo_drawplot_class::setData
;    cwo_drawplot_class::clearData
;    cwo_drawplot_class::hideData
;    cwo_drawplot_class::resize
;    cwo_drawplot_class::setProperty
;    cwo_drawplot_class::getProperty
;    cwo_drawplot_realize
;    cwo_drawplot_class::realize
;    cwo_drawplot_cleanup
;    cwo_drawplot_class::cleanup
;    cwo_drawplot_class::setvalues
;    cwo_drawplot_set_value
;    cwo_drawplot_get_value
;    cwo_drawplot_class::init
;    cwo_drawplot_class__define
;    run_cwo_drawplot_event
;    run_cwo_drawplot
;    cwo_drawplot
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu May 18 15:20:57 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################


;###############################################################################
;
;NAME:
;        setCircleSymbol
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro setCircleSymbol
;
;NAME:
;        setCircleSymbol
;
;PURPOSE:
;           Set up the circle as user-defined psym=8.
;PARAMETERS:
;           none
;KEYWORDS:
;           none



    symrad = 0.05


    symx = [symrad*(findgen(20)-10.0),symrad*(10.0-findgen(21))]
    symy = sqrt((10.0*symrad)^2 - symx^2)
    symy[21:*] = -1.0*symy[21:*]
    usersym,symx,symy
end;setCircleSymbol


;###############################################
;EVENT HANDLING METHODS
;###############################################
;###############################################################################
;
;NAME:
;        cwo_drawplot_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawplot_event,event

    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'cwo_drawplot: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return,-1
    endif


    widget_control,widget_info(event.handler,/child),get_uvalue=self
    event = self->event(event)
    return,event
end;cwo_drawplot_event


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawplot_class::event,event

    catch,es
    if es ne 0 then begin
        void = dialog_message('Error occurred in cwo_drawplot_class::event, please report the following: '+!error_state.msg)
        catch,/cancel
        return,-1
    endif

;NEED TO LOOK FOR BUTTON EVENTS, THEN

;NEED TO LOOK FOR contextMenu EVENTS HERE AND HANDLE IF NECESSARY.
;IF NOT NECESSARY, FINISH THIS METHOD . . . MONDAY!!!!!!

    etype = strupcase(tag_names(event,/structure_name))

    case etype of
    'WIDGET_BUTTON':begin

        self.mouseinwindow = 1

        self->handleContextMenu,event
        self.leftmousepressed = 0
        self.zoomboxflag = 0
        event.id = self.tlb
        xrange=self.zoomxrange
        yrange=self.zoomyrange
        xbeg = double('nan')
        xend = double('nan')
        ybeg = double('nan')
        yend = double('nan')
        event = {id:self.tlb,top:self.parent,handler:self.parent,$
                    xbeg:xbeg,xend:xend,ybeg:ybeg,yend:yend,$
                    xrange:xrange,yrange:yrange,obj:self}


        ;return,-1
    end;
    'WIDGET_TRACKING':begin
        self.mouseinwindow = event.enter
        event = -1  ;ADDING THIS.  TRACKING EVENTS SHOULD BE HANDLED IN THIS CLASS AND NOT PASSED ON.
                    ;SHOULD DO SOME TESTING ON THIS FIRST.
    end;WIDGET_TRACKING
    'WIDGET_DRAW':begin
        self.mouseinwindow = 1
        case event.key of
        0:event = self->handleMouseEvents(event)
        else:event = self->handleKeyboardEvents(event)
        endcase
    end;WIDGET_DRAW
    else:begin
    end;else
    endcase
    ;print,'self.mouseinwindow=',self.mouseinwindow

    self->draw
    return,event
end;cwo_drawplot_class::event

;;;###############################################################################
;;;
;;;NAME:
;;;        cwo_drawplot_class::handleKeyboardEvents
;;;
;;;PURPOSE:
;;;
;;;PARAMETERS:
;;;
;;;KEYWORDS:
;;;
;;;_EXTRA - is used to pass keywords meant for the superclass.
;;;
;;;RETURN VALUE:
;;;
;;;###############################################################################
;;function cwo_drawplot_class::handleKeyboardEvents,event
;;
;;
;;
;;    if event.press ne 0 then begin
;;        case event.key of
;;        5:begin
;;            if event.press ne 0 then self.xlegend -= 0.01
;;        end;5
;;        6:begin
;;            self.xlegend += 0.01
;;        end;6
;;        7:begin
;;            self.ylegend += 0.01
;;        end;7
;;        8:begin
;;            self.ylegend -= 0.01
;;        end;8
;;        9:begin
;;            self.xlegend = 0.8
;;            self.ylegend = 0.8
;;        end;9
;;        10:begin
;;            self.xlegend = 0.8
;;            self.ylegend = 0.2
;;        end;10
;;        11:begin
;;            self.xlegend = 0.2
;;            self.ylegend = 0.8
;;        end;11
;;        12:begin
;;            self.xlegend = 0.2
;;            self.ylegend = 0.2
;;        end;12
;;        else:
;;        endcase
;;    endif;event.press
;;
;;    event = -1
;;end;handleKeyboardEvents


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::handleKeyboardEvents
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawplot_class::handleKeyboardEvents,event


    if event.press ne 0 then begin
        case event.key of
        5:begin
            if event.press ne 0 then self.xlegend -= 0.01
        end;5
        6:begin
            self.xlegend += 0.01
        end;6
        7:begin
            self.ylegend += 0.01
        end;7
        8:begin
            self.ylegend -= 0.01
        end;8
        9:begin
            self.xlegend = 0.8
            self.ylegend = 0.8
        end;9
        10:begin
            self.xlegend = 0.8
            self.ylegend = 0.2
        end;10
        11:begin
            self.xlegend = 0.2
            self.ylegend = 0.8
        end;11
        12:begin
            self.xlegend = 0.2
            self.ylegend = 0.2
        end;12
        else:
        endcase
    endif;event.press

    event = -1
end;handleKeyboardEvents

;###############################################################################
;
;NAME:
;        cwo_drawplot_class::handleContextMenu
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::handleContextMenu,event,zoommode=zoommode


        uname = ''
        if n_elements(zoommode) eq 1 then begin
            case zoommode of
            0:uname = 'ZOOMMODE'
            1:uname = 'POSITIONMODE'
            2:uname = 'START_ENDMODE'
            3:uname = 'REGIONMODE'
            else:
            endcase
        endif else begin
            uname = widget_info(event.id,/uname)
        endelse
        if uname ne '' then begin


    ;        print,uname
    ;        print,'cwo_drawplot_class::handleContextMenu'
    ;        print,self.contextmenu
            parent  = self.contextmenu;widget_info(event.id,/parent)
    ;        print,parent
            zoommode = widget_info(parent,find_by_uname='ZOOMMODE')
            positionmode = widget_info(parent,find_by_uname='POSITIONMODE')
            StartStopmode = widget_info(parent,find_by_uname='START_ENDMODE')
            regionmode = widget_info(parent,find_by_uname='REGIONMODE')
            logxmode = widget_info(parent,find_by_uname='LOGXMODE')
            logymode = widget_info(parent,find_by_uname='LOGYMODE')


    ;print,self.winvis
            case uname of
            'UNZOOM':begin
                self->unzoom
            end;UNZOOM
            'PRINTJPG':begin
                self->draw,/printwin,/jpg
            end;PRINTJPG
            'PRINTDEFAULTPRINTER':begin
                self->draw,/printwin,/defaultPrinter
            end;PRINTDEFAULTPRINTER
            'PRINTPS':begin
                self->draw,/printwin,/ps
            end;PRINTPS
            'HIDEMODELABEL':begin
                self.hidemodelabel = (self.hidemodelabel eq 1 ? 0 : 1)
            end;HIDEMODELABEL
            'ZOOMMODE':begin
                ;RUBBER BAND BOX ZOOMING
                widget_control,zoommode,set_value='[X] Zoom'
                widget_control,positionmode,set_value='[_] Position'
                widget_control,StartStopmode,set_value='[_] Start/End'
                widget_control,regionmode,set_value='[_] Region'
                self.zoom_selectmode = 0
            end;ZOOMMODE
            'POSITIONMODE':begin
                ;REFLECTS POSTION ON PLOT WHILE MOUSE IS DRAGGED
                widget_control,zoommode,set_value='[_] Zoom'
                widget_control,positionmode,set_value='[X] Position'
                widget_control,StartStopmode,set_value='[_] Start/End'
                widget_control,regionmode,set_value='[_] Region'
                self.zoom_selectmode = 1
            end;POSITIONMODE
            'START_ENDMODE':begin
                ;SET START POINT ON MOUSE PRESS AND DRAW LINE FROM THERE TO
                ;CURRENT MOUSE POSITION ON DRAG
                widget_control,zoommode,set_value='[_] Zoom'
                widget_control,positionmode,set_value='[_] Position'
                widget_control,StartStopmode,set_value='[X] Start/End'
                widget_control,regionmode,set_value='[_] Region'
                self.zoom_selectmode = 2
            end;START_ENDMODE
            'REGIONMODE':begin
                ;RUBBER BAND BOX REGION SELECTION
                widget_control,zoommode,set_value='[_] Zoom'
                widget_control,positionmode,set_value='[_] Position'
                widget_control,StartStopmode,set_value='[_] Start/End'
                widget_control,regionmode,set_value='[X] Region'
                self.zoom_selectmode = 3
            end;REGIONMODE
            'LOGXMODE':begin
                self.xlog = (self.xlog eq 1 ? 0 : 1)
                char = (self.xlog eq 1 ? 'X' : '_')
                widget_control,logxmode,set_value='['+char+'] log(x)'
            end;LOGXMODE
            'LOGYMODE':begin
                self.ylog = (self.ylog eq 1 ? 0 : 1)
                char = (self.ylog eq 1 ? 'X' : '_')
                widget_control,logymode,set_value='['+char+'] log(y)'
            end;LOGYMODE
            'DATASETHIDE':begin
                print,'Data Set Hide'
                widget_control,event.id,get_uvalue=dat
                dat->toggleHide
            end;DATASETHIDE
            else:;OTHERS???
            endcase
        endif;''

end;handleContextMenu

;###############################################################################
;
;NAME:
;        cwo_drawplot_class::handleMouseEvents
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawplot_class::handleMouseEvents,event



        !x = *self.xptr
        !y = *self.yptr
        pcoord = convert_coord(self.pressxy,/device,/to_data)
        rcoord = convert_coord(self.releasexy,/device,/to_data)


        xbeg = pcoord[0]  ;double('nan')
        xend = rcoord[0];double('nan')
        ybeg = pcoord[1]  ;double('nan')
        yend = rcoord[1];double('nan')


        zoom = 0    ;FLAGS TO TELL IF RELEASE EVENT IS ZOOM OR SELECT OR NEITHER.
        select = 0

        pressButton = event.press
        releaseButton = event.release


        ;ZOOMING EVENTS
        ;GET LEFT PRESS POINT
        if event.press eq 1 then begin


            switch self.zoom_selectmode of
            0:
            1:
            2:
            3: begin
                self.leftmousepressed = 1
                self.zoomboxflag = 1
                self.pressxy = [event.x,event.y]


                pcoord = convert_coord(self.pressxy,/device,/to_data)
                rcoord = pcoord


                xbeg = pcoord[0]  ;double('nan')
                xend = rcoord[0];double('nan')
                ybeg = pcoord[1]  ;double('nan')
                yend = rcoord[1];double('nan')


                break
            end;3
            else:
            endswitch
        endif


        ;GET LEFT RELEASE POINT AND SET NEW RANGE VALUES
        if event.release eq 1 then begin


            self.leftmousepressed = 0
            self.zoomboxflag = 0
            case self.zoom_selectmode of
            0:begin
        ;        self.zoomboxflag = 0
                self.releasexy = [event.x,event.y]
                xend = self.releasexy[0]
                yend = self.releasexy[1]


                if self.pressxy[0] ne self.releasexy[0] or $
                    self.pressxy[1] ne self.releasexy[1] then begin
                        self->setZoomRange


                        self.zoomflag = 1
                    zoom=1
                    select=0
                endif
            end;0
            1:begin
                ;POSITION MODE
        ;        self.zoomboxflag = 0
                self.releasexy = [event.x,event.y]


                rcoord = convert_coord(self.releasexy,/device,/to_data)
                xend = rcoord[0];double('nan')
                yend = rcoord[1];double('nan')
                zoom=0
                select=0
            end;1
            2:begin
                ;START/END
        ;        self.zoomboxflag = 0
                self.releasexy = [event.x,event.y]
                rcoord = convert_coord(self.releasexy,/device,/to_data)
                xend = rcoord[0];double('nan')
                yend = rcoord[1];double('nan')
                zoom=0
                select = 1
            end;2


            3:begin
                ;REGION
        ;        self.zoomboxflag = 0
                self.releasexy = [event.x,event.y]
                rcoord = convert_coord(self.releasexy,/device,/to_data)
                xend = rcoord[0];double('nan')
                yend = rcoord[1];double('nan')
                zoom=0
                select = 1
            end;3
            else:begin
                zoom=0
                select=0
            endelse
            endcase



        endif


;        if event.release eq 4 then begin
;
;            ;widget_displaycontextmenu, self.tlb, event.x, event.y, self.contextMenu
;
;            ;UNZOOM FLAG
;            self.zoomflag = 0
;
;            ;RESTORE RANGES TO THE UNZOOMED VALUES
;            self.zoomxrange = self.xrange
;            self.zoomyrange = self.yrange
;        endif


        if event.press eq 4 then begin
            geom = widget_info(self.tlb,/geometry)
            self->updateContextSetList
            widget_displaycontextmenu,  self.tlb,$
                                        event.x,$
                                        geom.ysize - event.y, $
                                        self.contextMenu



            return,-1
        endif


;######################################################################
;
;   DEALING WITH DRAG EVENTS:
;
;######################################################################
        ;GET MOUSE POSITION ON DRAG WITH LEFT MOUSE BUTTON PRESSED
        if self.leftmousepressed eq 1 then begin
            self.mousexy = [event.x,event.y]
;            xend = self.mousexy[0]
;            yend = self.mousexy[1]
            rcoord = convert_coord(self.mousexy,/device,/to_data)
            xend = rcoord[0];double('nan')
            yend = rcoord[1];double('nan')


            ;020607
            ;SWALLOW DRAG EVENTS --- EXCEPT ON MOTION

            ;IF NOT POSITION MODE, SWALLOW EVENTS.

            if self.zoom_selectmode ne 1 then return,-1

        endif
;#####################################################################


        xrange=self.zoomxrange
        yrange=self.zoomyrange



    if self.leftmousepressed eq 0 and $
            self.rightmousepressed eq 0 and $
                event.release eq 0 then begin


        ;SWALLOW MOTION EVENTS WHEN NO BUTTON PRESSED/RELEASED.
        return,-1
    endif else begin
        event = {id:self.tlb,top:self.parent,handler:self.parent,$
                    xbeg:xbeg,xend:xend,ybeg:ybeg,yend:yend,$
                    xrange:xrange,yrange:yrange,zoom:zoom,select:select,$
                    mode:self.zoom_selectmode,$
                    press:pressButton,release:releaseButton}
        return,event
    endelse


end;handleMouseEvents



;###############################################################################
;
;NAME:
;        cwo_drawplot_class::reportRanges
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::reportRanges, xrange=xrange,yrange=yrange,xlog=xlog,ylog=ylog,$
                                xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax



    ;FOR COMMUNICATION WITH cwo_plotrangeloglin
    !x = *self.xptr
    !y = *self.yptr


    if self.xlog eq 1 then xrange = 10.0^((!x.crange)[0:1]) $
                      else xrange = (!x.crange)[0:1]


;    xrange = self.zoomxrange;(!x.crange)[0:1]


    if self.ylog eq 1 then yrange = 10.0^((!y.crange)[0:1]) $
                      else yrange = (!y.crange)[0:1]
;    yrange = self.zoomyrange;(!y.crange)[0:1]
    xlog = self.xlog
    ylog = self.ylog
    xmin = xrange[0]
    xmax = xrange[1]
    ymin = yrange[0]
    ymax = yrange[1]



end;reportRanges


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::unzoom
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::unzoom

            ;UNZOOM FLAG
            self.zoomflag = 0
            if finite(self.xmaxrange[0],/nan) eq 0 then xmin = self.xmaxrange[0] else $
                                                        xmin = self.xrange[0]
            if finite(self.xmaxrange[1],/nan) eq 0 then xmax = self.xmaxrange[1] else $
                                                        xmax = self.xrange[1]
            if finite(self.ymaxrange[0],/nan) eq 0 then ymin = self.ymaxrange[0] else $
                                                        ymin = self.yrange[0]
            if finite(self.ymaxrange[1],/nan) eq 0 then ymax = self.ymaxrange[1] else $
                                                        ymax = self.yrange[1]

            ;RESTORE RANGES TO THE UNZOOMED VALUES
            self.zoomxrange = [xmin,xmax];self.xrange
            self.zoomyrange = [ymin,ymax];self.yrange

end;unzoom

;###############################################################################
;
;NAME:
;        cwo_drawplot_class::updateContextSetList
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::updateContextSetList


    ;THIS CRASHES UNDER LINUX.  OMIT THIS FEATURE FOR NOW.
    ;MOST LIKELY I WILL HAVE TO ADD A POPUP WINDOW THAT WILL
    ;DO THE SAME FUNCTIONALITY.


    ;I BELIEVE THIS PROBLEM WAS EXPERIENCED BEFORE IN THE
    ;ooDisplayEcho WHEN I WANTED TO REOMVE FOURIER TIMES.
    if !version.os eq 'Win32' then begin


        widget_control,self.showHideSetList,/destroy
        self.showHideSetList = widget_button(self.showHideSetMenu,value='Sets:',/menu)


        count = self->count()


        for i=0,count-1 do begin
            ref = self->get(position=i)
            ref->getproperty,legend=legend,id=id
            ;print,id,legend
            s = strtrim(string(i),2)
            but = widget_button(self.showHideSetList,$
                                value='Set'+s,$
                                uvalue=ref,$
                                uname='DATASETHIDE')
        endfor;i
    endif;Win32


end;updateContextSetList



;#################################################
;WINDOW HANDLING METHODS
;#################################################


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::copyWindow
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::copyWindow


    geom = widget_info(self.draw,/geometry)
    ;PROVIDE OPTIONS TO COPY THIS TO PS DEVICE
    wset,self.winvis
    device,copy=[0,0,geom.xsize,geom.ysize,0,0,self.winpix]


end;cwo_drawplot_class::copyWindow
;###############################################################################
;
;NAME:
;        cwo_drawplot_class::saveWindow
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::saveWindow


    geom = widget_info(self.draw,/geometry)
    ;PROVIDE OPTIONS TO COPY THIS TO PS DEVICE
    wset,self.winsav
    device,copy=[0,0,geom.xsize,geom.ysize,0,0,self.winpix]


end;cwo_drawplot_class::copyWindow
;###############################################################################
;
;NAME:
;        cwo_drawplot_class::setWindow
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawplot_class::setWindow


    ;PROVIDE OPTIONS TO COPY THIS TO PS DEVICE
    ;PERHAPS HAVE A self.printpix WINDOW AVAILABLE FOR
    ;HIGH RESOLUTION PRINTING.


    ;SET DEVICE IN CASE IT HAS BEEN CHANGED ELSEWHERE.
    if !version.os eq 'Win32' then begin
        devicename = 'Win'
    endif else begin
        devicename = 'X'
    endelse

    set_plot,devicename

    if widget_info(self.draw,/valid) eq 0 then return,0
    
    if widget_info(self.draw,/realized) gt 0 then begin
        wset,self.winpix
        return,self.winpix;1
    endif else begin
        return,0
    endelse



end;cwo_drawplot_class::setWindow
;#################################################
;DRAWING METHODS
;#################################################
;###############################################################################
;
;NAME:
;        cwo_drawplot_class::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::draw,printwin=printwin,$
                       ps=ps,jpg=jpg,printdir=printdir,$
                       defaultPrinter=defaultPrinter,$
                       _Ref_Extra=extra;,position=position,_Extra=extra


    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'cwo_drawplot_class::draw: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
    endif



;    print,'cwo_drawplot_class::draw'
;    help,/traceback
;    help,extra
;    print,tag_names(extra)
;    print,extra.(0)


    ;SET USER SYMBOL HERE IN CASE IT WAS CHANGED ELSEWHERE
    setCircleSymbol

    if n_elements(defaultPrinter) eq 0 then defaultPrinter = 0
    if n_elements(printwin) eq 0 then printwin = 0
    if n_elements(jpg) eq 0 then jpg = 0
    if n_elements(ps) eq 0 then ps = 0
    if n_elements(position) eq 4 then begin
	self.position = self.position
    endif

    device,get_decomposed=dc
    device,decomposed=1




    win = self->setwindow() ;THE PRINT METHOD SHOULD CHANGE THE WINDOW TO 'PS'
                            ;AND THEN CHANGE IT BACK AT THE END OF PRINTING.
                            ;setWindow and copyWindow FUNCTIONALITY SHOULE BE
                            ;SET UP TO MAKE THE PRINT PROCESS WORK OUT.



    if win ne 0 then begin

        if self.zoomboxflag eq 0 then begin
                black = 0L
                red = 255L & green = 256L*red & blue = 256L*green
                white = red + green + blue


                xrange = self.zoomxrange
                yrange = self.zoomyrange


                if self.zoomflag eq 1 then begin
                    xstyle = 1
                    ystyle = 1
                endif else begin
                    xstyle = 0
                    ystyle = 0
                endelse

        font=0;-1
        !p.font = -1
                ;SET THE AXIS RANGES FOR THIS PLOT
                if min(xrange) ne max(xrange) $
                    and min(yrange) ne max(yrange) then begin

                        if self.xticks ne -1 then xticks = self.xticks else xticks = 0
                        if abs(xrange[1]-xrange[0]) lt 0.01 then xticks = 2
                        plot,xrange,yrange,/nodata,background=white,$
                            xrange = xrange,$;self.zoomxrange,$
                            yrange = yrange,$;self.zoomyrange,$
                            xstyle=xstyle,ystyle=ystyle,$
                            color = black,$
                            title=self.title,$
                            xtitle=self.xtitle,$
                            ytitle=self.ytitle,$
                            xlog = self.xlog,$
                            ylog = self.ylog,$
                            position = self.position,$
                            xcharsize=1.25,$
                            ycharsize=1.25,$
                            xticks=xticks;,font=font
                endif else begin
                        plot,xrange,yrange,/nodata,background=white,$
                            xstyle=xstyle,ystyle=ystyle,$
                            color = black,$
                            title=self.title,$
                            xtitle=self.xtitle,$
                            ytitle=self.ytitle,$
                            xlog = self.xlog,$
                            ylog = self.ylog,$
                            ;charsize=1.5,$
                            position = self.position;,font=font
                endelse

                ;RELEASE AXIS POINTERS FOR WINDOW
                ptr_free,self.xptr
                ptr_free,self.yptr

                ;RESET AXIS POINTERS
                self.xptr = ptr_new(!x)           ;MUST SET THESE HERE TO ASSIGN
                self.yptr = ptr_new(!y)           ;POINTERS TO PROPER AXES!!!

                ;OPLOT THE DATA
                self->oplot,win,_strict_Extra=extra

                self->showMode,win
                self->savewindow

        endif else begin
            geom = widget_info(self.draw,/geometry)
            device,copy=[0,0,geom.xsize,geom.ysize,0,0,self.winsav]
        endelse
;PERHAPS WANT A ZOOMBOX v. SELECTBOX OPTION.
        self->zoombox,win
;        self->showMode,win

        self->copywindow
        if printwin eq 1 then self->printWindow,jpg=jpg,ps=ps,printdir=printdir,defaultPrinter=defaultPrinter

    endif

    device,decomposed = dc
end;cwo_drawplot_class::draw


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::defaultDraw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::defaultDraw,xmin=xmin,xmax=xmax,$
                              ymin=ymin,ymax=ymax,$
                              printwin=printwin,$
                              nodraw=nodraw,$
                              _ref_Extra=extra


;    print,'cwo_drawplot_class::defaultDraw'
;    help,extra
;    print,tag_names(extra)
;    print,extra.(0)

    if n_elements(nodraw) eq 0 then nodraw = 0

    self->getDataRange  ;GETS OVERALL RANGE OF ALL DATA CONTAINED
    self->getproperty,xrange=xrange,yrange=yrange   ;RETRIEVE THE RANGES FROM SELF
    ;print,xrange,yrange


    if n_elements(xmin) eq 0 then xmin = xrange[0]
    if n_elements(xmax) eq 0 then xmax = xrange[1]
    if n_elements(ymin) eq 0 then ymin = yrange[0]
    if n_elements(ymax) eq 0 then ymax = yrange[1]

    self.xrange = [xmin,xmax]   ;SET THE RANGES BASED ON USER INPUTS IN CASE FOR INSTANCE USER
    self.yrange = [ymin,ymax]   ;WANTS ALL DATA GREATER THAN ZERO, AS WITH COUNTS.  WHAT ABOUT LOG???

    self->setDataRange,xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax,/no_draw ;SETS ZOOM RANGES
    if nodraw eq 0 then begin
        self->draw,printwin=printwin,_strict_Extra=extra
    endif

end;defaultDraw


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::getColorImage
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawplot_class::getColorImage

    self->draw
    win=self->setWindow()
    ;fn = 'C:\Documents and Settings\kneller\My Documents\DAVE_SOURCEFORGE\dave\programs\tas\ResGUI3\LatestFromWilliam\jpgtest.jpg'

    image = tvrd(true=3)

    return,image
end;cwo_drawplot_class::getImage
;###############################################################################
;
;NAME:
;        cwo_drawplot_class::writejpg
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::writejpg,image,fn
    len = strlen(fn)

    if fn ne '' then begin
        if len gt 4 then begin
            ext = strmid(fn,3,/reverse_offset)
            if strcmp(ext,'.jpg',/fold_case) eq 0 then fn = fn+'.jpg'
        endif else begin
            fn = fn + '.jpg'
        endelse

        if file_test(file_dirname(fn),/write) ne 0 then begin
            write_jpeg,fn,image,true=3
        endif else begin
            void = dialog_message('No write permission for this directory.')
        endelse

    endif else begin
        void = dialog_message('File name is invalid.')
    endelse

end;writejpg


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::writePS
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::writePS,image,fn


    catch,es
    if es ne 0 then begin
        void = dialog_message('Error at cwo_drawplot_class::writePS:'+(!error_state).msg)
        catch,/cancel
        return
    endif

    len = strlen(fn)

    if fn ne '' then begin
        if len gt 3 then begin
            ext = strmid(fn,2,/reverse_offset)
            if strcmp(ext,'.ps',/fold_case) eq 0 then fn = fn+'.ps'
        endif else begin
            fn = fn + '.ps'
        endelse


    ;THIS IS PRETTY GENERAL!
        sz = size(image)
;print,sz
        if file_test(file_dirname(fn),/write) ne 0 then begin
            set_plot,'PS'
            device,/color,file=fn,/inches,xsize=8.5,ysize=11
            ;plotimage,image,/no_axes
            if sz[0] eq 3 then begin

                ;UPDATE THE ASPECT RATIO AND TV THE IMAGE.
                aspect = float(sz[2])/float(sz[1])
                longside = 8.5

                if aspect ge 1 then begin
                    ysize = longside
                    xsize = longside/aspect
                endif else begin
                    xsize = longside
                    ysize = longside*aspect
                endelse
                tv,image,0.0,-4,true=3,xsize=xsize,ysize=ysize,/inches
            endif else begin
                tv,image
            endelse
            device,/close
        endif else begin
            void = dialog_message('No write permission for this directory.')
        endelse



        if !version.os eq 'Win32' then begin
            set_plot,'WIN'
        endif else begin
            set_plot,'X'
        endelse
    endif else begin
        void = dialog_message('File name is invalid.')
    endelse


end;cwo_drawplot_class::writePS






;###############################################################################
;
;NAME:
;        cwo_drawplot_class::printWindow
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::printWindow,jpg=jpg,ps=ps,printdir=printdir,defaultPrinter=defaultPrinter
;
;NAME:
;        cwo_drawplot_class::printWindow
;
;PURPOSE:
;           Print the plot to a .ps file --- eventually.
;PARAMETERS:
;           none
;KEYWORDS:
;           ps  PS option
;           jpg JPEG option


    if n_elements(defaultPrinter) eq 0 then defaultPrinter = 0
    if n_elements(ps)  eq 0 then ps  = 0
    if n_elements(jpg) eq 0 then jpg = 0
    if n_elements(printdir) eq 1 then path = printdir else path = ''

    if jpg eq 0 and ps eq 0 and defaultPrinter eq 0 then ps = 1

    if defaultPrinter  eq 1 then begin
        ;filter = '*.ps'
        ;fn = dialog_pickfile(filter=filter,title='Select .ps Output File:',/write,path=path)
        ;if fn ne '' then begin
            ;printdir = file_dirname(fn)
            win=self->setWindow()
            ;image = tvrd(true=3)
            ;self->writePS,image,fn;,true=3
            LK_PrintDirectGraphicsWindowToDefaultPrinter, win, /Landscape,/true
        ;endif
    endif


    if ps  eq 1 then begin
        filter = '*.ps'
        fn = dialog_pickfile(filter=filter,title='Select .ps Output File:',/write,path=path)
        if fn ne '' then begin
            printdir = file_dirname(fn)
            win=self->setWindow()
            image = tvrd(true=3)
            self->writePS,image,fn;,true=3
        endif
    endif

    if jpg eq 1 then begin
        filter = '*.jpg'
        fn = dialog_pickfile(filter=filter,title='Select .jpg Output File:',/write,path=path)
        if fn ne '' then begin
            printdir = file_dirname(fn)
            win=self->setWindow()
            image = tvrd(true=3)
            self->writejpg,image,fn
        endif
    endif

end;printWindow


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::showMode
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::showMode,win


        ;SHOW THE CURRENT MODE IN THE LOWER LEFTHAND CORNER OF THE PLOT


    if self.hidemodelabel eq 0 then begin
        wset,win
        device,get_decomposed=dc
        device,decomposed=1


        mode = ['ZOOM','POSITION','START/END','REGION']
        s = 'MODE = '+mode[self.zoom_selectmode]
        xyouts,0.0,0.0,s,/normal,color=0L,charsize=.75
        device,decomposed=dc
    endif


end;showMode



;###############################################################################
;
;NAME:
;        cwo_drawplot_class::togglehideplot
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################

pro cwo_drawplot_class::togglehideplot


        self.showplot = (self.showplot eq 1 ? 0 : 1)

        if self.showplot eq 1 then begin
            x = self.xshow
            y = self.yshow
        endif else begin
            x = self.xhide
            y = self.yhide
        endelse

        widget_control,self.tlb,xoffset=x,yoffset=y

end;togglehideplot


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::getDataRange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::getDataRange,xmin=xin,xmax=xmax,ymin=ymin,ymax=ymax


    count = self->count()   ;inherited from idl_container

    if count gt 0 then begin
        ref = self->get(position=0)
        xvals = ref->xrange()
        yvals = ref->yrange()

        for i=1,count-1 do begin
            ref = self->get(position=i)
            xvals = [xvals,ref->xrange()]
            yvals = [yvals,ref->yrange()]
        endfor;i

        xmin = min(xvals)
        xmax = max(xvals)
        ymin = min(yvals)
        ymax = max(yvals)


		if finite(xmin) ne 1 and finite(xmax) ne 1 then begin
			xmin = 0.0
			xmax = 1.0
		endif

		if finite(ymin) ne 1 and finite(ymax) ne 1 then begin
			ymin = 0.0
			ymax = 1.0
		endif



        self.xrange = [xmin,xmax]
        self.yrange = [ymin,ymax]
    endif else begin
        self.xrange = [0,1]
        self.yrange = [0,1]
        self.zoomxrange = [0,1]
        self.zoomyrange = [0,1]
    endelse



end;cwo_drawplot_class::getDataRange



;###############################################################################
;
;NAME:
;        cwo_drawplot_class::legend
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::legend,win,yoffset,legend,psym,symsize,color,linestyle,$
                        showdata,showlegend,_Extra=extra


catch,es
if es ne 0 then begin
    void = dialog_message('Error occurred, please report the following: '+!error_state.msg)
    catch,/cancel
    return
endif

;print,'cwo_drawplot_class::legend'
        ;KEEP TRACK OF TOTAL NUMBER OF LEGENDS SHOWN SO THEY ARE DISPLAYED
        ;CLOSE TOGETHER.
        j=0
        for i = 0, self->count()-1 do begin
            ref = self->get(position=i)
;help,ref

            ref->legend,win,self.xlegend,self.ylegend-0.05*j,symsize=0.85
            ref->getproperty,showlegend=refshowlegend
            if refshowlegend ne 0 then j++
        endfor;i


end;cwo_drawplot_class::legend



;###############################################################################
;
;NAME:
;        cwo_drawplot_class::oplot
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::oplot,win,_ref_Extra=extra    ;OVERRIDE IN SUBCLASSES


    ;OVERPLOT THE DATA OBJECTS IN THE PLOT.
    for i = 0, self->count()-1 do begin
        ;071806
        ;
        !x = *self.xptr
        !y = *self.yptr


        ref = self->get(position=i)
        ref->draw,win,_strict_Extra=extra
    endfor;i


    ;NEED SEPARATE LEGEND CALL SO THAT THE SETTING OF NORMAL COORDS FOR
    ;LEGENDS DOES NOT CONFLICT WITH THE PLOT COORDINATES
    if self.showlegend gt 0 then begin
        self->legend,win,_strict_Extra=extra
    endif


end;cwo_drawplot_class::oplot




;###############################################################################
;
;NAME:
;        cwo_drawplot_class::print
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::print
    print,'SET UP PRINTING ITEMS HERE.  PROBABLY A CALL TO setWindow, copyWindow, AND draw'


    set_plot,'PS'
    device,/color,/landscape,file='PRINTPLOT.ps'
    !P.font = 0 ;or 1?


    self->draw ;?
    device,/close


end;cwo_drawplot_class::print


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::setDataRange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::setDataRange,xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax,no_draw=no_draw


    ;SET THE ZOOM RANGE BASED ON THE INPUTS.


    ;QUIT DRAWING THE BOX AND SET THE RANGE

    if n_elements(no_draw) eq 0 then no_draw = 0


    if n_elements(xmin) ne 0 then begin
        self.zoomxrange[0] = xmin
        self.zoomflag = 1
    endif
    if n_elements(xmax) ne 0 then begin
        self.zoomxrange[1] = xmax
        self.zoomflag = 1
    endif
    if n_elements(ymin) ne 0 then begin
        self.zoomyrange[0] = ymin
        self.zoomflag = 1
    endif
    if n_elements(ymax) ne 0 then begin
        self.zoomyrange[1] = ymax
        self.zoomflag = 1
    endif

    if no_draw eq 0 then begin
        self->draw
    endif

end;setDataRange
;###############################################################################
;
;NAME:
;        cwo_drawplot_class::setZoomRange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::setZoomRange


    ;SET THE ZOOM RANGE BASED ON THE MOUSE POSITIONS.


    ;QUIT DRAWING THE BOX AND SET THE RANGE


        xmin = min([self.pressxy[0],self.releasexy[0]])
        xmax = max([self.pressxy[0],self.releasexy[0]])
        ymin = min([self.pressxy[1],self.releasexy[1]])
        ymax = max([self.pressxy[1],self.releasexy[1]])


    !x = *self.xptr
    !y = *self.yptr


    mincoords = convert_coord([xmin,ymin],/device,/to_data)
    maxcoords = convert_coord([xmax,ymax],/device,/to_data)


    self.zoomxrange = [mincoords[0],maxcoords[0]]
    self.zoomyrange = [mincoords[1],maxcoords[1]]



end;setZoomRange
;###############################################################################
;
;NAME:
;        cwo_drawplot_class::setxlog
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::setxlog,xlog
    logxmode = widget_info(self.contextmenu,find_by_uname='LOGXMODE')
    self.xlog = xlog
    char = (self.xlog eq 1 ? 'X' : '_')
    widget_control,logxmode,set_value='['+char+'] log(x)'
end;setxlog
;###############################################################################
;
;NAME:
;        cwo_drawplot_class::setylog
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::setylog,ylog
    self.ylog = ylog
    logymode = widget_info(self.contextmenu,find_by_uname='LOGYMODE')
    char = (self.ylog eq 1 ? 'X' : '_')
    widget_control,logymode,set_value='['+char+'] log(y)'
end;setylog

pro cwo_drawplot_class::updateDataRanges,xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax,$
                                    xlog=xlog,ylog=ylog

    if n_elements(xlog) eq 1 then self->setxlog,xlog
    if n_elements(ylog) eq 1 then self->setylog,ylog
    self->setDataRange,xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax


end;updateDataRanges
pro cwo_drawplot_class::retrieveDataRanges,xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax,$
                                     xlog=xlog,ylog=ylog

    xmin=self.zoomxrange[0]
    xmax=self.zoomxrange[1]
    ymin=self.zoomyrange[0]
    ymax=self.zoomyrange[1]
    xlog = self.xlog
    ylog = self.ylog

end;retrieveDataRanges



;###############################################################################
;
;NAME:
;        cwo_drawplot_class::range
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::range,xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax
    ;SET THE ZOOM RANGE EXPLICITLY. CALLED BY OUTSIDE USER.


        if n_elements(xmin) eq 0 then xmin = self.zoomxrange[0]
        if n_elements(xmax) eq 0 then xmax = self.zoomxrange[1]
        if n_elements(ymin) eq 0 then ymin = self.zoomyrange[0]
        if n_elements(ymax) eq 0 then ymax = self.zoomyrange[1]


    self.zoomflag = 1
    self.zoomxrange = [xmin,xmax]
    self.zoomyrange = [ymin,ymax]


end;range



;###############################################################################
;
;NAME:
;        cwo_drawplot_class::zoombox
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::zoombox,win



    ;#################################################################
    ;THIS COULD BE A GENERIC BOXING ROUTINE USED FOR SELECTION OR FOR
    ;ZOOMING OR ANY OTHER USE I CAN THINK OF, SINCE ALL IT DOES IS
    ;DRAW A BOX.
    ;#################################################################



        wset,win
        device,get_decomposed=dc
        device,decomposed=1


		zoomboxcolor = 255L*256L;0L

        case self.zoom_selectmode of
        0:begin
            ;DRAW THE ZOOMBOX
            if self.zoomboxflag eq 1 then begin
                xmin = min([self.pressxy[0],self.mousexy[0]])
                xmax = max([self.pressxy[0],self.mousexy[0]])
                ymin = min([self.pressxy[1],self.mousexy[1]])
                ymax = max([self.pressxy[1],self.mousexy[1]])


                x = [xmin,xmax,xmax,xmin,xmin]
                y = [ymin,ymin,ymax,ymax,ymin]


                plots,x,y,/device,color = zoomboxcolor
            endif
        end;0
        1:begin
            ;DISPLAY THE POSITION
            if self.zoomboxflag eq 1 then begin
                !x = *self.xptr
                !y = *self.yptr


                x = convert_coord([self.mousexy],/device,/to_data)


                ;plots,x,y,/device,color = 0L
                format = '(A1,g15.6,A1,g15.6,A1)'
                s = '[' + $
                    string(x[0],format='(g13.4)') + $
                    ',' + $
                    string(x[1],format='(g13.4)') + $
                    ']'
                xyouts,0.25,0.95,s,/normal,color=zoomboxcolor,charsize=.75
            endif
        end;1
        2:begin
            ;DRAW THE START/END LINE
            if self.zoomboxflag eq 1 then begin
                x = [self.pressxy[0],self.mousexy[0]]
                y = [self.pressxy[1],self.mousexy[1]]


                plots,x,y,/device,color = zoomboxcolor
            endif
        end;2
        3:begin
            ;DRAW THE SELECTION BOX
            if self.zoomboxflag eq 1 then begin
                xmin = min([self.pressxy[0],self.mousexy[0]])
                xmax = max([self.pressxy[0],self.mousexy[0]])
                ymin = min([self.pressxy[1],self.mousexy[1]])
                ymax = max([self.pressxy[1],self.mousexy[1]])


                x = [xmin,xmax,xmax,xmin,xmin]
                y = [ymin,ymin,ymax,ymax,ymin]


                plots,x,y,/device,color = zoomboxcolor
            endif
        end;3
        else:
        endcase
        device,decomposed=dc


end;cwo_drawplot_class::zoombox


;##########################################
;STARTUP METHODS
;##########################################
;###############################################################################
;
;NAME:
;        cwo_drawplot_class::createContextMenu
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawplot_class::createContextMenu



    ;print,'Creating Context Menu:'


    self.contextMenu = widget_base( self.tlb, $
                                    /CONTEXT_MENU,/col,$
                                    uname = 'CWO_DRAWPLOT_CONTEXTMENU',$
                                    uvalue={object:self,$
                                            method:'drawEvents',$
                                            id:'CWO_DRAWPLOT_CONTEXTMENU'})

    bttn0 = widget_button(self.contextMenu, value='Unzoom',$
                                uname='UNZOOM',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'UNZOOM',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})
    bttn0 = widget_button(self.contextMenu, value='Print to .ps',$
                                uname='PRINTPS',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'PRINTPS',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})
    bttn0 = widget_button(self.contextMenu, value='Print to .jpg',$
                                uname='PRINTJPG',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'PRINTJPG',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})
    bttn0 = widget_button(self.contextMenu, value='Print to Default Printer',$
                                uname='PRINTDEFAULTPRINTER',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'PRINTDEFAULTPRINTER',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})



    bttn1 = widget_button(self.contextMenu,value='Log/Lin',/menu)
    bttn1a = widget_button(bttn1, value='[_] Log(x)',$
                                uname='LOGXMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'LOGXMODE',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})
    bttn1a = widget_button(bttn1, value='[_] Log(y)',$
                                uname='LOGYMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'LOGYMODE',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})




    bttn1 = widget_button(self.contextMenu,value='Select/Zoom Mode',/menu)
    bttn1a = widget_button(bttn1, value='[X] Zoom',$
                                uname='ZOOMMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'ZOOMMODE',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})


    bttn1b = widget_button(bttn1, value='[_] Position',$
                                uname='POSITIONMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'POSITIONMODE',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})
    bttn1c = widget_button(bttn1, value='[_] Start/End',$
                                uname='START_ENDMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'START_ENDMODE',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})
    bttn1d = widget_button(bttn1, value='[_] Region Select',$
                                uname='REGIONMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'REGIONMODE',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})


    bttn1e = widget_button(bttn1, value='Hide/Show mode label',$
                                uname='HIDEMODELABEL',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'HIDEMODELABEL',$
                                        parent:'CWO_DRAWPLOT_CONTEXTMENU'})


    if !version.os eq 'Win32' then sensitive = 1 else sensitive = 0


    self.showHideSetMenu = widget_button(self.contextMenu,value='Show/Hide Set',$
                                                          /menu,$
                                                          sensitive=sensitive)


    self.showHideSetList = widget_button(self.showHideSetMenu,value='Sets:',/menu)


    return,1
end;createContextMenu



;##########################################
;GENERAL CLASS METHODS
;##########################################


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::add
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::add,obj,x=x,y=y,sy=sy,legend=legend,psym=psym,color=color,$
                            rescale=rescale,ebshow=ebshow,showlegend=showlegend,$
                            showdata=showdata,$
                            no_draw=no_draw,$
                            _Extra=extra


        if n_elements(no_draw) eq 0 then no_draw = 0

        if n_elements(showlegend) eq 0 then showlegend = 0
        if n_elements(showdata) eq 0 then showdata = 1
    if n_elements(rescale) eq 0 then rescale = 0
    if n_elements(obj) eq 0 then begin
        if n_elements(x) eq 0 then x = [0.0,1.0]
        if n_elements(y)  eq 0 then y = 0.0*x
        if n_elements(sy) eq 0 then begin
            sy = 0.0*x+1.0
            ebshow = 0
        endif
        if n_elements(ebshow) eq 0 then ebshow = 1


        if n_elements(legend) eq 0 then legend = ''
        if n_elements(psym) eq 0 then psym = 0
        if n_elements(color) eq 0 then color = 0L



        obj = obj_new('cwo_drawplot_data',x,y,sy,legend=legend,psym=psym,$
                                            color=color,ebshow=ebshow,$
                                            showlegend=showlegend,$
                                            showdata=showdata)
    endif


    self->idl_container::add,obj,_Extra=extra


    self->getDataRange


    if rescale gt 0 then begin
        self.zoomxrange = self.xrange
        self.zoomyrange = self.yrange
    endif
    self.hidemodelabel = 1

    if no_draw eq 0 then self->draw


end;cwo_drawplot_class::add



;###############################################################################
;
;NAME:
;        cwo_drawplot_class::setData
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::setData,x,y,sy,legend=legend,psym=psym,color=color,$
                  rescale=rescale,ebshow=ebshow,showlegend=showlegend,$
                  showdata=showdata,xtitle=xtitle,ytitle=ytitle,title=title,$
                  _Extra=extra


    if n_elements(x) gt 0 and n_elements(y) eq n_elements(x) then begin
        self->clearData
        self->add,x=x,y=y,sy=sy,legend=legend,psym=psym,color=color,$
                  rescale=rescale,ebshow=ebshow,showlegend=showlegend,$
                  showdata=showdata,_Extra=extra

        if n_elements(title)  gt 0 then self.title  = title
        if n_elements(xtitle) gt 0 then self.xtitle = xtitle
        if n_elements(ytitle) gt 0 then self.ytitle = ytitle

    endif


end;setData


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::clearData
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::clearData,position=position



    if n_elements(position) eq 0 then position = -1



    if position ne -1 then begin
        dat = self->get(position=position)
        self->remove,position=position
        if obj_valid(dat) then obj_destroy,dat
    endif else begin



        ;REMOVE ALL
        count = self->count()


        if count gt 0 then begin
            dat = self->get(/all)
            self->remove,/all
            if obj_valid(dat[0]) then obj_destroy,dat
        endif


    endelse


end;clearData
;###############################################################################
;
;NAME:
;        cwo_drawplot_class::hideData
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::hideData,position=position


    if n_elements(position) eq 0 then position = -1


    if position ne -1 then begin
        dat = self->get(position=position)
        if obj_valid(dat) then begin
            dat->hide
            dat->hidelegend
        endif
    endif else begin


        ;REMOVE ALL
        count = self->count()


        if count gt 0 then begin
            for i=0,count-1 do begin
                dat = self->get(position=i)
                dat->hide
                dat->hidelegend
            endfor;i
        endif;count


    endelse


end;hideData



;###############################################################################
;
;NAME:
;        cwo_drawplot_class::resize
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::resize,xsize,ysize,xoffset=xoffset,yoffset=yoffset


    widget_control,self.draw,xsize=xsize,ysize=ysize
    widget_control,self.tlb,xsize=xsize+2*self.frame,ysize=ysize+2*self.frame

    if n_elements(xoffset) ne 0 then begin
        widget_control,self.tlb,xoffset=xoffset
    endif
    if n_elements(yoffset) ne 0 then begin
        widget_control,self.tlb,yoffset=yoffset
    endif

;print,'TEST DRAWPLOT RESIZE'
    if self.winpix ne 0 then wdelete,self.winpix
    if self.winsav ne 0 then wdelete,self.winsav
;print,'TEST DRAWPLOT RESIZE'
    window,/free,/pixmap,xsize=xsize,ysize=ysize
    self.winpix = !d.window
    window,/free,/pixmap,xsize=xsize,ysize=ysize
    self.winsav = !d.window
    self->draw


end;cwo_drawplot_class::resize
;###############################################################################
;
;NAME:
;        cwo_drawplot_class::resize
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::adjustsize,dxsize,dysize,xsize=xsize,ysize=ysize
  
    ;geom = widget_info(self.tlb,/geometry)
    ;help,geom,/struct
    if n_elements(dxsize) eq 0 then dxsize = 0
    if n_elements(dysize) eq 0 then dysize = 0

    geom = widget_info(self.draw,/geometry)
    ;help,geom,/struct

    xsize = geom.scr_xsize
    ysize = geom.scr_ysize
    newxsize = (xsize + dxsize) > 20  
    newysize = (ysize + dysize) > 20

    self->resize,newxsize,newysize


end;cwo_drawplot_class::adjustsize


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::setProperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::setProperty,$
                parent=parent,$
                tlb=tlb,$
                draw=draw,$
                winpix=winpix,$
                winsav=winsav,$
                winvis=winvis,$
                xptr=xptr,$
                yptr=yptr,$
                xhide=xhide,yhide=yhide,$
                xshow=xshow,yshow=yshow,$
                showplot=showplot,$
                leftMousePressed=leftMousePressed,$
                rightMousePressed=rightMousePressed,$
                mousexy=mousexy,$
                pressxy=pressxy,$
                releasexy=releasexy,$
                    zoomflag=zoomflag,$
                    zoomboxflag=zoomboxflag,$
                    zoomxrange=zoomxrange,$
                    zoomyrange=zoomyrange,$
                    xrange=xrange,$
                    yrange=yrange,$
                      xmaxrange=xmaxrange,$
                      ymaxrange=ymaxrange,$
                    title=title,$
                    subtitle=subtitle,$
                    xtitle=xtitle,$
                    ytitle=ytitle,$
                    xlog=xlog,$
                ylog=ylog,$
                xlegend=xlegend,$
                ylegend=ylegend,$
                showlegend=showlegend,$
                black=black,$
                red=red,$
                green=green,$
                blue=blue,$
                white=white,$
                frame=frame,$
                contextmenu=contextmenu,$
                _ref_extra=extra

        if n_elements(parent) ne 0 then self.parent=parent
        if n_elements(tlb) ne 0 then self.tlb =tlb
        if n_elements(draw) ne 0 then self.draw =draw
        if n_elements(winpix) ne 0 then self.winpix =winpix
        if n_elements(winsav) ne 0 then self.winsv =winsav
        if n_elements(winvis) ne 0 then self.winvis =winvis
        if n_elements(xptr) ne 0 then self.xptr =xptr
        if n_elements(yptr) ne 0 then self.yptr =yptr
        if n_elements(xhide) ne 0 then self.xhide =xhide
        if n_elements(yhide) ne 0 then self.yhide =yhide
        if n_elements(xshow) ne 0 then self.xshow =xshow
        if n_elements(yshow) ne 0 then self.yshow =yshow
        if n_elements(showplot) ne 0 then self.showplot =showplot


        if n_elements(leftMousePressed) ne 0 then self.leftMousePressed = leftMousePressed
        if n_elements(rightMousePressed) ne 0 then self.rightMousePressed = rightMousePressed
        if n_elements(mousexy) ne 0 then self.mousexy = mousexy
        if n_elements(pressxy) ne 0 then self.pressxy = pressxy
        if n_elements(releasexy) ne 0 then self.releasexy = releasexy
        if n_elements(zoomflag) ne 0 then self.zoomflag = zoomflag
        if n_elements(zoomboxflag) ne 0 then self.zoomboxflag = zoomboxflag
        if n_elements(zoomxrange) ne 0 then self.zoomxrange = zoomxrange
        if n_elements(zoomyrange) ne 0 then self.zoomyrange = zoomyrange
        if n_elements(xrange) ne 0 then self.xrange = xrange
        if n_elements(yrange) ne 0 then self.yrange = yrange
        if n_elements(xmaxrange) ne 0 then self.xmaxrange = xmaxrange
        if n_elements(ymaxrange) ne 0 then self.ymaxrange = ymaxrange
        if n_elements(title) ne 0 then self.title = title
        if n_elements(subtitle) ne 0 then self.subtitle = subtitle
        if n_elements(xtitle) ne 0 then self.xtitle = xtitle
        if n_elements(ytitle) ne 0 then self.ytitle = ytitle
        if n_elements(xlog) ne 0 then self.xlog = xlog
        if n_elements(ylog) ne 0 then self.ylog = ylog
        if n_elements(xlegend) ne 0 then self.xlegend = xlegend
        if n_elements(ylegend) ne 0 then self.ylegend = ylegend
        if n_elements(showlegend) ne 0 then self.showlegend = showlegend
        if n_elements(black) ne 0 then self.black = black
        if n_elements(red) ne 0 then self.red = red
        if n_elements(green) ne 0 then self.green = green
        if n_elements(blue) ne 0 then self.blue = blue
        if n_elements(white) ne 0 then self.white = white
        if n_elements(frame) ne 0 then self.frame = frame
        if n_elements(contextmenu) ne 0 then self.contextmenu = contextmenu



end;cwo_drawplot_class::setProperty


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::getProperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::getProperty,$
                parent=parent,$
                tlb=tlb,$
                draw=draw,$
                winpix=winpix,$
                winsav=winsav,$
                winvis=winvis,$
                xptr=xptr,$
                yptr=yptr,$
                xhide=xhide,yhide=yhide,$
                xshow=xshow,yshow=yshow,$
                showplot=showplot,$
                leftMousePressed=leftMousePressed,$
                rightMousePressed=rightMousePressed,$
                mousexy=mousexy,$
                pressxy=pressxy,$
                releasexy=releasexy,$
                    zoomflag=zoomflag,$
                    zoomboxflag=zoomboxflag,$
                    zoomxrange=zoomxrange,$
                    zoomyrange=zoomyrange,$
                    xrange=xrange,$
                    yrange=yrange,$
                      xmaxrange=xmaxrange,$
                      ymaxrange=ymaxrange,$
                    title=title,$
                    subtitle=subtitle,$
                    xtitle=xtitle,$
                    ytitle=ytitle,$
                    xlog=xlog,$
                ylog=ylog,$
                xlegend=xlegend,$
                ylegend=ylegend,$
                showlegend=showlegend,$
                black=black,$
                red=red,$
                green=green,$
                blue=blue,$
                white=white,$
                frame=frame,$
                contextmenu = contextmenu,$
                _ref_extra=extra




    if arg_present(parent) ne 0 then parent = self.parent
    if arg_present(tlb) ne 0 then tlb = self.tlb


    if arg_present(draw) ne 0 then draw = self.draw
    if arg_present(winpix) ne 0 then winpix = self.winpix
    if arg_present(winsav) ne 0 then winsav = self.winsav
    if arg_present(winvis) ne 0 then winvis = self.winvis
    if arg_present(xptr) ne 0 then xptr=self.xptr
    if arg_present(yptr) ne 0 then yptr=self.yptr
    if arg_present(leftMousePressed) ne 0 then leftMousePressed=self.leftMousePressed
    if arg_present(rightMousePressed) ne 0 then rightMousePressed=self.rightMousePressed
    if arg_present(mousexy) ne 0 then mousexy=self.mousexy
    if arg_present(pressxy) ne 0 then pressxy=self.pressxy
    if arg_present(releasexy) ne 0 then releasexy=self.releasexy
    if arg_present(zoomflag) ne 0 then zoomflag=self.zoomflag
    if arg_present(zoomboxflag) ne 0 then zoomboxflag=self.zoomboxflag
    if arg_present(zoomxrange) ne 0 then zoomxrange=self.zoomxrange
    if arg_present(zoomyrange) ne 0 then zoomyrange=self.zoomyrange
    if arg_present(xrange) ne 0 then xrange=self.xrange
    if arg_present(yrange) ne 0 then yrange=self.yrange
    if arg_present(xmaxrange) ne 0 then xmaxrange=self.xmaxrange
    if arg_present(ymaxrange) ne 0 then ymaxrange=self.ymaxrange
    if arg_present(title) ne 0 then title=self.title
    if arg_present(subtitle) ne 0 then subtitle=self.subtitle
    if arg_present(xtitle) ne 0 then xtitle=self.xtitle
    if arg_present(ytitle) ne 0 then ytitle=self.ytitle
    if arg_present(xlog) ne 0 then xlog=self.xlog
    if arg_present(ylog) ne 0 then ylog=self.ylog
    if arg_present(xlegend) ne 0 then xlegend=self.xlegend
    if arg_present(ylegend) ne 0 then ylegend=self.ylegend
    if arg_present(showlegend) ne 0 then showlegend=self.showlegend
    if arg_present(black) ne 0 then black=self.black
    if arg_present(red) ne 0 then red=self.red
    if arg_present(green) ne 0 then green=self.green
    if arg_present(blue) ne 0 then blue=self.blue
    if arg_present(white) ne 0 then white=self.white
    if arg_present(frame) ne 0 then frame = self.frame
    if arg_present(contextmenu) ne 0 then contextmenu = self.contextmenu

    if arg_present(xhide) ne 0 then xhide =self.xhide
    if arg_present(yhide) ne 0 then yhide =self.yhide
    if arg_present(xshow) ne 0 then xshow =self.xshow
    if arg_present(yshow) ne 0 then yshow =self.yshow
    if arg_present(showplot) ne 0 then showplot =self.showplot



end;cwo_drawplot_class::getproperty
;###############################################################################
;
;NAME:
;        cwo_drawplot_realize
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_realize,id
    widget_control,id,get_uvalue=obj
    obj->realize,id
end;cwo_drawplot_realize
;###############################################################################
;
;NAME:
;        cwo_drawplot_class::realize
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::realize,id

    if self.draw eq 0L then self.draw = id
    
    widget_control,self.draw,get_value=winvis
    self.winvis = winvis


    geom = widget_info(self.draw,/geometry)


    if self.winsav ne 0 then wdelete,self.winsav
    window,/free,/pixmap,xsize=geom.xsize,ysize=geom.ysize
    self.winsav = !d.window

    if self.winpix ne 0 then wdelete,self.winpix
    window,/free,/pixmap,xsize=geom.xsize,ysize=geom.ysize
    self.winpix = !d.window


    if ptr_valid(self.xptr) then ptr_free,self.xptr
    self.xptr = ptr_new(!x)
    if ptr_valid(self.yptr) then ptr_free,self.yptr
    self.yptr = ptr_new(!y)


    self->getDataRange
    self.zoomxrange = self.xrange
    self.zoomyrange = self.yrange


    self->draw


end;cwo_drawplot_class::realize
;###############################################################################
;
;NAME:
;        cwo_drawplot_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_cleanup,id
    widget_control,id,get_uvalue=obj
    obj_destroy,obj
end;cwo_drawplot_cleanup
;###############################################################################
;
;NAME:
;        cwo_drawplot_class::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::cleanup
    print,'cwo_drawplot_class::cleanup'
    ptr_free,self.xptr
    ptr_free,self.yptr

;    wdelete,self.winpix
;    wdelete,self.winsav
;    wdelete,self.winvis


    count = self->count()
    if count gt 0 then begin
        ref = self->get(/all)
        obj_destroy,ref
    endif
    self->idl_container::cleanup


end;cwo_drawplot_class::cleanup


;###############################################################################
;
;NAME:
;        cwo_drawplot_class::setvalues
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class::setvalues,xmin=xmin,$
                            xmax=xmax,$
                            ymin=ymin,$
                            ymax=ymax,$
                            xlog=xlog,$
                            ylog=ylog

;print,'cwo_drawplot_class::setvalues'
;print,xmin,xmax,xlog,ymin,ymax,ylog
    self->range,xmin=xmin,$
                xmax=xmax,$
                ymin=ymin,$
                ymax=ymax


    self->setxlog,xlog
    self->setylog,ylog

    self->draw
end;setvalues


;###############################################################################
;
;NAME:
;        cwo_drawplot_set_value
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_set_value,id,value
    print,'set_value'
end;cwo_drawplot_set_value
;###############################################################################
;
;NAME:
;        cwo_drawplot_get_value
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawplot_get_value,id
    print,'get_value'
    stash = widget_info(id,/child)
    widget_control,stash,get_uvalue=obj
    return,obj
end;cwo_drawplot_get_value



;###############################################################################
;
;NAME:
;        cwo_drawplot_class::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawplot_class::init,parent, tlb=tlb,$
                                    xhide=xhide,yhide=yhide,$
                                    xshow=xshow,yshow=yshow,$
                                    showplot=showplot,$
                                    xsize=xsize,$
                                    ysize=ysize,$
                                    uvalue=uvalue,$
                                    uname=uname,$
                                    frame=frame,$
                                    title=title,$
                                    xtitle=xtitle,$
                                    ytitle=ytitle,$
                                    kill_notify=kill_notify,$
				                    position=position,$
				                    xoffset=xoffset,yoffset=yoffset,$
                                    xmaxrange=xmaxrange,$
                                    ymaxrange=ymaxrange,$
                                    xticks=xticks,yticks=yticks,$
                                    mode=mode,$
                                    _ref_extra=extra
    catch,es
    if es ne 0 then begin
        void = dialog_message('Error occurred in cwo_drawplot_class::init, please report the following: '+!error_state.msg)
        catch,/cancel
        return,-1
    endif


    if n_elements(title) eq 0 then title = ''
    if n_elements(xtitle) eq 0 then xtitle = ''
    if n_elements(ytitle) eq 0 then ytitle = ''
    if n_elements(uname) eq 0 then uname = ''
    if n_elements(frame) eq 0 then frame = 0
    if n_elements(position) eq 4 then begin
    if n_elements(xticks) eq 0 then xticks = 2
    if n_elements(yticks) eq 0 then yticks = 2

    self.xticks = xticks
    self.yticks = yticks

	self.position = position
    endif else begin
	self.position = [0.20,0.15,0.8,0.85]
    endelse

    if n_elements(xoffset) eq 0 then xoffset = 0
    if n_elements(yoffset) eq 0 then yoffset = 0

    if n_elements(showplot) eq 0 then self.showplot = 1 else self.showplot = showplot
    if n_elements(xhide) eq 0 then self.xhide = xoffset else self.yhide = yhide
    if n_elements(yhide) eq 0 then self.yhide = yoffset else self.yhide = yhide
    if n_elements(xshow) eq 0 then self.xshow = xoffset else self.xshow = xshow
    if n_elements(yshow) eq 0 then self.yshow = yoffset else self.yshow = yshow

    if self.showplot eq 0 then xoffset = xhide
    if self.showplot eq 0 then yoffset = yhide

    self.title = title
    self.xtitle = xtitle
    self.ytitle = ytitle
    self.frame = frame

    self.parent = parent

    self.tlb = widget_base(parent,$;xsize=xsize+2*frame,ysize=ysize+2*frame,$
                        frame=frame,$
                        event_func='cwo_drawplot_event',$
                        pro_set_value='cwo_drawplot_set_value',$
                        func_get_value='cwo_drawplot_get_value',$
                        uvalue=uvalue,uname=uname,kill_notify=kill_notify,$
                        xoffset=xoffset,yoffset=yoffset)

    tlb = self.tlb
    self.draw = widget_draw(tlb,xsize=xsize,ysize=ysize,$
                            /button_events,$
                            /motion_events,$
                            /tracking_events,$
                            keyboard_events=2,$
                            notify_realize='cwo_drawplot_realize',$
                            kill_notify='cwo_drawplot_cleanup',$
                            uvalue=self)

    ret = self->createContextMenu()

    if n_elements(mode) eq 0 then begin
        self.zoom_selectmode = 0
    endif else begin
        if mode ge 4 then self.zoom_selectmode = 0
        if mode lt 0 then self.zoom_selectmode = 0
        if mode ge 0 and mode lt 4 then self.zoom_selectmode = mode

        self->handleContextMenu,zoommode=mode

    endelse



    self.black = 0L
    self.red   = 255L
    self.green = 256L*self.red
    self.blue  = 256L*self.green
    self.white = self.red + self.green + self.blue

    self.zoomxrange = self.xrange
    self.zoomyrange = self.yrange

    if n_elements(xmaxrange) eq 0 then self.xmaxrange = double(['NaN','NaN'])
    if n_elements(ymaxrange) eq 0 then self.ymaxrange = double(['NaN','NaN'])

    self.xlegend = 0.675
    self.ylegend = 0.8
    self.showlegend = 1

    return,1
end;cwo_drawplot_class::init


;###############################################################################
;
;NAME:
;        cwo_drawplot_class__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_drawplot_class__define,class



    ;NOTE THAT THIS BASE CLASS WILL SIMPLY PROVIDE THE PLOTTING
    ;AND INTERACTION CAPABILITY WITHOUT THE SPECIFIC DATA.
    ;THE SPECIFIC DATA WILL BE HANDLED IN THE SUBCLASSES
    ;USING SUBCLASS VARIABLES.


    ;BUT WAIT, THIS IS A CONTAINER!!!!
    ;THE DATA WILL BE STORED IN DATA OBJECTS!!!



    class = {   cwo_drawplot_class,$
                inherits idl_container,$
                parent:0L,$
                tlb:0L,$
                draw:0L,$
                winpix:0L,$
                winsav:0L,$
                winvis:0L,$
		        position:dblarr(4),$
                xhide:0,yhide:0,$   ;POSITIONS OF WHERE TO PUT THE cwo
                xshow:0,yshow:0,$   ;WHEN SHOWN AND WHEN HIDDEN
                showplot:0,$
                contextmenu:0L,$
                showHideSetMenu:0L,$
                showHideSetList:0L,$
                xptr:ptr_new(),$        ;AXIS POINTERS
                yptr:ptr_new(),$
                leftMousePressed:0,$    ;FLAG FOR MOUSE BUTTON PRESSED
                rightMousePressed:0,$
                mouseinwindow:0,$
                mousexy:indgen(2),$     ;CURRENT MOUSE POSITION
                pressxy:indgen(2),$     ;POSITION OF MOUSE PRESS
                releasexy:indgen(2),$   ;POSITION OF MOUSE RELEASE
                zoom_selectmode:0,$     ;DETERMINE WHICH SELECT/ZOOM MODE IS IN USE (0=zoom,1=positon,2=start/end,3=region)
                    zoomflag:0,$            ;FLAG TO TELL THE PROGRAM IF PLOT IS ZOOMED OR NOT.
                    zoomboxflag:0,$         ;FLAG TO TELL THE PROGRAM TO DRAW A ZOOM BOX.
                    zoomxrange:dindgen(2),$ ;ZOOMED DATA RANGE
                    zoomyrange:dindgen(2),$
                    xrange:dindgen(2),$     ;TOTAL RANGE OF THE DATA
                    yrange:dindgen(2),$
                    xmaxrange:dindgen(2),$  ;OPTIONAL MAXIMUM RANGES FOR DATA
                    ymaxrange:dindgen(2),$
                    title:'',$              ;PLOT TITLE
                    subtitle:'',$           ;PLOT SUBTITILE
                    xtitle:'',$             ;AXIS TITLE
                    ytitle:'',$
                    xlog:0,$                ;FLAG FOR LOG v LIN AXIS
                ylog:0,$
                xlegend:0.0,$           ;basic legend position
                ylegend:0.0,$
                showlegend:0,$
                hidemodelabel:0,$
                black:0L,$              ;COLORS
                red:255L,$
                green:256L*255L,$
                blue:256L*256L*255L,$
                white:255L + 256L*(255L + 256L*255L),$
                frame:0,$
                xticks:0,yticks:0,$
                ID:''}


end;cwo_drawplot_class__define,class



;###############################################################################
;
;NAME:
;        cwo_drawplot
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawplot,parent,obj=obj,xsize=xsize,ysize=ysize,$
                      uvalue=uvalue,position=position,$
                      uname=uname,$
                      xoffset=xoffset,yoffset=yoffset,$
                      title=title,xtitle=xtitle,ytitle=ytitle,$
                      xhide=xhide,yhide=yhide,$
                      xshow=xshow,yshow=yshow,$
                      showplot=showplot,$
                      xmaxrange=xmaxrange,$
                      ymaxrange=ymaxrange,$
                      frame=frame,$
                      xticks=xticks,yticks=yticks,$
                      _Extra=extra



    if n_elements(parent) eq 0 then return,0L
    if n_elements(frame) eq 0 then frame=0

    obj = obj_new('cwo_drawplot_class',parent,frame=frame,xsize=xsize,ysize=ysize,$
                                 uvalue=uvalue,position=position,$
                                 uname=uname,$
                                 xoffset=xoffset,yoffset=yoffset,$
                                 xtitle=xtitle,ytitle=ytitle,title=title,$
                                 xhide=xhide,yhide=yhide,$
                                 xshow=xshow,yshow=yshow,$
                                 showplot=showplot,$
                                 xmaxrange=xmaxrange,$
                                 ymaxrange=ymaxrange,$
                                 xticks=xticks,yticks=yticks,$
                                 _Extra=extra)

    obj->getproperty,tlb=tlb


    return,tlb

end;cwo_drawplot
