/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.awt.EventQueue;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.auth.LoginEvent;
import org.jdesktop.swingx.auth.LoginListener;
import org.jdesktop.swingx.util.SwingWorker;

public abstract class LoginService {
    private Logger LOG = Logger.getLogger(LoginService.class.getName());
    private Vector<LoginListener> listenerList = new Vector();
    private SwingWorker loginWorker;
    private boolean synchronous;
    private String server;

    public LoginService() {
    }

    public LoginService(String string) {
        this.setServer(string);
    }

    public abstract boolean authenticate(String var1, char[] var2, String var3) throws Exception;

    public String[] getUserRoles() {
        return null;
    }

    public void cancelAuthentication() {
        if (this.loginWorker != null) {
            this.loginWorker.cancel(true);
        }
    }

    public void startAuthentication(final String string, final char[] cArray, final String string2) throws Exception {
        block5: {
            if (this.getSynchronous()) {
                try {
                    if (this.authenticate(string, cArray, string2)) {
                        this.fireLoginSucceeded(new LoginEvent(this));
                        break block5;
                    }
                    this.fireLoginFailed(new LoginEvent(this));
                }
                catch (Exception exception) {
                    this.fireLoginFailed(new LoginEvent(this, exception));
                }
            } else {
                this.loginWorker = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        try {
                            final boolean bl = LoginService.this.authenticate(string, cArray, string2);
                            if (this.isCancelled()) {
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        LoginService.this.fireLoginCanceled(new LoginEvent(this));
                                    }
                                });
                                return false;
                            }
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    if (bl) {
                                        LoginService.this.fireLoginSucceeded(new LoginEvent(LoginService.this));
                                    } else {
                                        LoginService.this.fireLoginFailed(new LoginEvent(LoginService.this));
                                    }
                                }
                            });
                            return bl;
                        }
                        catch (Exception exception) {
                            if (!this.isCancelled()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        LoginService.this.fireLoginFailed(new LoginEvent(LoginService.this, exception));
                                    }
                                });
                            } else {
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        LoginService.this.fireLoginCanceled(new LoginEvent(this));
                                    }
                                });
                            }
                            return false;
                        }
                    }
                };
                this.loginWorker.execute();
                this.fireLoginStarted(new LoginEvent(this));
            }
        }
    }

    public boolean getSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean bl) {
        this.synchronous = bl;
    }

    public void addLoginListener(LoginListener loginListener) {
        this.listenerList.add(loginListener);
    }

    public void removeLoginListener(LoginListener loginListener) {
        this.listenerList.remove(loginListener);
    }

    void fireLoginStarted(LoginEvent loginEvent) {
        for (LoginListener loginListener : this.listenerList) {
            loginListener.loginStarted(loginEvent);
        }
    }

    void fireLoginSucceeded(LoginEvent loginEvent) {
        for (LoginListener loginListener : this.listenerList) {
            loginListener.loginSucceeded(loginEvent);
        }
    }

    void fireLoginFailed(LoginEvent loginEvent) {
        for (LoginListener loginListener : this.listenerList) {
            loginListener.loginFailed(loginEvent);
        }
    }

    void fireLoginCanceled(LoginEvent loginEvent) {
        for (LoginListener loginListener : this.listenerList) {
            loginListener.loginCanceled(loginEvent);
        }
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) {
        this.server = string;
    }
}

