/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataProvider;
import org.jdesktop.dataset.DataRelation;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.DataSelector;
import org.jdesktop.dataset.DataSet;
import org.jdesktop.dataset.DataSetUtils;
import org.jdesktop.dataset.NameGenerator;
import org.jdesktop.dataset.event.DataTableListener;
import org.jdesktop.dataset.event.RowChangeEvent;
import org.jdesktop.dataset.event.TableChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable {
    private static final Logger LOG = Logger.getLogger(DataTable.class.getName());
    protected static final String DEFAULT_NAME_PREFIX = "DataTable";
    private static final NameGenerator NAMEGEN = new NameGenerator("DataTable");
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DataSet dataSet;
    private DataProvider dataProvider;
    private String name;
    protected Map<String, DataColumn> columns = new LinkedHashMap<String, DataColumn>();
    protected Map<Class, Comparator> classComparators = new HashMap<Class, Comparator>();
    protected Map<DataColumn, Comparator> columnComparators = new HashMap<DataColumn, Comparator>();
    private static final Comparator EQUALS_COMPARATOR = new Comparator(){

        public boolean equals(Object object) {
            return object == this;
        }

        public int compare(Object object, Object object2) {
            return object.equals(object2) ? 0 : -1;
        }
    };
    protected List<DataRow> rows = new ArrayList<DataRow>();
    protected Map<String, DataSelector> selectors = new HashMap<String, DataSelector>();
    private boolean deleteRowSupported = true;
    private boolean appendRowSupported = true;
    private boolean identityComparisonEnabled;
    private List<DataTableListener> listeners = new ArrayList<DataTableListener>();
    private final PropertyChangeListener nameChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataColumn dataColumn;
            if (propertyChangeEvent.getSource() instanceof DataSelector) {
                DataSelector dataSelector = DataTable.this.selectors.remove(propertyChangeEvent.getOldValue());
                if (dataSelector != null) {
                    DataTable.this.selectors.put((String)propertyChangeEvent.getNewValue(), dataSelector);
                }
            } else if (propertyChangeEvent.getSource() instanceof DataColumn && (dataColumn = DataTable.this.columns.remove(propertyChangeEvent.getOldValue())) != null) {
                DataTable.this.columns.put((String)propertyChangeEvent.getNewValue(), dataColumn);
            }
        }
    };

    protected DataTable(DataSet dataSet) {
        assert (dataSet != null);
        this.dataSet = dataSet;
        this.name = NAMEGEN.generateName(this);
        this.identityComparisonEnabled = true;
    }

    protected DataTable(DataSet dataSet, String string) {
        this(dataSet);
        if (string != null) {
            this.setName(string);
        }
    }

    public DataColumn createColumn() {
        return this.createColumn(null);
    }

    public DataColumn createColumn(String string) {
        DataColumn dataColumn = new DataColumn(this);
        if (string != null) {
            dataColumn.setName(string);
        }
        this.columns.put(dataColumn.getName(), dataColumn);
        dataColumn.addPropertyChangeListener("name", this.nameChangeListener);
        this.fireDataTableChanged(TableChangeEvent.newColumnAddedEvent(this, dataColumn));
        return dataColumn;
    }

    public void createColumns(String ... stringArray) {
        for (String string : stringArray) {
            this.createColumn(string);
        }
    }

    public void dropColumn(String string) {
        DataColumn dataColumn = this.columns.remove(string);
        if (dataColumn != null) {
            dataColumn.removePropertyChangeListener("name", this.nameChangeListener);
            for (DataRelation dataRelation : this.dataSet.getRelations()) {
                DataColumn dataColumn2 = dataRelation.getChildColumn();
                if (dataColumn2 == dataColumn) {
                    dataRelation.setChildColumn(null);
                }
                if ((dataColumn2 = dataRelation.getParentColumn()) != dataColumn) continue;
                dataRelation.setParentColumn(null);
            }
            this.columnComparators.remove(dataColumn);
            this.fireDataTableChanged(TableChangeEvent.newColumnRemovedEvent(this, dataColumn));
        }
    }

    public List<DataColumn> getColumns() {
        return Collections.unmodifiableList(new ArrayList<DataColumn>(this.columns.values()));
    }

    public DataColumn getColumn(String string) {
        return this.columns.get(string);
    }

    public List<DataRow> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public DataRow getRow(int n) {
        assert (n >= 0 && n < this.rows.size());
        return this.rows.get(n);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public DataSelector createSelector() {
        return this.createSelector(null);
    }

    public DataSelector createSelector(String string) {
        DataSelector dataSelector = new DataSelector(this);
        if (string != null) {
            dataSelector.setName(string);
        }
        if (this.rows.size() > 0) {
            dataSelector.setRowIndex(0);
        }
        this.selectors.put(dataSelector.getName(), dataSelector);
        dataSelector.addPropertyChangeListener("name", this.nameChangeListener);
        return dataSelector;
    }

    public List<DataSelector> getSelectors() {
        return Collections.unmodifiableList(new ArrayList<DataSelector>(this.selectors.values()));
    }

    public DataSelector getSelector(String string) {
        if (!this.selectors.containsKey(string)) {
            return this.createSelector(string);
        }
        return this.selectors.get(string);
    }

    public void dropSelector(DataSelector dataSelector) {
        this.dropSelector(dataSelector.getName());
    }

    public void dropSelector(String string) {
        DataSelector dataSelector = this.selectors.remove(string);
        if (dataSelector != null) {
            dataSelector.removePropertyChangeListener("name", this.nameChangeListener);
        }
    }

    public void setName(String string) {
        if (this.name != string) {
            assert (DataSetUtils.isValidName(string));
            assert (!this.dataSet.hasElement(string));
            String string2 = this.name;
            this.name = string;
            this.pcs.firePropertyChange("name", string2, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isIdentityComparisonEnabled() {
        return this.identityComparisonEnabled;
    }

    public void setIdentityComparisonEnabled(boolean bl) {
        this.identityComparisonEnabled = bl;
    }

    public void setClassComparator(Class clazz, Comparator comparator) {
        assert (clazz != null);
        assert (comparator != null);
        this.classComparators.put(clazz, comparator);
    }

    public void removeClassComparator(Class clazz) {
        assert (clazz != null);
        this.classComparators.remove(clazz);
    }

    public boolean hasClassComparator(Class clazz) {
        return this.classComparators.get(clazz) != null;
    }

    public Comparator getClassComparator(Class clazz) {
        Comparator comparator = this.classComparators.get(clazz);
        if (comparator == null) {
            comparator = EQUALS_COMPARATOR;
        }
        return comparator;
    }

    public void setColumnComparator(DataColumn dataColumn, Comparator comparator) {
        assert (dataColumn != null);
        assert (comparator != null);
        this.columnComparators.put(dataColumn, comparator);
    }

    public void removeColumnComparator(DataColumn dataColumn) {
        assert (dataColumn != null);
        this.columnComparators.remove(dataColumn);
    }

    public boolean hasColumnComparator(DataColumn dataColumn) {
        return this.columnComparators.get(dataColumn) != null;
    }

    public Comparator getColumnComparator(DataColumn dataColumn) {
        assert (dataColumn != null);
        Comparator comparator = this.columnComparators.get(dataColumn);
        if (comparator == null) {
            comparator = this.getClassComparator(dataColumn.getType());
        }
        return comparator;
    }

    public boolean isDeleteRowSupported() {
        return this.deleteRowSupported;
    }

    public void setDeleteRowSupported(boolean bl) {
        if (this.deleteRowSupported != bl) {
            boolean bl2 = this.deleteRowSupported;
            this.deleteRowSupported = bl;
            this.pcs.firePropertyChange("deleteRowSupported", bl2, bl);
        }
    }

    public boolean isAppendRowSupported() {
        return this.appendRowSupported;
    }

    public void setAppendRowSupported(boolean bl) {
        if (this.appendRowSupported != bl) {
            boolean bl2 = this.appendRowSupported;
            this.appendRowSupported = bl;
            this.pcs.firePropertyChange("appendRowSupported", bl2, bl);
        }
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DataProvider dataProvider) {
        if (this.dataProvider != dataProvider) {
            DataProvider dataProvider2 = this.dataProvider;
            this.dataProvider = dataProvider;
            this.pcs.firePropertyChange("dataProvider", dataProvider2, dataProvider);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public DataRow appendRow() {
        DataRow dataRow = this.appendRowNoEvent();
        if (dataRow != null) {
            this.fireDataTableChanged(TableChangeEvent.newRowAddedEvent(this, dataRow));
            if (this.selectors.get("current") == null) {
                this.createSelector("current");
            }
            this.selectors.get("current").setRowIndices(new int[]{this.indexOfRow(dataRow)});
        }
        return dataRow;
    }

    public DataRow appendRowNoEvent() {
        if (this.appendRowSupported) {
            DataRow dataRow = new DataRow(this);
            int n = this.rows.size();
            this.rows.add(dataRow);
            if (n == 0 && this.rows.size() > 0) {
                for (DataSelector dataSelector : this.selectors.values()) {
                    dataSelector.setRowIndices(new int[]{0});
                }
            }
            return dataRow;
        }
        return null;
    }

    public void deleteRow(int n) {
        assert (n >= 0 && n < this.rows.size());
        this.deleteRow(this.rows.get(n));
    }

    public void deleteRow(DataRow dataRow) {
        assert (dataRow.getTable() == this);
        if (this.deleteRowSupported) {
            dataRow.setStatus(DataRow.DataRowStatus.DELETED);
            this.fireDataTableChanged(TableChangeEvent.newRowDeletedEvent(this, dataRow));
        }
    }

    public void discardRow(int n) {
        assert (n >= 0 && n < this.rows.size());
        DataRow dataRow = this.rows.remove(n);
        this.fireDataTableChanged(TableChangeEvent.newRowDiscardedEvent(this, dataRow));
    }

    public void discardRow(DataRow dataRow) {
        this.discardRow(this.indexOfRow(dataRow));
    }

    public void load() {
        if (this.dataProvider != null) {
            this.fireDataTableChanged(TableChangeEvent.newLoadStartEvent(this));
            this.dataProvider.load(this);
        }
    }

    public void loadAndWait() {
        if (this.dataProvider != null) {
            this.fireDataTableChanged(TableChangeEvent.newLoadStartEvent(this));
            this.dataProvider.loadAndWait(this);
        }
    }

    public void save() {
        if (this.dataProvider != null) {
            this.fireDataTableChanged(TableChangeEvent.newSaveStartEvent(this));
            this.dataProvider.save(this);
        }
    }

    public void saveAndWait() {
        if (this.dataProvider != null) {
            this.fireDataTableChanged(TableChangeEvent.newSaveStartEvent(this));
            this.dataProvider.saveAndWait(this);
        }
    }

    public void clear() {
        this.rows.clear();
        for (DataSelector dataSelector : this.selectors.values()) {
            dataSelector.setRowIndices(new int[0]);
        }
        this.fireDataTableChanged(TableChangeEvent.newTableClearedEvent(this));
    }

    public void refresh() {
        this.clear();
        this.load();
    }

    public void refreshAndWait() {
        this.clear();
        this.loadAndWait();
    }

    public Object getValue(int n, String string) {
        assert (n >= 0 && n < this.rows.size());
        assert (this.columns.containsKey(string));
        return this.rows.get(n).getValue(string);
    }

    public void setValue(int n, String string, Object object) {
        assert (n >= 0 && n < this.rows.size());
        assert (this.columns.containsKey(string));
        this.rows.get(n).setValue(string, object);
    }

    public Object getValue(DataRow dataRow, DataColumn dataColumn) {
        assert (dataRow.getTable() == this);
        assert (dataColumn.getTable() == this);
        return dataRow.getValue(dataColumn);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void addDataTableListener(DataTableListener dataTableListener) {
        if (!this.listeners.contains(dataTableListener)) {
            this.listeners.add(dataTableListener);
        }
        if (dataTableListener instanceof PropertyChangeListener) {
            this.addPropertyChangeListener((PropertyChangeListener)((Object)dataTableListener));
        }
    }

    public void removeDataTableListener(DataTableListener dataTableListener) {
        this.listeners.remove(dataTableListener);
        if (dataTableListener instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)dataTableListener));
        }
    }

    public void fireDataTableChanged(TableChangeEvent tableChangeEvent) {
        for (DataTableListener dataTableListener : new ArrayList<DataTableListener>(this.listeners)) {
            dataTableListener.tableChanged(tableChangeEvent);
        }
    }

    public void fireRowChanged(RowChangeEvent rowChangeEvent) {
        for (DataTableListener dataTableListener : new ArrayList<DataTableListener>(this.listeners)) {
            dataTableListener.rowChanged(rowChangeEvent);
        }
    }

    protected int indexOfRow(DataRow dataRow) {
        return this.rows.indexOf(dataRow);
    }
}

