/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx.adapter;

import javax.swing.table.AbstractTableModel;
import org.jdesktop.binding.TabularDataModel;
import org.jdesktop.binding.TabularValueChangeEvent;
import org.jdesktop.binding.TabularValueChangeListener;
import org.jdesktop.binding.metadata.DefaultMetaDataProvider;
import org.jdesktop.binding.metadata.MetaData;
import org.jdesktop.binding.metadata.MetaDataProvider;

public class DataModelToTableModelAdapter
extends AbstractTableModel
implements MetaDataProvider {
    protected TabularDataModel dm;
    private DefaultMetaDataProvider metaDataProvider;

    public DataModelToTableModelAdapter(TabularDataModel tabularDataModel) {
        this(tabularDataModel, null);
    }

    public DataModelToTableModelAdapter(TabularDataModel tabularDataModel, String[] stringArray) {
        this.dm = tabularDataModel;
        this.initMetaDataProvider(stringArray);
        this.installDataModelListener();
    }

    private void initMetaDataProvider(String[] stringArray) {
        if (stringArray == null) {
            this.metaDataProvider = new DefaultMetaDataProvider(this.dm);
        } else {
            MetaData[] metaDataArray = new MetaData[stringArray.length];
            for (int i = 0; i < metaDataArray.length; ++i) {
                metaDataArray[i] = this.dm.getMetaData(stringArray[i]);
            }
            this.metaDataProvider = new DefaultMetaDataProvider(metaDataArray);
        }
    }

    public Class getColumnClass(int n) {
        MetaData metaData = this.getMetaData(n);
        return metaData.getElementClass();
    }

    public String getColumnName(int n) {
        MetaData metaData = this.getMetaData(n);
        return metaData.getLabel();
    }

    public boolean isCellEditable(int n, int n2) {
        MetaData metaData = this.getMetaData(n2);
        return !metaData.isReadOnly();
    }

    public void setValueAt(Object object, int n, int n2) {
        this.dm.setValueAt(this.getFieldName(n2), n, object);
    }

    public int getRowCount() {
        return this.dm.getRecordCount();
    }

    public int getColumnCount() {
        return this.getFieldCount();
    }

    public Object getValueAt(int n, int n2) {
        return this.dm.getValueAt(this.getFieldName(n2), n);
    }

    private String getFieldName(int n) {
        return this.getDefaultMetaDataProvider().getFieldName(n);
    }

    private MetaData getMetaData(int n) {
        String string = this.getFieldName(n);
        return this.getMetaData(string);
    }

    public String[] getFieldNames() {
        return this.getDefaultMetaDataProvider().getFieldNames();
    }

    public int getFieldCount() {
        return this.getDefaultMetaDataProvider().getFieldCount();
    }

    public MetaData getMetaData(String string) {
        return this.getDefaultMetaDataProvider().getMetaData(string);
    }

    public MetaData[] getMetaData() {
        return this.getDefaultMetaDataProvider().getMetaData();
    }

    private DefaultMetaDataProvider getDefaultMetaDataProvider() {
        if (this.metaDataProvider == null) {
            this.metaDataProvider = new DefaultMetaDataProvider();
        }
        return this.metaDataProvider;
    }

    private void installDataModelListener() {
        TabularValueChangeListener tabularValueChangeListener = new TabularValueChangeListener(){

            public void tabularValueChanged(TabularValueChangeEvent tabularValueChangeEvent) {
                int n = tabularValueChangeEvent.getRowIndex();
                int n2 = DataModelToTableModelAdapter.this.findColumnIndex(tabularValueChangeEvent.getFieldName());
                if (n < 0) {
                    if (n2 < 0) {
                        DataModelToTableModelAdapter.this.fireTableStructureChanged();
                    } else {
                        DataModelToTableModelAdapter.this.fireTableDataChanged();
                    }
                } else if (n2 < 0) {
                    DataModelToTableModelAdapter.this.fireTableRowsUpdated(n, n);
                } else {
                    DataModelToTableModelAdapter.this.fireTableCellUpdated(n, n2);
                }
            }
        };
        this.dm.addTabularValueChangeListener(tabularValueChangeListener);
    }

    protected int findColumnIndex(String string) {
        if (string == null) {
            return -1;
        }
        return this.getDefaultMetaDataProvider().getFieldIndex(string);
    }
}

