/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.jdesktop.binding.DataModel;
import org.jdesktop.binding.IndexMapper;
import org.jdesktop.binding.SelectionModel;
import org.jdesktop.binding.TabularDataModel;
import org.jdesktop.binding.swingx.AbstractBinding;
import org.jdesktop.binding.swingx.adapter.DataModelToTableModelAdapter;
import org.jdesktop.binding.swingx.adapter.ListSelectionBinding;
import org.jdesktop.swingx.JXTable;

public class DirectTableBinding
extends AbstractBinding {
    private JTable table;

    public DirectTableBinding(JTable jTable, TabularDataModel tabularDataModel) {
        this(jTable, tabularDataModel, null);
    }

    public DirectTableBinding(JTable jTable, TabularDataModel tabularDataModel, String[] stringArray) {
        this(jTable, tabularDataModel, stringArray, null);
    }

    public DirectTableBinding(JTable jTable, TabularDataModel tabularDataModel, String[] stringArray, SelectionModel selectionModel) {
        super(jTable, tabularDataModel, "", 2);
        TableModel tableModel = this.createAdapter(tabularDataModel, stringArray);
        this.table.setModel(tableModel);
        if (selectionModel != null) {
            new ListSelectionBinding(selectionModel, this.table.getSelectionModel(), this.createIndexMapper(this.table));
        }
    }

    private IndexMapper createIndexMapper(JTable jTable) {
        if (!(jTable instanceof JXTable)) {
            return null;
        }
        final JXTable jXTable = (JXTable)jTable;
        IndexMapper indexMapper = new IndexMapper(){

            public int viewToModel(int n) {
                return jXTable.convertRowIndexToModel(n);
            }

            public int modelToView(int n) {
                return jXTable.convertRowIndexToView(n);
            }
        };
        return indexMapper;
    }

    public boolean push() {
        return true;
    }

    public boolean pull() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    protected TableModel createAdapter(TabularDataModel tabularDataModel, String[] stringArray) {
        return new DataModelToTableModelAdapter(tabularDataModel, stringArray);
    }

    protected JComponent getBoundComponent() {
        return this.table;
    }

    protected void setBoundComponent(JComponent jComponent) {
        if (!(jComponent instanceof JTable)) {
            throw new IllegalArgumentException("TableBindings only accept a JTable or one of its child classes");
        }
        this.table = (JTable)jComponent;
    }

    protected Object getComponentValue() {
        return null;
    }

    protected void setComponentValue(Object object) {
    }

    protected void installDataModel(DataModel dataModel, String string) {
        this.dataModel = dataModel;
        this.fieldName = string;
        this.installDataModelListener();
    }

    public JComponent getComponent() {
        return this.getBoundComponent();
    }

    public void setComponent(JComponent jComponent) {
        this.setBoundComponent(jComponent);
    }
}

