/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding;

import java.util.ArrayList;
import java.util.HashMap;
import org.jdesktop.binding.DataModel;
import org.jdesktop.binding.ValueChangeEvent;
import org.jdesktop.binding.ValueChangeListener;
import org.jdesktop.binding.metadata.MetaData;
import org.jdesktop.binding.metadata.Validator;

public abstract class AbstractDataModel
implements DataModel {
    protected ArrayList validators;
    private ArrayList valueChangeListeners;
    private HashMap valueChangeEvents;

    public abstract String[] getFieldNames();

    public MetaData[] getMetaData() {
        String[] stringArray = this.getFieldNames();
        MetaData[] metaDataArray = new MetaData[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            metaDataArray[i] = this.getMetaData(stringArray[i]);
        }
        return metaDataArray;
    }

    public abstract MetaData getMetaData(String var1);

    public abstract Object getValue(String var1);

    public void setValue(String string, Object object) {
        Object object2 = this.getValue(string);
        this.setValueImpl(string, object);
        if (object2 != null && !object2.equals(object) || object2 == null && object != null) {
            this.fireValueChanged(string);
        }
    }

    protected abstract void setValueImpl(String var1, Object var2);

    public void addValidator(Validator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(validator);
    }

    public void removeValidator(Validator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
        }
    }

    public Validator[] getValidators() {
        if (this.validators != null) {
            return this.validators.toArray(new Validator[this.validators.size()]);
        }
        return new Validator[0];
    }

    public void addValueChangeListener(ValueChangeListener valueChangeListener) {
        if (this.valueChangeListeners == null) {
            this.valueChangeListeners = new ArrayList();
        }
        this.valueChangeListeners.add(valueChangeListener);
    }

    public void removeValueChangeListener(ValueChangeListener valueChangeListener) {
        if (this.valueChangeListeners != null) {
            this.valueChangeListeners.remove(valueChangeListener);
        }
    }

    public ValueChangeListener[] getValueChangeListeners() {
        if (this.valueChangeListeners != null) {
            return this.valueChangeListeners.toArray(new ValueChangeListener[1]);
        }
        return new ValueChangeListener[0];
    }

    protected void fireValueChanged(String string) {
        ValueChangeListener[] valueChangeListenerArray = this.getValueChangeListeners();
        ValueChangeEvent valueChangeEvent = this.getCachedEvent(string);
        if (this.valueChangeListeners != null) {
            for (int i = 0; i < this.valueChangeListeners.size(); ++i) {
                ValueChangeListener valueChangeListener = (ValueChangeListener)this.valueChangeListeners.get(i);
                valueChangeListener.valueChanged(valueChangeEvent);
            }
        }
    }

    private ValueChangeEvent getCachedEvent(String string) {
        ValueChangeEvent valueChangeEvent;
        if (this.valueChangeEvents == null) {
            this.valueChangeEvents = new HashMap();
        }
        if ((valueChangeEvent = (ValueChangeEvent)this.valueChangeEvents.get(string)) == null) {
            valueChangeEvent = new ValueChangeEvent(this, string);
            this.valueChangeEvents.put(string, valueChangeEvent);
        }
        return valueChangeEvent;
    }
}

