/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.util.ArrayList;
import org.freehep.math.minuit.DavidonErrorUpdator;
import org.freehep.math.minuit.FunctionGradient;
import org.freehep.math.minuit.FunctionMinimum;
import org.freehep.math.minuit.GradientCalculator;
import org.freehep.math.minuit.MinimumBuilder;
import org.freehep.math.minuit.MinimumError;
import org.freehep.math.minuit.MinimumParameters;
import org.freehep.math.minuit.MinimumSeed;
import org.freehep.math.minuit.MinimumState;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnFcn;
import org.freehep.math.minuit.MnHesse;
import org.freehep.math.minuit.MnLineSearch;
import org.freehep.math.minuit.MnMachinePrecision;
import org.freehep.math.minuit.MnParabolaPoint;
import org.freehep.math.minuit.MnPosDef;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUtils;
import org.freehep.math.minuit.VariableMetricEDMEstimator;

class VariableMetricBuilder
implements MinimumBuilder {
    private VariableMetricEDMEstimator theEstimator = new VariableMetricEDMEstimator();
    private DavidonErrorUpdator theErrorUpdator = new DavidonErrorUpdator();

    VariableMetricBuilder() {
    }

    public FunctionMinimum minimum(MnFcn fcn, GradientCalculator gc2, MinimumSeed seed, MnStrategy strategy, int maxfcn, double edmval) {
        FunctionMinimum min = this.minimum(fcn, gc2, seed, maxfcn, edmval);
        if (strategy.strategy() == 2 || strategy.strategy() == 1 && min.error().dcovar() > 0.05) {
            MinimumState st = new MnHesse(strategy).calculate(fcn, min.state(), min.seed().trafo(), 0);
            min.add(st);
        }
        if (!min.isValid()) {
            System.err.println("FunctionMinimum is invalid.");
        }
        return min;
    }

    FunctionMinimum minimum(MnFcn fcn, GradientCalculator gc2, MinimumSeed seed, int maxfcn, double edmval) {
        MinimumError e;
        edmval *= 1.0E-4;
        if (seed.parameters().vec().size() == 0) {
            return new FunctionMinimum(seed, fcn.errorDef());
        }
        MnMachinePrecision prec = seed.precision();
        ArrayList<MinimumState> result = new ArrayList<MinimumState>(8);
        double edm = seed.state().edm();
        if (edm < 0.0) {
            System.err.println("VariableMetricBuilder: initial matrix not pos.def.");
            if (seed.error().isPosDef()) {
                throw new RuntimeException("Something is wrong!");
            }
            return new FunctionMinimum(seed, fcn.errorDef());
        }
        result.add(seed.state());
        edm *= 1.0 + 3.0 * seed.error().dcovar();
        MnAlgebraicVector step = new MnAlgebraicVector(seed.gradient().vec().size());
        do {
            MnParabolaPoint pp;
            MinimumState s0;
            double gdel;
            if ((gdel = MnUtils.innerProduct(step = MnUtils.mul(MnUtils.mul((s0 = (MinimumState)result.get(result.size() - 1)).error().invHessian(), s0.gradient().vec()), -1.0), s0.gradient().grad())) > 0.0) {
                System.err.println("VariableMetricBuilder: matrix not pos.def.");
                System.err.println("gdel > 0: " + gdel);
                s0 = MnPosDef.test(s0, prec);
                step = MnUtils.mul(MnUtils.mul(s0.error().invHessian(), s0.gradient().vec()), -1.0);
                gdel = MnUtils.innerProduct(step, s0.gradient().grad());
                System.err.println("gdel: " + gdel);
                if (gdel > 0.0) {
                    result.add(s0);
                    return new FunctionMinimum(seed, result, fcn.errorDef());
                }
            }
            if (Math.abs((pp = MnLineSearch.search(fcn, s0.parameters(), step, gdel, prec)).y() - s0.fval()) < prec.eps()) {
                System.err.println("VariableMetricBuilder: no improvement");
                break;
            }
            MinimumParameters p = new MinimumParameters(MnUtils.add(s0.vec(), MnUtils.mul(step, pp.x())), pp.y());
            FunctionGradient g = gc2.gradient(p, s0.gradient());
            edm = this.estimator().estimate(g, s0.error());
            if (edm < 0.0) {
                System.err.println("VariableMetricBuilder: matrix not pos.def.");
                System.err.println("edm < 0");
                s0 = MnPosDef.test(s0, prec);
                edm = this.estimator().estimate(g, s0.error());
                if (edm < 0.0) {
                    result.add(s0);
                    return new FunctionMinimum(seed, result, fcn.errorDef());
                }
            }
            e = this.errorUpdator().update(s0, p, g);
            result.add(new MinimumState(p, e, g, edm, fcn.numOfCalls()));
        } while ((edm *= 1.0 + 3.0 * e.dcovar()) > edmval && fcn.numOfCalls() < maxfcn);
        if (fcn.numOfCalls() >= maxfcn) {
            System.err.println("VariableMetricBuilder: call limit exceeded.");
            return new FunctionMinimum(seed, result, fcn.errorDef(), new FunctionMinimum.MnReachedCallLimit());
        }
        if (edm > edmval) {
            if (edm < Math.abs(prec.eps2() * ((MinimumState)result.get(result.size() - 1)).fval())) {
                System.err.println("VariableMetricBuilder: machine accuracy limits further improvement.");
                return new FunctionMinimum(seed, result, fcn.errorDef());
            }
            if (edm < 10.0 * edmval) {
                return new FunctionMinimum(seed, result, fcn.errorDef());
            }
            System.err.println("VariableMetricBuilder: finishes without convergence.");
            System.err.println("VariableMetricBuilder: edm= " + edm + " requested: " + edmval);
            return new FunctionMinimum(seed, result, fcn.errorDef(), new FunctionMinimum.MnAboveMaxEdm());
        }
        return new FunctionMinimum(seed, result, fcn.errorDef());
    }

    VariableMetricEDMEstimator estimator() {
        return this.theEstimator;
    }

    DavidonErrorUpdator errorUpdator() {
        return this.theErrorUpdator;
    }
}

