/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.util.ArrayList;
import java.util.List;
import org.freehep.math.minuit.ContoursError;
import org.freehep.math.minuit.FCNBase;
import org.freehep.math.minuit.FunctionMinimum;
import org.freehep.math.minuit.MinosError;
import org.freehep.math.minuit.MnApplication;
import org.freehep.math.minuit.MnCross;
import org.freehep.math.minuit.MnFunctionCross;
import org.freehep.math.minuit.MnMigrad;
import org.freehep.math.minuit.MnMinos;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUserParameterState;
import org.freehep.math.minuit.Point;

public class MnContours {
    private FCNBase theFCN;
    private FunctionMinimum theMinimum;
    private MnStrategy theStrategy;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MnContours(FCNBase fcn, FunctionMinimum min) {
        this(fcn, min, MnApplication.DEFAULT_STRATEGY);
    }

    public MnContours(FCNBase fcn, FunctionMinimum min, int stra) {
        this(fcn, min, new MnStrategy(stra));
    }

    public MnContours(FCNBase fcn, FunctionMinimum min, MnStrategy stra) {
        this.theFCN = fcn;
        this.theMinimum = min;
        this.theStrategy = stra;
    }

    public List points(int px, int py) {
        return this.points(px, py, 1.0);
    }

    public List points(int px, int py, double errDef) {
        return this.points(px, py, errDef, 20);
    }

    public List points(int px, int py, double errDef, int npoints) {
        ContoursError cont = this.contour(px, py, errDef, npoints);
        return cont.points();
    }

    public ContoursError contour(int px, int py) {
        return this.contour(px, py, 1.0);
    }

    public ContoursError contour(int px, int py, double errDef) {
        return this.contour(px, py, errDef, 20);
    }

    public ContoursError contour(int px, int py, double errDef, int npoints) {
        errDef *= this.theMinimum.errorDef();
        if (!$assertionsDisabled && npoints <= 3) {
            throw new AssertionError();
        }
        int maxcalls = 100 * (npoints + 5) * (this.theMinimum.userState().variableParameters() + 1);
        int nfcn = 0;
        ArrayList<Point> result = new ArrayList<Point>(npoints);
        ArrayList states = new ArrayList();
        double toler = 0.05;
        MnMinos minos = new MnMinos(this.theFCN, this.theMinimum, this.theStrategy);
        double valx = this.theMinimum.userState().value(px);
        double valy = this.theMinimum.userState().value(py);
        MinosError mex = minos.minos(px, errDef);
        nfcn += mex.nfcn();
        if (!mex.isValid()) {
            System.err.println("MnContours is unable to find first two points.");
            return new ContoursError(px, py, result, mex, mex, nfcn);
        }
        Point ex = mex.range();
        MinosError mey = minos.minos(py, errDef);
        nfcn += mey.nfcn();
        if (!mey.isValid()) {
            System.err.println("MnContours is unable to find second two points.");
            return new ContoursError(px, py, result, mex, mey, nfcn);
        }
        Point ey = mey.range();
        MnMigrad migrad = new MnMigrad(this.theFCN, (MnUserParameterState)this.theMinimum.userState().clone(), new MnStrategy(Math.max(0, this.theStrategy.strategy() - 1)));
        migrad.fix(px);
        migrad.setValue(px, valx + ex.second);
        FunctionMinimum exy_up = migrad.minimize();
        nfcn += exy_up.nfcn();
        if (!exy_up.isValid()) {
            System.err.println("MnContours is unable to find upper y value for x parameter " + px + ".");
            return new ContoursError(px, py, result, mex, mey, nfcn);
        }
        migrad.setValue(px, valx + ex.first);
        FunctionMinimum exy_lo = migrad.minimize();
        nfcn += exy_lo.nfcn();
        if (!exy_lo.isValid()) {
            System.err.println("MnContours is unable to find lower y value for x parameter " + px + ".");
            return new ContoursError(px, py, result, mex, mey, nfcn);
        }
        MnMigrad migrad1 = new MnMigrad(this.theFCN, (MnUserParameterState)this.theMinimum.userState().clone(), new MnStrategy(Math.max(0, this.theStrategy.strategy() - 1)));
        migrad1.fix(py);
        migrad1.setValue(py, valy + ey.second);
        FunctionMinimum eyx_up = migrad1.minimize();
        nfcn += eyx_up.nfcn();
        if (!eyx_up.isValid()) {
            System.err.println("MnContours is unable to find upper x value for y parameter " + py + ".");
            return new ContoursError(px, py, result, mex, mey, nfcn);
        }
        migrad1.setValue(py, valy + ey.first);
        FunctionMinimum eyx_lo = migrad1.minimize();
        nfcn += eyx_lo.nfcn();
        if (!eyx_lo.isValid()) {
            System.err.println("MnContours is unable to find lower x value for y parameter " + py + ".");
            return new ContoursError(px, py, result, mex, mey, nfcn);
        }
        double scalx = 1.0 / (ex.second - ex.first);
        double scaly = 1.0 / (ey.second - ey.first);
        result.add(new Point(valx + ex.first, exy_lo.userState().value(py)));
        result.add(new Point(eyx_lo.userState().value(px), valy + ey.first));
        result.add(new Point(valx + ex.second, exy_up.userState().value(py)));
        result.add(new Point(eyx_up.userState().value(px), valy + ey.second));
        MnUserParameterState upar = (MnUserParameterState)this.theMinimum.userState().clone();
        upar.fix(px);
        upar.fix(py);
        int[] par = new int[]{px, py};
        MnFunctionCross cross = new MnFunctionCross(this.theFCN, upar, this.theMinimum.fval(), this.theStrategy, errDef);
        block0: for (int i = 4; i < npoints; ++i) {
            Point idist1 = (Point)result.get(result.size() - 1);
            Point idist2 = (Point)result.get(0);
            int pos2 = 0;
            double distx = idist1.first - idist2.first;
            double disty = idist1.second - idist2.second;
            double bigdis = scalx * scalx * distx * distx + scaly * scaly * disty * disty;
            for (int j = 0; j < result.size() - 1; ++j) {
                Point ipair = (Point)result.get(j);
                double distx2 = ipair.first - ((Point)result.get((int)(j + 1))).first;
                double disty2 = ipair.second - ((Point)result.get((int)(j + 1))).second;
                double dist = scalx * scalx * distx2 * distx2 + scaly * scaly * disty2 * disty2;
                if (!(dist > bigdis)) continue;
                bigdis = dist;
                idist1 = ipair;
                idist2 = (Point)result.get(j + 1);
                pos2 = j + 1;
            }
            double a1 = 0.5;
            double a2 = 0.5;
            double sca = 1.0;
            while (true) {
                if (nfcn > maxcalls) {
                    System.err.println("MnContours: maximum number of function calls exhausted.");
                    return new ContoursError(px, py, result, mex, mey, nfcn);
                }
                double xmidcr = a1 * idist1.first + a2 * idist2.first;
                double ymidcr = a1 * idist1.second + a2 * idist2.second;
                double xdir = idist2.second - idist1.second;
                double ydir = idist1.first - idist2.first;
                double scalfac = sca * Math.max(Math.abs(xdir * scalx), Math.abs(ydir * scaly));
                double xdircr = xdir / scalfac;
                double ydircr = ydir / scalfac;
                double[] pmid = new double[]{xmidcr, ymidcr};
                double[] pdir = new double[]{xdircr, ydircr};
                MnCross opt = cross.cross(par, pmid, pdir, toler, maxcalls);
                nfcn += opt.nfcn();
                if (opt.isValid()) {
                    double aopt = opt.value();
                    if (pos2 == 0) {
                        result.add(new Point(xmidcr + aopt * xdircr, ymidcr + aopt * ydircr));
                        continue block0;
                    }
                    result.add(pos2, new Point(xmidcr + aopt * xdircr, ymidcr + aopt * ydircr));
                    continue block0;
                }
                if (sca < 0.0) {
                    System.err.println("MnContours is unable to find point " + (i + 1) + " on contour.");
                    System.err.println("MnContours finds only " + i + " points.");
                    return new ContoursError(px, py, result, mex, mey, nfcn);
                }
                sca = -1.0;
            }
        }
        return new ContoursError(px, py, result, mex, mey, nfcn);
    }

    MnStrategy strategy() {
        return this.theStrategy;
    }

    static {
        $assertionsDisabled = !MnContours.class.desiredAssertionStatus();
    }
}

