/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.FunctionGradient;
import org.freehep.math.minuit.GradientCalculator;
import org.freehep.math.minuit.InitialGradientCalculator;
import org.freehep.math.minuit.MinimumParameters;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnFcn;
import org.freehep.math.minuit.MnMachinePrecision;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUserTransformation;
import org.freehep.math.minuit.Pair;

class HessianGradientCalculator
implements GradientCalculator {
    private MnFcn theFcn;
    private MnUserTransformation theTransformation;
    private MnStrategy theStrategy;

    HessianGradientCalculator(MnFcn fcn, MnUserTransformation par, MnStrategy stra) {
        this.theFcn = fcn;
        this.theTransformation = par;
        this.theStrategy = stra;
    }

    public FunctionGradient gradient(MinimumParameters par) {
        InitialGradientCalculator gc2 = new InitialGradientCalculator(this.theFcn, this.theTransformation, this.theStrategy);
        FunctionGradient gra = gc2.gradient(par);
        return this.gradient(par, gra);
    }

    public FunctionGradient gradient(MinimumParameters par, FunctionGradient gradient) {
        return (FunctionGradient)this.deltaGradient((MinimumParameters)par, (FunctionGradient)gradient).first;
    }

    Pair deltaGradient(MinimumParameters par, FunctionGradient gradient) {
        if (!par.isValid()) {
            throw new IllegalArgumentException("parameters are invalid");
        }
        MnAlgebraicVector x = (MnAlgebraicVector)par.vec().clone();
        MnAlgebraicVector grd = (MnAlgebraicVector)gradient.grad().clone();
        MnAlgebraicVector g2 = gradient.g2();
        MnAlgebraicVector gstep = gradient.gstep();
        double fcnmin = par.fval();
        double dfmin = 4.0 * this.precision().eps2() * (Math.abs(fcnmin) + this.theFcn.errorDef());
        int n = x.size();
        MnAlgebraicVector dgrd = new MnAlgebraicVector(n);
        for (int i = 0; i < n; ++i) {
            double xtf = x.get(i);
            double dmin = 4.0 * this.precision().eps2() * (xtf + this.precision().eps2());
            double epspri = this.precision().eps2() + Math.abs(grd.get(i) * this.precision().eps2());
            double optstp = Math.sqrt(dfmin / (Math.abs(g2.get(i)) + epspri));
            double d = 0.2 * Math.abs(gstep.get(i));
            if (d > optstp) {
                d = optstp;
            }
            if (d < dmin) {
                d = dmin;
            }
            double chgold = 10000.0;
            double dgmin = 0.0;
            double grdold = 0.0;
            double grdnew = 0.0;
            for (int j = 0; j < this.ncycle(); ++j) {
                double change;
                x.set(i, xtf + d);
                double fs1 = this.theFcn.valueOf(x);
                x.set(i, xtf - d);
                double fs2 = this.theFcn.valueOf(x);
                x.set(i, xtf);
                grdold = grd.get(i);
                grdnew = (fs1 - fs2) / (2.0 * d);
                dgmin = this.precision().eps() * (Math.abs(fs1) + Math.abs(fs2)) / d;
                if (Math.abs(grdnew) < this.precision().eps() || (change = Math.abs((grdold - grdnew) / grdnew)) > chgold && j > 1) break;
                chgold = change;
                grd.set(i, grdnew);
                if (change < 0.05 || Math.abs(grdold - grdnew) < dgmin || d < dmin) break;
                d *= 0.2;
            }
            dgrd.set(i, Math.max(dgmin, Math.abs(grdold - grdnew)));
        }
        return new Pair(new FunctionGradient(grd, g2, gstep), dgrd);
    }

    MnFcn fcn() {
        return this.theFcn;
    }

    MnUserTransformation trafo() {
        return this.theTransformation;
    }

    MnMachinePrecision precision() {
        return this.theTransformation.precision();
    }

    MnStrategy strategy() {
        return this.theStrategy;
    }

    int ncycle() {
        return this.strategy().hessianGradientNCycles();
    }

    double stepTolerance() {
        return this.strategy().gradientStepTolerance();
    }

    double gradTolerance() {
        return this.strategy().gradientTolerance();
    }
}

