/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.SaveAsGIF;
import jas.hist.SaveAsPlotML;
import jas.hist.SaveAsPlugin;
import jas.util.Application;
import jas.util.JASDialog;
import jas.util.JASState;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SaveAsDialog
extends JASDialog
implements ActionListener {
    private static Vector list;
    private static Properties props;
    private JButton browse = new JButton("Browse...");
    private JButton advanced = new JButton("Options...");
    private JTextField file = new JTextField(40);
    private JComboBox type;
    private Component component;

    public static void register(SaveAsPlugin plugin) {
        list.addElement(plugin);
        plugin.restoreOptions(props);
    }

    public SaveAsDialog(Component c) {
        super((Frame)SwingUtilities.getAncestorOfClass(Frame.class, c), "Save As...");
        this.component = c;
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        pane.add((Component)this.file, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        pane.add((Component)this.browse, gridBagConstraints);
        Vector<SaveAsPlugin> fileTypes = new Vector<SaveAsPlugin>();
        for (int i = 0; i < list.size(); ++i) {
            SaveAsPlugin type = (SaveAsPlugin)list.elementAt(i);
            if (!type.supportsClass(c)) continue;
            fileTypes.addElement(type);
        }
        this.type = new JComboBox(fileTypes);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        pane.add((Component)this.type, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        pane.add((Component)this.advanced, gridBagConstraints);
        this.getContentPane().add((Component)pane, "Center");
        String defFile = System.getProperty("user.home") + File.separator + "plot.xxx";
        String dType = props.getProperty("jas.hist.saveAsType");
        if (dType != null) {
            for (int i = 0; i < fileTypes.size(); ++i) {
                SaveAsPlugin saveAs = (SaveAsPlugin)fileTypes.elementAt(i);
                if (!saveAs.getFileFilter().getDescription().equals(dType)) continue;
                this.type.setSelectedItem(saveAs);
                break;
            }
        }
        defFile = props.getProperty("jas.hist.saveAsFile", defFile);
        File f = new File(defFile);
        f = this.currentType().adjustFilename(f);
        this.file.setText(f.toString());
        this.browse.addActionListener(this);
        this.advanced.addActionListener(this);
        this.advanced.setEnabled(this.currentType().hasOptions());
        this.type.setRenderer(new SaveAsRenderer());
        this.type.addActionListener(this);
        this.file.getDocument().addDocumentListener(this);
    }

    private SaveAsPlugin currentType() {
        return (SaveAsPlugin)this.type.getSelectedItem();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.browse) {
            JFileChooser chooser = new JFileChooser(this.file.getText());
            chooser.setFileFilter(this.currentType().getFileFilter());
            if (chooser.showDialog(this, "Select") == 0) {
                this.file.setText(chooser.getSelectedFile().toString());
            }
        } else if (source == this.advanced) {
            Properties save = new Properties();
            this.currentType().saveOptions(save);
            JPanel panel = this.currentType().getOptionsPanel();
            int rc = JOptionPane.showConfirmDialog(this, panel, "Options for " + this.currentType().getFileFilter().getDescription(), 2, -1);
            if (rc != 0) {
                this.currentType().restoreOptions(save);
            }
        } else if (source == this.type) {
            this.advanced.setEnabled(this.currentType().hasOptions());
            File f1 = new File(this.file.getText());
            File f2 = this.currentType().adjustFilename(f1);
            if (!f1.equals(f2)) {
                this.file.setText(f2.toString());
            }
        }
    }

    protected void onOK() {
        try {
            int ok;
            File f = new File(this.file.getText());
            if (f.exists() && (ok = JOptionPane.showConfirmDialog(this, "Replace existing file?")) != 0) {
                return;
            }
            SaveAsPlugin t = this.currentType();
            BufferedOutputStream os2 = new BufferedOutputStream(new FileOutputStream(f));
            t.saveAs(this.component, os2, f, this);
            ((OutputStream)os2).close();
            super.onOK();
            props.put("jas.hist.saveAsFile", this.file.getText());
            props.put("jas.hist.saveAsType", this.currentType().getFileFilter().getDescription());
            t.saveOptions(props);
        }
        catch (IOException x) {
            JOptionPane.showMessageDialog(this, x);
        }
    }

    protected void enableOK(JASState state) {
        state.setEnabled(this.file.getText().length() > 0);
    }

    static {
        String prop;
        list = new Vector();
        Application app = Application.getApplication();
        props = app != null ? app.getUserProperties() : new Properties();
        String embed = props.getProperty(prop = "org.freehep.graphics2d.exportchooser.EPS_PSExportFileType.EmbedFonts");
        if (embed == null) {
            props.setProperty(prop, "Embed unknown as Type3");
        }
        SaveAsDialog.register(new SaveAsPlotML());
        SaveAsDialog.register(new SaveAsGIF());
    }

    private class SaveAsRenderer
    extends DefaultListCellRenderer {
        private SaveAsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof SaveAsPlugin) {
                this.setText(((SaveAsPlugin)value).getFileFilter().getDescription());
            }
            return this;
        }
    }
}

