/*
 * Decompiled with CFR 0.152.
 */
package ice.util.ICEListenerList;

import ice.util.ICEListenerList.ICEEventInterface;
import ice.util.ICEListenerList.ICEListener;
import ice.util.ICEListenerList.exception.ExceededListenerListMaxLengthException;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ICEListenerList<L extends ICEListener, E extends ICEEventInterface> {
    private static final Logger logger = Logger.getLogger("RootLogger");
    protected static final int DEFALUT_MAX_CAPACITY = 200;
    protected int maxCapacity;
    protected Vector<L> listenerList;

    public ICEListenerList() {
        this.init(200);
    }

    public ICEListenerList(int maxCapacity) {
        this.init(maxCapacity);
    }

    protected void init(int maxCapacity) {
        this.listenerList = new Vector();
        this.setMaxCapacity(maxCapacity);
    }

    public long getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        int length = this.listenerList.size();
        if (length > maxCapacity) {
            int i = length - 1;
            while (i >= maxCapacity) {
                this.listenerList.removeElementAt(i);
                --i;
            }
            this.listenerList.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(L iceListener) throws ICEListenerListExceptionBase {
        block8: {
            try {
                int theSize = this.listenerList.size() + 1;
                if (theSize <= this.maxCapacity) {
                    Vector<L> vector = this.listenerList;
                    synchronized (vector) {
                        boolean allReadyAdded = this.listenerList.contains(iceListener);
                        if (!allReadyAdded) {
                            this.listenerList.add(iceListener);
                        } else {
                            logger.error("IceListenerList.addListener ListenerAlreadyInListExeption()");
                        }
                        break block8;
                    }
                }
                System.out.println("exceeded limit");
                throw new ExceededListenerListMaxLengthException();
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("Attempted to add listener to " + this + " " + e);
                System.out.println("ICEListenerListExceptionBase");
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(L iceListener) {
        boolean flag = false;
        Vector<L> vector = this.listenerList;
        synchronized (vector) {
            flag = this.listenerList.remove(iceListener);
        }
        return flag;
    }

    public boolean isEmpty() {
        return this.listenerList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(E event) {
        Vector<L> vector = this.listenerList;
        synchronized (vector) {
            for (ICEListener iceListener : this.listenerList) {
                try {
                    Class<?> iceListenerClass = iceListener.getClass();
                    Class[] cs = new Class[]{event.getClass()};
                    Method method = iceListenerClass.getMethod("actionPerformed", cs);
                    Object[] args = new Object[]{event};
                    method.invoke((Object)iceListener, args);
                }
                catch (Exception e) {
                    logger.error("Error in notifier " + e);
                }
            }
        }
    }

    public int size() {
        return this.listenerList.size();
    }
}

