/*
 * Decompiled with CFR 0.152.
 */
package ice.swing.textFields;

import ice.event.communication.EmptyDocumentListener;
import java.text.Format;
import java.util.ArrayList;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ICEFormattedTextFieldBase
extends JFormattedTextField
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    protected ArrayList<EmptyDocumentListener> emptyDocumentListeners;
    protected boolean formattedState;

    public ICEFormattedTextFieldBase() {
        this.init();
    }

    public ICEFormattedTextFieldBase(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
        this.init();
    }

    public ICEFormattedTextFieldBase(JFormattedTextField.AbstractFormatterFactory factory, Object currentValue) {
        super(factory, currentValue);
        this.init();
    }

    public ICEFormattedTextFieldBase(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
        this.init();
    }

    public ICEFormattedTextFieldBase(Format format) {
        super(format);
        this.init();
    }

    public ICEFormattedTextFieldBase(Object value) {
        super(value);
        this.init();
    }

    public void addEmptyDocumentListener(EmptyDocumentListener l) {
        this.emptyDocumentListeners.add(l);
    }

    public void removeEmptyDocumentListener(EmptyDocumentListener l) {
        this.emptyDocumentListeners.remove(l);
    }

    protected void init() {
        this.emptyDocumentListeners = new ArrayList();
        this.getDocument().addDocumentListener(this);
    }

    protected void notifyEmptyDocumentListeners(EmptyDocumentListener.EmptyDocumentEvent e) {
        for (EmptyDocumentListener l : this.emptyDocumentListeners) {
            l.documentChanged(e);
        }
    }

    protected void determineDocumentState(DocumentEvent e) {
        int documentLength = -1;
        EmptyDocumentListener.EmptyDocumentState state = EmptyDocumentListener.EmptyDocumentState.EMPTY;
        EmptyDocumentListener.EmptyDocumentEvent event = null;
        if (this.formattedState) {
            state = EmptyDocumentListener.EmptyDocumentState.FORMATTING;
        }
        if ((documentLength = e.getDocument().getLength()) > 0) {
            state = EmptyDocumentListener.EmptyDocumentState.HAS_TEXT;
        }
        event = new EmptyDocumentListener.EmptyDocumentEvent(this, state);
        this.notifyEmptyDocumentListeners(event);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.determineDocumentState(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.determineDocumentState(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.determineDocumentState(e);
    }

    public boolean isInFormattingState() {
        return this.formattedState;
    }

    public void setFormattingState(boolean formattedState) {
        this.formattedState = formattedState;
    }
}

