/*
 * Decompiled with CFR 0.152.
 */
package ice.swing.tas.bt7;

import ice.IconManager;
import ice.communication.SendQueueManager;
import ice.data.tas.bt7.PeakSet;
import ice.data.tas.bt7.UBMatrix;
import ice.event.PeakSetPropertyChangedEvent;
import ice.event.PeakSetPropertyChangedListener;
import ice.event.UBIncludedPrimaryListener;
import ice.event.UBMatrixPropertyChangedEvent;
import ice.event.UBMatrixPropertyChangedListener;
import ice.event.communication.UBMatrixAskCommandListener;
import ice.event.communication.util.UBMatrixAskCommandEnums;
import ice.event.communication.util.UBMatrixAskCommandListenerUtil;
import ice.event.communication.util.UBMatrixParsedAskResponse;
import ice.event.tas.bt7.PeakSetChangeRequestListener;
import ice.swing.SelfDisablingEnablingButton;
import ice.swing.buttons.ImageButton;
import ice.swing.tas.bt7.PrimaryRefectionButtonGroup;
import ice.swing.tas.bt7.PrimaryReflectionToggleButton;
import ice.swing.textFields.ChangeBackgroundOnEditTextField;
import ice.util.I18N;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PeakSetRow
extends JPanel
implements UBMatrixPropertyChangedListener,
PeakSetPropertyChangedListener,
ActionListener,
UBMatrixAskCommandListener {
    protected static final String H_INPUT_LABEL_KEY = "ice.swing.tas.bt7.PeakSetRow.hInput.label";
    protected static final String K_INPUT_LABEL_KEY = "ice.swing.tas.bt7.PeakSetRow.kInput.label";
    protected static final String L_INPUT_LABEL_KEY = "ice.swing.tas.bt7.PeakSetRow.lInput.label";
    protected static final String A3_INPUT_LABEL_KEY = "ice.swing.tas.bt7.PeakSetRow.a3Input.label";
    protected static final String A4_INPUT_LABEL_KEY = "ice.swing.tas.bt7.PeakSetRow.a4Input.label";
    protected static final String LTILT_INPUT_LABEL_KEY = "ice.swing.tas.bt7.PeakSetRow.lowerTiltInput.label";
    protected static final String UTILT_INPUT_LABEL_KEY = "ice.swing.tas.bt7.PeakSetRow.upperTiltInput.label";
    protected static PrimaryRefectionButtonGroup primaryButtonGroup = new PrimaryRefectionButtonGroup();
    protected static PrimaryReflectionToggleButton noPrimaryRB = new PrimaryReflectionToggleButton();
    protected static int numIncluded;
    protected static final int MAX_INCLUDED_ALLOWED;
    protected SendQueueManager sendManager;
    protected PrimaryReflectionToggleButton primaryRB;
    protected JCheckBox includedCB;
    protected JLabel hklLabel;
    protected PeakSet peakSet;
    protected UBMatrix ubMatrix;
    protected DeletePeakSetAction deletePeakSetAction;
    protected ChangeBackgroundOnEditTextField hField;
    protected ChangeBackgroundOnEditTextField kField;
    protected ChangeBackgroundOnEditTextField lField;
    protected ChangeBackgroundOnEditTextField a3Field;
    protected ChangeBackgroundOnEditTextField a4Field;
    protected ChangeBackgroundOnEditTextField lowerTiltField;
    protected ChangeBackgroundOnEditTextField upperTiltField;
    protected SetUBMotorValuesAction updateUBMotorValuesAction;
    protected ArrayList<PeakSetChangeRequestListener> peakSetChangeRequestListeners;
    protected ArrayList<UBIncludedPrimaryListener> ubIncludedPrimaryListeners;
    protected static final String INCLUDED_CHECKBOX_LABEL_KEY = "ice.swing.tas.bt7.PeakSetRow.includedCB.label";
    protected static final String PEAKSET_ROW_TITLE_KEY = "ice.swing.tas.bt7.PeakSetRow.peakSetRow.title";

    static {
        primaryButtonGroup.add(noPrimaryRB);
        numIncluded = 0;
        MAX_INCLUDED_ALLOWED = 2;
        noPrimaryRB.setSelected(true);
    }

    public static int getNumIncluded() {
        return numIncluded;
    }

    public static boolean isPrimarySelected() {
        return !noPrimaryRB.isSelected();
    }

    public PeakSetRow(PeakSet peakSet, UBMatrix ubMatrix, SendQueueManager sendManager) {
        String includedCBLabel = null;
        this.peakSet = peakSet;
        this.ubMatrix = ubMatrix;
        this.sendManager = sendManager;
        this.primaryRB = new PrimaryReflectionToggleButton();
        includedCBLabel = I18N.getString(INCLUDED_CHECKBOX_LABEL_KEY);
        this.includedCB = new JCheckBox(includedCBLabel);
        this.hklLabel = new JLabel();
        this.hField = new ChangeBackgroundOnEditTextField();
        this.kField = new ChangeBackgroundOnEditTextField();
        this.lField = new ChangeBackgroundOnEditTextField();
        this.a3Field = new ChangeBackgroundOnEditTextField();
        this.a4Field = new ChangeBackgroundOnEditTextField();
        this.lowerTiltField = new ChangeBackgroundOnEditTextField();
        this.upperTiltField = new ChangeBackgroundOnEditTextField();
        this.deletePeakSetAction = new DeletePeakSetAction();
        this.updateUBMotorValuesAction = new SetUBMotorValuesAction();
        this.peakSetChangeRequestListeners = new ArrayList();
        this.ubIncludedPrimaryListeners = new ArrayList();
        primaryButtonGroup.add(this.primaryRB);
        this.hField.setText(String.valueOf(peakSet.getH()));
        this.kField.setText(String.valueOf(peakSet.getK()));
        this.lField.setText(String.valueOf(peakSet.getL()));
        this.a3Field.setText(String.valueOf(peakSet.getA3Value()));
        this.a4Field.setText(String.valueOf(peakSet.getA4Value()));
        this.lowerTiltField.setText(String.valueOf(peakSet.getLowerTiltValue()));
        this.upperTiltField.setText(String.valueOf(peakSet.getUpperTiltValue()));
        try {
            peakSet.addPropertyChangeListener(this);
            ubMatrix.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("PeakSetRow can not add listener " + e);
        }
        this.buildGUI();
    }

    protected void buildGUI() {
        JPanel fieldsAndControlsPanel = new JPanel();
        JPanel controlsPanel = this.buildControlsPanel();
        JPanel fieldsPanel = this.buildFieldsPanel();
        DeleteButton deleteBtn = new DeleteButton();
        String peaksetRowTitle = null;
        String peaksetRowTitlePattern = null;
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        Insets insets = null;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        deleteBtn.addActionListener(this.deletePeakSetAction);
        this.add((Component)deleteBtn, gridBagConstraints);
        peaksetRowTitlePattern = I18N.getString(PEAKSET_ROW_TITLE_KEY);
        peaksetRowTitle = MessageFormat.format(peaksetRowTitlePattern, this.peakSet.getId());
        fieldsAndControlsPanel.setBorder(BorderFactory.createTitledBorder(peaksetRowTitle));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)fieldsAndControlsPanel, gridBagConstraints);
        GridBagConstraints fieldsAndControlsConstraints = null;
        GridBagLayout fieldsAndControlsLayout = null;
        fieldsAndControlsLayout = new GridBagLayout();
        fieldsAndControlsPanel.setLayout(fieldsAndControlsLayout);
        fieldsAndControlsConstraints = new GridBagConstraints();
        fieldsAndControlsConstraints.insets = new Insets(2, 0, 2, 0);
        fieldsAndControlsConstraints.weightx = 1.0;
        fieldsAndControlsConstraints.weighty = 0.0;
        fieldsAndControlsConstraints.gridx = 0;
        fieldsAndControlsConstraints.gridy = 0;
        fieldsAndControlsConstraints.anchor = 18;
        fieldsAndControlsConstraints.fill = 2;
        fieldsAndControlsPanel.add((Component)fieldsPanel, fieldsAndControlsConstraints);
        fieldsAndControlsConstraints.gridy = 1;
        fieldsAndControlsPanel.add((Component)controlsPanel, fieldsAndControlsConstraints);
        this.initState();
    }

    protected void initState() {
        if (this.ubMatrix.getPrimaryPeakSet() == this.peakSet) {
            this.primaryRB.setSelected(true);
            this.includedCB.setSelected(true);
            ++numIncluded;
        } else if (this.peakSet.isIncluded()) {
            this.includedCB.setSelected(true);
            ++numIncluded;
        } else {
            this.primaryRB.setEnabled(false);
        }
        this.includedCB.addActionListener(this);
        this.primaryRB.addActionListener(this);
    }

    protected JPanel buildControlsPanel() {
        ApplyButton applyBtn = new ApplyButton();
        JPanel panel = new JPanel();
        GridBagConstraints gridBagConstraints = null;
        GridBagLayout gridBagLayout = null;
        Insets insets = null;
        JPanel includedPrimaryPanel = new JPanel();
        gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        insets = new Insets(0, 0, 0, 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        includedPrimaryPanel.setLayout(new BoxLayout(includedPrimaryPanel, 0));
        includedPrimaryPanel.add(Box.createHorizontalStrut(5));
        includedPrimaryPanel.add(this.includedCB);
        includedPrimaryPanel.add(Box.createHorizontalStrut(10));
        includedPrimaryPanel.add(this.primaryRB);
        panel.add((Component)includedPrimaryPanel, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridx = 1;
        panel.add((Component)applyBtn, gridBagConstraints);
        applyBtn.addActionListener(this.hField);
        applyBtn.addActionListener(this.kField);
        applyBtn.addActionListener(this.lField);
        applyBtn.addActionListener(this.a3Field);
        applyBtn.addActionListener(this.a4Field);
        applyBtn.addActionListener(this.lowerTiltField);
        applyBtn.addActionListener(this.upperTiltField);
        this.hField.addKeyListener(applyBtn);
        this.kField.addKeyListener(applyBtn);
        this.lField.addKeyListener(applyBtn);
        this.a3Field.addKeyListener(applyBtn);
        this.a4Field.addKeyListener(applyBtn);
        this.lowerTiltField.addKeyListener(applyBtn);
        this.upperTiltField.addKeyListener(applyBtn);
        return panel;
    }

    protected JPanel buildFieldsPanel() {
        JLabel hLabel = new JLabel(I18N.getString(H_INPUT_LABEL_KEY));
        JLabel kLabel = new JLabel(I18N.getString(K_INPUT_LABEL_KEY));
        JLabel lLabel = new JLabel(I18N.getString(L_INPUT_LABEL_KEY));
        JLabel a3Label = new JLabel(I18N.getString(A3_INPUT_LABEL_KEY));
        JLabel a4Label = new JLabel(I18N.getString(A4_INPUT_LABEL_KEY));
        JLabel upperTiltLabel = new JLabel(I18N.getString(UTILT_INPUT_LABEL_KEY));
        JLabel lowerTiltLabel = new JLabel(I18N.getString(LTILT_INPUT_LABEL_KEY));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalStrut(10));
        panel.add(hLabel);
        panel.add(this.hField);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(kLabel);
        panel.add(this.kField);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(lLabel);
        panel.add(this.lField);
        panel.add(Box.createHorizontalStrut(30));
        panel.add(a3Label);
        panel.add(this.a3Field);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(a4Label);
        panel.add(this.a4Field);
        panel.add(Box.createHorizontalStrut(30));
        panel.add(lowerTiltLabel);
        panel.add(this.lowerTiltField);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(upperTiltLabel);
        panel.add(this.upperTiltField);
        return panel;
    }

    @Override
    public void actionPerformed(PeakSetPropertyChangedEvent pce) {
        String propertyName = pce.getPropertyName();
        Object newValue = pce.getNewValue();
        Object source = pce.getSource();
        if (propertyName.equals(PeakSet.includedFieldName)) {
            if (((Boolean)newValue).booleanValue()) {
                this.includedCB.setSelected(true);
                this.primaryRB.setEnabled(true);
            } else {
                this.includedCB.setSelected(false);
                noPrimaryRB.setSelected(true);
                this.primaryRB.setEnabled(false);
            }
            this.notifyOfIncludedChange();
        } else if (propertyName.equals(PeakSet.a3ValueFieldName) || propertyName.equals(PeakSet.hFieldName) || propertyName.equals(PeakSet.kFieldName) || propertyName.equals(PeakSet.lFieldName) || propertyName.equals(PeakSet.a4ValueFieldName) || propertyName.equals(PeakSet.lowerTiltFieldName) || propertyName.equals(PeakSet.upperTiltFieldName)) {
            SwingUtilities.invokeLater(new UpdateUBMatrixMotorValuesRunnable());
        }
    }

    @Override
    public void actionPerformed(UBMatrixPropertyChangedEvent pce) {
        String propertyName = pce.getPropertyName();
        Object newValue = pce.getNewValue();
        Object source = pce.getSource();
        if (propertyName.equals(UBMatrix.primaryPeakSetFieldName) && (PeakSet)newValue == this.peakSet) {
            this.includedCB.setSelected(true);
            this.primaryRB.setEnabled(true);
            this.primaryRB.setSelected(true);
            this.notifyOfPrimaryChange();
        }
    }

    @Override
    public String toString() {
        return "blah";
    }

    public void addPeakSetChangeRequestListener(PeakSetChangeRequestListener cprl) {
        this.peakSetChangeRequestListeners.add(cprl);
    }

    public void removePeakSetChangeRequestListener(PeakSetChangeRequestListener cprl) {
        this.peakSetChangeRequestListeners.remove(cprl);
    }

    public PeakSet getPeakSet() {
        return this.peakSet;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        System.out.println("action event");
        if (source == this.includedCB) {
            boolean isSelected = this.includedCB.isSelected();
            if (isSelected) {
                String calcTag = null;
                String metaData = null;
                metaData = String.valueOf(this.peakSet.getId());
                calcTag = UBMatrixAskCommandListenerUtil.buildAskResponseTag(UBMatrixAskCommandEnums.INCLUDE_REFLECTION, metaData);
                this.primaryRB.setEnabled(true);
                this.sendManager.addMessage("ask " + calcTag + " ub includepeakset " + this.peakSet.getId());
                ++numIncluded;
            } else {
                if (this.primaryRB.isSelected()) {
                    noPrimaryRB.setSelected(true);
                }
                this.primaryRB.setEnabled(false);
                this.sendManager.addMessage("ub excludepeakset " + this.peakSet.getId());
                --numIncluded;
            }
        } else if (source == this.primaryRB) {
            String calcTag = null;
            String metaData = null;
            metaData = String.valueOf(this.peakSet.getId());
            calcTag = UBMatrixAskCommandListenerUtil.buildAskResponseTag(UBMatrixAskCommandEnums.MAKE_REFLECTION_PRIMARY, metaData);
            this.sendManager.addMessage("ask " + calcTag + " ub setprimary " + this.peakSet.getId());
        }
    }

    public void beingRemoved() {
        if (this.peakSet.isIncluded()) {
            --numIncluded;
        }
    }

    public void addUBIncludedPrimaryListener(UBIncludedPrimaryListener ubipl) {
        this.ubIncludedPrimaryListeners.add(ubipl);
    }

    public void removeUBIncludedPrimaryListener(UBIncludedPrimaryListener ubipl) {
        this.ubIncludedPrimaryListeners.remove(ubipl);
    }

    public void notifyOfPrimaryChange() {
        Iterator<UBIncludedPrimaryListener> iterator = this.ubIncludedPrimaryListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().primarySelected();
        }
    }

    public void notifyOfIncludedChange() {
        Iterator<UBIncludedPrimaryListener> iterator = this.ubIncludedPrimaryListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().numIncludedChanged();
        }
    }

    @Override
    public void actionPerformed(UBMatrixParsedAskResponse ubMatrixParsedAskResponse) {
        UBMatrixAskCommandEnums theCommand = null;
        boolean errorOccurred = false;
        String metaData = null;
        int reflectionId = -1;
        int thisId = -1;
        theCommand = ubMatrixParsedAskResponse.getTheCommand();
        errorOccurred = ubMatrixParsedAskResponse.isErrorCondition();
        if (theCommand == UBMatrixAskCommandEnums.INCLUDE_REFLECTION && errorOccurred) {
            thisId = this.peakSet.getId();
            if (thisId == (reflectionId = Integer.parseInt(metaData = ubMatrixParsedAskResponse.getMetaData()))) {
                this.includedCB.setSelected(false);
                --numIncluded;
                this.primaryRB.setEnabled(false);
            }
            return;
        }
        if (theCommand == UBMatrixAskCommandEnums.MAKE_REFLECTION_PRIMARY && errorOccurred) {
            thisId = this.peakSet.getId();
            if (thisId == (reflectionId = Integer.parseInt(metaData = ubMatrixParsedAskResponse.getMetaData()))) {
                noPrimaryRB.setSelected(true);
            }
            return;
        }
    }

    protected class ApplyButton
    extends SelfDisablingEnablingButton {
        private static final long serialVersionUID = 1L;

        public ApplyButton() {
            super(PeakSetRow.this.updateUBMotorValuesAction);
            this.initialize();
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.setEnabled(false);
        }

        @Override
        protected void doExtraWorkWhenRespondingToSelf(ActionEvent e) {
        }

        @Override
        protected Boolean shouldIEnable(ActionEvent e) {
            return true;
        }

        @Override
        protected Boolean shouldIEnableOnKeyEvent(KeyEvent e) {
            return true;
        }
    }

    protected class DeleteButton
    extends ImageButton {
        private static final String NORMAL_IMAGE_KEY = "remove21x21";
        private static final String PRESSED_IMAGE_KEY = "remove21x21";
        private static final String ROLLOVER_IMAGE_KEY = "remove21x21";
        private static final long serialVersionUID = 1L;

        public DeleteButton() {
            super(IconManager.getIcon("remove21x21"), IconManager.getIcon("remove21x21"), IconManager.getIcon("remove21x21"));
        }

        protected DeleteButton(ImageIcon normalImage, ImageIcon pressedImage, ImageIcon rolloverImage) {
            super(normalImage, pressedImage, rolloverImage);
        }
    }

    private class DeletePeakSetAction
    extends AbstractAction {
        public DeletePeakSetAction() {
            super(I18N.getString("ubSampleAlignment.peakSetPanel.deletePeakSet.button"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.sendDeleteEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendDeleteEvent() {
            ArrayList<PeakSetChangeRequestListener> arrayList = PeakSetRow.this.peakSetChangeRequestListeners;
            synchronized (arrayList) {
                Iterator<PeakSetChangeRequestListener> iterator = PeakSetRow.this.peakSetChangeRequestListeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().deletePeakSet(PeakSetRow.this.peakSet);
                }
            }
        }
    }

    private class SetUBMotorValuesAction
    extends AbstractAction {
        private Map<ChangeBackgroundOnEditTextField, String> map;

        public SetUBMotorValuesAction() {
            super(I18N.getString("ubSampleAlignment.peakSetPanel.updateUBMotorValues.button"));
            this.map = new HashMap<ChangeBackgroundOnEditTextField, String>();
            this.map.put(PeakSetRow.this.hField, "H");
            this.map.put(PeakSetRow.this.kField, "K");
            this.map.put(PeakSetRow.this.lField, "L");
            this.map.put(PeakSetRow.this.a3Field, "A3");
            this.map.put(PeakSetRow.this.a4Field, "A4");
            this.map.put(PeakSetRow.this.lowerTiltField, "Lower Tilt");
            this.map.put(PeakSetRow.this.upperTiltField, "Upper Tilt");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            boolean allValid = true;
            StringBuilder invalidFields = new StringBuilder();
            for (ChangeBackgroundOnEditTextField textField : this.map.keySet()) {
                if (textField.containsNumber()) continue;
                allValid = false;
                invalidFields.append(", ");
                invalidFields.append(this.map.get(textField));
            }
            if (allValid) {
                String h = PeakSetRow.this.hField.getText();
                String k = PeakSetRow.this.kField.getText();
                String l = PeakSetRow.this.lField.getText();
                String a3 = PeakSetRow.this.a3Field.getText();
                String a4 = PeakSetRow.this.a4Field.getText();
                String lowerTilt = PeakSetRow.this.lowerTiltField.getText();
                String upperTilt = PeakSetRow.this.upperTiltField.getText();
                StringBuilder commandBuilder = new StringBuilder("ub modifypeakset ");
                commandBuilder.append(PeakSetRow.this.peakSet.getId());
                commandBuilder.append(" -h ");
                commandBuilder.append(h);
                commandBuilder.append(" -k ");
                commandBuilder.append(k);
                commandBuilder.append(" -l ");
                commandBuilder.append(l);
                commandBuilder.append(" -a3 ");
                commandBuilder.append(a3);
                commandBuilder.append(" -a4 ");
                commandBuilder.append(a4);
                commandBuilder.append(" -ltilt ");
                commandBuilder.append(lowerTilt);
                commandBuilder.append(" -utilt ");
                commandBuilder.append(upperTilt);
                PeakSetRow.this.sendManager.addMessage(commandBuilder.toString());
                PeakSetRow.this.hField.grabFocus();
            } else {
                String errorMessage = I18N.getString("invalidNumberError");
                errorMessage = errorMessage.concat(invalidFields.substring(2));
                String title = I18N.getString("ubSampleAlignment.invalidNumberDialog.title");
                JOptionPane.showMessageDialog(PeakSetRow.this, errorMessage, title, 0);
            }
        }
    }

    private class UpdateUBMatrixMotorValuesRunnable
    implements Runnable {
        private UpdateUBMatrixMotorValuesRunnable() {
        }

        @Override
        public void run() {
            String h = PeakSetRow.this.hField.getText();
            String k = PeakSetRow.this.kField.getText();
            String l = PeakSetRow.this.lField.getText();
            String a3 = PeakSetRow.this.a3Field.getText();
            String a4 = PeakSetRow.this.a4Field.getText();
            String lTilt = PeakSetRow.this.lowerTiltField.getText();
            String uTilt = PeakSetRow.this.upperTiltField.getText();
            if (!h.equals(String.valueOf(PeakSetRow.this.peakSet.getH()))) {
                PeakSetRow.this.hField.setText(String.valueOf(PeakSetRow.this.peakSet.getH()));
            }
            if (!k.equals(String.valueOf(PeakSetRow.this.peakSet.getK()))) {
                PeakSetRow.this.kField.setText(String.valueOf(PeakSetRow.this.peakSet.getK()));
            }
            if (!l.equals(String.valueOf(PeakSetRow.this.peakSet.getL()))) {
                PeakSetRow.this.lField.setText(String.valueOf(PeakSetRow.this.peakSet.getL()));
            }
            if (!a3.equals(String.valueOf(PeakSetRow.this.peakSet.getA3Value()))) {
                PeakSetRow.this.a3Field.setText(String.valueOf(PeakSetRow.this.peakSet.getA3Value()));
            }
            if (!a4.equals(String.valueOf(PeakSetRow.this.peakSet.getA4Value()))) {
                PeakSetRow.this.a4Field.setText(String.valueOf(PeakSetRow.this.peakSet.getA4Value()));
            }
            if (!lTilt.equals(String.valueOf(PeakSetRow.this.peakSet.getLowerTiltValue()))) {
                PeakSetRow.this.lowerTiltField.setText(String.valueOf(PeakSetRow.this.peakSet.getLowerTiltValue()));
            }
            if (!uTilt.equals(String.valueOf(PeakSetRow.this.peakSet.getUpperTiltValue()))) {
                PeakSetRow.this.upperTiltField.setText(String.valueOf(PeakSetRow.this.peakSet.getUpperTiltValue()));
            }
        }
    }
}

