/*
 * Decompiled with CFR 0.152.
 */
package ice.swing.buttons;

import ice.communication.SendQueueManager;
import ice.data.tas.bt7.Instrument;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.swing.actions.PauseUnPauseAction;
import ice.swing.buttons.TwoStateImageButton;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class PausePlayButtonBase
extends TwoStateImageButton
implements InstrumentValueChangedListener {
    private static final long serialVersionUID = 1L;
    private Instrument instrument = null;
    private PauseUnPauseAction pauseUnPauseAction = null;
    private SendQueueManager sendManager = null;

    public PausePlayButtonBase(Instrument instrument, SendQueueManager sendManager, ImageIcon pauseButton, ImageIcon pauseButtonPressed, ImageIcon pauseButtonRollover, ImageIcon playButton, ImageIcon playButtonPressed, ImageIcon playButtonRollover) {
        super(pauseButton, pauseButtonPressed, pauseButtonRollover, playButton, playButtonPressed, playButtonRollover);
        this.instrument = instrument;
        this.sendManager = sendManager;
        try {
            this.instrument.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("PausePlayButtonBase " + e);
        }
        this.pauseUnPauseAction = new PauseUnPauseAction(sendManager);
        this.addActionListener(this.pauseUnPauseAction);
    }

    @Override
    public void actionPerformed(InstrumentValueChangedEvent pce) {
        if ("state".equals(pce.getPropertyName()) && pce.getSource() == this.instrument) {
            this.updateName();
        }
    }

    private void updateName() {
        if (this.instrument.getState() == Instrument.State.pause) {
            this.setLookStateTwo();
        } else {
            this.setLookStateOne();
        }
    }
}

