/*
 * Decompiled with CFR 0.152.
 */
package ice.profiling;

import ice.profiling.EventList;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.xml.sax.Attributes;

public class IceProfilingEvent {
    private double startTimeDouble = 0.0;
    private Date startTime = null;
    private double stopTimeDouble = 0.0;
    private Date stopTime = null;
    private double duration = 0.0;
    private String category = "";
    private String actionObject = "";
    private String command = "";
    private String description = "";
    private DateFormat dateFormatObj = new SimpleDateFormat();

    IceProfilingEvent(double startTimeDouble, double stopTimeDouble, String category, String actionObject, String command, String description) {
        this.startTimeDouble = startTimeDouble;
        this.startTime = new Date((long)(startTimeDouble * 1000.0));
        this.stopTimeDouble = stopTimeDouble;
        this.stopTime = new Date((long)(stopTimeDouble * 1000.0));
        this.duration = stopTimeDouble - startTimeDouble;
        this.category = category;
        this.command = command;
        this.actionObject = actionObject;
        this.description = description;
    }

    public IceProfilingEvent(Attributes eventAttributes) {
        this(Double.parseDouble(eventAttributes.getValue("starttime")), Double.parseDouble(eventAttributes.getValue("stoptime")), eventAttributes.getValue("category"), eventAttributes.getValue("command"), eventAttributes.getValue("actionobject"), eventAttributes.getValue("description"));
    }

    public String toString() {
        String retString = "ICE Profiling Event";
        retString = String.valueOf(retString) + "\nCategory: " + this.category + " ActionObject: " + this.actionObject;
        if (this.description != "") {
            retString = String.valueOf(retString) + "\n description: " + this.description;
        }
        retString = String.valueOf(retString) + "\n" + this.dateFormatObj.format(this.startTime) + " to " + this.dateFormatObj.format(this.stopTime) + " duration: " + String.valueOf(this.duration);
        return retString;
    }

    public boolean containsEvent(IceProfilingEvent ev) {
        return this.getStartTimeDouble() < ev.getStartTimeDouble() && this.getStopTimeDouble() > ev.getStopTimeDouble();
    }

    public EventList getContainedEvents(List<IceProfilingEvent> events) {
        EventList containedList = new EventList();
        for (IceProfilingEvent ev : events) {
            containedList.addEvent(ev);
        }
        return containedList;
    }

    public double getStartTimeDouble() {
        return this.startTimeDouble;
    }

    public void setStartTimeDouble(double startTimeDouble) {
        this.startTimeDouble = startTimeDouble;
        this.duration = this.stopTimeDouble - this.startTimeDouble;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public double getStopTimeDouble() {
        return this.stopTimeDouble;
    }

    public void setStopTimeDouble(double stopTimeDouble) {
        this.stopTimeDouble = stopTimeDouble;
        this.duration = this.stopTimeDouble - this.startTimeDouble;
    }

    public Date getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }

    public double getDuration() {
        return this.duration;
    }

    public String getActionObject() {
        return this.actionObject;
    }

    public void setActionObject(String actionObject) {
        this.actionObject = actionObject;
    }

    public String getDevice() {
        if (this.actionObject == null) {
            return "";
        }
        return this.actionObject;
    }

    public String getCommand() {
        if (this.command == null) {
            return "";
        }
        return this.command;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

