/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas.sampleAlignment.orientationControl;

import ice.Controller;
import ice.communication.SendQueueManager;
import ice.data.Sample;
import ice.event.SamplePropertyChangedEvent;
import ice.event.SamplePropertyChangedListener;
import ice.gui.tas.sampleAlignment.orientationControl.ApplyButton;
import ice.gui.tas.sampleAlignment.orientationControl.ResetButton;
import ice.swing.textFields.ICEDecimalFormattedTextField;
import ice.util.CommandBuilder;
import ice.util.I18N;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import ice.util.PropertiesManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class OrientationControl
extends JPanel
implements ActionListener,
SamplePropertyChangedListener {
    private static final long serialVersionUID = 1L;
    protected static Logger logger = Logger.getLogger("ice.gui.tas.bt7.sampleAlignment.ubMatrix.orientationPanel");
    protected static final String A_LABEL_KEY = "sample.a.label";
    protected static final String B_LABEL_KEY = "sample.b.label";
    protected static final String C_LABEL_KEY = "sample.c.label";
    protected static final String ALPHA_LABEL_KEY = "sample.alpha.label";
    protected static final String BETA_LABEL_KEY = "sample.beta.label";
    protected static final String GAMMA_LABEL_KEY = "sample.gamma.label";
    protected static final String ANGSTROM_LABEL_KEY = "angstrom.symbol";
    protected static final String DEGREE_LABEL_KEY = "degree.symbol";
    protected SendQueueManager sendManager = null;
    protected Sample sample = null;
    protected JLabel aLabel = null;
    protected JLabel bLabel = null;
    protected JLabel cLabel = null;
    protected JLabel alphaLabel = null;
    protected JLabel betaLabel = null;
    protected JLabel gammaLabel = null;
    protected ICEDecimalFormattedTextField aField = null;
    protected ICEDecimalFormattedTextField bField = null;
    protected ICEDecimalFormattedTextField cField = null;
    protected ICEDecimalFormattedTextField alphaField = null;
    protected ICEDecimalFormattedTextField betaField = null;
    protected ICEDecimalFormattedTextField gammaField = null;
    protected ApplyButton applyButton = null;
    protected ResetButton resetButton = null;
    private Controller controller;

    public OrientationControl() {
        this.init();
        this.buildGUI();
    }

    protected void init() {
        this.controller = Controller.getReference();
        this.sample = this.controller.getSample();
        this.sendManager = this.controller.getSendManager();
        try {
            this.sample.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("OrientationControl.init can not add listener " + e);
        }
    }

    protected void buildGUI() {
        GridBagConstraints gridBagConstraints = null;
        GridBagLayout gridBagLayout = null;
        Insets fullRowInsets = null;
        this.applyButton = new ApplyButton();
        this.resetButton = new ResetButton();
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        fullRowInsets = new Insets(0, 4, 10, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = fullRowInsets;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel dataPanel = null;
        dataPanel = this.buildDataPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        this.add((Component)dataPanel, gridBagConstraints);
        JPanel btnPanel = new JPanel();
        this.applyButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        btnPanel.setLayout(new BoxLayout(btnPanel, 2));
        btnPanel.add(Box.createHorizontalGlue());
        btnPanel.add(this.applyButton);
        btnPanel.add(this.resetButton);
        this.applyButton.addActionListener(this.resetButton);
        this.resetButton.addActionListener(this.applyButton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        this.add((Component)btnPanel, gridBagConstraints);
    }

    protected JPanel buildDataPanel() {
        String tempString = null;
        JLabel tempLabel = null;
        String angstromString = null;
        String degreeString = null;
        int fieldValueLength = 5;
        angstromString = I18N.getString(ANGSTROM_LABEL_KEY);
        degreeString = I18N.getString(DEGREE_LABEL_KEY);
        JPanel dataPanel = null;
        GridBagLayout dataPanelLayout = null;
        GridBagConstraints dataPanelConstraints = null;
        Insets zeroInset = new Insets(0, 0, 0, 0);
        Insets fiveAroundInset = new Insets(5, 5, 5, 5);
        dataPanel = new JPanel();
        dataPanelLayout = new GridBagLayout();
        dataPanel.setLayout(dataPanelLayout);
        dataPanelConstraints = new GridBagConstraints();
        dataPanelConstraints.anchor = 17;
        dataPanelConstraints.insets = fiveAroundInset;
        dataPanelConstraints.fill = 2;
        dataPanelConstraints.weightx = 1.0;
        dataPanelConstraints.gridx = 0;
        dataPanelConstraints.gridy = 0;
        tempString = I18N.getString(A_LABEL_KEY);
        this.aLabel = new JLabel(tempString);
        dataPanel.add((Component)this.aLabel, dataPanelConstraints);
        dataPanelConstraints.gridx = 1;
        dataPanelConstraints.gridy = 0;
        dataPanelConstraints.insets = zeroInset;
        this.aField = new ICEDecimalFormattedTextField(fieldValueLength, false);
        dataPanel.add((Component)this.aField, dataPanelConstraints);
        this.aField.setColumns(5);
        this.aField.setValue(this.sample.getA());
        this.aField.addKeyListener(this.applyButton);
        this.applyButton.addActionListener(this.aField);
        this.aField.addKeyListener(this.resetButton);
        this.resetButton.addActionListener(this.aField);
        dataPanelConstraints.gridx = 2;
        dataPanelConstraints.gridy = 0;
        dataPanelConstraints.insets = fiveAroundInset;
        tempLabel = new JLabel(angstromString);
        dataPanel.add((Component)tempLabel, dataPanelConstraints);
        dataPanelConstraints.gridx = 3;
        dataPanelConstraints.gridy = 0;
        dataPanelConstraints.insets = fiveAroundInset;
        tempString = I18N.getString(B_LABEL_KEY);
        this.bLabel = new JLabel(tempString);
        dataPanel.add((Component)this.bLabel, dataPanelConstraints);
        dataPanelConstraints.gridx = 4;
        dataPanelConstraints.gridy = 0;
        dataPanelConstraints.insets = zeroInset;
        this.bField = new ICEDecimalFormattedTextField(fieldValueLength, false);
        dataPanel.add((Component)this.bField, dataPanelConstraints);
        this.bField.setColumns(5);
        this.bField.setValue(this.sample.getB());
        this.bField.addKeyListener(this.applyButton);
        this.applyButton.addActionListener(this.bField);
        this.bField.addKeyListener(this.resetButton);
        this.resetButton.addActionListener(this.bField);
        dataPanelConstraints.gridx = 5;
        dataPanelConstraints.gridy = 0;
        dataPanelConstraints.insets = fiveAroundInset;
        tempLabel = new JLabel(angstromString);
        dataPanel.add((Component)tempLabel, dataPanelConstraints);
        dataPanelConstraints.gridx = 6;
        dataPanelConstraints.gridy = 0;
        dataPanelConstraints.insets = fiveAroundInset;
        tempString = I18N.getString(C_LABEL_KEY);
        this.cLabel = new JLabel(tempString);
        dataPanel.add((Component)this.cLabel, dataPanelConstraints);
        dataPanelConstraints.gridx = 7;
        dataPanelConstraints.gridy = 0;
        dataPanelConstraints.insets = zeroInset;
        this.cField = new ICEDecimalFormattedTextField(fieldValueLength, false);
        dataPanel.add((Component)this.cField, dataPanelConstraints);
        this.cField.setColumns(5);
        this.cField.setValue(this.sample.getC());
        this.cField.addKeyListener(this.applyButton);
        this.applyButton.addActionListener(this.cField);
        this.cField.addKeyListener(this.resetButton);
        this.resetButton.addActionListener(this.cField);
        dataPanelConstraints.gridx = 8;
        dataPanelConstraints.gridy = 0;
        dataPanelConstraints.insets = fiveAroundInset;
        tempLabel = new JLabel(angstromString);
        dataPanel.add((Component)tempLabel, dataPanelConstraints);
        dataPanelConstraints.gridx = 0;
        dataPanelConstraints.gridy = 1;
        dataPanelConstraints.insets = fiveAroundInset;
        tempString = I18N.getString(ALPHA_LABEL_KEY);
        this.alphaLabel = new JLabel(tempString);
        dataPanel.add((Component)this.alphaLabel, dataPanelConstraints);
        dataPanelConstraints.gridx = 1;
        dataPanelConstraints.gridy = 1;
        dataPanelConstraints.insets = zeroInset;
        this.alphaField = new ICEDecimalFormattedTextField(3, false);
        dataPanel.add((Component)this.alphaField, dataPanelConstraints);
        this.alphaField.setValue(this.sample.getAlpha());
        this.alphaField.addKeyListener(this.applyButton);
        this.applyButton.addActionListener(this.alphaField);
        this.alphaField.addKeyListener(this.resetButton);
        this.resetButton.addActionListener(this.alphaField);
        dataPanelConstraints.gridx = 2;
        dataPanelConstraints.gridy = 1;
        dataPanelConstraints.insets = fiveAroundInset;
        tempLabel = new JLabel(degreeString);
        dataPanel.add((Component)tempLabel, dataPanelConstraints);
        dataPanelConstraints.gridx = 3;
        dataPanelConstraints.gridy = 1;
        dataPanelConstraints.insets = fiveAroundInset;
        tempString = I18N.getString(BETA_LABEL_KEY);
        this.betaLabel = new JLabel(tempString);
        dataPanel.add((Component)this.betaLabel, dataPanelConstraints);
        dataPanelConstraints.gridx = 4;
        dataPanelConstraints.gridy = 1;
        dataPanelConstraints.insets = zeroInset;
        this.betaField = new ICEDecimalFormattedTextField(3, false);
        dataPanel.add((Component)this.betaField, dataPanelConstraints);
        this.betaField.setValue(this.sample.getBeta());
        this.betaField.addKeyListener(this.applyButton);
        this.applyButton.addActionListener(this.betaField);
        this.betaField.addKeyListener(this.resetButton);
        this.resetButton.addActionListener(this.betaField);
        dataPanelConstraints.gridx = 5;
        dataPanelConstraints.gridy = 1;
        dataPanelConstraints.insets = fiveAroundInset;
        tempLabel = new JLabel(degreeString);
        dataPanel.add((Component)tempLabel, dataPanelConstraints);
        dataPanelConstraints.gridx = 6;
        dataPanelConstraints.gridy = 1;
        dataPanelConstraints.insets = fiveAroundInset;
        tempString = I18N.getString(GAMMA_LABEL_KEY);
        this.gammaLabel = new JLabel(tempString);
        dataPanel.add((Component)this.gammaLabel, dataPanelConstraints);
        dataPanelConstraints.gridx = 7;
        dataPanelConstraints.gridy = 1;
        dataPanelConstraints.insets = zeroInset;
        this.gammaField = new ICEDecimalFormattedTextField(3, false);
        dataPanel.add((Component)this.gammaField, dataPanelConstraints);
        this.gammaField.setValue(this.sample.getGamma());
        this.gammaField.addKeyListener(this.applyButton);
        this.applyButton.addActionListener(this.gammaField);
        this.gammaField.addKeyListener(this.resetButton);
        this.resetButton.addActionListener(this.gammaField);
        dataPanelConstraints.gridx = 8;
        dataPanelConstraints.gridy = 1;
        dataPanelConstraints.insets = fiveAroundInset;
        tempLabel = new JLabel(degreeString);
        dataPanel.add((Component)tempLabel, dataPanelConstraints);
        return dataPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = null;
        actionCommand = e.getActionCommand();
        if (actionCommand.compareTo(ApplyButton.APPLY_MESSAGE) == 0) {
            this.applyPreformAction(e);
        } else if (actionCommand.compareTo(ResetButton.RESET_MESSAGE) == 0) {
            this.resetSampleParametersPreformAction(e);
        }
    }

    public void applyPreformAction(ActionEvent e) {
        String command = null;
        String[] args = null;
        args = new String[]{this.aField.getText(), this.bField.getText(), this.cField.getText(), this.alphaField.getText(), this.betaField.getText(), this.gammaField.getText()};
        command = CommandBuilder.build(PropertiesManager.Properties.SAMPLE_SET_LATTICE_CMD, args);
        this.sendManager.addMessage(command);
    }

    public void resetSampleParametersPreformAction(ActionEvent ae) {
        this.aField.setValue(this.sample.getA());
        this.bField.setValue(this.sample.getB());
        this.cField.setValue(this.sample.getC());
        this.alphaField.setValue(this.sample.getAlpha());
        this.betaField.setValue(this.sample.getBeta());
        this.gammaField.setValue(this.sample.getGamma());
    }

    @Override
    public void actionPerformed(SamplePropertyChangedEvent pce) {
        Object source = pce.getSource();
        String propertyName = pce.getPropertyName();
        Object newValue = pce.getNewValue();
        SwingUtilities.invokeLater(new UpdateSampleFieldRunnable(propertyName, newValue));
    }

    protected class UpdateSampleFieldRunnable
    implements Runnable {
        protected String propertyName;
        protected Object newValue;

        public UpdateSampleFieldRunnable(String propertyName, Object newValue) {
            this.propertyName = propertyName;
            this.newValue = newValue;
        }

        @Override
        public void run() {
            if (Sample.aFieldName.equals(this.propertyName)) {
                OrientationControl.this.aField.setValue(this.newValue);
            } else if (Sample.bFieldName.equals(this.propertyName)) {
                OrientationControl.this.bField.setValue(this.newValue);
            } else if (Sample.cFieldName.equals(this.propertyName)) {
                OrientationControl.this.cField.setValue(this.newValue);
            } else if (Sample.alphaFieldName.equals(this.propertyName)) {
                OrientationControl.this.alphaField.setValue(this.newValue);
            } else if (Sample.betaFieldName.equals(this.propertyName)) {
                OrientationControl.this.betaField.setValue(this.newValue);
            } else if (Sample.gammaFieldName.equals(this.propertyName)) {
                OrientationControl.this.gammaField.setValue(this.newValue);
            }
        }
    }
}

