/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas.bt7.config;

import ice.communication.SendQueueManager;
import ice.data.Sample;
import ice.gui.core.config.BaseConfigPanel;
import ice.gui.tas.bt7.config.ExpConfigWindow;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class SampleDetailsPanel
extends BaseConfigPanel
implements ChangeListener,
DocumentListener {
    private static Logger logger = Logger.getLogger("WidgetLogger.ConfigLogger");
    private Sample sample;
    private JTextArea sampleDescTextArea;
    private JFormattedTextField aField;
    private JFormattedTextField bField;
    private JFormattedTextField cField;
    private JFormattedTextField alphaField;
    private JFormattedTextField betaField;
    private JFormattedTextField gammaField;
    private JFormattedTextField h1Field;
    private JFormattedTextField k1Field;
    private JFormattedTextField l1Field;
    private JFormattedTextField h2Field;
    private JFormattedTextField k2Field;
    private JFormattedTextField l2Field;

    public SampleDetailsPanel(ExpConfigWindow realParent, Sample sample) {
        super(realParent);
        this.sample = sample;
        this.sampleDescTextArea = new JTextArea(10, 10);
        this.sampleDescTextArea.setText(String.valueOf(sample.getDescription()));
        this.aField = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.aField.setFocusLostBehavior(1);
        this.bField = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.cField = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.alphaField = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.betaField = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.gammaField = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.h1Field = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.k1Field = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.l1Field = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.h2Field = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.k2Field = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.l2Field = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.buildGUI();
        this.reload();
        this.sampleDescTextArea.getDocument().addDocumentListener(this);
        this.aField.getDocument().addDocumentListener(this);
        this.bField.getDocument().addDocumentListener(this);
        this.cField.getDocument().addDocumentListener(this);
        this.alphaField.getDocument().addDocumentListener(this);
        this.betaField.getDocument().addDocumentListener(this);
        this.gammaField.getDocument().addDocumentListener(this);
        this.h1Field.getDocument().addDocumentListener(this);
        this.k1Field.getDocument().addDocumentListener(this);
        this.l1Field.getDocument().addDocumentListener(this);
        this.h2Field.getDocument().addDocumentListener(this);
        this.k2Field.getDocument().addDocumentListener(this);
        this.l2Field.getDocument().addDocumentListener(this);
    }

    public void buildGUI() {
        this.setName("Sample Details");
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        JLabel sampleDescLabel = this.createLabel("Sample Description:");
        JPanel latticePanel = this.createLatticePanel();
        JPanel hklPanel = this.createHKLPanel();
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        this.add((Component)sampleDescLabel, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        ++constraints.gridx;
        this.add((Component)this.sampleDescTextArea, constraints);
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        --constraints.gridx;
        ++constraints.gridy;
        this.add((Component)latticePanel, constraints);
        ++constraints.gridy;
        this.add((Component)hklPanel, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.add((Component)new JLabel(""), constraints);
    }

    private JPanel createLatticePanel() {
        JLabel abcLabel = this.createLabel("a, b, c:");
        JLabel greekLabel = this.createLabel(String.valueOf(new Character('\u03b1').toString()) + ", " + new Character('\u03b2').toString() + ", " + new Character('\u03b3').toString() + ":");
        JPanel latticePanel = new JPanel(new GridBagLayout());
        latticePanel.setBorder(BorderFactory.createTitledBorder("Lattice Constants"));
        GridBagConstraints latticeConstraints = new GridBagConstraints();
        latticeConstraints.gridx = 0;
        latticeConstraints.gridy = 0;
        latticeConstraints.fill = 2;
        latticeConstraints.insets = new Insets(5, 5, 5, 5);
        latticeConstraints.weightx = 0.0;
        latticePanel.add((Component)abcLabel, latticeConstraints);
        ++latticeConstraints.gridy;
        latticePanel.add((Component)greekLabel, latticeConstraints);
        --latticeConstraints.gridy;
        latticeConstraints.weightx = 1.0;
        ++latticeConstraints.gridx;
        latticePanel.add((Component)this.aField, latticeConstraints);
        ++latticeConstraints.gridx;
        latticePanel.add((Component)this.bField, latticeConstraints);
        ++latticeConstraints.gridx;
        latticePanel.add((Component)this.cField, latticeConstraints);
        latticeConstraints.gridx -= 2;
        ++latticeConstraints.gridy;
        latticePanel.add((Component)this.alphaField, latticeConstraints);
        ++latticeConstraints.gridx;
        latticePanel.add((Component)this.betaField, latticeConstraints);
        ++latticeConstraints.gridx;
        latticePanel.add((Component)this.gammaField, latticeConstraints);
        return latticePanel;
    }

    private JPanel createHKLPanel() {
        JLabel hkl1Label = this.createLabel("h1, k1, l1");
        JLabel hkl2Label = this.createLabel("h2, k2, l2");
        JPanel hklPanel = new JPanel(new GridBagLayout());
        hklPanel.setBorder(BorderFactory.createTitledBorder("Crystal Indices"));
        GridBagConstraints hklConstraints = new GridBagConstraints();
        hklConstraints.gridx = 0;
        hklConstraints.gridy = 0;
        hklConstraints.fill = 2;
        hklConstraints.insets = new Insets(5, 5, 5, 5);
        hklConstraints.weightx = 0.0;
        hklPanel.add((Component)hkl1Label, hklConstraints);
        ++hklConstraints.gridy;
        hklPanel.add((Component)hkl2Label, hklConstraints);
        --hklConstraints.gridy;
        hklConstraints.weightx = 1.0;
        ++hklConstraints.gridx;
        hklPanel.add((Component)this.h1Field, hklConstraints);
        ++hklConstraints.gridx;
        hklPanel.add((Component)this.k1Field, hklConstraints);
        ++hklConstraints.gridx;
        hklPanel.add((Component)this.l1Field, hklConstraints);
        hklConstraints.gridx -= 2;
        ++hklConstraints.gridy;
        hklPanel.add((Component)this.h2Field, hklConstraints);
        ++hklConstraints.gridx;
        hklPanel.add((Component)this.k2Field, hklConstraints);
        ++hklConstraints.gridx;
        hklPanel.add((Component)this.l2Field, hklConstraints);
        return hklPanel;
    }

    @Override
    protected void reload() {
        logger.debug("sample state changed.  Updating...");
        this.sampleDescTextArea.setText(this.sample.getDescription());
        try {
            this.aField.setValue(this.sample.getA());
        }
        catch (NumberFormatException nfe) {
            logger.debug("NumberFormatException.  Ignoring and moving on.", nfe);
        }
        try {
            this.bField.setValue(this.sample.getB());
        }
        catch (NumberFormatException nfe) {
            logger.debug("NumberFormatException.  Ignoring and moving on.", nfe);
        }
        try {
            this.cField.setValue(this.sample.getC());
        }
        catch (NumberFormatException nfe) {
            logger.debug("NumberFormatException.  Ignoring and moving on.", nfe);
        }
        try {
            this.alphaField.setValue(this.sample.getAlpha());
        }
        catch (NumberFormatException nfe) {
            logger.debug("NumberFormatException.  Ignoring and moving on.", nfe);
        }
        try {
            this.betaField.setValue(this.sample.getBeta());
        }
        catch (NumberFormatException nfe) {
            logger.debug("NumberFormatException.  Ignoring and moving on.", nfe);
        }
        try {
            this.gammaField.setValue(this.sample.getGamma());
        }
        catch (NumberFormatException nfe) {
            logger.debug("NumberFormatException.  Ignoring and moving on.", nfe);
        }
        try {
            this.h1Field.setValue(this.sample.getH1());
        }
        catch (NumberFormatException nfe) {
            logger.debug("NumberFormatException.  Ignoring and moving on.", nfe);
        }
        try {
            this.k1Field.setValue(this.sample.getK1());
        }
        catch (NumberFormatException nfe) {
            logger.debug("NumberFormatException.  Ignoring and moving on.", nfe);
        }
        try {
            this.l1Field.setValue(this.sample.getL1());
        }
        catch (NumberFormatException nfe) {
            logger.debug("NumberFormatException.  Ignoring and moving on.", nfe);
        }
        try {
            this.h2Field.setValue(this.sample.getH2());
        }
        catch (NumberFormatException nfe) {
            logger.debug("NumberFormatException.  Ignoring and moving on.", nfe);
        }
        try {
            this.k2Field.setValue(this.sample.getK2());
        }
        catch (NumberFormatException nfe) {
            logger.debug("NumberFormatException.  Ignoring and moving on.", nfe);
        }
        try {
            this.l2Field.setValue(this.sample.getL2());
        }
        catch (NumberFormatException nfe) {
            logger.debug("NumberFormatException.  Ignoring and moving on.", nfe);
        }
        this.setModified(false);
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() != this.sample) {
            return;
        }
        this.processIncomingChanges();
    }

    @Override
    protected boolean isCompleted() {
        return this.aField.getText().length() != 0 && this.bField.getText().length() != 0 && this.cField.getText().length() != 0 && this.alphaField.getText().length() != 0 && this.betaField.getText().length() != 0 && this.gammaField.getText().length() != 0 && this.h1Field.getText().length() != 0 && this.k1Field.getText().length() != 0 && this.l1Field.getText().length() != 0 && this.h2Field.getText().length() != 0 && this.k2Field.getText().length() != 0 && this.l2Field.getText().length() != 0;
    }

    @Override
    protected String getCompletionErrorString() {
        String part1 = "";
        String part2 = "";
        String part3 = "";
        if (this.aField.getText().length() == 0 || this.bField.getText().length() != 0 || this.cField.getText().length() != 0 || this.alphaField.getText().length() != 0 || this.betaField.getText().length() != 0 || this.gammaField.getText().length() != 0) {
            part1 = "lattice parameters";
        }
        if (this.h1Field.getText().length() != 0 && this.k1Field.getText().length() != 0 && this.l1Field.getText().length() != 0 && this.h2Field.getText().length() != 0 && this.k2Field.getText().length() != 0 && this.l2Field.getText().length() != 0) {
            part3 = "miller indices";
        }
        if (part1.length() != 0 && part2.length() != 0) {
            part2 = " and ";
        }
        return "All fields for " + part1 + part2 + part3 + " must be filled in.";
    }

    @Override
    protected boolean commitChanges(SendQueueManager sendManager) {
        return true;
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.setModified(true);
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.setModified(true);
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.setModified(true);
    }
}

