/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas.bt7.config;

import ice.Controller;
import ice.communication.SendQueueManager;
import ice.data.Experiment;
import ice.event.communication.ExpChangeListener;
import ice.gui.core.config.BaseConfigPanel;
import ice.gui.tas.bt7.config.ExpConfigWindow;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class ExpDetailsPanel
extends BaseConfigPanel
implements ChangeListener,
DocumentListener,
ActionListener {
    private static Logger logger = Logger.getLogger("WidgetLogger.ConfigLogger");
    private static String naString = "N/A";
    private Experiment experiment;
    private JLabel expIDValueLabel;
    private JTextField expNameField;
    private JTextField participantsField;
    private JTextArea expDetailsTextArea;
    private JTextArea commentsTextArea;
    private JLabel dataDirValueLabel;
    private ArrayList<ExpChangeListener> listeners;
    private HashMap<Object, Boolean> fieldModified;
    private JButton applyBtn;
    private SendQueueManager sendManager;
    private Controller controller = Controller.getReference();

    public ExpDetailsPanel(ExpConfigWindow realParent) {
        super(realParent);
        this.experiment = this.controller.getExperiment();
        this.sendManager = this.controller.getSendManager();
        this.listeners = new ArrayList();
        this.fieldModified = new HashMap(20);
        this.expNameField = new JTextField();
        if (this.experiment.getName() != null) {
            this.expNameField.setText(this.experiment.getName());
        }
        this.participantsField = new JTextField();
        if (this.experiment.getParticipants() != null) {
            this.participantsField.setText(this.experiment.getParticipants());
        }
        this.expDetailsTextArea = new JTextArea(4, 10);
        if (this.experiment.getDetails() != null) {
            this.expDetailsTextArea.setText(this.experiment.getDetails());
        }
        this.commentsTextArea = new JTextArea(4, 10);
        if (this.experiment.getComments() != null) {
            this.commentsTextArea.setText(this.experiment.getComments());
        }
        this.expIDValueLabel = this.experiment.getID() == null ? this.createLabel(naString) : this.createLabel(this.experiment.getID());
        this.dataDirValueLabel = this.createLabel(naString);
        this.buildGUI();
        this.reload();
        this.expNameField.getDocument().addDocumentListener(this);
        this.participantsField.getDocument().addDocumentListener(this);
        this.expDetailsTextArea.getDocument().addDocumentListener(this);
        this.commentsTextArea.getDocument().addDocumentListener(this);
        this.fieldModified.put(this.expNameField.getDocument(), false);
        this.fieldModified.put(this.participantsField.getDocument(), false);
        this.fieldModified.put(this.expDetailsTextArea.getDocument(), false);
        this.fieldModified.put(this.commentsTextArea.getDocument(), false);
    }

    public void buildGUI() {
        this.setName("Experiment Details");
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        this.applyBtn = new JButton(new ApplyAction());
        this.applyBtn.setEnabled(false);
        JLabel expIDLabel = this.createLabel("Experiment ID:");
        JLabel expNameLabel = this.createLabel("Experiment Name:", true);
        JLabel participantsLabel = this.createLabel("Participants", true);
        JLabel expDetailsLabel = this.createLabel("Experiment Details:", true);
        JLabel commentsLabel = this.createLabel("Comments:");
        JLabel dataDirLabel = this.createLabel("Data Directory:");
        constraints.weightx = 0.0;
        this.add((Component)expIDLabel, constraints);
        ++constraints.gridy;
        this.add((Component)expNameLabel, constraints);
        ++constraints.gridy;
        this.add((Component)participantsLabel, constraints);
        ++constraints.gridy;
        this.add((Component)expDetailsLabel, constraints);
        ++constraints.gridy;
        this.add((Component)commentsLabel, constraints);
        ++constraints.gridy;
        this.add((Component)dataDirLabel, constraints);
        constraints.fill = 10;
        ++constraints.gridy;
        constraints.gridwidth = 2;
        this.add((Component)this.applyBtn, constraints);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        ++constraints.gridx;
        constraints.weighty = 0.0;
        this.add((Component)this.expIDValueLabel, constraints);
        ++constraints.gridy;
        this.add((Component)this.expNameField, constraints);
        ++constraints.gridy;
        this.add((Component)this.participantsField, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.add((Component)new JScrollPane(this.expDetailsTextArea, 20, 31), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.add((Component)new JScrollPane(this.commentsTextArea, 20, 31), constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        this.add((Component)this.dataDirValueLabel, constraints);
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() != this.experiment) {
            return;
        }
        this.processIncomingChanges();
    }

    @Override
    public void reload() {
        if (this.experiment.getName() != null) {
            this.expNameField.setText(this.experiment.getName());
        }
        if (this.experiment.getParticipants() != null) {
            this.participantsField.setText(this.experiment.getParticipants());
        }
        if (this.experiment.getDetails() != null) {
            this.expDetailsTextArea.setText(this.experiment.getDetails());
        }
        if (this.experiment.getComments() != null) {
            this.commentsTextArea.setText(this.experiment.getComments());
        }
        if (this.experiment.getID() != null) {
            this.expIDValueLabel.setText(this.experiment.getID());
        } else {
            this.expIDValueLabel.setText(naString);
        }
        this.fieldModified.put(this.expNameField.getDocument(), false);
        this.fieldModified.put(this.participantsField.getDocument(), false);
        this.fieldModified.put(this.expDetailsTextArea.getDocument(), false);
        this.fieldModified.put(this.commentsTextArea.getDocument(), false);
        this.setModified(false);
        this.applyBtn.setEnabled(false);
    }

    @Override
    protected synchronized boolean isCompleted() {
        return !this.expNameField.getText().equals("") && !this.participantsField.getText().equals("") && !this.expDetailsTextArea.getText().equals("");
    }

    @Override
    protected synchronized String getCompletionErrorString() {
        if (this.expNameField.getText().equals("")) {
            return "The experiment name cannot be left blank.";
        }
        if (this.participantsField.getText().equals("")) {
            return "The participants field cannot be left blank.";
        }
        if (this.expDetailsTextArea.getText().equals("")) {
            return "The experiment details cannot be left blank.";
        }
        return "";
    }

    @Override
    protected synchronized boolean commitChanges(SendQueueManager sendManager) {
        if (this.fieldModified.get(this.expNameField.getDocument()).booleanValue()) {
            sendManager.addMessage("expt SetName \"" + this.expNameField.getText() + "\"");
        }
        if (this.fieldModified.get(this.participantsField.getDocument()).booleanValue()) {
            sendManager.addMessage("expt SetParticipants \"" + this.participantsField.getText() + "\"");
        }
        if (this.fieldModified.get(this.expDetailsTextArea.getDocument()).booleanValue()) {
            sendManager.addMessage("expt SetDetails \"" + this.expDetailsTextArea.getText() + "\"");
        }
        if (this.fieldModified.get(this.commentsTextArea.getDocument()).booleanValue()) {
            sendManager.addMessage("expt SetComment \"" + this.commentsTextArea.getText() + "\"");
        }
        return true;
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        if (this.fieldModified.containsKey(de.getDocument())) {
            this.fieldModified.put(de.getDocument(), true);
        }
        this.setModified(true);
        this.applyBtn.setEnabled(true);
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        if (this.fieldModified.containsKey(de.getDocument())) {
            this.fieldModified.put(de.getDocument(), true);
        }
        this.setModified(true);
        this.applyBtn.setEnabled(true);
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        if (this.fieldModified.containsKey(de.getDocument())) {
            this.fieldModified.put(de.getDocument(), true);
        }
        this.setModified(true);
        this.applyBtn.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction() {
            this.putValue("Name", "Apply");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (ExpDetailsPanel.this.getModified()) {
                ExpDetailsPanel.this.setCommitting(true);
                ExpDetailsPanel.this.setModified(false);
                ExpDetailsPanel.this.applyBtn.setEnabled(false);
                if (!ExpDetailsPanel.this.commitChanges(ExpDetailsPanel.this.sendManager)) {
                    ExpDetailsPanel.this.setCommitting(false);
                }
            }
        }
    }
}

