/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels.autodata;

import ice.ClientAPI;
import ice.Controller;
import ice.Global;
import ice.commands.DevicePositionsCommand;
import ice.data.InstalledDevice;
import ice.data.InstalledEnvDevice;
import ice.data.InstalledTempDevice;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.NumberOutOfRangeListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.FilePrefixSansScanDeviceControlPanel;
import ice.gui.panel.sans.controls.HelpPanel;
import ice.gui.panel.sans.controls.SampleLabelSansScanDeviceControlPanel;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.SansScanDeviceComboBoxControlPanel;
import ice.gui.panel.sans.controls.SansScanDeviceControlPanel;
import ice.gui.panel.sans.controls.SansScanDeviceDoubleControlPanel;
import ice.gui.panel.sans.controls.SansScanDeviceDoubleNoEmptyControlPanel;
import ice.gui.panel.sans.controls.SansScanDeviceGuideControl;
import ice.gui.panel.sans.controls.SansScanTempDeviceControlNonEmptyPanel;
import ice.gui.panel.sans.controls.buttons.PropertiesButtonControlPanel;
import ice.gui.panel.sans.controls.buttons.RunPropertiesButtonControlPanel;
import ice.gui.panel.sans.data.SansScan;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.subpanels.autodata.SansTableModel;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class RunPropertiesPanel
extends SansIcePanel
implements DeviceListListener,
NumberOutOfRangeListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("ErrorLogger.RunProperties");
    private static final String title = "RUN PROPERTIES";
    protected ArrayList<SansDeviceControlPanel> controls;
    protected PropertiesButtonControlPanel buttonPanel;
    protected ArrayList<InstalledDevice> allDevices;
    private Controller controller;
    protected JLabel runBuffer;
    private SansScan sansScan;
    protected InstalledTempDevice currentTempDevice;
    protected InstalledDevice currentMagDevice;
    protected ArrayList<SansScanDeviceDoubleControlPanel> errorControls;
    protected String sansStop = "";
    protected SampleLabelSansScanDeviceControlPanel sampleLabel;
    protected FilePrefixSansScanDeviceControlPanel filePrefix;
    protected SansScanDeviceDoubleControlPanel sampleThick;
    protected SansScanDeviceDoubleControlPanel sampleTrans;
    protected SansScanDeviceDoubleControlPanel samplePos;
    protected SansScanDeviceDoubleControlPanel huberPos;
    protected SansScanDeviceDoubleControlPanel huberRot;
    protected SansScanDeviceDoubleControlPanel sampleRot;
    protected SansScanDeviceDoubleControlPanel countIntTime;
    protected SansScanDeviceDoubleControlPanel countIntvls;
    protected SansScanDeviceDoubleControlPanel tempSetPt;
    protected SansScanDeviceDoubleControlPanel tempSetPtErr;
    protected SansScanDeviceDoubleControlPanel tempHoldTime;
    protected SansScanDeviceDoubleControlPanel tempTimeOut;
    protected SansScanDeviceDoubleControlPanel magnetCurrent;
    protected SansScanDeviceDoubleControlPanel magneticField;
    protected SansScanDeviceDoubleControlPanel rheoPulses;
    protected SansScanDeviceDoubleControlPanel waveLength;
    protected SansScanDeviceComboBoxControlPanel atten;
    protected SansScanDeviceDoubleControlPanel waveLSpread;
    protected SansScanDeviceComboBoxControlPanel bmStp;
    protected SansScanDeviceDoubleControlPanel bmStpX;
    protected SansScanDeviceDoubleControlPanel bmStpY;
    protected SansScanDeviceDoubleControlPanel detDist;
    protected SansScanDeviceDoubleControlPanel detOff;
    protected SansScanDeviceDoubleControlPanel bmCtrX;
    protected SansScanDeviceDoubleControlPanel bmCtrY;
    protected SansScanDeviceGuideControl guides;
    protected String instrumentName;
    protected static final String ng3 = "ng3";
    protected SansScanDeviceComboBoxControlPanel flipper;
    protected SansScanDeviceDoubleControlPanel flipperHorizCurrent;
    protected SansScanDeviceDoubleControlPanel flipperVertCurrent;

    public RunPropertiesPanel() throws IcePanelException {
        super(title, title);
    }

    public RunPropertiesPanel(String title) throws IcePanelException {
        super(title, title);
    }

    void populateFields(SansScan scan) {
        this.clearPanel();
        this.sansScan = scan;
        this.sansStop = scan.getScanValue("sansstop");
        int sansStopValue = Integer.valueOf(this.sansStop);
        if (sansStopValue == 1) {
            this.sampleLabel.setControlBackground(new Color(227, 161, 161));
        } else {
            this.sampleLabel.setControlBackground(Color.WHITE);
        }
        this.runBuffer.setText("Run Buffer " + scan.getName());
        this.sampleLabel.setCurrentValue(scan.getComments());
        this.filePrefix.setCurrentValue(scan.getPrefix());
        this.sampleLabel.setScanValue(scan.getComments());
        this.filePrefix.setScanValue(scan.getPrefix());
        this.countIntTime.setCurrentValue(String.valueOf(scan.getBaseCount()));
        this.countIntvls.setCurrentValue(String.valueOf(scan.getPrefactor()));
        this.countIntTime.setScanValue(String.valueOf(scan.getBaseCount()));
        this.countIntvls.setScanValue(String.valueOf(scan.getPrefactor()));
        this.magnetCurrent.setCurrentValue("");
        this.magnetCurrent.setScanValue("");
        this.magneticField.setCurrentValue("");
        this.magneticField.setScanValue("");
        HashMap<String, String> angleValues = scan.getAngleValues();
        this.setCollimationControls(scan);
        for (SansDeviceControlPanel control : this.controls) {
            String controlName = control.getDeviceName();
            String scanName = ((SansScanDeviceControlPanel)control).getScanName();
            InstalledDevice device = this.controller.getFirstDevice(controlName);
            if (scan.containsAngle(scanName)) {
                String scanValue = scan.getAngleValue(scanName);
                if (scanValue == null) {
                    scanValue = "";
                }
                if (device == null) {
                    control.setCurrentValue(scanValue);
                    control.setScanValue(scanValue);
                    control.setDisabled(true);
                    continue;
                }
                if (!device.isFixed()) {
                    control.setCurrentValue(scanValue);
                    control.setScanValue(scanValue);
                    continue;
                }
                String currentValue = device.getCurrValue();
                control.setCurrentValue(currentValue);
                control.setScanValue(scanValue);
                continue;
            }
            if (!scan.containsScan(scanName) || !controlName.equalsIgnoreCase(this.rheoPulses.getDeviceName())) continue;
            if (device == null) {
                this.rheoPulses.setDisabled(true);
                this.rheoPulses.setSaveToScan(false);
                continue;
            }
            if (!device.isFixed()) {
                this.rheoPulses.setCurrentValue(scan.getScanValue("SANSRHEOPULSES"));
                this.rheoPulses.setScanValue(scan.getScanValue("SANSRHEOPULSES"));
                continue;
            }
            this.rheoPulses.setCurrentValue(device.getCurrValue());
            this.rheoPulses.setScanValue(scan.getScanValue("SANSRHEOPULSES"));
        }
        InstalledDevice device = this.controller.getFirstDevice("Temp");
        Double timeOut = null;
        Double error = null;
        Double scanTimeOut = scan.gettempMaxWaitTime();
        Double scanTolerance = scan.gettempTolerance();
        if (device != null && device.isFixed()) {
            timeOut = ((InstalledTempDevice)device).getTimeout();
            error = device.getTolerance();
        } else {
            timeOut = scanTimeOut;
            error = scanTolerance;
        }
        if (error != null) {
            this.tempSetPtErr.setCurrentValue(error.toString());
            this.tempSetPtErr.setScanValue(scanTolerance.toString());
        }
        if (timeOut != null) {
            timeOut = timeOut / 60.0;
            scanTimeOut = scanTimeOut / 60.0;
            this.tempTimeOut.setCurrentValue(timeOut.toString());
            this.tempTimeOut.setScanValue(scanTimeOut.toString());
            String holdTime = String.valueOf(timeOut / 10.0);
            String scanHoldTime = String.valueOf(scanTimeOut / 10.0);
            this.tempHoldTime.setCurrentValue(holdTime);
            this.tempHoldTime.setScanValue(scanHoldTime);
        }
        String spread = SansTableModel.getDeviceCurrentValue("WavelengthSpread");
        this.waveLSpread.setCurrentValue(spread);
        HashMap<String, String> sampleValues = scan.getSampleValues();
        Set<String> sampleNames = sampleValues.keySet();
        block1: for (String name : sampleNames) {
            for (SansDeviceControlPanel control : this.controls) {
                if (!name.equalsIgnoreCase(control.getDeviceName())) continue;
                String value = scan.getSampleValue(name);
                control.setCurrentValue(value);
                control.setScanValue(value);
                continue block1;
            }
        }
        this.setLastMagnetCurrent();
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(800, 800));
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        this.setBorder(new LineBorder(Color.black));
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        mainBagConstraints.gridwidth = 3;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.anchor = 17;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.insets = new Insets(0, 0, 0, 10);
        mainBagConstraints.anchor = 13;
        mainBagConstraints.gridx = 2;
        mainBagConstraints.gridy = y++;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.runBuffer, mainBagConstraints);
        mainBagConstraints.insets = new Insets(0, 0, 0, 0);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        mainBagConstraints.gridwidth = 3;
        mainBagConstraints.weightx = 1.0;
        this.add((Component)this.sampleLabel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y;
        mainBagConstraints.gridwidth = 1;
        mainBagConstraints.weightx = 0.0;
        this.add((Component)this.filePrefix, mainBagConstraints);
        mainBagConstraints.gridx = 1;
        mainBagConstraints.gridy = y;
        this.add((Component)this.countIntTime, mainBagConstraints);
        mainBagConstraints.gridx = 2;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.countIntvls, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.sampleThick, mainBagConstraints);
        mainBagConstraints.gridx = 1;
        mainBagConstraints.gridy = y++;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.sampleTrans, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.samplePos, mainBagConstraints);
        mainBagConstraints.gridx = 1;
        mainBagConstraints.gridy = y++;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.sampleRot, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.huberPos, mainBagConstraints);
        mainBagConstraints.gridx = 1;
        mainBagConstraints.gridy = y++;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.huberRot, mainBagConstraints);
        mainBagConstraints.insets = new Insets(10, 0, 0, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.tempSetPt, mainBagConstraints);
        mainBagConstraints.gridx = 1;
        mainBagConstraints.gridy = y;
        this.add((Component)this.tempSetPtErr, mainBagConstraints);
        mainBagConstraints.gridx = 2;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.tempHoldTime, mainBagConstraints);
        mainBagConstraints.insets = new Insets(0, 0, 0, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.magneticField, mainBagConstraints);
        mainBagConstraints.gridx = 1;
        mainBagConstraints.gridy = y;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.magnetCurrent, mainBagConstraints);
        mainBagConstraints.gridx = 2;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.tempTimeOut, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.rheoPulses, mainBagConstraints);
        mainBagConstraints.insets = new Insets(10, 0, 0, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.waveLength, mainBagConstraints);
        mainBagConstraints.gridx = 1;
        mainBagConstraints.gridy = y;
        this.add((Component)this.waveLSpread, mainBagConstraints);
        mainBagConstraints.gridx = 2;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.atten, mainBagConstraints);
        mainBagConstraints.insets = new Insets(0, 0, 0, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y;
        this.add((Component)this.guides.getCollimationControl(), mainBagConstraints);
        mainBagConstraints.gridx = 1;
        mainBagConstraints.gridy = y;
        this.add((Component)this.guides.getApertureControl(), mainBagConstraints);
        mainBagConstraints.gridx = 2;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.guides.getLensesControl(), mainBagConstraints);
        if (this.instrumentName.equalsIgnoreCase(ng3)) {
            mainBagConstraints.insets = new Insets(0, 0, 0, 0);
            mainBagConstraints.gridx = 0;
            mainBagConstraints.gridy = y;
            this.add((Component)this.flipper, mainBagConstraints);
            mainBagConstraints.gridx = 1;
            mainBagConstraints.gridy = y;
            this.add((Component)this.flipperHorizCurrent, mainBagConstraints);
            mainBagConstraints.gridx = 2;
            mainBagConstraints.gridy = y++;
            this.add((Component)this.flipperVertCurrent, mainBagConstraints);
        }
        mainBagConstraints.gridx = 1;
        mainBagConstraints.gridy = y;
        this.add((Component)this.detDist, mainBagConstraints);
        mainBagConstraints.gridx = 2;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.detOff, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.bmStp, mainBagConstraints);
        mainBagConstraints.gridx = 1;
        mainBagConstraints.gridy = y;
        this.add((Component)this.bmStpX, mainBagConstraints);
        mainBagConstraints.gridx = 2;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.bmStpY, mainBagConstraints);
        mainBagConstraints.gridx = 1;
        mainBagConstraints.gridy = y;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.bmCtrX, mainBagConstraints);
        mainBagConstraints.gridx = 2;
        mainBagConstraints.gridy = y++;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.bmCtrY, mainBagConstraints);
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        mainBagConstraints.gridwidth = 3;
        this.add((Component)this.buttonPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.updateDeviceControls();
        this.readControlKeysFromHelpPreferenceFile(this);
    }

    protected void instanciateControls() {
        this.sampleLabel = new SampleLabelSansScanDeviceControlPanel("Sample Label", "Comment");
        this.filePrefix = new FilePrefixSansScanDeviceControlPanel("File Prefix", "FileName");
        this.sampleThick = new SansScanDeviceDoubleNoEmptyControlPanel("Sample Thickness (cm)", "Thk", SansScan.DeviceType.sample);
        this.sampleTrans = new SansScanDeviceDoubleNoEmptyControlPanel("Sample Transmission", "Trans", SansScan.DeviceType.sample);
        this.countIntTime = new SansScanDeviceDoubleNoEmptyControlPanel("Counting Interval (sec)", "Counts");
        this.countIntvls = new SansScanDeviceDoubleNoEmptyControlPanel("No. of Intervals/run", "Prefac");
        this.samplePos = new SansScanDeviceDoubleNoEmptyControlPanel("Sample Position", "SamplePosition", SansScan.DeviceType.angle);
        this.huberPos = new SansScanDeviceDoubleNoEmptyControlPanel("Huber Position (cm)", "HuberTranslation", SansScan.DeviceType.angle);
        this.sampleRot = new SansScanDeviceDoubleNoEmptyControlPanel("Sample Rotation (deg)", "SampleRotation", SansScan.DeviceType.angle);
        this.huberRot = new SansScanDeviceDoubleNoEmptyControlPanel("Huber Rotation (deg)", "HuberRotation", SansScan.DeviceType.angle);
        this.tempSetPt = new SansScanTempDeviceControlNonEmptyPanel("Temp. Set Point (N/A)", "Temp", SansScan.DeviceType.angle);
        this.tempSetPtErr = new SansScanDeviceDoubleNoEmptyControlPanel("Temp. Set Point Error ", "Temp Tolerance", SansScan.DeviceType.preset_temp_tol);
        this.tempHoldTime = new SansScanDeviceDoubleNoEmptyControlPanel("Temp. Hold Time (min)", "HoldTime");
        this.tempTimeOut = new SansScanDeviceDoubleNoEmptyControlPanel("Temp. Timeout (min)", "Temp Timeout", SansScan.DeviceType.preset_temp_timeout);
        ((SansScanTempDeviceControlNonEmptyPanel)this.tempSetPt).addPropertyControl(this.tempSetPtErr);
        ((SansScanTempDeviceControlNonEmptyPanel)this.tempSetPt).addPropertyControl(this.tempHoldTime);
        ((SansScanTempDeviceControlNonEmptyPanel)this.tempSetPt).addPropertyControl(this.tempTimeOut);
        this.configureTemperatureControl();
        this.magneticField = new SansScanDeviceDoubleNoEmptyControlPanel("Magnetic Field (Units)", "MagField", SansScan.DeviceType.angle);
        this.configureCurrentMagnetControl();
        this.magnetCurrent = new SansScanDeviceDoubleNoEmptyControlPanel("Magnet Current (Amps)", "LMC");
        this.magnetCurrent.setSaveToScan(false);
        this.rheoPulses = new SansScanDeviceDoubleNoEmptyControlPanel("Rheometer Pulses", "RheoPulses");
        this.waveLength = new SansScanDeviceDoubleNoEmptyControlPanel("Neutron Wavelength", "Wavelength", SansScan.DeviceType.angle);
        this.waveLSpread = new SansScanDeviceDoubleNoEmptyControlPanel("Wavelength Spread", "WavelengthSpread", SansScan.DeviceType.angle);
        this.flipper = new SansScanDeviceComboBoxControlPanel("Flipper", "Flipper", SansScan.DeviceType.angle);
        this.flipperHorizCurrent = new SansScanDeviceDoubleNoEmptyControlPanel("Horiz. Current", "FlipperHorizCurrent", SansScan.DeviceType.angle);
        this.flipperVertCurrent = new SansScanDeviceDoubleNoEmptyControlPanel("Vert. Current", "FlipperVertCurrent", SansScan.DeviceType.angle);
        this.configureEnvControl(this.flipperHorizCurrent);
        this.configureEnvControl(this.flipperVertCurrent);
        this.atten = new SansScanDeviceComboBoxControlPanel("Attenuators", "Attenuator", SansScan.DeviceType.angle);
        this.detDist = new SansScanDeviceDoubleNoEmptyControlPanel("Detector Distance (cm)", "DetectorPos", SansScan.DeviceType.angle);
        this.detOff = new SansScanDeviceDoubleNoEmptyControlPanel("Detector Offset (cm)", "DetectorOffset", SansScan.DeviceType.angle);
        this.bmStp = new SansScanDeviceComboBoxControlPanel("Beam Stop Size", "BeamStop", SansScan.DeviceType.angle);
        this.bmStpX = new SansScanDeviceDoubleNoEmptyControlPanel("Beam Stop X Position (cm)", "BeamStopX", SansScan.DeviceType.angle);
        this.bmStpY = new SansScanDeviceDoubleNoEmptyControlPanel("Beam Stop Y Position (cm)", "BeamStopY", SansScan.DeviceType.angle);
        this.bmCtrX = new SansScanDeviceDoubleNoEmptyControlPanel("Beam Center X Position", "BeamCenterX", SansScan.DeviceType.angle);
        this.bmCtrY = new SansScanDeviceDoubleNoEmptyControlPanel("Beam Center Y Position", "BeamCenterY", SansScan.DeviceType.angle);
    }

    @Override
    protected void init() {
        String[] values;
        DevicePositionsCommand iCommand;
        ClientAPI messageSender;
        this.initSansIcePanel();
        this.instanciateControls();
        this.guides = new SansScanDeviceGuideControl();
        this.instrumentName = Global.getInstrumentName();
        this.controls = new ArrayList();
        this.controller = Controller.getReference();
        this.runBuffer = new JLabel();
        this.controller.getDeviceListeners().add(this);
        this.errorControls = new ArrayList();
        this.sampleThick.addNumberOutOfRangeListener(this);
        this.sampleTrans.addNumberOutOfRangeListener(this);
        this.samplePos.addNumberOutOfRangeListener(this);
        this.huberPos.addNumberOutOfRangeListener(this);
        this.sampleRot.addNumberOutOfRangeListener(this);
        this.huberRot.addNumberOutOfRangeListener(this);
        this.tempSetPt.addNumberOutOfRangeListener(this);
        this.tempHoldTime.addNumberOutOfRangeListener(this);
        this.tempHoldTime.addFocusListener(new HoldTimeFocusListener());
        this.tempHoldTime.setSaveToScan(false);
        this.tempTimeOut.setNeverEdit(true);
        this.tempTimeOut.setSaveToScan(true);
        this.magnetCurrent.setDisabled(true);
        this.magnetCurrent.setSaveToScan(false);
        this.rheoPulses.setScanName("SANSRHEOPULSES");
        this.rheoPulses.addNumberOutOfRangeListener(this);
        this.waveLSpread.setDisabled(true);
        this.waveLSpread.setSaveToScan(false);
        this.waveLength.addNumberOutOfRangeListener(this);
        this.waveLSpread.addNumberOutOfRangeListener(this);
        this.countIntvls.addNumberOutOfRangeListener(this);
        this.countIntTime.addNumberOutOfRangeListener(this);
        this.detDist.addNumberOutOfRangeListener(this);
        this.detOff.addNumberOutOfRangeListener(this);
        this.magnetCurrent.addNumberOutOfRangeListener(this);
        this.magneticField.addNumberOutOfRangeListener(this);
        this.flipperHorizCurrent.addNumberOutOfRangeListener(this);
        this.flipperVertCurrent.addNumberOutOfRangeListener(this);
        try {
            messageSender = ClientAPI.getInstance();
            iCommand = new DevicePositionsCommand("Attenuator", messageSender);
            iCommand.runSynchronous();
            values = iCommand.getParsedResponse();
            this.atten.addItems(values);
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
        try {
            messageSender = ClientAPI.getInstance();
            iCommand = new DevicePositionsCommand("BeamStop", messageSender);
            iCommand.runSynchronous();
            values = iCommand.getParsedResponse();
            this.bmStp.addItems(values);
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
        try {
            messageSender = ClientAPI.getInstance();
            iCommand = new DevicePositionsCommand("Flipper", messageSender);
            iCommand.runSynchronous();
            values = iCommand.getParsedResponse();
            this.flipper.addItems(values);
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
        this.controls.add(this.sampleLabel);
        this.controls.add(this.filePrefix);
        this.controls.add(this.countIntTime);
        this.controls.add(this.countIntvls);
        this.controls.add(this.samplePos);
        this.controls.add(this.huberPos);
        this.controls.add(this.detDist);
        this.controls.add(this.detOff);
        this.controls.add(this.rheoPulses);
        this.controls.add(this.sampleRot);
        this.controls.add(this.huberRot);
        this.controls.add(this.waveLength);
        this.controls.add(this.waveLSpread);
        this.controls.add(this.guides.getCollimationControl());
        this.controls.add(this.guides.getLensesControl());
        this.controls.add(this.guides.getApertureControl());
        if (this.instrumentName.equalsIgnoreCase(ng3)) {
            this.controls.add(this.flipper);
            this.controls.add(this.flipperHorizCurrent);
            this.controls.add(this.flipperVertCurrent);
        }
        this.controls.add(this.atten);
        this.controls.add(this.bmStp);
        this.controls.add(this.bmStpX);
        this.controls.add(this.bmStpY);
        this.controls.add(this.bmCtrX);
        this.controls.add(this.bmCtrY);
        this.controls.add(this.sampleThick);
        this.controls.add(this.sampleTrans);
        this.controls.add(this.tempSetPt);
        this.controls.add(this.tempSetPtErr);
        this.controls.add(this.tempHoldTime);
        this.controls.add(this.tempTimeOut);
        this.controls.add(this.magneticField);
        this.controls.add(this.magnetCurrent);
        this.buttonPanel = new RunPropertiesButtonControlPanel(this);
        this.helpPanel = new HelpPanel();
        ArrayList<InstalledDevice> devices = this.controller.getDeviceList();
        this.allDevices = new ArrayList<InstalledDevice>(devices);
        this.setControlPrefferedSize();
        for (SansDeviceControlPanel control : this.controls) {
            control.addToDoNotEnableDisableOnIdleOrBusy(control.getComponents());
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        List<InstalledDevice> installedDevices = null;
        String alias2 = null;
        String realName = null;
        String currentTempRealName = null;
        if (this.currentTempDevice != null) {
            currentTempRealName = this.currentTempDevice.getRealName();
        }
        String currentMagRealName = null;
        if (this.currentMagDevice != null) {
            currentMagRealName = this.currentMagDevice.getRealName();
        }
        installedDevices = dle.getDevicesRemoved();
        for (InstalledDevice removeMe : installedDevices) {
            if (removeMe instanceof InstalledTempDevice) {
                alias2 = removeMe.getAlias();
                realName = removeMe.getRealName();
                if ((alias2 == null || alias2.equalsIgnoreCase("Temp")) && (currentTempRealName == null || !realName.equalsIgnoreCase(currentTempRealName))) continue;
                this.tempSetPt.setControlName("Temp. Set Point (N/A)");
                this.tempSetPt.setFixed(false);
                this.stopListeningForDeviceErrors(realName);
                this.tempSetPt.setDisabled(true);
                this.currentTempDevice = null;
                continue;
            }
            if (!(removeMe instanceof InstalledEnvDevice)) continue;
            alias2 = removeMe.getAlias();
            realName = removeMe.getRealName();
            if (alias2 != null && alias2.equalsIgnoreCase("MagField") || currentMagRealName != null && realName.equalsIgnoreCase(currentMagRealName)) {
                this.magneticField.setFixed(false);
                this.magneticField.setControlName("Magnetic Field (N/A)");
                this.stopListeningForDeviceErrors(realName);
                removeMe.removeValueChangeListener(this.magneticField);
                this.magneticField.setDisabled(true);
                this.currentMagDevice = null;
                continue;
            }
            this.removeEnvDevice((InstalledEnvDevice)removeMe);
        }
        installedDevices = dle.getDevicesAdded();
        for (InstalledDevice addMe : installedDevices) {
            String currentValue;
            String units;
            if (addMe instanceof InstalledTempDevice) {
                alias2 = addMe.getAlias();
                realName = addMe.getRealName();
                if (alias2 == null || !alias2.equalsIgnoreCase("Temp")) continue;
                InstalledTempDevice currentTempDevice = (InstalledTempDevice)addMe;
                try {
                    currentTempDevice.addValueChangeListener(this.tempSetPt);
                    this.tempSetPt.setDevice(currentTempDevice);
                }
                catch (ICEListenerListExceptionBase e) {
                    logger.error("RunPropertiesPanel.deviceListUpdated " + e);
                }
                this.listenForDeviceErrors(realName);
                units = currentTempDevice.getUnits();
                this.tempSetPt.setControlName("Temp. Set Point (" + units + ")");
                this.tempSetPt.setDisabled(false);
                this.currentTempDevice = currentTempDevice;
                if (!currentTempDevice.isFixed()) continue;
                currentValue = currentTempDevice.getCurrValue().toString();
                this.tempSetPt.setCurrentValue(currentValue);
                this.tempSetPt.setFixed(true);
                continue;
            }
            if (!(addMe instanceof InstalledEnvDevice)) continue;
            alias2 = addMe.getAlias();
            realName = addMe.getRealName();
            if (alias2 != null && alias2.equalsIgnoreCase("MagField")) {
                InstalledEnvDevice currentMagnetDevice = (InstalledEnvDevice)addMe;
                try {
                    currentMagnetDevice.addValueChangeListener(this.magneticField);
                    this.magneticField.setDevice(currentMagnetDevice);
                }
                catch (ICEListenerListExceptionBase e) {
                    logger.error("RunPropertiesPanel.deviceListUpdated " + e);
                }
                this.listenForDeviceErrors(realName);
                units = currentMagnetDevice.getUnits();
                this.magneticField.setControlName("Magnetic Field (" + units + ")");
                this.magneticField.setDisabled(false);
                this.currentMagDevice = currentMagnetDevice;
                if (!currentMagnetDevice.isFixed()) continue;
                currentValue = currentMagnetDevice.getCurrValue().toString();
                this.magneticField.setCurrentValue(currentValue);
                this.magneticField.setFixed(true);
                continue;
            }
            this.addEnvDevice((InstalledEnvDevice)addMe);
        }
    }

    @Override
    public void updateDeviceControls() {
        for (SansDeviceControlPanel control : this.controls) {
            String currentValue;
            String deviceName = control.getDeviceName();
            InstalledDevice device = this.controller.getFirstDevice(deviceName);
            if (device == null) continue;
            try {
                device.addValueChangeListener(control);
                ((SansScanDeviceControlPanel)control).setDevice(device);
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("RunPropertiesPanel.updateDeviceControls " + e);
            }
            if (control.isDisabled()) {
                currentValue = device.getCurrValue().toString();
                control.setCurrentValue(currentValue);
                continue;
            }
            if (!device.isFixed()) continue;
            currentValue = device.getCurrValue().toString();
            control.setCurrentValue(currentValue);
            control.setFixed(true);
            this.errorControls.remove(control);
        }
    }

    public String getScanDescription() {
        String scan = "Scan";
        String deviceValue = "";
        for (SansDeviceControlPanel control : this.controls) {
            if (!(control instanceof SansScanDeviceControlPanel)) continue;
            SansScanDeviceControlPanel scanControl = (SansScanDeviceControlPanel)control;
            String scanControlName = scanControl.getControlName();
            if (!scanControl.isSaveToScan()) continue;
            deviceValue = scanControl.isFixed() || scanControl.isDisabled() ? scanControl.getScanValue() : scanControl.getCurrentValue();
            String prefix = "";
            SansScan.DeviceType type = scanControl.getDeviceType();
            if (deviceValue.equals("")) continue;
            String scanName = scanControl.getScanName();
            switch (type) {
                case angle: {
                    prefix = "Angle=" + scanName + "=";
                    break;
                }
                case preset_temp_timeout: {
                    prefix = "PresetDevicesProperties=Temp timeout ";
                    break;
                }
                case preset_temp_tol: {
                    prefix = "PresetDevicesProperties=Temp tolerance ";
                    break;
                }
                case sample: {
                    prefix = "Sample=" + scanName + "=";
                    break;
                }
                case other: {
                    prefix = String.valueOf(scanName) + "=";
                }
            }
            String value = "";
            if (scanName.equalsIgnoreCase("Temp Timeout")) {
                String holdTime = this.tempHoldTime.getCurrentValue();
                Double timeout = Double.valueOf(holdTime) * 600.0;
                value = String.valueOf(prefix) + timeout.toString();
            } else {
                value = !((deviceValue = deviceValue.replaceAll("\"", "\\\\\"")).indexOf("\n") < 0 && deviceValue.indexOf(" ") < 0 && deviceValue.indexOf(":") < 0 || deviceValue.startsWith("\"") && deviceValue.endsWith("\"")) ? String.valueOf(prefix) + "\"" + deviceValue + "\"" : String.valueOf(prefix) + deviceValue;
            }
            scan = String.valueOf(scan) + ":" + value;
        }
        scan = String.valueOf(scan) + ":jtype=sansauto:sansstop=" + this.sansStop;
        return scan;
    }

    public String getBufferNumber() {
        String buffer = "";
        if (this.sansScan != null) {
            buffer = this.sansScan.getName();
        }
        return buffer;
    }

    public void clearPanel() {
        for (SansDeviceControlPanel control : this.controls) {
            control.setCurrentValue("");
            control.setScanValue("");
        }
    }

    public void setControlPrefferedSize() {
        for (SansDeviceControlPanel control : this.controls) {
            SansScanDeviceControlPanel propControl = (SansScanDeviceControlPanel)control;
            propControl.setTextPrefferedSize(70, 22);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void handleOutOfRangeNumber(NumberOutOfRangeListener.NumberOutOfRangeEvent event) {
        Object source = event.getTheSource();
        if (!(source instanceof JTextField)) {
            return;
        }
        JTextField textField = (JTextField)source;
        Container sourceParent = textField.getParent();
        if (!(sourceParent instanceof SansScanDeviceDoubleControlPanel)) {
            return;
        }
        SansScanDeviceDoubleControlPanel control = (SansScanDeviceDoubleControlPanel)sourceParent;
        NumberOutOfRangeListener.NumberRange range = event.getState();
        if (range == NumberOutOfRangeListener.NumberRange.IN_RANGE) {
            this.errorControls.remove(control);
        } else if (!this.errorControls.contains(control) && control.isEditable()) {
            this.errorControls.add(control);
        }
        boolean errorState = this.errorControls.isEmpty();
        boolean buttonState = this.buttonPanel.isButtonStateEnabled();
        if (buttonState != errorState) {
            this.buttonPanel.enableNavigationButtons(errorState);
        }
    }

    protected void configureTemperatureControl() {
        Controller controller = null;
        boolean found = false;
        controller = Controller.getReference();
        ArrayList<InstalledDevice> allDevices = controller.getDeviceList();
        this.currentTempDevice = null;
        for (InstalledDevice aDevice : allDevices) {
            if (aDevice instanceof InstalledTempDevice) {
                String aliasName = null;
                String realName = null;
                realName = aDevice.getName();
                aliasName = aDevice.getAlias();
                if (aliasName != null && aliasName.equalsIgnoreCase("Temp")) {
                    InstalledTempDevice currentTempDevice = (InstalledTempDevice)aDevice;
                    try {
                        currentTempDevice.addValueChangeListener(this.tempSetPt);
                        this.tempSetPt.setDevice(currentTempDevice);
                    }
                    catch (ICEListenerListExceptionBase e) {
                        logger.error("RunPropertiesPanel.setCurrentTemperatureControl " + e);
                    }
                    String units = currentTempDevice.getUnits();
                    this.tempSetPt.setControlName("Temp. Set Point (" + units + ")");
                    this.currentTempDevice = currentTempDevice;
                    this.listenForDeviceErrors(realName);
                    found = true;
                }
            }
            if (found) break;
        }
        if (!found) {
            this.tempSetPt.setDisabled(true);
        }
    }

    protected void configureCurrentMagnetControl() {
        Controller controller = null;
        boolean found = false;
        controller = Controller.getReference();
        ArrayList<InstalledDevice> allDevices = controller.getDeviceList();
        for (InstalledDevice aDevice : allDevices) {
            if (aDevice instanceof InstalledEnvDevice) {
                String aliasName = null;
                String realName = null;
                realName = aDevice.getName();
                aliasName = aDevice.getAlias();
                if (aliasName != null && aliasName.equalsIgnoreCase("MagField")) {
                    InstalledEnvDevice currentMagnetDevice = (InstalledEnvDevice)aDevice;
                    try {
                        currentMagnetDevice.addValueChangeListener(this.magneticField);
                        this.magneticField.setDevice(currentMagnetDevice);
                    }
                    catch (ICEListenerListExceptionBase e) {
                        logger.error("RunProperitesPanel.setCurrentMagnetControl " + e);
                    }
                    this.magneticField.setDeviceName(aliasName);
                    String units = currentMagnetDevice.getUnits();
                    this.magneticField.setControlName("Magnetic Field (" + units + ")");
                    this.listenForDeviceErrors(realName);
                    found = true;
                }
            }
            if (found) break;
        }
        if (!found) {
            this.magneticField.setDisabled(true);
            this.magneticField.setControlName("Magnetic Field (N/A)");
        }
    }

    protected void configureEnvControl(SansScanDeviceControlPanel control) {
        Controller controller = Controller.getReference();
        InstalledDevice device = controller.getFirstDevice(control.getDeviceName());
        if (device == null) {
            control.setDisabled(true);
            return;
        }
        if (device instanceof InstalledEnvDevice) {
            InstalledEnvDevice envDevice = (InstalledEnvDevice)device;
            try {
                envDevice.addValueChangeListener(control);
                control.setDevice(envDevice);
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("RunPropertiesPanel.setEnvControl " + e.getMessage());
            }
            this.listenForDeviceErrors(envDevice.getRealName());
        }
    }

    private void setCollimationControls(SansScan scan) {
        String scanName = "GuideTable";
        if (scan.containsAngle(scanName)) {
            InstalledDevice guideTableDevice;
            String guideTableValue = scan.getAngleValue(scanName);
            if (guideTableValue == null) {
                guideTableValue = "";
            }
            if ((guideTableDevice = this.controller.getFirstDevice("GuideTable")) != null && guideTableDevice.isFixed()) {
                this.guides.configureApertureControl(guideTableDevice.getCurrValue(), false);
            } else {
                this.guides.configureApertureControl(guideTableValue, true);
            }
        }
    }

    protected void setLastMagnetCurrent() {
        Controller controller = Controller.getReference();
        InstalledDevice magnet = controller.getFirstDevice("MagField");
        String value = "N/A";
        if (magnet != null) {
            value = magnet.getAdditionalPropertyValue("LASTMAGNETCURRENT");
        }
        this.magnetCurrent.setCurrentValue(value);
    }

    private void addEnvDevice(InstalledEnvDevice device) {
        String deviceName = device.getRealName();
        SansScanDeviceControlPanel control = this.getControl(deviceName);
        if (control != null) {
            try {
                device.addValueChangeListener(control);
                control.setDevice(device);
                control.setDisabled(false);
                if (device.isFixed()) {
                    control.setDisabled(true);
                    control.setCurrentValue(device.getCurrValue());
                }
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("RunPropertiesPanel.setEnvControl " + e.getMessage());
            }
            this.listenForDeviceErrors(deviceName);
        }
    }

    private void removeEnvDevice(InstalledEnvDevice device) {
        String deviceName = device.getRealName();
        SansScanDeviceControlPanel control = this.getControl(deviceName);
        if (control != null) {
            device.removeValueChangeListener(control);
            control.setFixed(false);
            control.setDisabled(true);
            String scanValue = control.getScanName();
            control.setCurrentValue(scanValue);
            this.stopListeningForDeviceErrors(deviceName);
        }
    }

    private SansScanDeviceControlPanel getControl(String deviceName) {
        SansScanDeviceControlPanel foundControl = null;
        for (SansDeviceControlPanel control : this.controls) {
            String name = control.getDeviceName();
            if (!deviceName.equalsIgnoreCase(name)) continue;
            foundControl = (SansScanDeviceControlPanel)control;
            break;
        }
        return foundControl;
    }

    private class HoldTimeFocusListener
    implements FocusListener {
        private HoldTimeFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent event) {
            RunPropertiesPanel.this.errorPanel.clearErrors();
            String holdTime = RunPropertiesPanel.this.tempHoldTime.getCurrentValue();
            if (holdTime.equals("")) {
                return;
            }
            try {
                Double timeout = Double.valueOf(RunPropertiesPanel.this.tempHoldTime.getCurrentValue()) * 10.0;
                RunPropertiesPanel.this.tempTimeOut.setCurrentValue(timeout.toString());
                RunPropertiesPanel.this.tempTimeOut.setScanValue(timeout.toString());
            }
            catch (NumberFormatException e) {
                RunPropertiesPanel.this.errorPanel.setError("Invalid Number Format for: " + RunPropertiesPanel.this.tempHoldTime.getControlName());
                logger.error(e);
            }
        }
    }
}

