/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels.autodata;

import ice.ClientAPI;
import ice.Controller;
import ice.IcePanelManager;
import ice.commands.ImmediateCommand;
import ice.data.BaseScan;
import ice.data.InstalledDevice;
import ice.data.InstalledMagnetDevice;
import ice.data.InstalledTempDevice;
import ice.data.Sample;
import ice.data.ScanList;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.SamplePropertyChangedEvent;
import ice.event.SamplePropertyChangedListener;
import ice.event.ScanListEvent;
import ice.event.ScanListListener;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.gui.core.GenericIcePanel;
import ice.gui.core.IceWindow;
import ice.gui.panel.sans.DataAcquisitionPanel;
import ice.gui.panel.sans.data.SansScan;
import ice.gui.panel.sans.events.SansTableHeaderListener;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.subpanels.autodata.RunPropertiesDialog;
import ice.gui.panel.sans.subpanels.autodata.SansTableModel;
import ice.gui.panel.sans.subpanels.autodata.TableTextPrintable;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterJob;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class RunListTable
extends JPanel
implements ActionListener,
ScanListListener,
DeviceListListener,
DeviceValueChangedListener,
SamplePropertyChangedListener {
    private static final long serialVersionUID = 7525844006700816159L;
    private static Logger logger = Logger.getLogger("ErrorLogger.RunListTable");
    public static int min_col_width = 15;
    private JScrollPane tableScrollPane;
    private RunListJTable runListTable;
    private SansTableModel tableModel;
    private int selPosition;
    private int[] columnWidth;
    private InstalledTempDevice tempDevice;
    private InstalledMagnetDevice magDevice;

    public RunListTable() {
        this.init();
        this.buildGUI();
    }

    public RunListTable(SansIcePanel panel) {
        this.init();
        this.buildGUI();
    }

    public void buildGUI() {
        this.setLayout(new BorderLayout());
        this.runListTable.setModel(this.tableModel);
        this.runListTable.setSelectionMode(1);
        int colCount = this.tableModel.getColumnCount();
        int i = 1;
        while (i < colCount) {
            TableColumn tableColumn = this.runListTable.getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(new TableRowRenderer());
            ++i;
        }
        InputMap im = this.runListTable.getInputMap(1);
        KeyStroke f2 = KeyStroke.getKeyStroke(113, 0);
        im.put(f2, "none");
        KeyStroke f8 = KeyStroke.getKeyStroke(119, 0);
        im.put(f8, "none");
        this.runListTable.setPreferredScrollableViewportSize(new Dimension(800, 400));
        this.runListTable.addMouseListener(new TableMouseListener());
        this.runListTable.setAutoResizeMode(0);
        this.tableScrollPane.setViewportView(this.runListTable);
        this.add((Component)this.tableScrollPane, "Center");
        this.computeColumnWidths();
        this.setDefaultColumnWidth();
        this.updateDeviceControls();
        this.runListTable.requestFocusInWindow();
        if (!this.runListTable.isEmpty()) {
            this.runListTable.setRowSelectionInterval(0, 0);
        }
    }

    public void init() {
        this.tableScrollPane = new JScrollPane();
        this.runListTable = new RunListJTable();
        this.tableModel = new SansTableModel();
        this.columnWidth = new int[this.tableModel.getColumnCount()];
        TableCellEditor boolEditor = this.runListTable.getDefaultEditor(Boolean.class);
        boolEditor.addCellEditorListener(new CheckBoxListener(this.runListTable));
        Controller controller = Controller.getReference();
        ScanList scanListController = controller.getServerScanList();
        try {
            scanListController.addScanListListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("RunListTable.init can not add listener " + e.toString());
        }
        controller.getDeviceListeners().add(this);
        Sample sample = controller.getSample();
        try {
            sample.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("error adding SampleChangePropertyListener" + e.toString());
        }
        JTableHeader header = this.runListTable.getTableHeader();
        header.addMouseListener(new SansTableHeaderListener(this));
    }

    public JTable getRunListTable() {
        return this.runListTable;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
    }

    public void collapseColumn(int vColIndex, TableColumnModel colModel) {
        TableColumn column = colModel.getColumn(vColIndex);
        if (column.getPreferredWidth() <= min_col_width) {
            this.setDefaultColumnWidth(vColIndex);
            column.setResizable(true);
        } else {
            column.setMinWidth(min_col_width);
            column.setPreferredWidth(min_col_width);
            column.setResizable(false);
        }
    }

    public void scansAdded(ScanListEvent sle) {
        int[] indeces = sle.getIndices();
        if (indeces.length == 0) {
            return;
        }
        logger.debug("ADDING SCANS:" + indeces.length);
        ArrayList<BaseScan> scans = sle.getScanList();
        this.tableModel.addScanData(scans, indeces);
        this.restoreSelection();
        boolean request = this.runListTable.requestFocusInWindow();
    }

    public void scansRemoved(ScanListEvent sle) {
        int[] indeces = sle.getIndices();
        if (indeces.length == 0) {
            return;
        }
        logger.debug("REMOVING SCANS:" + indeces.length);
        this.tableModel.removeScanData(sle.getRemovedChildren(), indeces);
        this.restoreSelection();
        boolean request = this.runListTable.requestFocusInWindow();
        TableCellRenderer renderer = this.runListTable.getColumnModel().getColumn(1).getCellRenderer();
        if (renderer == null) {
            int colCount = this.tableModel.getColumnCount();
            int i = 1;
            while (i < colCount) {
                TableColumn tableColumn = this.runListTable.getColumnModel().getColumn(i);
                tableColumn.setCellRenderer(new TableRowRenderer());
                ++i;
            }
        }
    }

    public void scansUpdated(ScanListEvent sle) {
        int[] indeces = sle.getIndices();
        if (indeces.length == 0) {
            return;
        }
        logger.debug("UPDATING SCANS:" + indeces.length);
        ArrayList<BaseScan> scans = sle.getScanList();
        this.tableModel.updateScanData(scans, indeces);
        this.restoreSelection();
        boolean request = this.runListTable.requestFocusInWindow();
    }

    @Override
    public void actionPerformed(ScanListEvent event) {
        ScanListEvent.Type theType = event.getType();
        switch (theType) {
            case ADD: {
                this.scansAdded(event);
                break;
            }
            case REMOVE: {
                this.scansRemoved(event);
                break;
            }
            case UPDATE: {
                this.scansUpdated(event);
            }
        }
    }

    private void computeColumnWidths() {
        int hspace = 14;
        int max_width = 100;
        int cols = this.tableModel.getColumnCount();
        int rows = this.tableModel.getRowCount();
        int i = 0;
        while (i < cols) {
            TableCellRenderer renderer = this.runListTable.getDefaultRenderer(String.class);
            try {
                Component component = renderer.getTableCellRendererComponent(this.runListTable, this.runListTable.getColumnName(i), false, false, -1, i);
                double width = component.getPreferredSize().getWidth();
                double colWidth = width + (double)hspace;
                this.columnWidth[i] = (int)colWidth;
            }
            catch (Exception e) {
                logger.error("error in computeColumnWidths()", e.getCause());
                this.columnWidth[i] = hspace;
            }
            ++i;
        }
        i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                Object o = this.tableModel.getValueAt(i, j);
                int width = 0;
                if (o != null) {
                    width = (int)this.runListTable.getCellRenderer(i, j).getTableCellRendererComponent(this.runListTable, o, false, false, i, j).getPreferredSize().getWidth() + hspace;
                }
                if (width > max_width) {
                    width = max_width;
                }
                if (this.columnWidth[j] < width) {
                    this.columnWidth[j] = width;
                }
                ++j;
            }
            ++i;
        }
    }

    private void setDefaultColumnWidth(int colIndex) {
        TableColumnModel colModel = this.runListTable.getColumnModel();
        colModel.getColumn(colIndex).setPreferredWidth(this.columnWidth[colIndex]);
    }

    private void setDefaultColumnWidth() {
        TableColumnModel colModel = this.runListTable.getColumnModel();
        int i = 0;
        while (i < colModel.getColumnCount()) {
            colModel.getColumn(i).setPreferredWidth(this.columnWidth[i]);
            ++i;
        }
    }

    private void updateDeviceControls() {
        TableColumn column;
        Controller controller = Controller.getReference();
        ArrayList<InstalledDevice> devices = controller.getDeviceList();
        ArrayList<InstalledDevice> allDevices = new ArrayList<InstalledDevice>(devices);
        ArrayList<String> controls = this.tableModel.getControlNames();
        this.magDevice = null;
        this.tempDevice = null;
        for (InstalledDevice device : allDevices) {
            if (device.getName() == null) continue;
            int i = 0;
            for (String controlName : controls) {
                if (device.getName().equalsIgnoreCase(controlName)) {
                    String aliasName;
                    String colName = this.tableModel.getColumnName(i);
                    TableColumn column2 = this.runListTable.getColumn(colName);
                    try {
                        device.addValueChangeListener(this);
                    }
                    catch (ICEListenerListExceptionBase e) {
                        logger.error("RunListTable.updateDeviceControls " + e);
                    }
                    if (device.isFixed()) {
                        this.hideTableColumn(column2);
                    } else {
                        this.setDefaultColumnWidth(i);
                        column2.setResizable(true);
                    }
                    if (device instanceof InstalledMagnetDevice) {
                        aliasName = device.getAlias();
                        if (aliasName.equalsIgnoreCase("MagField")) {
                            this.magDevice = (InstalledMagnetDevice)device;
                        }
                    } else if (device instanceof InstalledTempDevice && (aliasName = device.getAlias()).equalsIgnoreCase("Temp")) {
                        this.tempDevice = (InstalledTempDevice)device;
                    }
                }
                ++i;
            }
        }
        if (this.tempDevice == null) {
            column = this.runListTable.getColumn("TmpSetPt");
            this.hideTableColumn(column);
        }
        if (this.magDevice == null) {
            column = this.runListTable.getColumn("MagField");
            this.hideTableColumn(column);
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        List<InstalledDevice> installedDevices = null;
        String alias2 = null;
        String realName = null;
        installedDevices = dle.getDevicesRemoved();
        for (InstalledDevice removeMe : installedDevices) {
            String currentRealName;
            TableColumn column;
            if (removeMe instanceof InstalledTempDevice) {
                column = this.runListTable.getColumn("TmpSetPt");
                alias2 = removeMe.getAlias();
                realName = removeMe.getRealName();
                currentRealName = this.tempDevice.getRealName();
                if ((alias2 == null || alias2.equalsIgnoreCase("Temp")) && (currentRealName == null || !realName.equalsIgnoreCase(currentRealName))) continue;
                removeMe.removeValueChangeListener(this);
                this.hideTableColumn(column);
                this.tempDevice = null;
                continue;
            }
            if (!(removeMe instanceof InstalledMagnetDevice)) continue;
            column = this.runListTable.getColumn("MagField");
            alias2 = removeMe.getAlias();
            realName = removeMe.getRealName();
            currentRealName = this.magDevice.getRealName();
            if ((alias2 == null || !alias2.equalsIgnoreCase("MagField")) && (currentRealName == null || !realName.equalsIgnoreCase(currentRealName))) continue;
            removeMe.removeValueChangeListener(this);
            this.hideTableColumn(column);
            this.magDevice = null;
        }
        installedDevices = dle.getDevicesAdded();
        for (InstalledDevice addMe : installedDevices) {
            TableColumn column;
            if (addMe instanceof InstalledTempDevice) {
                alias2 = addMe.getAlias();
                realName = addMe.getRealName();
                if (alias2 == null || !alias2.equalsIgnoreCase("Temp")) continue;
                InstalledTempDevice currentTempDevice = (InstalledTempDevice)addMe;
                try {
                    currentTempDevice.addValueChangeListener(this);
                }
                catch (ICEListenerListExceptionBase e) {
                    logger.error("RunListTable.deviceListUpdated " + e);
                }
                column = this.runListTable.getColumn("TmpSetPt");
                this.tempDevice = currentTempDevice;
                if (currentTempDevice.isFixed()) {
                    this.hideTableColumn(column);
                    continue;
                }
                this.setDefaultColumnWidth(column.getModelIndex());
                column.setResizable(true);
                continue;
            }
            if (!(addMe instanceof InstalledMagnetDevice)) continue;
            alias2 = addMe.getAlias();
            realName = addMe.getRealName();
            if (alias2 == null || !alias2.equalsIgnoreCase("MagField")) continue;
            InstalledMagnetDevice currentMagnetDevice = (InstalledMagnetDevice)addMe;
            try {
                currentMagnetDevice.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("RunListTable.deviceListUpdated " + e);
            }
            column = this.runListTable.getColumn("MagField");
            this.magDevice = currentMagnetDevice;
            if (currentMagnetDevice.isFixed()) {
                this.hideTableColumn(column);
                continue;
            }
            this.setDefaultColumnWidth(column.getModelIndex());
            column.setResizable(true);
        }
    }

    private void hideTableColumn(TableColumn column) {
        column.setMinWidth(0);
        column.setPreferredWidth(0);
        column.setResizable(false);
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent event) {
        Object object = event.getSource();
        InstalledDevice device = (InstalledDevice)object;
        ArrayList<String> controls = this.tableModel.getControlNames();
        int colIndex = 0;
        for (String controlName : controls) {
            String colName = this.tableModel.getColumnName(colIndex);
            TableColumn column = this.runListTable.getColumn(colName);
            colIndex = column.getModelIndex();
            if (event.getPropertyName().equalsIgnoreCase("fixed") && device.getName().equalsIgnoreCase(controlName)) {
                TableColumn propColumn;
                String propColName;
                int propIndex;
                HashMap<String, String> properties = device.getAdditionalProperties();
                Set<String> propertyNames = properties.keySet();
                if (device.isFixed()) {
                    this.hideTableColumn(column);
                    for (String propName : propertyNames) {
                        if (!controls.contains(propName)) continue;
                        propIndex = controls.indexOf(propName);
                        propColName = this.tableModel.getColumnName(propIndex);
                        propColumn = this.runListTable.getColumn(propColName);
                        this.hideTableColumn(propColumn);
                    }
                } else {
                    this.setDefaultColumnWidth(colIndex);
                    column.setMinWidth(min_col_width);
                    column.setResizable(true);
                    for (String propName : propertyNames) {
                        if (!controls.contains(propName)) continue;
                        propIndex = controls.indexOf(propName);
                        propColName = this.tableModel.getColumnName(propIndex);
                        propColumn = this.runListTable.getColumn(propColName);
                        this.setDefaultColumnWidth(propIndex);
                        propColumn.setMinWidth(min_col_width);
                        propColumn.setResizable(true);
                    }
                }
            }
            ++colIndex;
        }
        this.runListTable.invalidate();
        this.repaint();
    }

    private static void executeToggleStopCommand(boolean stop, Object[] row) {
        try {
            ClientAPI messageSender = ClientAPI.getInstance();
            String stopValue = "0";
            if (stop) {
                stopValue = "1";
            }
            String message = "scan operation " + row[1] + " " + "sansstop=" + stopValue;
            ImmediateCommand command = new ImmediateCommand(message, messageSender);
            command.runAsynchronous();
        }
        catch (Exception e) {
            logger.error("client api error", e.getCause());
        }
    }

    public SansScan getNextScan(int selBuffer) {
        SansScan scan;
        int selection = selBuffer - 1;
        int nextSel = selection + 1;
        int count = this.runListTable.getRowCount();
        if (nextSel < count) {
            scan = this.tableModel.getSansScan(nextSel);
            this.setRowSelection(nextSel);
            this.runListTable.setRowSelectionInterval(nextSel, nextSel);
        } else {
            scan = this.tableModel.getSansScan(selection);
            this.setRowSelection(selection);
            this.runListTable.setRowSelectionInterval(selection, selection);
        }
        return scan;
    }

    public SansScan getPrevScan(int selBuffer) {
        SansScan scan;
        int selection = selBuffer - 1;
        int prevSel = selection - 1;
        if (prevSel >= 0) {
            scan = this.tableModel.getSansScan(prevSel);
            this.setRowSelection(prevSel);
            this.runListTable.setRowSelectionInterval(prevSel, prevSel);
        } else {
            scan = this.tableModel.getSansScan(selection);
            this.runListTable.setRowSelectionInterval(selection, selection);
        }
        return scan;
    }

    public void restoreSelection() {
        int currSelection = this.runListTable.getSelectedRowCount();
        if (currSelection > 0) {
            return;
        }
        int rowCount = this.runListTable.getRowCount();
        if (rowCount == 0) {
            this.selPosition = 0;
            return;
        }
        if (this.selPosition >= rowCount) {
            this.selPosition = rowCount - 1;
        }
        this.runListTable.setRowSelectionInterval(this.selPosition, this.selPosition);
    }

    public void setRowSelectionFromKeyStroke(int keyCode) {
        int selection = 0;
        int count = this.runListTable.getRowCount();
        int currentSelection = this.runListTable.getSelectedRow();
        switch (keyCode) {
            case 48: {
                selection = 0;
                break;
            }
            case 49: {
                selection = 9;
                break;
            }
            case 50: {
                selection = 19;
                break;
            }
            case 51: {
                selection = 29;
                break;
            }
            case 52: {
                selection = 39;
                break;
            }
            case 53: {
                selection = 49;
                break;
            }
            case 54: {
                selection = 59;
                break;
            }
            case 55: {
                selection = 69;
                break;
            }
            case 56: {
                selection = 79;
                break;
            }
            case 57: {
                selection = 89;
                break;
            }
            case 37: {
                selection = currentSelection + 10;
                break;
            }
            case 39: {
                selection = currentSelection - 10;
            }
        }
        ListSelectionModel selectionModel = this.runListTable.getSelectionModel();
        if (selection < count) {
            Rectangle rect = this.runListTable.getCellRect(selection, 0, true);
            this.runListTable.scrollRectToVisible(rect);
            this.runListTable.clearSelection();
            selectionModel.setSelectionInterval(selection, selection);
        }
    }

    public void setRowSelection(int sel) {
        this.selPosition = sel;
    }

    public void print(int start, int end, String header, String footer) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        TableTextPrintable printable = new TableTextPrintable(this, start, end, header, footer);
        printJob.setPrintable(printable);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception printException) {
                printException.printStackTrace();
            }
        }
    }

    public void printToFile(int from, int to) {
        try {
            FileWriter out = new FileWriter("lpt1");
            int i = from - 1;
            while (i < to) {
                Object[] row = this.tableModel.getRow(i);
                if (row != null) {
                    String line = this.rowToString(row);
                    System.out.println(line);
                    out.write(line);
                    out.write(13);
                }
                ++i;
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String rowToString(Object[] row) {
        StringBuffer line = new StringBuffer();
        int i = 1;
        while (i < row.length - 1) {
            String value = row[i].toString();
            String colName = this.runListTable.getColumnName(i);
            int width = colName.length();
            String format = "%-" + width + "s|";
            if (value.length() > width) {
                value = value.substring(0, width - 1);
            }
            line = line.append(String.format(format, value));
            ++i;
        }
        return line.toString();
    }

    public SansTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(SansTableModel tableModel) {
        this.tableModel = tableModel;
    }

    private JTable showPreviewTable(int start, int end) {
        JTable printTable = new JTable();
        DefaultTableModel printModel = new DefaultTableModel();
        TableCellEditor boolEditor = this.runListTable.getDefaultEditor(Boolean.class);
        boolEditor.addCellEditorListener(new CheckBoxListener(printTable));
        int i = start - 1;
        while (i <= end - 1) {
            Object[] row = this.tableModel.getRow(i);
            printModel.addRow(row);
            ++i;
        }
        printTable.setModel(printModel);
        printTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        JPanel panel = new JPanel();
        panel.setOpaque(true);
        panel.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(printTable);
        printTable.setAutoResizeMode(0);
        scrollPane.setViewportView(printTable);
        panel.add((Component)scrollPane, "Center");
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
        return printTable;
    }

    public Object[] getColumnNamesForPrinting() {
        ArrayList<String> colNames = new ArrayList<String>();
        TableColumnModel colModel = this.runListTable.getColumnModel();
        int colCount = colModel.getColumnCount();
        int i = 0;
        while (i < colCount) {
            int width;
            TableColumn tableColumn = colModel.getColumn(i);
            int modelIndex = tableColumn.getModelIndex();
            if (modelIndex != 0 && modelIndex != 28 && (width = tableColumn.getPreferredWidth()) > min_col_width) {
                colNames.add(this.runListTable.getColumnName(i));
            }
            ++i;
        }
        return colNames.toArray();
    }

    public Object[] getRowForPrinting(int rowIndex) {
        ArrayList<String> rowData = new ArrayList<String>();
        TableColumnModel colModel = this.runListTable.getColumnModel();
        int colCount = colModel.getColumnCount();
        int colIndex = 0;
        while (colIndex < colCount) {
            int width;
            TableColumn tableColumn = colModel.getColumn(colIndex);
            int modelIndex = tableColumn.getModelIndex();
            if (modelIndex != 0 && modelIndex != 28 && (width = tableColumn.getPreferredWidth()) > min_col_width) {
                Object value = this.tableModel.getValueAt(rowIndex, modelIndex);
                if (value != null) {
                    rowData.add(value.toString());
                } else {
                    rowData.add(" ");
                }
            }
            ++colIndex;
        }
        return rowData.toArray();
    }

    @Override
    public void actionPerformed(SamplePropertyChangedEvent event) {
        String propertyName = event.getPropertyName();
        Object value = event.getNewValue();
        if (Sample.apertFieldName.equals(propertyName)) {
            TableColumn column = this.runListTable.getColumn("SampAper");
            int colIndex = column.getModelIndex();
            int rowCount = this.runListTable.getRowCount();
            int i = 0;
            while (i < rowCount) {
                this.tableModel.setValueAt(value, i, colIndex);
                ++i;
            }
        }
    }

    private static class CheckBoxListener
    implements CellEditorListener {
        JTable table;

        public CheckBoxListener(JTable table) {
            this.table = table;
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            int rowIndex = this.table.getSelectedRow();
            int colIndex = this.table.getSelectedColumn();
            Boolean stop = (Boolean)this.table.getValueAt(rowIndex, colIndex);
            SansTableModel model = (SansTableModel)this.table.getModel();
            Object[] row = model.getRow(rowIndex);
            RunListTable.executeToggleStopCommand(stop, row);
        }
    }

    public class EnterKeyAction
    extends AbstractAction {
        private static final long serialVersionUID = 9111068614450947516L;
        private static final String title = "key_action";

        public EnterKeyAction() {
            super("EnterKeyAction");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JTable target = (JTable)event.getSource();
            SansTableModel model = (SansTableModel)target.getModel();
            int row = target.getSelectedRow();
            int col = target.getSelectedColumn();
            RunListTable.this.selPosition = row;
            if (row != -1) {
                IcePanelManager panelManager = IcePanelManager.getReference();
                GenericIcePanel autoPanel = panelManager.findOpenPanelByName(DataAcquisitionPanel.title);
                IceWindow window = panelManager.getIceWindow(autoPanel);
                SansScan scan = RunListTable.this.tableModel.getSansScan(row);
                try {
                    RunPropertiesDialog runPropDialog = RunPropertiesDialog.getInstance(window, scan, RunListTable.this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public class RunListJTable
    extends JTable {
        private static final long serialVersionUID = 11075319830163115L;

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if ((ks.getKeyCode() == 10 || e.getKeyChar() == '\n') && pressed) {
                EnterKeyAction enterKeyAction = new EnterKeyAction();
                SwingUtilities.notifyAction(enterKeyAction, ks, e, this, e.getModifiers());
                return true;
            }
            if ((ks.getKeyCode() == 38 || ks.getKeyCode() == 40) && pressed) {
                boolean activated = super.processKeyBinding(ks, e, condition, pressed);
                if (activated) {
                    RunListTable.this.selPosition = RunListTable.this.runListTable.getSelectedRow();
                }
                return activated;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }

        public boolean isEmpty() {
            boolean empty = false;
            int rowCount = this.getRowCount();
            if (rowCount == 0) {
                empty = true;
            }
            return empty;
        }
    }

    private class SansTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new JTextField();

        private SansTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            ((JTextField)this.component).setText((String)value);
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return ((JTextField)this.component).getText();
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            JTable target = (JTable)event.getSource();
            SansTableModel model = (SansTableModel)target.getModel();
            int row = target.getSelectedRow();
            int col = target.getSelectedColumn();
            RunListTable.this.selPosition = row;
            if (col < 1) {
                return;
            }
            if (event.getClickCount() == 2 && row != -1) {
                IcePanelManager panelManager = IcePanelManager.getReference();
                GenericIcePanel autoPanel = panelManager.findOpenPanelByName(DataAcquisitionPanel.title);
                IceWindow window = panelManager.getIceWindow(autoPanel);
                SansScan scan = RunListTable.this.tableModel.getSansScan(row);
                try {
                    RunPropertiesDialog runPropDialog = RunPropertiesDialog.getInstance(window, scan, RunListTable.this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static class TableRowRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -1446884368999807052L;
        private static final String empty = "Empty";
        private static final String current = "Current";
        private static final String queued = "Queued";
        private static final Color currentColor = new Color(50, 205, 50);
        private static final Color queuedColor = new Color(255, 255, 0);

        public TableRowRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            TableModel model = table.getModel();
            try {
                String status = model.getValueAt(row, 28).toString();
                if (isSelected && status.equalsIgnoreCase(empty)) {
                    cell.setBackground(table.getSelectionBackground());
                    cell.setForeground(table.getSelectionForeground());
                } else if (status.equalsIgnoreCase(empty)) {
                    cell.setBackground(table.getBackground());
                    cell.setForeground(table.getForeground());
                } else if (status.equalsIgnoreCase(current)) {
                    cell.setBackground(currentColor);
                    cell.setForeground(table.getForeground());
                } else if (status.equalsIgnoreCase(queued)) {
                    cell.setBackground(queuedColor);
                    cell.setForeground(table.getForeground());
                }
                if (value != null) {
                    this.setToolTipText(value.toString());
                }
            }
            catch (Exception e) {
                logger.error("error in run list table", e);
            }
            return cell;
        }
    }
}

