/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.ClientAPI;
import ice.Controller;
import ice.IcePanelManager;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.QueuedCommand;
import ice.communication.SendQueueManager;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.data.tas.bt7.Instrument;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.exceptions.IcePanelException;
import ice.gui.core.GenericIcePanel;
import ice.gui.core.IceWindow;
import ice.gui.core.controls.serverFileView.ServerFileSaveDialog;
import ice.gui.core.controls.serverFileView.ServerFolderView;
import ice.gui.panel.sans.DataAcquisitionPanel;
import ice.gui.panel.sans.actions.ShowSansPanelAction;
import ice.gui.panel.sans.actions.SingleRunSaveParamsAction;
import ice.gui.panel.sans.actions.StopInstrumentAction;
import ice.gui.panel.sans.controls.SansButtonPanelControl;
import ice.gui.panel.sans.controls.SingleRunParametersPanel;
import ice.gui.panel.sans.controls.buttons.PauseButton;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.swing.buttons.KeyResponseButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class SingleRunPanel
extends SansIcePanel
implements SingleRunParametersPanel.TextBoxStateChangedListener {
    private static Logger logger = Logger.getLogger("ErrorLogger.SingleRun");
    private static final String title = "Single Run";
    private static final String manualOperationsString = "F14: Manual Operations";
    private static final String previousMenuString = "F20: Previous Menu";
    private static final String saveCurrentConfigString = "F9: Save Current Config";
    private static final String startDataCollectionString = "F12:Start Data Collection";
    private static final String stopDataCollectionString = "F10: Stop Data Collection";
    private static final String saveParametersString = "Save Parameters";
    public static final String beamCenterX = "BeamCenterX";
    public static final String beamCenterY = "BeamCenterY";
    public static final String sampleThickness = "Thk";
    public static final String sampleTrans = "Trans";
    public static final String countIntTime = "Counts";
    private SingleRunParametersPanel parametersPanel;
    private SingleRunButtonControlPanel buttonsPanel;
    protected static final String DELIMITER = ":";

    public SingleRunPanel() throws IcePanelException {
        super(title, title);
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.buttonsPanel = new SingleRunButtonControlPanel(this);
        this.parametersPanel = new SingleRunParametersPanel();
        this.parametersPanel.addTextBoxStateChangedListener(this);
        this.listenForDeviceErrors(beamCenterX);
        this.listenForDeviceErrors(beamCenterY);
    }

    @Override
    protected void buildGUI() {
        this.buildButtonsPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(new Color(153, 153, 255), 1, true));
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.anchor = 17;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.parametersPanel, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.buttonsPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.writeKeysToHelpPreferenceFile(this.parametersPanel);
        this.buttonsPanel.writeKeysToHelpPreferenceFile(this);
        this.readControlKeysFromHelpPreferenceFile(this.parametersPanel);
        this.setIcePanelAsParent(this.parametersPanel);
        this.parametersPanel.requestFocusInIceWindow();
    }

    private void buildButtonsPanel() {
    }

    @Override
    public void textBoxStateChange(SingleRunParametersPanel.TextBoxStateEvent event) {
        SingleRunParametersPanel.TextBoxState theState = SingleRunParametersPanel.TextBoxState.ALL_OFF;
        theState = event.getTheState();
        switch (theState) {
            case ALL_ON: {
                this.buttonsPanel.enableNecessaryButtons(true);
                break;
            }
            case ALL_OFF: 
            case ATLEAST_ONE_OFF: {
                this.buttonsPanel.enableNecessaryButtons(false);
            }
        }
    }

    protected String buildScanCommandFromParams() {
        return this.buildScanCommandFromParams(false);
    }

    protected String buildBasicScanCommandFromParams() {
        return this.buildScanCommandFromParams(true);
    }

    protected String buildScanCommandFromParams(boolean basicDescription) {
        String returnValue = "";
        StringBuffer buffer = null;
        String fileName = "";
        buffer = new StringBuffer();
        buffer.append("Scan");
        buffer.append(DELIMITER);
        String comment = this.parametersPanel.getSampleField();
        comment = comment.replaceAll("\"", "\\\\\"");
        if (!(comment.indexOf("\n") < 0 && comment.indexOf(" ") < 0 && comment.indexOf(DELIMITER) < 0 || comment.startsWith("\"") && comment.endsWith("\""))) {
            comment = "\"" + comment + "\"";
        }
        buffer.append("Comment=" + comment);
        buffer.append(DELIMITER);
        fileName = this.parametersPanel.getFileNameField();
        buffer.append("Filename=" + fileName);
        buffer.append(DELIMITER);
        String runNumber = this.parametersPanel.getRunNumberField();
        buffer.append("Filenumber=" + runNumber);
        buffer.append(DELIMITER);
        String counts = "";
        counts = this.parametersPanel.getCountingIntervals();
        buffer.append("Counts=" + counts);
        buffer.append(DELIMITER);
        String sampleTrans = null;
        sampleTrans = this.parametersPanel.getSampleTransmissionField();
        buffer.append("Sample=Trans=" + sampleTrans);
        buffer.append(DELIMITER);
        String beamCenterX = null;
        beamCenterX = this.parametersPanel.getBeamCenterXField();
        buffer.append("Angle=BeamCenterX=" + beamCenterX);
        buffer.append(DELIMITER);
        String prefactor = null;
        prefactor = this.parametersPanel.getNumIntervalsRunField();
        buffer.append("Prefac=" + prefactor);
        buffer.append(DELIMITER);
        if (!basicDescription) {
            String sampleThickness = null;
            sampleThickness = this.parametersPanel.getSampleThicknessField();
            buffer.append("Sample=Thk=" + sampleThickness);
            buffer.append(DELIMITER);
            String beamCenterY = null;
            beamCenterY = this.parametersPanel.getBeamCenterYField();
            buffer.append("Angle=BeamCenterY=" + beamCenterY);
            buffer.append(DELIMITER);
            buffer.append("sansstop=0");
            buffer.append(DELIMITER);
            buffer.append("SANSManual=1");
            buffer.append(DELIMITER);
        }
        returnValue = buffer.toString();
        return returnValue;
    }

    @Override
    public void updateDeviceControls() {
    }

    @Override
    public boolean requestFocusInIceWindow() {
        return this.parametersPanel.requestFocusInIceWindow();
    }

    public SingleRunParametersPanel getParametersPanel() {
        return this.parametersPanel;
    }

    public void setParametersPanel(SingleRunParametersPanel parametersPanel) {
        this.parametersPanel = parametersPanel;
    }

    protected class SingleRunButtonControlPanel
    extends SansButtonPanelControl {
        protected boolean runNumberNeedsUpdate;
        private KeyResponseButton manualOperationsButton;
        private KeyResponseButton previousMenuButton;
        private KeyResponseButton saveCurrentConfigButton;
        private KeyResponseButton startDataCollectionButton;
        private KeyResponseButton stopDataCollectionButton;
        private PauseButton pauseButton;
        protected boolean singleRunStarted;
        protected SingleRunStartDataCollectionAction startAction;
        protected StopInstrumentAction stopAction;
        private JButton saveParamsButton;

        public SingleRunButtonControlPanel(GenericIcePanel parentPanel) {
            super(parentPanel);
            this.runNumberNeedsUpdate = false;
        }

        public void enableNecessaryButtons(boolean enable) {
            this.saveCurrentConfigButton.setEnabled(enable);
            this.startDataCollectionButton.setEnabled(enable);
            this.stopDataCollectionButton.setEnabled(!enable);
            this.saveParamsButton.setEnabled(enable);
        }

        @Override
        protected void buildGUI() {
            super.buildGUI();
            this.manualOperationsButton.setText(SingleRunPanel.manualOperationsString);
            this.previousMenuButton.setText(SingleRunPanel.previousMenuString);
            this.saveCurrentConfigButton.setText(SingleRunPanel.saveCurrentConfigString);
            this.startDataCollectionButton.setText(SingleRunPanel.startDataCollectionString);
            this.stopDataCollectionButton.setText(SingleRunPanel.stopDataCollectionString);
            this.stopDataCollectionButton.setVisible(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 4, 13);
            this.add((Component)this.saveCurrentConfigButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.manualOperationsButton, gridBagConstraints);
            ShowSansPanelAction prevAction = new ShowSansPanelAction("MainMenu");
            this.previousMenuButton.addActionListener(prevAction);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.previousMenuButton, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.startDataCollectionButton, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.stopDataCollectionButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.pauseButton, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.saveParamsButton, gridBagConstraints);
            this.readButtonHintsFromPreferenceFile();
        }

        @Override
        protected void init(GenericIcePanel panel) {
            super.init(panel);
            this.saveCurrentConfigButton = new KeyResponseButton(SingleRunPanel.saveCurrentConfigString, SingleRunPanel.saveCurrentConfigString, 112);
            this.startDataCollectionButton = new KeyResponseButton(SingleRunPanel.startDataCollectionString, SingleRunPanel.startDataCollectionString, 115);
            this.addToDoNotEnableDisableOnIdleOrBusy(this.startDataCollectionButton);
            this.stopDataCollectionButton = new KeyResponseButton(SingleRunPanel.stopDataCollectionString, SingleRunPanel.stopDataCollectionString, 113);
            this.addToDoNotEnableDisableOnIdleOrBusy(this.stopDataCollectionButton);
            InputMap inputMap = this.getInputMap(2);
            SingleRunSaveCurrentConfigAction saveAction = new SingleRunSaveCurrentConfigAction();
            this.saveCurrentConfigButton.addActionListener(saveAction);
            this.addToClearsErrors(this.saveCurrentConfigButton);
            this.saveCurrentConfigButton.addActionListener(this);
            this.startAction = new SingleRunStartDataCollectionAction();
            this.stopAction = new StopInstrumentAction();
            this.startDataCollectionButton.addActionListener(this.startAction);
            this.stopDataCollectionButton.addActionListener(this.stopAction);
            this.addToClearsErrors(this.startDataCollectionButton);
            this.addToClearsErrors(this.stopDataCollectionButton);
            this.startDataCollectionButton.addActionListener(this);
            this.stopDataCollectionButton.addActionListener(this);
            this.previousMenuButton = new KeyResponseButton(SingleRunPanel.previousMenuString, SingleRunPanel.previousMenuString, 123);
            this.manualOperationsButton = new KeyResponseButton(SingleRunPanel.manualOperationsString, SingleRunPanel.manualOperationsString, 117);
            ShowSansPanelAction backAction = new ShowSansPanelAction("Manual Operations");
            this.manualOperationsButton.addActionListener(backAction);
            this.pauseButton = new PauseButton("F11: Pause Auto Collection", "F11: Pause Auto Collection", 114);
            this.pauseButton.setEnabled(false);
            this.saveParamsButton = new JButton(SingleRunPanel.saveParametersString);
            SingleRunSaveParamsAction saveParamsAction = new SingleRunSaveParamsAction(SingleRunPanel.this);
            this.saveParamsButton.addActionListener(saveParamsAction);
            this.addToClearsErrors(this.saveParamsButton);
            this.saveParamsButton.addActionListener(this);
        }

        @Override
        public synchronized void actionPerformed(InstrumentValueChangedEvent event) {
            super.actionPerformed(event);
            Instrument instrument = (Instrument)event.getSource();
            String propertyName = event.getPropertyName();
            if ("state".equals(propertyName)) {
                if (instrument.getState() == Instrument.State.idle) {
                    if (this.singleRunStarted) {
                        this.singleRunStarted = false;
                        String hint = "Start";
                        this.startDataCollectionButton.setVisible(true);
                        this.startDataCollectionButton.setEnabled(true);
                        this.stopDataCollectionButton.setEnabled(false);
                        this.stopDataCollectionButton.setVisible(false);
                        this.pauseButton.setEnabled(false);
                        this.invalidate();
                        this.updateUI();
                    }
                } else if (!(instrument.getState() != Instrument.State.busy && instrument.getState() != Instrument.State.scan || this.singleRunStarted)) {
                    this.singleRunStarted = true;
                    this.startDataCollectionButton.setVisible(false);
                    this.startDataCollectionButton.setEnabled(false);
                    this.stopDataCollectionButton.setEnabled(true);
                    this.stopDataCollectionButton.setVisible(true);
                    this.pauseButton.setEnabled(true);
                    this.invalidate();
                    this.updateUI();
                }
            }
        }
    }

    private class SingleRunSaveCurrentConfigAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            StringBuffer buffer = null;
            String bufferString = null;
            ClientAPI messageSender = null;
            String parentName = "";
            IceFile parentDir = null;
            try {
                messageSender = ClientAPI.getInstance();
            }
            catch (NoClientAPIInstanceException e1) {
                e1.printStackTrace();
            }
            buffer = new StringBuffer("");
            buffer.append("Scan SetVar ");
            String comment = SingleRunPanel.this.parametersPanel.getSampleField();
            comment = comment.replaceAll("\"", "\\\\\"");
            if (!(comment.indexOf("\n") < 0 && comment.indexOf(" ") < 0 && comment.indexOf(SingleRunPanel.DELIMITER) < 0 || comment.startsWith("\"") && comment.endsWith("\""))) {
                comment = "\"" + comment + "\"";
            }
            buffer.append("Comment=" + comment + SingleRunPanel.DELIMITER);
            buffer.append("Filename=" + SingleRunPanel.this.parametersPanel.getFileNameField() + SingleRunPanel.DELIMITER);
            buffer.append("Filenumber=" + SingleRunPanel.this.parametersPanel.getRunNumberField() + SingleRunPanel.DELIMITER);
            buffer.append("Counts=" + SingleRunPanel.this.parametersPanel.getCountingIntervals() + SingleRunPanel.DELIMITER);
            buffer.append("Prefac=" + SingleRunPanel.this.parametersPanel.getNumIntervalsRunField());
            bufferString = buffer.toString();
            QueuedCommand scanSetVars = new QueuedCommand(bufferString, messageSender);
            buffer.setLength(0);
            buffer.append("Sample SetThk " + SingleRunPanel.this.parametersPanel.getSampleThicknessField());
            bufferString = buffer.toString();
            QueuedCommand setThickness = new QueuedCommand(bufferString, messageSender);
            buffer.setLength(0);
            buffer.append("Sample SetTrans " + SingleRunPanel.this.parametersPanel.getSampleTransmissionField());
            bufferString = buffer.toString();
            QueuedCommand setTrans = new QueuedCommand(bufferString, messageSender);
            buffer.setLength(0);
            buffer.append("Move BeamCenterX " + SingleRunPanel.this.parametersPanel.getBeamCenterXField() + " ");
            buffer.append("BeamCenterY " + SingleRunPanel.this.parametersPanel.getBeamCenterYField());
            bufferString = buffer.toString();
            QueuedCommand move = new QueuedCommand(bufferString, messageSender);
            IcePanelManager panelManager = IcePanelManager.getReference();
            GenericIcePanel panel = panelManager.findOpenPanelByName(DataAcquisitionPanel.title);
            IceWindow window = panelManager.getIceWindow(panel);
            ServerFileSaveDialog.FileNameAndParent fileNameAndParent = ServerFileSaveDialog.saveIceFileToServer(window, IceFileType.sansConfig, ServerFolderView.ValidServerFolders.USER, true);
            if (fileNameAndParent == null) {
                return;
            }
            String configFileName = fileNameAndParent.getFileName();
            if (!configFileName.endsWith(".cfg") && !configFileName.contains(".")) {
                configFileName = String.valueOf(configFileName) + ".cfg";
            }
            if ((parentDir = fileNameAndParent.getParent()) != null && parentDir.isMagicWord()) {
                parentName = String.valueOf(parentDir.getName()) + SingleRunPanel.DELIMITER;
            }
            try {
                String message = "Scan SaveConfig " + parentName + configFileName;
                QueuedCommand saveConfig = new QueuedCommand(message, messageSender);
                scanSetVars.runAsynchronous();
                setThickness.runAsynchronous();
                setTrans.runAsynchronous();
                move.runAsynchronous();
                saveConfig.runAsynchronous();
            }
            catch (Exception e) {
                logger.error("client api error", e.getCause());
            }
        }
    }

    private class SingleRunStartDataCollectionAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String scanDescr = null;
            Controller controller = null;
            SendQueueManager sendQueueManager = null;
            String msg = null;
            controller = Controller.getReference();
            sendQueueManager = controller.getSendManager();
            scanDescr = SingleRunPanel.this.buildBasicScanCommandFromParams();
            msg = "Scan SetVar " + scanDescr;
            sendQueueManager.addMessage(msg);
            scanDescr = SingleRunPanel.this.buildScanCommandFromParams();
            msg = "Scan Set " + scanDescr;
            sendQueueManager.addMessage(msg);
            msg = "Scan Run";
            sendQueueManager.addMessage(msg);
            SingleRunPanel.this.parametersPanel.updateRunNumber();
        }
    }
}

