/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.event.communication.EmptyDocumentListener;
import ice.exceptions.IcePanelException;
import ice.gui.core.IceViewPanel;
import ice.gui.panel.sans.controls.ErrorMessagePanel;
import ice.gui.panel.sans.controls.HelpPanel;
import ice.gui.panel.sans.controls.SansButtonPanelControl;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.subpanels.SansPanelController;
import ice.util.HelpPropertiesManager;
import java.awt.Component;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class SansIcePanel
extends IceViewPanel
implements EmptyDocumentListener {
    private static final long serialVersionUID = 1L;
    protected HelpPanel helpPanel;
    protected ErrorMessagePanel errorPanel;
    protected JLabel titleLbl;
    protected String hint;

    public SansIcePanel(String panelName, String panelTitle) throws IcePanelException {
        super(panelName);
        this.setTitle(panelTitle);
    }

    protected void initSansIcePanel() {
        this.helpPanel = new HelpPanel();
        this.errorPanel = new ErrorMessagePanel();
        this.titleLbl = new JLabel();
        this.hint = "";
    }

    @Override
    protected abstract void buildGUI();

    @Override
    protected abstract void init();

    @Override
    public void documentChanged(EmptyDocumentListener.EmptyDocumentEvent e) {
    }

    public void setTitle(String title) {
        if (title != null) {
            title = title.toUpperCase();
        }
        this.titleLbl.setText(title);
    }

    public void listenForDeviceErrors(String deviceName) {
        this.errorPanel.listenForDeviceErrors(deviceName);
    }

    public void stopListeningForDeviceErrors(String deviceName) {
        this.errorPanel.stopListeningForDeviceErrors(deviceName);
    }

    public void listenForCommandId(long commandId) {
        this.errorPanel.listenForCommandId(commandId);
    }

    public void stopListeningForCommandId(long commandId) {
        this.errorPanel.stopListeningForCommandId(commandId);
    }

    protected void addErrorListener(Component comp) {
        if (comp instanceof SansDeviceControlPanel) {
            String deviceName = ((SansDeviceControlPanel)comp).getDeviceName();
            this.listenForDeviceErrors(deviceName);
        }
    }

    public void setErrorText(String error) {
        this.errorPanel.setError(error);
    }

    public void setHelpText(String help) {
        this.helpPanel.setHelpText(help);
    }

    public void clearHelp() {
        this.helpPanel.clearHelp();
    }

    public void clearErrors() {
        this.errorPanel.clearErrors();
    }

    public void clearErrors(String message) {
        this.errorPanel.clearErrors(message);
    }

    @Override
    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        this.addErrorListener(comp);
    }

    @Override
    public Component add(Component comp) {
        this.addErrorListener(comp);
        return super.add(comp);
    }

    public abstract void updateDeviceControls();

    public void performKeyAction(int keyCode) {
    }

    public void writeKeysToHelpPreferenceFile(JPanel panel) {
        Component[] components;
        if (!SansPanelController.writeHelpKeys) {
            return;
        }
        Component[] componentArray = components = panel.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof SansDeviceControlPanel) {
                SansDeviceControlPanel control = (SansDeviceControlPanel)comp;
                String controlName = control.getControlName().replace(" ", "");
                controlName = controlName.replace(":", "");
                String key = String.valueOf(panel.getClass().getName()) + "." + control.getClass().getSimpleName() + "." + controlName + ".hint";
                try {
                    HelpPropertiesManager.initPreferenceString(key);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public void writeKeysToHelpPreferenceFile() {
        this.writeKeysToHelpPreferenceFile(this);
    }

    public void writeButtonKeysToHelpPreferenceFile(JButton button) {
        if (!SansPanelController.writeHelpKeys) {
            return;
        }
        String parentName = button.getParent().getClass().getName();
        String buttonName = button.getText().replace(" ", "");
        buttonName = buttonName.replace(":", "");
        String key = String.valueOf(parentName) + "." + button.getClass().getSimpleName() + "." + buttonName + ".hint";
        try {
            HelpPropertiesManager.initPreferenceString(key);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readControlKeysFromHelpPreferenceFile(JPanel panel) {
        Component[] components;
        this.readPanelHintsFromPreferenceFile();
        if (SansPanelController.writeHelpKeys) {
            return;
        }
        Component[] componentArray = components = panel.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof SansDeviceControlPanel) {
                SansDeviceControlPanel control = (SansDeviceControlPanel)comp;
                control.readHintsFromPreferenceFile();
            }
            ++n2;
        }
    }

    public void setIcePanelAsParent(JPanel panel) {
        Component[] components;
        Component[] componentArray = components = panel.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof SansDeviceControlPanel) {
                SansDeviceControlPanel control = (SansDeviceControlPanel)comp;
                control.setControlParent();
            }
            ++n2;
        }
    }

    public void readButtonHintFromHelpPreferenceFile(JPanel panel) {
        Component[] components;
        if (SansPanelController.writeHelpKeys) {
            return;
        }
        Component[] componentArray = components = panel.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof JButton) {
                JButton button = (JButton)comp;
                String buttonName = button.getText().replace(" ", "");
                buttonName = buttonName.replace(":", "");
                String key = String.valueOf(panel.getClass().getName()) + "." + button.getClass().getSimpleName() + "." + buttonName + ".hint";
                String hint = HelpPropertiesManager.getPreferenceString(key);
                if (!hint.equals("undefined")) {
                    button.setToolTipText(hint);
                }
            }
            ++n2;
        }
    }

    public void readPanelHintsFromPreferenceFile() {
        String name = this.getName().replace(" ", "");
        name = name.replace(":", "");
        String key = String.valueOf(this.getClass().getName()) + "." + name + ".hint";
        String controlHint = HelpPropertiesManager.getPreferenceString(key);
        if (!controlHint.equals("undefined")) {
            this.hint = controlHint;
            this.helpPanel.setHelpText(this.hint);
        }
    }

    public HelpPanel getHelpPanel() {
        return this.helpPanel;
    }

    protected void restoreDefaults() {
    }

    @Override
    protected void updateLockState() {
        Component[] components;
        boolean locked = this.isLocked();
        Component[] componentArray = components = this.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof SansButtonPanelControl) {
                ((SansButtonPanelControl)component).setEnabled(!locked);
            }
            ++n2;
        }
    }
}

