/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.ClientAPI;
import ice.commands.DeviceComponentsCommand;
import ice.commands.DevicePositionsCommand;
import ice.commands.ImmediateCommand;
import ice.commands.QueuedCommand;
import ice.gui.panel.sans.communication.SansCommandResponseEvent;
import ice.gui.panel.sans.communication.SansCommandResponseListener;
import org.apache.log4j.Logger;

public class SansCommandManager {
    private static Logger logger = Logger.getLogger("ErrorLogger");

    public static void takeQueuedAction(String command) {
        try {
            ClientAPI messageSender = ClientAPI.getInstance();
            QueuedCommand qCommand = new QueuedCommand(command, messageSender);
            qCommand.runAsynchronous();
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
    }

    public static void executeDevicePositionsCommand(String command, String tag, SansCommandResponseListener commListener) {
        DevicePositionAction action = new DevicePositionAction(command, tag, commListener);
        Thread positionThread = new Thread((Runnable)action, tag);
        positionThread.start();
    }

    public static void executeDeviceComponentsCommand(String command, String tag, SansCommandResponseListener commListener) {
        DeviceComponentsAction action = new DeviceComponentsAction(command, tag, commListener);
        Thread componentsThread = new Thread((Runnable)action, tag);
        componentsThread.start();
    }

    public static void takeImmediateAction(String command, String tag, SansCommandResponseListener commListener) {
        ImmediateAction action = new ImmediateAction(command, tag, commListener);
        Thread thread2 = new Thread((Runnable)action, tag);
        thread2.start();
    }

    private static class DeviceComponentsAction
    implements Runnable {
        String command = "";
        String tag = "";
        SansCommandResponseListener commListener = null;

        public DeviceComponentsAction(String command, String tag, SansCommandResponseListener commListener) {
            this.command = command;
            this.tag = tag;
            this.commListener = commListener;
        }

        @Override
        public void run() {
            try {
                ClientAPI messageSender = ClientAPI.getInstance();
                DeviceComponentsCommand iCommand = new DeviceComponentsCommand(this.command, messageSender);
                iCommand.runSynchronous();
                String[] devicePositions = iCommand.getParsedResponse();
                SansCommandResponseEvent event = new SansCommandResponseEvent(devicePositions, this.tag);
                this.commListener.actionPerformed(event);
            }
            catch (Exception e) {
                logger.error("Error while sending a command...", e.getCause());
                e.printStackTrace();
            }
        }
    }

    private static class DevicePositionAction
    implements Runnable {
        String command = "";
        String tag = "";
        SansCommandResponseListener commListener = null;

        public DevicePositionAction(String command, String tag, SansCommandResponseListener commListener) {
            this.command = command;
            this.tag = tag;
            this.commListener = commListener;
        }

        @Override
        public void run() {
            try {
                ClientAPI messageSender = ClientAPI.getInstance();
                DevicePositionsCommand iCommand = new DevicePositionsCommand(this.command, messageSender);
                iCommand.runSynchronous();
                String[] devicePositions = iCommand.getParsedResponse();
                SansCommandResponseEvent event = new SansCommandResponseEvent(devicePositions, this.tag);
                this.commListener.actionPerformed(event);
            }
            catch (Exception e) {
                logger.error("Error while sending a command...", e.getCause());
                e.printStackTrace();
            }
        }
    }

    private static class ImmediateAction
    implements Runnable {
        String command = "";
        String tag = "";
        SansCommandResponseListener commListener = null;

        public ImmediateAction(String command, String tag, SansCommandResponseListener commListener) {
            this.commListener = commListener;
            this.command = command;
            this.tag = tag;
        }

        @Override
        public void run() {
            try {
                ClientAPI messageSender = ClientAPI.getInstance();
                ImmediateCommand iCommand = new ImmediateCommand(this.command, messageSender);
                iCommand.getLabel();
                iCommand.runSynchronous();
                String response = iCommand.getResponse();
                SansCommandResponseEvent event = new SansCommandResponseEvent(response, this.tag);
                this.commListener.actionPerformed(event);
            }
            catch (Exception e) {
                logger.error("Error while executing a command...", e.getCause());
                e.printStackTrace();
            }
        }
    }
}

