/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.RheoSANSControlPanel;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.buttons.RheoPulsesButtonControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class RheoSansPanel
extends SansIcePanel
implements DeviceListListener {
    public static final String scanName = "SANSRHEOPULSES";
    public static final String deviceName = "RheoPulses";
    public static final String name = "Pulses for RheoSANS";
    private static final String title = "Activate/Deactivate RheoSans";
    private static final String previousMenuString = "F20: Previous Menu";
    private static final String previousMenuToolTipString = "<html>F20: Go to previous panel.</html>";
    private RheoSANSControlPanel rheoControl;
    private RheoPulsesButtonControlPanel buttonsPanel;
    private ArrayList<InstalledDevice> allDevices;

    public RheoSansPanel() throws IcePanelException {
        super(deviceName, title);
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.rheoControl = new RheoSANSControlPanel(name, deviceName);
        this.buttonsPanel = new RheoPulsesButtonControlPanel(this);
        Controller controller = Controller.getReference();
        ArrayList<InstalledDevice> devices = controller.getDeviceList();
        this.allDevices = new ArrayList<InstalledDevice>(devices);
        controller.getDeviceListeners().add(this);
        this.writeKeysToHelpPreferenceFile();
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(new Color(153, 153, 255), 1, true));
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.anchor = 17;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.rheoControl, mainBagConstraints);
        mainBagConstraints.anchor = 10;
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.buttonsPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.updateDeviceControls();
        this.writeKeysToHelpPreferenceFile();
        this.buttonsPanel.writeKeysToHelpPreferenceFile(this);
        this.readControlKeysFromHelpPreferenceFile(this);
    }

    public SansDeviceControlPanel getRheoSansControl() {
        return this.rheoControl;
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        for (InstalledDevice device : this.allDevices) {
            if (device.getName() == null || !device.getName().equalsIgnoreCase(deviceName)) continue;
            device.removeValueChangeListener(this.rheoControl);
        }
        this.allDevices = dle.getNewList();
        this.updateDeviceControls();
    }

    @Override
    public void updateDeviceControls() {
        for (InstalledDevice device : this.allDevices) {
            if (device.getName() == null || !device.getName().equalsIgnoreCase(deviceName)) continue;
            try {
                device.addValueChangeListener(this.rheoControl);
            }
            catch (ICEListenerListExceptionBase e) {
                Logger.getLogger("BeamStopPanel.updateDeviceControls " + e);
            }
            this.rheoControl.setFixed(device.isFixed());
        }
    }
}

