/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.NumberOutOfRangeListener;
import ice.event.communication.EmptyDocumentListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.SansDeviceButtonControlPanel;
import ice.gui.panel.sans.controls.SansDeviceControlDoubleNoScalePanel;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.buttons.HuberTableButtonControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.swing.SANSDecimalFormattedTextField;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class HuberTablePanel
extends SansIcePanel
implements DeviceListListener {
    protected static final String HUBER_TRANSLATION_PANEL_NAME = "Sample Position";
    protected static final String HUMBER_ROTATION_PANEL_NAME = "Sample Rotation Angle";
    private static Logger logger = Logger.getLogger("ErrorLogger");
    public static final String huberPosition = "HuberTranslation";
    public static final String huberRotation = "HuberRotation";
    private static final String title = "Sample Table Rotation Angle/Position";
    private SansDeviceControlDoubleNoScalePanel huberTranslationPanel;
    private SansDeviceControlDoubleNoScalePanel huberRotationPanel;
    private SansDeviceButtonControlPanel initPositionBtn;
    private SansDeviceButtonControlPanel initAngleBtn;
    private HuberTableButtonControlPanel buttonPanel;
    private ArrayList<InstalledDevice> allDevices;
    private Controller controller;

    public HuberTablePanel() throws IcePanelException {
        super(huberPosition, title);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.anchor = 17;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.huberTranslationPanel, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.initPositionBtn, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.huberRotationPanel, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.initAngleBtn, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.buttonPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.updateDeviceControls();
        this.writeKeysToHelpPreferenceFile();
        this.readControlKeysFromHelpPreferenceFile(this);
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.huberTranslationPanel = new SansDeviceControlDoubleNoScalePanel(HUBER_TRANSLATION_PANEL_NAME, huberPosition, "cm");
        this.huberTranslationPanel.listenToTargetEmptyDocumentEvent(this);
        this.huberRotationPanel = new SansDeviceControlDoubleNoScalePanel(HUMBER_ROTATION_PANEL_NAME, huberRotation, "deg");
        this.huberRotationPanel.listenToTargetEmptyDocumentEvent(this);
        this.buttonPanel = new HuberTableButtonControlPanel(this);
        String name = "F12: Initialize Table Position";
        String command = "device set hubertranslation 0";
        this.initPositionBtn = new SansDeviceButtonControlPanel(name, huberPosition, command);
        this.initPositionBtn.setKeyStroke(115);
        String name1 = "F9: Initialize Table Rotation Angle";
        String command1 = "device set huberrotation 0";
        this.initAngleBtn = new SansDeviceButtonControlPanel(name1, huberRotation, command1);
        this.initAngleBtn.setKeyStroke(112);
        this.controller = Controller.getReference();
        ArrayList<InstalledDevice> devices = this.controller.getDeviceList();
        this.allDevices = new ArrayList<InstalledDevice>(devices);
        this.controller.getDeviceListeners().add(this);
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        for (InstalledDevice device : this.allDevices) {
            if (device.getName() == null) continue;
            if (device.getName().equalsIgnoreCase(huberPosition)) {
                device.removeValueChangeListener(this.huberTranslationPanel);
                continue;
            }
            if (!device.getName().equalsIgnoreCase(huberRotation)) continue;
            device.removeValueChangeListener(this.huberRotationPanel);
        }
        this.allDevices = dle.getNewList();
        this.updateDeviceControls();
    }

    @Override
    public void updateDeviceControls() {
        for (InstalledDevice device : this.allDevices) {
            try {
                String currentValue;
                if (device.getName() == null) continue;
                Double min = Double.MIN_VALUE;
                Double max = Double.MAX_VALUE;
                min = device.getLowerLimit();
                max = device.getUpperLimit();
                if (device.getName().equalsIgnoreCase(huberPosition)) {
                    device.addValueChangeListener(this.huberTranslationPanel);
                    currentValue = device.getCurrValue().toString();
                    this.huberTranslationPanel.setCurrentValue(currentValue);
                    this.huberTranslationPanel.setTargetMinMax(min, max);
                    this.huberTranslationPanel.setFixed(device.isFixed());
                    continue;
                }
                if (!device.getName().equalsIgnoreCase(huberRotation)) continue;
                device.addValueChangeListener(this.huberRotationPanel);
                currentValue = device.getCurrValue().toString();
                this.huberRotationPanel.setCurrentValue(currentValue);
                this.huberRotationPanel.setTargetMinMax(min, max);
                this.huberRotationPanel.setFixed(device.isFixed());
            }
            catch (ICEListenerListExceptionBase e) {
                Logger.getLogger("CollimationPanel.updateDeviceControls " + e);
            }
        }
    }

    @Override
    public void documentChanged(EmptyDocumentListener.EmptyDocumentEvent e) {
        boolean buttonOn;
        super.documentChanged(e);
        SANSDecimalFormattedTextField textField = (SANSDecimalFormattedTextField)e.getSource();
        SansDeviceControlDoubleNoScalePanel parent = (SansDeviceControlDoubleNoScalePanel)textField.getParent();
        String name = parent.getControlName();
        EmptyDocumentListener.EmptyDocumentState state = e.getState();
        NumberOutOfRangeListener.NumberRange inRange = textField.inRange();
        if (state == EmptyDocumentListener.EmptyDocumentState.FORMATTING) {
            return;
        }
        boolean bl = buttonOn = state == EmptyDocumentListener.EmptyDocumentState.HAS_TEXT && inRange == NumberOutOfRangeListener.NumberRange.IN_RANGE;
        if (name != null && name.equals(HUBER_TRANSLATION_PANEL_NAME)) {
            this.buttonPanel.enableMoveToTargetPosBtn(buttonOn);
        } else if (name != null && name.equals(HUMBER_ROTATION_PANEL_NAME)) {
            this.buttonPanel.enableMoveToTargetRotAngleBtn(buttonOn);
        }
    }

    public SansDeviceControlPanel getSamplePositionPanel() {
        return this.huberTranslationPanel;
    }

    public SansDeviceControlPanel getSampleRotaitonPanel() {
        return this.huberRotationPanel;
    }
}

