/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.buttons;

import ice.gui.core.GenericIcePanel;
import ice.gui.panel.sans.actions.MoveDeviceAction;
import ice.gui.panel.sans.actions.MoveVSTiltAction;
import ice.gui.panel.sans.controls.SansButtonPanelControl;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.buttons.F20PreviousMenuButton;
import ice.gui.panel.sans.subpanels.WavelengthPanel;
import ice.swing.buttons.KeyResponseButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

public class WavelengthButtonControlPanel
extends SansButtonPanelControl {
    private F20PreviousMenuButton backBtn;
    private KeyResponseButton moveToTargetTiltBtn;
    private KeyResponseButton moveToTargetWavelengthBtn;
    private WavelengthPanel wavelengthPanel;
    private static final String moveTilt = "F18: Move to Target Tilt Angle";
    private static final String moveWavelength = "F17: Move to Target Wavelength";
    private static final String back = "F20: Previous Menu";

    public WavelengthButtonControlPanel(GenericIcePanel parentPanel) {
        super(parentPanel);
    }

    @Override
    protected void init(GenericIcePanel panel) {
        super.init(panel);
        this.wavelengthPanel = (WavelengthPanel)panel;
        this.moveToTargetTiltBtn = new KeyResponseButton(moveTilt, moveTilt, 121);
        this.moveToTargetTiltBtn.setEnabled(false);
        this.moveToTargetWavelengthBtn = new KeyResponseButton(moveWavelength, moveWavelength, 120);
        this.moveToTargetWavelengthBtn.setEnabled(false);
        this.backBtn = new F20PreviousMenuButton();
    }

    public void enableMoveToTargetTiltBtn(boolean enable) {
        this.moveToTargetTiltBtn.setEnabled(enable);
    }

    public void enableMoveToTargetWaveLengthBtn(boolean enable) {
        this.moveToTargetWavelengthBtn.setEnabled(enable);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        SansDeviceControlPanel control = this.wavelengthPanel.getWavelengthControl();
        MoveDeviceAction moveWavelengthAction = new MoveDeviceAction(control);
        this.moveToTargetWavelengthBtn.addActionListener(moveWavelengthAction);
        this.addToClearsErrors(this.moveToTargetWavelengthBtn);
        this.moveToTargetWavelengthBtn.addActionListener(this);
        this.moveToTargetWavelengthBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.moveToTargetWavelengthBtn, gridBagConstraints);
        SansDeviceControlPanel tiltControl = this.wavelengthPanel.getTiltControlPanel();
        MoveVSTiltAction moveTiltAction = new MoveVSTiltAction(tiltControl, control);
        this.moveToTargetTiltBtn.addActionListener(moveTiltAction);
        this.addToClearsErrors(this.moveToTargetTiltBtn);
        this.moveToTargetTiltBtn.addActionListener(this);
        this.moveToTargetTiltBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.moveToTargetTiltBtn, gridBagConstraints);
        this.backBtn.setHorizontalAlignment(2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.backBtn, gridBagConstraints);
        this.readButtonHintsFromPreferenceFile();
    }
}

