/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.gui.panel.sans.controls.SansDeviceComboBoxWithScaleDoubleControlPanel;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JLabel;

public class VSTiltControlPanel
extends SansDeviceComboBoxWithScaleDoubleControlPanel {
    private JLabel newWavelengthLabel;
    private String wavelengthDeviceName = "Wavelength";
    private static final String units = "FWHM";
    private static final String controlName = "VS Tilt Angle";
    private static final String wavelengthMessage = "New Wavelength will be     ";

    public VSTiltControlPanel() {
        super(controlName, "VSTilt", "WavelengthSpread", units);
    }

    @Override
    protected void init() {
        super.init();
        this.newWavelengthLabel = new JLabel();
    }

    @Override
    protected void buildGUI() {
        super.buildGUI();
        this.newWavelengthLabel.setText(wavelengthMessage);
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 3;
        this.gridBagConstraints.gridwidth = 3;
        this.gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.newWavelengthLabel, this.gridBagConstraints);
    }

    @Override
    public void performComboBoxAction() {
        String value = (String)this.targetBoxModel.getSelectedItem();
        String scale = "";
        String wavelength = "";
        if (value.equals("")) {
            this.targetScaleField.setText(scale);
            return;
        }
        String[] targetValues = this.getTargetTranslation(value);
        if (targetValues == null || targetValues.length < 2) {
            this.targetScaleField.setText(scale);
            return;
        }
        int i = 0;
        while (i < targetValues.length) {
            if (this.scaleDeviceName.equals(targetValues[i])) {
                scale = targetValues[++i];
            } else if (this.wavelengthDeviceName.equals(targetValues[i])) {
                wavelength = targetValues[++i];
            }
            ++i;
        }
        this.targetScaleField.setText(scale);
        this.newWavelengthLabel.setText(wavelengthMessage + wavelength);
    }

    @Override
    public void clearTargetValue() {
        this.targetScaleField.setText("");
        this.newWavelengthLabel.setText(wavelengthMessage);
        this.targetComboBox.setSelectedItem("");
    }
}

