/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.gui.panel.sans.controls.SansDeviceTextFieldControlPanel;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class SingleRunPropertyViewPanel
extends JPanel
implements DeviceListListener {
    private static final String title = "Single Run/Property View Control";
    private static final String sampleTablePosString = "Sample Table Pos.: ";
    private static final String detectorDistanceString = "Detector Distance: ";
    private static final String detectorOffsetString = "Detector Offset: ";
    private static final String beamStopYPosString = "Beamstop y Position: ";
    private static final String attenuatorNumberString = "Attenuator Number: ";
    private static final String beamStopXPosString = "Beamstop x Position: ";
    private static final String numOfGuidesString = "Num. of Guides: ";
    public static final String detectorDistance = "detectorPos";
    public static final String detectorOffset = "detectorOffset";
    public static final String beamStopX = "beamStopX";
    public static final String beamStopY = "beamStopY";
    public static final String attenuator = "attenuator";
    private SansDeviceTextFieldControlPanel beamStopXPosControl;
    private SansDeviceTextFieldControlPanel beamStopYPosControl;
    private SansDeviceTextFieldControlPanel attenuatorNumberControl;
    private SansDeviceTextFieldControlPanel detectorDistanceControl;
    private SansDeviceTextFieldControlPanel detectorOffsetControl;
    private ArrayList<InstalledDevice> allDevices;
    private Controller controller;

    public SingleRunPropertyViewPanel() {
        this.init();
        this.buildGUI();
    }

    protected void init() {
        this.setName(title);
        this.beamStopXPosControl = new SansDeviceTextFieldControlPanel(beamStopXPosString, beamStopX);
        this.beamStopYPosControl = new SansDeviceTextFieldControlPanel(beamStopYPosString, beamStopY);
        this.attenuatorNumberControl = new SansDeviceTextFieldControlPanel(attenuatorNumberString, attenuator);
        this.detectorDistanceControl = new SansDeviceTextFieldControlPanel(detectorDistanceString, detectorDistance, "cm");
        this.detectorOffsetControl = new SansDeviceTextFieldControlPanel(detectorOffsetString, detectorOffset, "cm");
        this.controller = Controller.getReference();
        ArrayList<InstalledDevice> devices = this.controller.getDeviceList();
        this.allDevices = new ArrayList<InstalledDevice>(devices);
        this.controller.getDeviceListeners().add(this);
    }

    protected void buildGUI() {
        this.setBorder(new LineBorder(new Color(153, 153, 255), 1, true));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.attenuatorNumberControl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.beamStopXPosControl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.beamStopYPosControl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.detectorDistanceControl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.detectorOffsetControl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.updateDeviceControls();
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        for (InstalledDevice device : this.allDevices) {
            if (device.getName() == null) continue;
            if (device.getName().equalsIgnoreCase(detectorDistance)) {
                device.removeValueChangeListener(this.detectorDistanceControl);
                continue;
            }
            if (device.getName().equalsIgnoreCase(detectorOffset)) {
                device.removeValueChangeListener(this.detectorOffsetControl);
                continue;
            }
            if (!device.getName().equalsIgnoreCase(attenuator)) continue;
            device.removeValueChangeListener(this.attenuatorNumberControl);
        }
        this.allDevices = dle.getNewList();
        this.updateDeviceControls();
    }

    private void updateDeviceControls() {
        try {
            for (InstalledDevice device : this.allDevices) {
                String currentValue;
                if (device.getName() == null) continue;
                if (device.getName().equalsIgnoreCase(detectorDistance)) {
                    device.addValueChangeListener(this.detectorDistanceControl);
                    currentValue = device.getCurrValue().toString();
                    this.detectorDistanceControl.setCurrentValue(currentValue);
                    continue;
                }
                if (device.getName().equalsIgnoreCase(detectorOffset)) {
                    device.addValueChangeListener(this.detectorOffsetControl);
                    currentValue = device.getCurrValue().toString();
                    this.detectorOffsetControl.setCurrentValue(currentValue);
                    continue;
                }
                if (!device.getName().equalsIgnoreCase(attenuator)) continue;
                device.addValueChangeListener(this.attenuatorNumberControl);
                currentValue = device.getCurrValue().toString();
                this.attenuatorNumberControl.setCurrentValue(currentValue);
            }
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("SingleRunPropertyViewPanel.updateDeviceControls " + e);
        }
    }
}

