/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.Controller;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ScanGetVar;
import ice.data.InstalledDevice;
import ice.data.Sample;
import ice.event.NumberOutOfRangeListener;
import ice.event.SamplePropertyChangedEvent;
import ice.event.SamplePropertyChangedListener;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.gui.panel.sans.controls.SansSingleRunDeviceControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.swing.SANSCharLimitTextField;
import ice.gui.panel.sans.swing.SANSDecimalFormattedTextField;
import ice.gui.panel.sans.swing.SANSIntegerFormattedTextField;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class SingleRunParametersPanel
extends JPanel
implements NumberOutOfRangeListener {
    protected Logger logger = Logger.getLogger("ErrorLogger");
    protected static final int SAMPLE_SET = 0;
    protected static final int FILE_NAME_SET = 1;
    protected static final int RUN_NUMBER_SET = 2;
    protected static final int COUNT_INTERVALS_SET = 3;
    protected static final int NUM_INTERVALS_RUN_SET = 4;
    protected static final int SAMPLE_TRANSMSISSION_SET = 5;
    protected static final int SAMPLE_THICKNESS_SET = 6;
    protected static final int BEAM_CENTER_X_SET = 7;
    protected static final int BEAM_CENTER_Y_SET = 8;
    protected static final int LAST_BIT_USED = 8;
    protected static final int MAX_FILE_NAME = 5;
    protected static final int MAX_SAMPLE_LABEL_NAME = 60;
    protected ArrayList<TextBoxStateChangedListener> textBoxStateChangedListeners;
    protected BitSet keepTrackOfEmptyTextFields;
    private static final String title = "Single Run/Setup Parameters";
    private static final String runNumberString = "Run Number:";
    private static final String sampleString = "Sample Label:";
    private static final String fileNameString = "File Name:";
    private static final String numIntervalsRunString = "No . of intervals /run:";
    private static final String countingIntervalsString = "Counting Interval:";
    private static final String moreParametersString = "More Parameters:";
    private static final String sampleTransmissionString = "Sample transmission:";
    private static final String sampleThicknessString = "Sample thickness (cm):";
    private static final String beamCenterXString = "Beam center x value:";
    private static final String beamCenterYString = "Beam center y value:";
    private BitIntegerTextField countingIntervalsField;
    private BitTextField fileNameField;
    private BitIntegerTextField numIntervalsRunField;
    private BitIntegerTextField runNumberField;
    private BitTextField sampleField;
    private SampleTransmissionField sampleTransmissionField;
    private SampleThkField sampleThicknessField;
    private BeamCenterXField beamCenterXField;
    private BeamCenterYField beamCenterYField;
    private JLabel countingIntervalsLabel;
    private JLabel fileNameLabel;
    private JLabel numIntervalsRunLabel;
    private JLabel runNumberLabel;
    private JLabel sampleLabel;
    private JLabel sampleTransmissionLabel;
    private JLabel sampleThicknessLabel;
    private JLabel beamCenterXLabel;
    private JLabel beamCenterYLabel;
    private SansSingleRunDeviceControlPanel countingIntervalsControl;
    private SansSingleRunDeviceControlPanel fileNameControl;
    private SansSingleRunDeviceControlPanel numIntervalsRunControl;
    private SansSingleRunDeviceControlPanel runNumberControl;
    private SansSingleRunDeviceControlPanel sampleControl;
    private SansSingleRunDeviceControlPanel sampleTransmissionControl;
    private SansSingleRunDeviceControlPanel sampleThicknessControl;
    private SansSingleRunDeviceControlPanel beamCenterXControl;
    private SansSingleRunDeviceControlPanel beamCenterYControl;

    public SingleRunParametersPanel() {
        this.init();
        this.buildGUI();
    }

    protected void init() {
        Controller controller = null;
        Sample sample = null;
        InstalledDevice aDevice = null;
        String currValue = null;
        Double max = Double.MAX_VALUE;
        Double min = Double.MIN_VALUE;
        Object parent = null;
        this.setName(title);
        this.textBoxStateChangedListeners = new ArrayList();
        this.keepTrackOfEmptyTextFields = new BitSet(8);
        this.keepTrackOfEmptyTextFields.clear();
        this.runNumberLabel = new JLabel();
        this.sampleLabel = new JLabel();
        this.fileNameLabel = new JLabel();
        this.numIntervalsRunLabel = new JLabel();
        this.countingIntervalsLabel = new JLabel();
        this.sampleTransmissionLabel = new JLabel();
        this.sampleThicknessLabel = new JLabel();
        this.beamCenterXLabel = new JLabel();
        this.beamCenterYLabel = new JLabel();
        this.runNumberLabel.setText(runNumberString);
        this.sampleLabel.setText(sampleString);
        this.fileNameLabel.setText(fileNameString);
        this.numIntervalsRunLabel.setText(numIntervalsRunString);
        this.countingIntervalsLabel.setText(countingIntervalsString);
        this.sampleTransmissionLabel.setText(sampleTransmissionString);
        this.sampleThicknessLabel.setText(sampleThicknessString);
        this.beamCenterXLabel.setText(beamCenterXString);
        this.beamCenterYLabel.setText(beamCenterYString);
        this.countingIntervalsField = new BitIntegerTextField(3);
        this.countingIntervalsField.setName(countingIntervalsString);
        this.countingIntervalsField.addNumberOutOfRangeListener(this);
        this.numIntervalsRunField = new BitIntegerTextField(4);
        this.numIntervalsRunField.addNumberOutOfRangeListener(this);
        this.numIntervalsRunField.setName(numIntervalsRunString);
        this.sampleField = new BitTextField(0, 60);
        this.fileNameField = new BitTextField(1, 5);
        this.runNumberField = new BitIntegerTextField(2);
        this.sampleTransmissionField = new SampleTransmissionField(5);
        this.sampleTransmissionField.addNumberOutOfRangeListener(this);
        this.sampleTransmissionField.setName(sampleTransmissionString);
        this.sampleTransmissionField.addNumberOutOfRangeListener(this);
        this.sampleThicknessField = new SampleThkField(6);
        this.sampleThicknessField.addNumberOutOfRangeListener(this);
        this.sampleThicknessField.setName(sampleThicknessString);
        this.sampleThicknessField.addNumberOutOfRangeListener(this);
        this.beamCenterXField = new BeamCenterXField(7);
        this.beamCenterXField.addNumberOutOfRangeListener(this);
        this.beamCenterXField.setName(beamCenterXString);
        this.beamCenterXField.addNumberOutOfRangeListener(this);
        this.beamCenterYField = new BeamCenterYField(8);
        this.beamCenterYField.addNumberOutOfRangeListener(this);
        this.beamCenterYField.setName(beamCenterYString);
        this.beamCenterYField.addNumberOutOfRangeListener(this);
        controller = Controller.getReference();
        sample = controller.getSample();
        String temp = null;
        try {
            sample.addPropertyChangeListener(this.sampleTransmissionField);
            temp = Double.toString(sample.getTrans());
            this.sampleTransmissionField.setText(temp);
            temp = Double.toString(sample.getThk());
            this.sampleThicknessField.setText(temp);
            sample.addPropertyChangeListener(this.sampleThicknessField);
        }
        catch (ICEListenerListExceptionBase e1) {
            this.logger.error("SingleRunParameters.init can't add listener " + e1);
        }
        this.runNumberControl = new SansSingleRunDeviceControlPanel(this.runNumberLabel, this.runNumberField);
        this.runNumberControl.setLabelPrefferedSize(120, 20);
        this.runNumberControl.setTextPrefferedSize(70, 20);
        this.fileNameControl = new SansSingleRunDeviceControlPanel(this.fileNameLabel, this.fileNameField);
        this.fileNameControl.setLabelPrefferedSize(120, 20);
        this.fileNameControl.setTextPrefferedSize(70, 20);
        this.numIntervalsRunControl = new SansSingleRunDeviceControlPanel(this.numIntervalsRunLabel, this.numIntervalsRunField);
        this.numIntervalsRunControl.setLabelPrefferedSize(120, 20);
        this.numIntervalsRunControl.setTextPrefferedSize(70, 20);
        this.beamCenterXControl = new SansSingleRunDeviceControlPanel(this.beamCenterXLabel, this.beamCenterXField);
        this.beamCenterXControl.setLabelPrefferedSize(120, 20);
        this.beamCenterXControl.setTextPrefferedSize(70, 20);
        this.beamCenterYControl = new SansSingleRunDeviceControlPanel(this.beamCenterYLabel, this.beamCenterYField);
        this.beamCenterYControl.setLabelPrefferedSize(120, 20);
        this.beamCenterYControl.setTextPrefferedSize(70, 20);
        this.sampleControl = new SansSingleRunDeviceControlPanel(this.sampleLabel, this.sampleField);
        this.sampleControl.setLabelPrefferedSize(120, 20);
        this.sampleControl.setTextPrefferedSize(220, 20);
        this.countingIntervalsControl = new SansSingleRunDeviceControlPanel(this.countingIntervalsLabel, this.countingIntervalsField);
        this.countingIntervalsControl.setLabelPrefferedSize(120, 20);
        this.countingIntervalsControl.setTextPrefferedSize(70, 20);
        this.sampleThicknessControl = new SansSingleRunDeviceControlPanel(this.sampleThicknessLabel, this.sampleThicknessField);
        this.sampleThicknessControl.setLabelPrefferedSize(120, 20);
        this.sampleThicknessControl.setTextPrefferedSize(70, 20);
        this.sampleTransmissionControl = new SansSingleRunDeviceControlPanel(this.sampleTransmissionLabel, this.sampleTransmissionField);
        this.sampleTransmissionControl.setLabelPrefferedSize(120, 20);
        this.sampleTransmissionControl.setTextPrefferedSize(70, 20);
        aDevice = controller.getFirstDevice("BeamCenterX");
        if (aDevice != null) {
            currValue = aDevice.getCurrValue();
            try {
                aDevice.addValueChangeListener(this.beamCenterXField);
            }
            catch (ICEListenerListExceptionBase e) {
                this.logger.error("SingleRunParameters.init " + e);
            }
            max = aDevice.getUpperLimit();
            min = aDevice.getLowerLimit();
            this.beamCenterXField.setMaxValue(max);
            this.beamCenterXField.setMinValue(min);
            this.beamCenterXField.setText(currValue);
        } else {
            this.beamCenterXField.setEnabled(false);
            this.beamCenterXLabel.setEnabled(false);
        }
        aDevice = controller.getFirstDevice("BeamCenterY");
        if (aDevice != null) {
            currValue = aDevice.getCurrValue();
            try {
                aDevice.addValueChangeListener(this.beamCenterYField);
            }
            catch (ICEListenerListExceptionBase e) {
                this.logger.error("SingleRunParameters.init " + e);
            }
            max = aDevice.getUpperLimit();
            min = aDevice.getLowerLimit();
            this.beamCenterYField.setMaxValue(max);
            this.beamCenterYField.setMinValue(min);
            this.beamCenterYField.setText(currValue);
        } else {
            this.beamCenterYField.setEnabled(false);
            this.beamCenterYLabel.setEnabled(false);
        }
        String[] vars = new String[]{"comment", "filename", "filenumber", "counts", "prefac"};
        try {
            Hashtable<String, String> valuePairs = null;
            ScanGetVar scanGetVar = new ScanGetVar(vars);
            scanGetVar.run();
            if (!scanGetVar.isError()) {
                Set<String> keys = null;
                valuePairs = scanGetVar.getScanVars();
                keys = valuePairs.keySet();
                for (String key : keys) {
                    String value = null;
                    value = valuePairs.get(key);
                    if (value == null || value.equalsIgnoreCase("empty")) {
                        value = "";
                    }
                    if (key.equalsIgnoreCase("filename")) {
                        this.fileNameField.setText(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase("comment")) {
                        if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 2) {
                            value = value.substring(1, value.length() - 1).replaceAll("\\\\\"", "\"");
                        }
                        this.sampleField.setText(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase("filenumber")) {
                        this.runNumberField.setText(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase("counts")) {
                        this.countingIntervalsField.setText(value);
                        continue;
                    }
                    if (!key.equalsIgnoreCase("prefac")) continue;
                    this.numIntervalsRunField.setText(value);
                }
            }
        }
        catch (NoClientAPIInstanceException e) {
            this.logger.error("SingleRunParameters.init " + e);
        }
        catch (ICEListenerListExceptionBase e) {
            this.logger.error("SingleRunParameters.init " + e);
        }
    }

    public void updateRunNumber() {
        String current = this.runNumberField.getText();
        int theValue = -1;
        try {
            theValue = Integer.parseInt(current);
            ++theValue;
        }
        catch (NumberFormatException e) {
            theValue = 1;
        }
        current = Integer.toString(theValue);
        this.runNumberField.setText(current);
    }

    protected void buildGUI() {
        this.setBorder(new LineBorder(new Color(153, 153, 255), 1, true));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sampleControl, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.fileNameControl, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.runNumberControl, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.countingIntervalsControl, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.numIntervalsRunControl, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.sampleTransmissionControl, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.sampleThicknessControl, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.beamCenterXControl, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.beamCenterYControl, gridBagConstraints);
    }

    public SansIcePanel getSansIcePanelParent() {
        SansIcePanel returnValue = null;
        Container parent = null;
        parent = this;
        while (!((parent = this.getParent()) instanceof SansIcePanel) && parent != null) {
        }
        returnValue = (SansIcePanel)parent;
        return returnValue;
    }

    @Override
    public void handleOutOfRangeNumber(NumberOutOfRangeListener.NumberOutOfRangeEvent numberOutOfRangeEvent) {
        int id;
        ComponentEvent detectedOn = numberOutOfRangeEvent.getDetectedOn();
        NumberOutOfRangeListener.NumberRange state = numberOutOfRangeEvent.getState();
        Object source = numberOutOfRangeEvent.getTheSource();
        if (detectedOn instanceof FocusEvent && (id = ((FocusEvent)detectedOn).getID()) == 1005 && state == NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE) {
            SansIcePanel parent = this.getSansIcePanelParent();
            String message = "";
            message = String.valueOf(message) + ((JTextField)source).getName() + " is out of range. The value must be between " + numberOutOfRangeEvent.getMin() + " and " + numberOutOfRangeEvent.getMax() + ".";
            parent.setErrorText(message);
        }
    }

    protected void EvaluateTextFields() {
        int indexOfClear = -1;
        TextBoxStateEvent textBoxStateEvent = null;
        TextBoxState textBoxState = TextBoxState.ALL_OFF;
        indexOfClear = this.keepTrackOfEmptyTextFields.nextClearBit(0);
        textBoxState = indexOfClear > 8 ? TextBoxState.ALL_ON : TextBoxState.ATLEAST_ONE_OFF;
        textBoxStateEvent = new TextBoxStateEvent(textBoxState);
        this.notifyTextBoxStateChangedListeners(textBoxStateEvent);
    }

    public void addTextBoxStateChangedListener(TextBoxStateChangedListener listener) {
        this.textBoxStateChangedListeners.add(listener);
        this.EvaluateTextFields();
    }

    public void removeTextBoxStateChangedListener(TextBoxStateChangedListener listener) {
        this.textBoxStateChangedListeners.remove(listener);
    }

    public void notifyTextBoxStateChangedListeners(TextBoxStateEvent e) {
        for (TextBoxStateChangedListener listener : this.textBoxStateChangedListeners) {
            listener.textBoxStateChange(e);
        }
    }

    public String getCountingIntervals() {
        String returnValue = "";
        returnValue = this.countingIntervalsField.getText();
        return returnValue;
    }

    public String getFileNameField() {
        String returnValue = "";
        returnValue = this.fileNameField.getText();
        return returnValue;
    }

    public String getNumIntervalsRunField() {
        String returnValue = "";
        returnValue = this.numIntervalsRunField.getText();
        return returnValue;
    }

    public String getRunNumberField() {
        String returnValue = "";
        returnValue = this.runNumberField.getText();
        return returnValue;
    }

    public String getSampleField() {
        String returnValue = "";
        returnValue = this.sampleField.getText();
        return returnValue;
    }

    public String getSampleTransmissionField() {
        String returnValue = "";
        returnValue = this.sampleTransmissionField.getText();
        return returnValue;
    }

    public String getSampleThicknessField() {
        String returnValue = "";
        returnValue = this.sampleThicknessField.getText();
        return returnValue;
    }

    public String getBeamCenterXField() {
        String returnValue = "";
        returnValue = this.beamCenterXField.getText();
        return returnValue;
    }

    public String getBeamCenterYField() {
        String returnValue = "";
        returnValue = this.beamCenterYField.getText();
        return returnValue;
    }

    public boolean requestFocusInIceWindow() {
        return this.sampleField.requestFocusInWindow();
    }

    protected class BeamCenterXField
    extends BitDoubleTextField
    implements DeviceValueChangedListener {
        public BeamCenterXField(int BitField) {
            super(BitField);
        }

        @Override
        public void actionPerformed(DeviceValueChangedEvent evt) {
            String propertyName = null;
            propertyName = evt.getPropertyName();
            if (propertyName.equals("currValue")) {
                String value = null;
                value = (String)evt.getNewValue();
                this.setText(value);
            }
        }
    }

    protected class BeamCenterYField
    extends BitDoubleTextField
    implements DeviceValueChangedListener {
        public BeamCenterYField(int BitField) {
            super(BitField);
        }

        @Override
        public void actionPerformed(DeviceValueChangedEvent evt) {
            String propertyName = null;
            propertyName = evt.getPropertyName();
            if (propertyName.equals("currValue")) {
                String value = null;
                value = (String)evt.getNewValue();
                this.setText(value);
            }
        }
    }

    protected class BitDoubleTextField
    extends SANSDecimalFormattedTextField
    implements DocumentListener {
        protected static final int MAX_FRACTION_DIGITS = 3;
        int bitField;

        public BitDoubleTextField(int bitField) {
            this.init(bitField);
        }

        protected void init(int bitField) {
            this.bitField = bitField;
            this.setNumberOfFractionDigits(3);
            this.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            String value = null;
            NumberOutOfRangeListener.NumberRange inRange = this.inRange();
            value = this.getText();
            if (this.formattedState) {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.set(this.bitField);
            } else if (value != null && !value.equals("") && inRange != NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE) {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.set(this.bitField);
            } else {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.clear(this.bitField);
            }
            SingleRunParametersPanel.this.EvaluateTextFields();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            String value = null;
            NumberOutOfRangeListener.NumberRange inRange = this.inRange();
            value = this.getText();
            if (this.formattedState) {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.set(this.bitField);
            } else if (value != null && !value.equals("") && inRange != NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE) {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.set(this.bitField);
            } else {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.clear(this.bitField);
            }
            SingleRunParametersPanel.this.EvaluateTextFields();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            String value = null;
            NumberOutOfRangeListener.NumberRange inRange = this.inRange();
            value = this.getText();
            if (this.formattedState) {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.set(this.bitField);
            } else if (value == null || value.equals("") || inRange == NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE) {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.clear(this.bitField);
            } else {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.set(this.bitField);
            }
            SingleRunParametersPanel.this.EvaluateTextFields();
        }
    }

    protected class BitIntegerTextField
    extends SANSIntegerFormattedTextField
    implements DocumentListener {
        protected static final int MAX_FRACTION_DIGITS = 3;
        int bitField;

        public BitIntegerTextField(int bitField) {
            super(false);
            this.init(bitField);
        }

        protected void init(int bitField) {
            this.bitField = bitField;
            this.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            String value = null;
            NumberOutOfRangeListener.NumberRange inRange = this.inRange();
            value = this.getText();
            if (value != null && !value.equals("") && inRange != NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE) {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.set(this.bitField);
            } else {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.clear(this.bitField);
            }
            SingleRunParametersPanel.this.EvaluateTextFields();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            String value = null;
            NumberOutOfRangeListener.NumberRange inRange = this.inRange();
            value = this.getText();
            if (value != null && !value.equals("") && inRange != NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE) {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.set(this.bitField);
            } else {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.clear(this.bitField);
            }
            SingleRunParametersPanel.this.EvaluateTextFields();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            String value = null;
            NumberOutOfRangeListener.NumberRange inRange = this.inRange();
            value = this.getText();
            if (value == null || value.equals("") || inRange == NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE) {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.clear(this.bitField);
            } else {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.set(this.bitField);
            }
            SingleRunParametersPanel.this.EvaluateTextFields();
        }
    }

    protected class BitTextField
    extends SANSCharLimitTextField
    implements DocumentListener {
        int bitField;

        public BitTextField(int bitField, int charLimit) {
            this.init(bitField, charLimit);
        }

        public BitTextField(int bitField) {
            this.init(bitField, Integer.MAX_VALUE);
        }

        protected void init(int bitField, int maxChars) {
            this.bitField = bitField;
            this.setCharLimit(maxChars);
            this.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            String value = null;
            value = this.getText();
            if (value != null && !value.equals("")) {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.set(this.bitField);
            } else {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.clear(this.bitField);
            }
            SingleRunParametersPanel.this.EvaluateTextFields();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            String value = null;
            value = this.getText();
            if (value != null && !value.equals("")) {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.set(this.bitField);
                SingleRunParametersPanel.this.EvaluateTextFields();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            String value = null;
            value = this.getText();
            if (value == null || value.equals("")) {
                SingleRunParametersPanel.this.keepTrackOfEmptyTextFields.clear(this.bitField);
                SingleRunParametersPanel.this.EvaluateTextFields();
            }
        }
    }

    protected class SampleThkField
    extends BitDoubleTextField
    implements SamplePropertyChangedListener {
        public SampleThkField(int BitField) {
            super(BitField);
        }

        @Override
        public void actionPerformed(SamplePropertyChangedEvent evt) {
            String propertyName = null;
            propertyName = evt.getPropertyName();
            if (propertyName.equals(Sample.thkFieldName)) {
                Double value = 0.0;
                value = (Double)evt.getNewValue();
                this.setText(value.toString());
            }
        }
    }

    protected class SampleTransmissionField
    extends BitDoubleTextField
    implements SamplePropertyChangedListener {
        public SampleTransmissionField(int BitField) {
            super(BitField);
        }

        @Override
        public void actionPerformed(SamplePropertyChangedEvent evt) {
            String propertyName = null;
            propertyName = evt.getPropertyName();
            if (propertyName.equals(Sample.transFieldName)) {
                Double value = 0.0;
                value = (Double)evt.getNewValue();
                this.setText(value.toString());
            }
        }
    }

    public static enum TextBoxState {
        ALL_ON,
        ALL_OFF,
        ATLEAST_ONE_OFF;

    }

    public static interface TextBoxStateChangedListener {
        public void textBoxStateChange(TextBoxStateEvent var1);
    }

    public class TextBoxStateEvent {
        protected TextBoxState theState;

        public TextBoxStateEvent(TextBoxState theState) {
            this.theState = theState;
        }

        public TextBoxState getTheState() {
            return this.theState;
        }
    }
}

