/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.ClientAPI;
import ice.commands.DeviceComponentsCommand;
import ice.data.InstalledDevice;
import ice.event.communication.DeviceValueChangedEvent;
import ice.gui.panel.sans.communication.FixDeviceActionListener;
import ice.gui.panel.sans.controls.JSansCheckBox;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.util.HelpPropertiesManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SansDeviceWithScaleControlPanel
extends SansDeviceControlPanel
implements FocusListener {
    private static final long serialVersionUID = -5655114451818822234L;
    public static final String TARGET_TAG = "TARGET";
    public static final String TRANSLATION_TAG = "TRANSLATION";
    protected Logger logger = Logger.getLogger("ErrorLogger.Control");
    protected JTextField currTranValueField;
    private JLabel currentLabel;
    protected JTextField currentValueField;
    private JCheckBox fixedBox;
    private JLabel samplePosLabel;
    protected JLabel targetLabel;
    protected JTextField targetTranValueField;
    protected JTextField targetValueTextField;
    private JLabel unitCLabel;
    private JLabel unitTLabel;
    protected String tranHint;
    protected String scaleDeviceName;

    public SansDeviceWithScaleControlPanel(String name, String deviceName, String scaleDeviceName, String units) {
        super(name, deviceName, units);
        this.scaleDeviceName = scaleDeviceName;
    }

    public SansDeviceWithScaleControlPanel(String name, String deviceName, String scaleDeviceName, String units, boolean showFixed) {
        super(name, deviceName, units, showFixed);
        this.scaleDeviceName = scaleDeviceName;
    }

    protected JTextField instantiateTargetTranField() {
        return new JTextField();
    }

    protected JTextField instantiateCurrentTranField() {
        return new JTextField();
    }

    protected JTextField instantiateTargetField() {
        return new JTextField();
    }

    protected JTextField instantiateCurrentField() {
        return new JTextField();
    }

    @Override
    protected void init() {
        super.init();
        this.samplePosLabel = new JLabel();
        this.currentLabel = new JLabel();
        this.targetLabel = new JLabel();
        this.targetValueTextField = this.instantiateTargetField();
        this.targetValueTextField.addFocusListener(this);
        this.currentValueField = this.instantiateCurrentField();
        this.fixedBox = new JSansCheckBox();
        this.unitCLabel = new JLabel();
        this.unitTLabel = new JLabel();
        this.targetTranValueField = this.instantiateTargetTranField();
        this.targetTranValueField.addFocusListener(this);
        this.currTranValueField = this.instantiateCurrentTranField();
        this.targetValueTextField.setName(TARGET_TAG);
        this.targetTranValueField.setName(TRANSLATION_TAG);
        this.tranHint = "";
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.samplePosLabel.setText(this.controlName);
        this.samplePosLabel.setPreferredSize(new Dimension(140, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.samplePosLabel, gridBagConstraints);
        this.currentLabel.setText("Current");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.currentLabel, gridBagConstraints);
        this.currentValueField.setEditable(false);
        this.currentValueField.setText("");
        this.currentValueField.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.currentValueField, gridBagConstraints);
        this.currTranValueField.setEditable(false);
        this.currTranValueField.setText("");
        this.currTranValueField.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.currTranValueField, gridBagConstraints);
        if (this.showFixed) {
            this.fixedBox.setText("Fixed");
            this.fixedBox.addActionListener(new FixDeviceActionListener(this));
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            this.add((Component)this.fixedBox, gridBagConstraints);
        }
        gridBagConstraints.anchor = 17;
        this.targetLabel.setText("Target");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.targetLabel, gridBagConstraints);
        this.targetValueTextField.setText("");
        this.targetValueTextField.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.targetValueTextField, gridBagConstraints);
        this.targetTranValueField.setText("");
        this.targetTranValueField.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.targetTranValueField, gridBagConstraints);
        this.unitCLabel.setText(this.units);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.unitCLabel, gridBagConstraints);
        this.unitTLabel.setText(this.units);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.unitTLabel, gridBagConstraints);
    }

    @Override
    public void setCurrentValue(String value) {
        this.currentValueField.setText(value);
    }

    @Override
    public void setTargetValue(String value) {
        this.targetValueTextField.setText(value);
    }

    @Override
    public String getTargetValue() {
        String targetValue = this.targetValueTextField.getText();
        return targetValue;
    }

    @Override
    public String getCurrentValue() {
        String currentValue = this.currentValueField.getText();
        return currentValue;
    }

    public void setCurrentTranslationValue(String value) {
        this.currTranValueField.setText(value);
    }

    public void setTargetTranslationValue(String value) {
        this.targetTranValueField.setText(value);
    }

    public String getTargetTranslationValue() {
        return this.targetTranValueField.getText();
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent evt) {
        super.actionPerformed(evt);
        if (!(evt.getSource() instanceof InstalledDevice)) {
            return;
        }
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        if (changedDevice.getName().equalsIgnoreCase(this.scaleDeviceName)) {
            if (evt.getPropertyName().equalsIgnoreCase("currValue")) {
                String currentValue = changedDevice.getCurrValue();
                this.setCurrentTranslationValue(currentValue);
            } else if (evt.getPropertyName().equalsIgnoreCase("upperLimit")) {
                this.doDeviceUpperLimitPropertyChanged(evt);
            } else if (evt.getPropertyName().equalsIgnoreCase("lowerLimit")) {
                this.doDeviceLowerLimitPropertyChanged(evt);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        String targetHint = "";
        Object source = event.getSource();
        if (source == this.targetValueTextField) {
            targetHint = this.hint;
        } else if (source == this.targetTranValueField) {
            targetHint = this.tranHint;
        }
        Container panel = this.getParent();
        if (panel instanceof SansIcePanel) {
            SansIcePanel sansPanel = (SansIcePanel)panel;
            sansPanel.setHelpText(targetHint);
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        Object source = event.getSource();
        if (!(source instanceof JTextField)) {
            return;
        }
        if (source == this.targetValueTextField) {
            this.performFocusLostAction(this.targetValueTextField, this.targetTranValueField, this.deviceName, this.scaleDeviceName);
        } else if (source == this.targetTranValueField) {
            this.performFocusLostAction(this.targetTranValueField, this.targetValueTextField, this.scaleDeviceName, this.deviceName);
        }
    }

    public void performFocusLostAction(JTextField source, JTextField target, String sourceName, String targetName) {
        String value = source.getText();
        String scale = "";
        if (value.equals("")) {
            target.setText(scale);
            return;
        }
        String[] targetValues = this.getTargetTranslation(sourceName, value);
        if (targetValues == null || targetValues.length < 2) {
            target.setText(scale);
            return;
        }
        int i = 0;
        while (i < targetValues.length) {
            if (targetName.equals(targetValues[i])) {
                scale = targetValues[i + 1];
                break;
            }
            ++i;
        }
        target.setText(scale);
    }

    public String[] getTargetTranslation(String deviceName, String value) {
        String command = String.valueOf(deviceName) + " " + value;
        String[] values = new String[]{"N/A"};
        try {
            ClientAPI messageSender = ClientAPI.getInstance();
            DeviceComponentsCommand iCommand = new DeviceComponentsCommand(command, messageSender);
            iCommand.runSynchronous();
            values = iCommand.getParsedResponse();
        }
        catch (Exception e) {
            this.logger.error("Error while executing a command...", e);
        }
        return values;
    }

    @Override
    public void clearTargetValue() {
        this.targetValueTextField.setText("");
        this.targetTranValueField.setText("");
    }

    @Override
    public void setFixed(boolean isFixed) {
        super.setFixed(isFixed);
        this.fixedBox.setSelected(isFixed);
    }

    @Override
    public void readHintsFromPreferenceFile() {
        super.readHintsFromPreferenceFile();
        String name = this.targetTranValueField.getName();
        name = name.replace(":", "");
        String key = String.valueOf(this.getParent().getClass().getName()) + "." + this.getClass().getSimpleName() + "." + name + ".hint";
        String controlHint = HelpPropertiesManager.getPreferenceString(key);
        if (!controlHint.equals("undefined")) {
            this.setHint(controlHint);
        }
        String name1 = this.fixedBox.getClass().getSimpleName();
        name1 = name1.replace(" ", "");
        String key1 = String.valueOf(this.getParent().getClass().getName()) + "." + this.getClass().getSimpleName() + "." + this.controlName + "." + name1 + ".hint";
        String controlHint1 = HelpPropertiesManager.getPreferenceString(key1);
        if (!controlHint1.equals("undefined")) {
            ((JSansCheckBox)this.fixedBox).setHint(controlHint1);
        }
    }
}

